/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.help.HelpEvent;
import com.jaxfront.core.help.HelpEventMulticaster;
import com.jaxfront.core.help.HelpListener;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.EditablePanel;
import com.jaxfront.core.ui.TreeModel;
import com.jaxfront.core.ui.TreeNode;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.swing.helpers.JAXFrontDocument;
import com.jaxfront.swing.ui.editor.NavigationTree;
import com.jaxfront.swing.ui.editor.TypeWorkspace;
import com.jaxfront.swing.ui.tools.CalculatorHandler;
import com.jaxfront.swing.ui.tools.FontTools;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.visualizers.JavaSwingFactory;
import com.jaxfront.swing.ui.wrapper.JAXJSplitPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractEditorPanel
extends JPanel
implements EditablePanel,
TreeModelListener,
TreeSelectionListener {
    protected transient HelpListener _helpListener;
    protected JComponent _centerComponent;
    protected Window _holder;
    protected Type _type;
    protected Document _targetDocument;
    protected TypeWorkspace _workspace;
    protected NavigationTree _tree;
    protected JComponent _navigationContainer;
    protected JAXJSplitPane _splitPane;
    protected JTabbedPane _tabbedPane;
    protected DefaultMutableTreeNode _selectedNode;
    protected boolean _isOnlyHighLightMode = false;
    private TreeNode _currentSelectedNode;
    private JPanel _helpPanel;
    private HelpLabel _helpLabel = null;
    private Action _redoAction;
    private Action _undoAction;
    private Action _calcAction;
    private Action _copyContentAction;
    private Action _pasteContentAction;
    private boolean _isSelectingTreeNode;

    public AbstractEditorPanel() {
    }

    public AbstractEditorPanel(Type type, Window window) {
        this();
        this._type = type;
        this._holder = window;
        if (this.isTopLevelEditor()) {
            ((JavaSwingFactory)TypeVisualizerFactory.getInstance()).registerEditor(this._type.getDOM(), this);
            this.setSize(this._type.getDOM().getScreenSize());
        }
        this.initialize();
    }

    public void addButton(JButton button) {
        this._workspace.addButton(button);
    }

    protected void initKeyBindings() {
        KeyStroke undoKey = KeyStroke.getKeyStroke(90, 2);
        KeyStroke redoKey = KeyStroke.getKeyStroke(89, 2);
        KeyStroke calckey = KeyStroke.getKeyStroke(75, 2);
        KeyStroke copykey = KeyStroke.getKeyStroke(67, 2);
        KeyStroke pastekey = KeyStroke.getKeyStroke(86, 2);
        this.registerKeyboardAction(this.getUndoAction(), undoKey, 2);
        this.registerKeyboardAction(this.getRedoAction(), redoKey, 2);
        this.registerKeyboardAction(this.getCalculateAction(), calckey, 2);
        if (this.getNavigationTree() != null) {
            this.getNavigationTree().registerKeyboardAction(this.getUndoAction(), undoKey, 2);
            this.getNavigationTree().registerKeyboardAction(this.getRedoAction(), redoKey, 2);
            this.getNavigationTree().registerKeyboardAction(this.getCalculateAction(), calckey, 2);
            this.getNavigationTree().registerKeyboardAction(this.getCopyContentAction(), copykey, 1);
            this.getNavigationTree().registerKeyboardAction(this.getPasteContentAction(), pastekey, 1);
        }
    }

    public void addButton(JButton button, int orientation) {
        this._workspace.addButton(button, orientation);
    }

    protected abstract JComponent buildPanel();

    public Document getDOM() {
        return this._type.getDOM();
    }

    public Window getWindow() {
        if (this._holder == null) {
            this._holder = SwingUtilities.getWindowAncestor(this);
        }
        return this._holder;
    }

    public int getLastDividerLocation() {
        if (this._splitPane != null) {
            return this._splitPane.getLastDividerLocation();
        }
        return 0;
    }

    public Type getRootType() {
        return this._type;
    }

    public Document getTargetDOM() {
        return this._targetDocument;
    }

    public TreeModel getTreeModel() {
        if (this._tree == null) {
            return null;
        }
        return (TreeModel)this._tree.getModel();
    }

    public TreeNode getSelectedTreeNode() {
        return (TreeNode)this._selectedNode;
    }

    public TypeWorkspace getWorkspace() {
        return this._workspace;
    }

    protected void initialize() {
        this.setLayout(new BorderLayout());
        this.setFocusable(false);
        this._workspace = new TypeWorkspace(this);
        this.makeNavigationPanel();
        this.add((Component)this.buildPanel(), "Center");
        if (this.getDOM().getGlobalDefinition().isShowHelpPanel()) {
            this.add((Component)this.buildHelpPanel(), "South");
        }
        this.setBorder(null);
        this.initKeyBindings();
    }

    protected JPanel buildHelpPanel() {
        this._helpPanel = new JPanel(new BorderLayout());
        this._helpPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this._helpPanel.setFocusable(false);
        this._helpLabel = new HelpLabel(3, 30);
        JScrollPane scrollPane = new JScrollPane(this._helpLabel);
        scrollPane.setBackground(Color.white);
        scrollPane.setPreferredSize(new Dimension(1, 50));
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        this._helpPanel.add((Component)scrollPane, "Center");
        return this._helpPanel;
    }

    private String getHelpText(Type type, String annotation) {
        String text = annotation;
        return text;
    }

    public NavigationTree getNavigationTree() {
        return this._tree;
    }

    public boolean isTopLevelEditor() {
        return this._type.isRoot();
    }

    public boolean isXUIEditor() {
        return false;
    }

    protected abstract JComponent makeNavigationPanel();

    public void release() {
        if (this.getNavigationTree() != null) {
            this.getNavigationTree().removeTreeSelectionListener(this);
            this.getNavigationTree().release();
            this._tree = null;
        }
        if (this._helpLabel != null) {
            this.removeHelpListener(this._helpLabel);
        }
        this._targetDocument = null;
        if (this._workspace != null) {
            this._workspace.release();
        }
        this._workspace = null;
        this._selectedNode = null;
        this._holder = null;
        this._centerComponent = null;
        this._navigationContainer = null;
        this._splitPane = null;
        this._tabbedPane = null;
        this._type = null;
        this._currentSelectedNode = null;
        this._calcAction = null;
        this._undoAction = null;
        this._redoAction = null;
    }

    public void removeSaveButton() {
        this._workspace.removeSaveButton();
    }

    public void selectNode(TreeNode node) {
        this.setSelectedNode(node);
        if (this._tree != null) {
            if (node == null) {
                this._tree.setSelectionPath(null);
            } else {
                TreePath treePath = new TreePath(node.getPath());
                this._tree.setSelectionPath(treePath);
                this._tree.scrollPathToVisible(treePath);
            }
        }
    }

    public void selectNode(Type type) {
        if (this._tree != null) {
            this.selectNode(this._tree.getNode(type));
        }
    }

    public boolean isHighLightMode() {
        return this._isOnlyHighLightMode;
    }

    public void selectNode(Type type, boolean withoutVisualize) {
        boolean wasHighlight = this._isOnlyHighLightMode;
        this._isOnlyHighLightMode = withoutVisualize;
        if (!this.isSelectingTreeNode()) {
            this.selectNode(this._tree.getNode(type));
        }
        if (!wasHighlight) {
            this._isOnlyHighLightMode = false;
        }
    }

    public TreeNode getSelectedNode() {
        return this._currentSelectedNode;
    }

    public void setSelectedNode(TreeNode treeNode) {
        this._currentSelectedNode = treeNode;
    }

    public void highlightNode(TreeNode node) {
        if (this._tree != null) {
            this.setHighLightMode(true);
            this.selectNode(node);
            this.setHighLightMode(false);
        }
    }

    public void selectRootNode() {
        if (this.getDOM() != null) {
            this.selectNode(this.getDOM().getRootType());
        }
    }

    public void setRootVisible(boolean visible) {
        this._tree.setRootVisible(visible);
    }

    public abstract void treeNodesChanged(TreeModelEvent var1);

    public abstract void treeNodesInserted(TreeModelEvent var1);

    public abstract void treeNodesRemoved(TreeModelEvent var1);

    public abstract void treeStructureChanged(TreeModelEvent var1);

    public abstract void valueChanged(TreeSelectionEvent var1);

    public abstract Visualizer visualize(Type var1, boolean var2);

    public JScrollPane getScrollPane() {
        if (this._workspace != null) {
            return this._workspace.getScrollPane();
        }
        return null;
    }

    public void setTargetMessageTable(JPanel component) {
        if (component != null) {
            component.add((Component)this.getWorkspace().getMessageTablePanel(), "Center");
        }
    }

    public void setTargetMessageTable(Panel component) {
        if (component != null) {
            component.add((Component)this.getWorkspace().getMessageTablePanel(), "Center");
        }
    }

    public void setHighLightMode(boolean isOnlyHighLightMode) {
        this._isOnlyHighLightMode = isOnlyHighLightMode;
    }

    public void setIsSelectingTreeNode(boolean isSelectingTreeNode) {
        this._isSelectingTreeNode = isSelectingTreeNode;
    }

    public boolean isSelectingTreeNode() {
        return this._isSelectingTreeNode;
    }

    public void addHelpListener(HelpListener newListener) {
        this._helpListener = HelpEventMulticaster.add((HelpListener)this._helpListener, (HelpListener)newListener);
    }

    public void fireHelpEvent(Type source, String helpID) {
        this.fireShowHelp(new HelpEvent(source, helpID));
    }

    protected void fireShowHelp(HelpEvent event) {
        if (this._helpListener == null) {
            return;
        }
        this._helpListener.showHelp(event);
    }

    public void removeHelpListener(HelpListener listener) {
        this._helpListener = HelpEventMulticaster.remove((HelpListener)this._helpListener, (HelpListener)listener);
    }

    public void setTargetDOM(Document dom) {
        this._targetDocument = dom;
    }

    public JPanel getHelpPanel() {
        return this._helpPanel;
    }

    public void setHelpPanelPosition(String position) {
        if (!(position == null || position.equals("East") || position.equals("West") || position.equals("North"))) {
            if (LogRegistry.getInstance().logWarnings()) {
                LogRegistry.getInstance().warn(this.getClass(), "HelpPanel location must be: NORTH, EAST or WEST");
            }
            return;
        }
        if (this._helpPanel != null) {
            if (position != null) {
                this.remove(this._helpPanel);
            }
            this.add((Component)this._helpPanel, position);
        }
    }

    private Action getUndoAction() {
        if (this._undoAction == null) {
            this._undoAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText("menu_item_undo", "Undo"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/undo_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                    Visualizer vis;
                    Component owner = FocusManager.getCurrentManager().getFocusOwner();
                    if (owner != null && (vis = GUITools.getParentVisualizer(owner)) != null && !vis.isViewReleased() && vis.getModel().isSimple()) {
                        vis.populateModel();
                    }
                    if (AbstractEditorPanel.this.getDOM().getUndoManager().canUndo()) {
                        AbstractEditorPanel.this.getDOM().getUndoManager().undo();
                    }
                }
            };
        }
        return this._undoAction;
    }

    private Action getRedoAction() {
        if (this._redoAction == null) {
            this._redoAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText("menu_item_redo", "Redo"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/redo_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                    if (AbstractEditorPanel.this.getDOM().getUndoManager().canRedo()) {
                        AbstractEditorPanel.this.getDOM().getUndoManager().redo();
                    }
                }
            };
        }
        return this._redoAction;
    }

    private Action getCalculateAction() {
        if (this._calcAction == null) {
            this._calcAction = new AbstractAction("Calculate"){

                public void actionPerformed(ActionEvent e) {
                    JTextComponent tf;
                    Component comp = FocusManager.getCurrentManager().getFocusOwner();
                    if (comp instanceof JTextComponent && (tf = (JTextComponent)comp).getDocument() instanceof JAXFrontDocument && tf.isEditable() && tf.isEnabled()) {
                        CalculatorHandler ch = new CalculatorHandler(tf, AbstractEditorPanel.this._type);
                        tf.addFocusListener(ch);
                        tf.addKeyListener(ch);
                    }
                }
            };
        }
        return this._calcAction;
    }

    Action getCopyContentAction() {
        if (this._copyContentAction == null) {
            this._copyContentAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText(this._type.getDOM(), "button_copy_content", "copy content"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/copy_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                    if (AbstractEditorPanel.this.getSelectedNode().getType() != null) {
                        AbstractEditorPanel.this.getDOM().getClipBoard().copy(AbstractEditorPanel.this.getSelectedNode().getType());
                    }
                }
            };
        }
        return this._copyContentAction;
    }

    Action getPasteContentAction() {
        if (this._pasteContentAction == null) {
            this._pasteContentAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText(this._type.getDOM(), "button_paste_content", "paste content"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/pasteContent_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == AbstractEditorPanel.this.getNavigationTree()) {
                        AbstractEditorPanel.this.getNavigationTree().doPaste();
                    }
                }
            };
        }
        return this._pasteContentAction;
    }

    public JComponent getCenterComponent() {
        return this._centerComponent;
    }

    public void setCenterComponent(JComponent centerComponent) {
        this._centerComponent = centerComponent;
    }

    public void clearWorkbench() {
        this.getWorkspace().clearWorkbench();
    }

    class HelpLabel
    extends JTextArea
    implements TreeSelectionListener,
    HelpListener {
        public HelpLabel(int rows, int cols) {
            super(rows, cols);
            this.init();
        }

        public HelpLabel() {
            this.init();
        }

        private void init() {
            if (AbstractEditorPanel.this.getNavigationTree() != null) {
                AbstractEditorPanel.this.getNavigationTree().addTreeSelectionListener(this);
            }
            AbstractEditorPanel.this.addHelpListener(this);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setEditable(false);
            this.setFont(FontTools.getPlainFont(10.0f));
            this.setBackground(Color.white);
        }

        public void valueChanged(TreeSelectionEvent e) {
            TreeNode selectedNode = (TreeNode)e.getPath().getLastPathComponent();
            if (selectedNode.getType() != null) {
                String helpText = DOMHelper.getAnnotation((Type)selectedNode.getType());
                helpText = helpText == null ? "" : AbstractEditorPanel.this.getHelpText(selectedNode.getType(), helpText);
                this.setText(helpText);
                this.setCaretPosition(0);
            } else if (LogRegistry.getInstance().logWarnings()) {
                LogRegistry.getInstance().warn(this.getClass(), "node is dead!");
            }
        }

        public void showHelp(HelpEvent event) {
            this.setText(event.getHelpID());
        }
    }
}

