/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jaxfront.core.util.GUIComponentNLS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Priority;

public class Console
extends JPanel
implements ItemListener,
ActionListener,
MouseListener {
    private JPanel checkBoxPanel;
    private JPanel textPanel;
    private JTextArea textArea;
    private JCheckBox logCheckBox;
    private JCheckBox infoCheckBox;
    private JCheckBox warnCheckBox;
    private JCheckBox fatalCheckBox;
    private JCheckBox errorCheckBox;
    private JButton configurationButton;
    private boolean isUsingLog;
    private boolean isUsingInfo;
    private boolean isUsingWarn;
    private boolean isUsingFatal;
    private boolean isUsingError;
    private JFrame configurationFrame;
    private JCheckBox threatNameCheckBox;
    private JCheckBox dateCheckBox;
    private JCheckBox priorityCheckBox;
    private JCheckBox classNameCheckBox;
    private JCheckBox messageCheckBox;
    private boolean isShowingThreatName;
    private boolean isShowingDate;
    private boolean isShowingPriority;
    private boolean isShowingClassName;
    private boolean isShowingMessage;
    private Action clearAction;
    private JPopupMenu popup;

    public Console() {
        this.init();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.configurationButton) {
            if (this.configurationFrame == null) {
                this.configurationFrame = this.initFrame();
            }
            Point p = this.configurationButton.getLocationOnScreen();
            this.configurationFrame.setLocation(p);
            this.configurationFrame.setVisible(true);
            this.configurationFrame.pack();
        }
    }

    private void clearTextArea() {
        this.popup.setVisible(false);
        this.textArea.setText("");
    }

    private String getClassNameString(String className) {
        if (this.isShowingClassName) {
            return className;
        }
        return "";
    }

    private String getDateString(Date date) {
        if (this.isShowingDate) {
            return date.toString();
        }
        return "";
    }

    private String getMessageString(String message) {
        if (this.isShowingMessage) {
            return message;
        }
        return "";
    }

    private String getPriorityString(Priority priority) {
        if (this.isShowingPriority) {
            return priority.toString();
        }
        return "";
    }

    private String getThreatNameString(String threatName) {
        if (this.isShowingThreatName) {
            return threatName;
        }
        return "";
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.checkBoxPanel = (JPanel)this.initCheckBoxPanel();
        this.textPanel = (JPanel)this.initTextPanel();
        this.initAction();
        this.add((Component)this.checkBoxPanel, "North");
        this.add((Component)this.textPanel, "Center");
    }

    private void initAction() {
        this.clearAction = new AbstractAction("clear"){

            public void actionPerformed(ActionEvent e) {
                Console.this.clearTextArea();
            }
        };
    }

    private JComponent initCheckBoxPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 0));
        this.logCheckBox = new JCheckBox("Log");
        this.isUsingLog = false;
        this.logCheckBox.setSelected(this.isUsingLog);
        this.logCheckBox.addItemListener(this);
        checkBoxPanel.add(this.logCheckBox);
        this.infoCheckBox = new JCheckBox("Info");
        this.isUsingInfo = false;
        this.infoCheckBox.setSelected(this.isUsingInfo);
        this.infoCheckBox.addItemListener(this);
        checkBoxPanel.add(this.infoCheckBox);
        this.warnCheckBox = new JCheckBox("Warn");
        this.isUsingWarn = false;
        this.warnCheckBox.setSelected(this.isUsingWarn);
        this.warnCheckBox.addItemListener(this);
        checkBoxPanel.add(this.warnCheckBox);
        this.fatalCheckBox = new JCheckBox("Fatal");
        this.isUsingFatal = false;
        this.fatalCheckBox.setSelected(this.isUsingFatal);
        this.fatalCheckBox.addItemListener(this);
        checkBoxPanel.add(this.fatalCheckBox);
        this.errorCheckBox = new JCheckBox("Error");
        this.isUsingError = true;
        this.errorCheckBox.setSelected(this.isUsingError);
        this.errorCheckBox.addItemListener(this);
        checkBoxPanel.add(this.errorCheckBox);
        panel.add((Component)checkBoxPanel, "East");
        JPanel buttonPanel = new JPanel();
        this.configurationButton = new JButton("..");
        this.configurationButton.addActionListener(this);
        buttonPanel.add(this.configurationButton);
        panel.add((Component)buttonPanel, "West");
        return panel;
    }

    private JFrame initFrame() {
        JFrame frame = new JFrame();
        frame.setTitle(GUIComponentNLS.getInstance().getNLSText("dialog_tokenChooser", "Token Chooser"));
        Container content = frame.getContentPane();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel(GUIComponentNLS.getInstance().getNLSText("label_tokenChooser", "Choose which tokens should be displayed in the console")));
        this.dateCheckBox = new JCheckBox(GUIComponentNLS.getInstance().getNLSText("checkbox_date", "Date"));
        this.isShowingDate = true;
        this.dateCheckBox.setSelected(this.isShowingDate);
        this.dateCheckBox.addItemListener(this);
        panel.add(this.dateCheckBox);
        this.priorityCheckBox = new JCheckBox(GUIComponentNLS.getInstance().getNLSText("checkbox_priority", "Priority"));
        this.isShowingPriority = true;
        this.priorityCheckBox.setSelected(this.isShowingPriority);
        this.priorityCheckBox.addItemListener(this);
        panel.add(this.priorityCheckBox);
        this.classNameCheckBox = new JCheckBox(GUIComponentNLS.getInstance().getNLSText("checkbox_className", "Class name"));
        this.isShowingClassName = true;
        this.classNameCheckBox.setSelected(this.isShowingClassName);
        this.classNameCheckBox.addItemListener(this);
        panel.add(this.classNameCheckBox);
        this.threatNameCheckBox = new JCheckBox(GUIComponentNLS.getInstance().getNLSText("checkbox_threadName", "Thread name"));
        this.isShowingThreatName = true;
        this.threatNameCheckBox.setSelected(this.isShowingThreatName);
        this.threatNameCheckBox.addItemListener(this);
        panel.add(this.threatNameCheckBox);
        this.messageCheckBox = new JCheckBox(GUIComponentNLS.getInstance().getNLSText("checkbox_message", "Message"));
        this.isShowingMessage = true;
        this.messageCheckBox.setSelected(this.isShowingMessage);
        this.messageCheckBox.addItemListener(this);
        panel.add(this.messageCheckBox);
        content.add(panel);
        return frame;
    }

    private JComponent initTextPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.textArea = new JTextArea(5, 40);
        this.textArea.addMouseListener(this);
        JScrollPane scroller = new JScrollPane(this.textArea);
        scroller.setVerticalScrollBarPolicy(22);
        scroller.setHorizontalScrollBarPolicy(30);
        panel.add((Component)scroller, "Center");
        return panel;
    }

    public void itemStateChanged(ItemEvent e) {
        this.isUsingError = this.errorCheckBox.isSelected();
        this.isUsingFatal = this.fatalCheckBox.isSelected();
        this.isUsingInfo = this.infoCheckBox.isSelected();
        this.isUsingLog = this.logCheckBox.isSelected();
        this.isUsingWarn = this.warnCheckBox.isSelected();
        this.isShowingClassName = this.classNameCheckBox.isSelected();
        this.isShowingDate = this.dateCheckBox.isSelected();
        this.isShowingMessage = this.messageCheckBox.isSelected();
        this.isShowingPriority = this.priorityCheckBox.isSelected();
        this.isShowingThreatName = this.threatNameCheckBox.isSelected();
    }

    public void mouseClicked(MouseEvent e) {
        this.showPopup(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.showPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.showPopup(e);
    }

    public void setMessage(Date date, Priority priority, String className, String thread, String message) {
        boolean showMessage = false;
        switch (priority.toInt()) {
            case 10000: {
                if (!this.isUsingLog) break;
                showMessage = true;
                break;
            }
            case 40000: {
                if (!this.isUsingError) break;
                showMessage = true;
                break;
            }
            case 50000: {
                if (!this.isUsingFatal) break;
                showMessage = true;
                break;
            }
            case 20000: {
                if (!this.isUsingInfo) break;
                showMessage = true;
                break;
            }
            case 30000: {
                if (!this.isUsingWarn) break;
                showMessage = true;
            }
        }
        if (showMessage) {
            this.textArea.append(this.getDateString(date) + " " + this.getPriorityString(priority) + " " + this.getClassNameString(className) + " " + this.getThreatNameString(thread) + " " + this.getMessageString(message) + "\n");
        }
    }

    private void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (this.popup == null) {
                this.popup = new JPopupMenu();
                this.popup.add(this.clearAction);
                this.popup.setInvoker(this);
            }
            Point p1 = e.getComponent().getLocationOnScreen();
            Point p2 = e.getPoint();
            p1.translate(p2.x, p2.y);
            this.popup.setLocation(p1);
            this.popup.setVisible(true);
        }
    }
}

