/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.error.SAXValidator;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.ValidationException;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.search.Search;
import com.jaxfront.swing.ui.editor.AbstractFrame;
import com.jaxfront.swing.ui.tools.Dialog;
import com.jaxfront.swing.ui.tools.search.Find;
import com.jaxfront.swing.ui.tools.search.TextComponentSearcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public class ShowXMLDialog
extends AbstractFrame {
    public static final String DOM_TO_EDITOR = "dom_to_editor";
    private Document _dom;
    private StringBuffer _buffer;
    private boolean _useValidation = true;
    private JEditorPane _textArea;
    private Action _saveAsAction;
    private Action _exitAction;
    private Action _findAction;
    private Action _validateAgainstSchemaAction;
    private JMenuBar _menuBar;
    private JMenu _fileMenu;

    public ShowXMLDialog(Document dom) {
        this.setTitle("XML Syntax");
        this._dom = dom;
        this.init();
    }

    public Document getDom() {
        return this._dom;
    }

    private void init() {
        this.initAction();
        this.initMenuBar();
        this.initTextArea();
        ImageIcon iconWhite = JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/xcentric_16x16.gif");
        this.setIconImage(iconWhite.getImage());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JScrollPane scroller = new JScrollPane(this._textArea);
        container.add((Component)scroller, "Center");
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent event) {
                int keyCode = event.getKeyCode();
                int modifier = event.getModifiers();
                if (event.getSource() == ShowXMLDialog.this._textArea && keyCode == 70 && modifier == 2) {
                    ShowXMLDialog.this.showFind();
                }
                return false;
            }
        });
        this.setSize(800, 600);
    }

    public void showFind() {
        Find find = Find.getSharedInstance(this);
        TextComponentSearcher textSearchar = new TextComponentSearcher(this._textArea);
        find.setResultProcessor(textSearchar);
        find.showFind((Search)textSearchar);
    }

    private void initAction() {
        this._exitAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText("button_close", "Close"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/close_16x16.gif")){

            public void actionPerformed(ActionEvent e) {
                ShowXMLDialog.this.setVisible(false);
            }
        };
        this._findAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText("button_find", "Find"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/find_16x16.gif")){

            public void actionPerformed(ActionEvent e) {
                ShowXMLDialog.this.showFind();
            }
        };
        this._validateAgainstSchemaAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText("tooltip_validate", "validate"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/validate_16x16.gif")){

            public void actionPerformed(ActionEvent e) {
                ShowXMLDialog.this.validateAgainstSchema();
            }
        };
        this._saveAsAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText("button_save", "Save"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/saveFile_16x16.gif")){

            public void actionPerformed(ActionEvent e) {
                ShowXMLDialog.this.saveFileChooser();
            }
        };
    }

    private void initMenuBar() {
        this._menuBar = new JMenuBar();
        this._fileMenu = new JMenu(GUIComponentNLS.getInstance().getNLSText("menu_title_file", "File"));
        this._fileMenu.add(this._saveAsAction);
        this._fileMenu.addSeparator();
        this._fileMenu.add(this._findAction);
        this._fileMenu.addSeparator();
        this._fileMenu.add(this._validateAgainstSchemaAction);
        this._fileMenu.addSeparator();
        this._fileMenu.add(this._exitAction);
        this._menuBar.add(this._fileMenu);
        this.setJMenuBar(this._menuBar);
    }

    private void initTextArea() {
        this._buffer = null;
        if (this._dom != null) {
            try {
                this._buffer = this._dom.serialize(true);
            }
            catch (ValidationException ex) {
                LogRegistry.getInstance().error(this.getClass(), (Exception)((Object)ex));
            }
        } else {
            this._buffer = new StringBuffer("!!Can't load the XML-Document!!");
        }
        if (this._textArea == null) {
            this._textArea = new JEditorPane();
        }
        if (this._buffer != null) {
            this._textArea.setText(this._buffer.toString());
        } else {
            this._textArea.setText("!!Can't load the XML-Document!!");
        }
        this._textArea.setCaretPosition(0);
        this._textArea.setEditable(false);
    }

    public void prettyPrint() {
    }

    private void saveFileChooser() {
        try {
            JFileChooser fc = new JFileChooser();
            class XMLFileFilter
            extends FileFilter {
                XMLFileFilter() {
                }

                public boolean accept(File file) {
                    String filename = file.getName();
                    return filename.endsWith(".xml");
                }

                public String getDescription() {
                    return "*.xml";
                }
            }
            fc.addChoosableFileFilter(new XMLFileFilter());
            int returnVal = fc.showSaveDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                this._dom.saveAs(file);
            }
        }
        catch (ValidationException e) {
            LogRegistry.getInstance().error(this.getClass(), (Exception)((Object)e));
        }
        catch (IOException e) {
            Dialog.showErrorDialog(e.getMessage());
        }
    }

    public void setDom(Document newDom) {
        this._dom = newDom;
        this.initTextArea();
    }

    protected JComponent initializeWorkspace() {
        return null;
    }

    public void validateAgainstSchema() {
        SAXValidator.SAXErrorHandler handler = new SAXValidator().validateAgainstSchema(this._textArea.getText(), this.getDom().getFingerPrint().getXSDURL().toExternalForm());
        if (handler.hasMessages()) {
            JList errorlist = new JList(handler.getErrors());
            JScrollPane scroller = new JScrollPane();
            scroller.getViewport().add(errorlist);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)scroller, "Center");
            Dialog.showErrorDialog((Component)this, panel, "Errors");
            handler.dumpToLog();
        } else {
            Dialog.showInformationDialog(this, "XML Schema Validation (xerces)", "XML is valid.");
        }
    }

    public void setUseValidation(boolean useValidation) {
        this._useValidation = useValidation;
        if (!this._useValidation) {
            this._validateAgainstSchemaAction.setEnabled(false);
        } else {
            this._validateAgainstSchemaAction.setEnabled(true);
        }
    }
}

