/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.layout;

import com.jaxfront.core.log.LogRegistry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;

public class PercentLayout
implements LayoutManager2 {
    public static final int NONE = -1;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final int BOTH = 3;
    public boolean DEBUG = false;
    protected ArrayList _components = new ArrayList();
    protected int _orient = 1;
    protected int _defaultSpace = 0;
    protected boolean _invalid = true;
    protected Dimension _preferredSize;

    public PercentLayout() {
    }

    public PercentLayout(int orientation) {
        this();
        this.setOrientation(orientation);
    }

    public PercentLayout(int orientation, int space) {
        this(orientation);
        this._defaultSpace = space;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null) {
            constraints = new Constraints(-1, 3);
        }
        if (constraints instanceof Constraints) {
            ComponentInfo ci = new ComponentInfo();
            ci.component = comp;
            ci.constraints = (Constraints)constraints;
            this._components.add(ci);
        }
    }

    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, new Constraints(-1, 3));
    }

    protected void assignPreferredSizes(Container c) {
        if (this.DEBUG && LogRegistry.getInstance().logLogs()) {
            LogRegistry.getInstance().log(this.getClass(), "[PercentLayout] assignPreferredSizes");
        }
        Iterator it = this._components.iterator();
        while (it.hasNext()) {
            Dimension preferredSize;
            ComponentInfo ci = (ComponentInfo)it.next();
            if (ci.preferredSize == null) {
                ci.preferredSize = preferredSize = ci.component.getPreferredSize();
            } else {
                preferredSize = ci.preferredSize;
            }
            ci.width = preferredSize.width;
            ci.height = preferredSize.height;
        }
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    public void invalidateLayout(Container target) {
        this._invalid = true;
    }

    public void layoutContainer(Container parent) {
        if (this._invalid) {
            this.recalculateLayout(parent);
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension preferredLayoutSize(Container parent) {
        if (this._invalid) {
            this.recalculateLayout(parent);
            this._invalid = false;
        }
        return new Dimension(this._preferredSize);
    }

    protected void recalculateLayout(Container container) {
        Dimension size = container.getSize();
        int xsum = 0;
        int ysum = 0;
        int xmax = 0;
        int ymax = 0;
        int pcttotal = 0;
        int largestHeight = 0;
        Insets insets = container.getInsets();
        if (this.DEBUG && LogRegistry.getInstance().logLogs()) {
            LogRegistry.getInstance().log(this.getClass(), "[PercentLayout] recalculateLayout");
        }
        this.assignPreferredSizes(container);
        if (size.width <= 0 || size.height <= 0) {
            switch (this._orient) {
                case 1: {
                    Dimension ps;
                    ComponentInfo ci;
                    Iterator it = this._components.iterator();
                    while (it.hasNext()) {
                        ci = (ComponentInfo)it.next();
                        ps = ci.preferredSize;
                        xsum += ps.width;
                        if (ps.height > ymax) {
                            ymax = ps.height;
                        }
                        pcttotal += ci.constraints._percent;
                    }
                    break;
                }
                case 2: {
                    Dimension ps;
                    ComponentInfo ci;
                    Iterator it = this._components.iterator();
                    while (it.hasNext()) {
                        ci = (ComponentInfo)it.next();
                        ps = ci.preferredSize;
                        ysum += ps.height;
                        if (ps.width > xmax) {
                            xmax = ps.width;
                        }
                        pcttotal += ci.constraints._percent;
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Bad orientation: " + this._orient);
                }
            }
            this._preferredSize = xsum > 0 ? new Dimension(xsum + this._defaultSpace * (this._components.size() - 1) + insets.right + insets.left, ymax + insets.top + insets.bottom) : (ysum > 0 ? new Dimension(xmax + insets.right + insets.left, ysum + this._defaultSpace * (this._components.size() - 1) + insets.top + insets.bottom) : new Dimension(insets.right + insets.left, insets.top + insets.bottom));
            size = new Dimension(this._preferredSize);
            if (this.DEBUG && LogRegistry.getInstance().logLogs()) {
                LogRegistry.getInstance().log(this.getClass(), "[PercentLayout] preferredSize = " + this._preferredSize + "  size = " + size);
            }
        }
        size.width -= insets.right + insets.left;
        size.height -= insets.top + insets.bottom;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        if (pcttotal == 0) {
            pcttotal = 100;
        }
        Iterator it = this._components.iterator();
        while (it.hasNext()) {
            ComponentInfo ci = (ComponentInfo)it.next();
            Component c = ci.component;
            Dimension ps = c.getPreferredSize();
            Dimension ms = c.getMinimumSize();
            Dimension xs = c.getMaximumSize();
            switch (this._orient) {
                default: {
                    break;
                }
                case 1: {
                    int paddedsize = size.height;
                    width = ci.constraints._percent * (size.width - (this._components.size() - 1) * this._defaultSpace) / pcttotal;
                    if (this.DEBUG && LogRegistry.getInstance().logLogs()) {
                        LogRegistry.getInstance().log(this.getClass(), "[PercentLayout] width = percent(" + ci.constraints._percent + ") / pcttotal(" + pcttotal + ") * size.width(" + size.width + ")   width=" + width);
                    }
                    int prefheight = ci.constraints._resize == 2 || ci.constraints._resize == 3 ? paddedsize : ps.height;
                    if (this.DEBUG && LogRegistry.getInstance().logLogs()) {
                        LogRegistry.getInstance().log(this.getClass(), "[PercentLayout] prefheight = " + prefheight);
                    }
                    if (prefheight < ps.height) {
                        height = prefheight > ms.height ? prefheight : ms.height;
                        if (this.DEBUG && LogRegistry.getInstance().logLogs()) {
                            LogRegistry.getInstance().log(this.getClass(), "[PercentLayout] 1: height = " + height + " ps.height = " + ps.height);
                        }
                    } else {
                        height = prefheight;
                        if (this.DEBUG && LogRegistry.getInstance().logLogs()) {
                            LogRegistry.getInstance().log(this.getClass(), "[PercentLayout] 3: height = prefheight = " + height);
                        }
                    }
                    if (height <= largestHeight) break;
                    largestHeight = height;
                    break;
                }
                case 2: {
                    int paddedsize = size.width;
                    height = ci.constraints._percent * (size.height - (this._components.size() - 1) * this._defaultSpace) / pcttotal;
                    int prefwidth = ci.constraints._resize == 1 || ci.constraints._resize == 3 ? paddedsize : ps.width;
                    if (prefwidth < ps.width) {
                        if (prefwidth > ms.width) {
                            width = prefwidth;
                            break;
                        }
                        width = ms.width;
                        break;
                    }
                    width = prefwidth;
                }
            }
            c.setBounds(x + insets.left, y + insets.top, width, height);
            if (this.DEBUG && LogRegistry.getInstance().logLogs()) {
                LogRegistry.getInstance().log(this.getClass(), "[PercentLayout] setting bounds on " + c + " to x:" + x + " y:" + y + " width:" + width + " height:" + height);
            }
            if (this._orient == 1) {
                x += width + this._defaultSpace;
                continue;
            }
            y += height + this._defaultSpace;
        }
        int pWidth = this._preferredSize.width;
        this._preferredSize.setSize(pWidth, largestHeight);
    }

    public void removeLayoutComponent(Component component) {
    }

    public void setDefaultSpacing(int space) {
        this._defaultSpace = space;
    }

    public void setOrientation(int orient) {
        if (orient != 1 && orient != 2) {
            throw new RuntimeException("Bad orientation: " + orient);
        }
        this._orient = orient;
    }

    protected void translateComponents(int xdelta, int ydelta) {
        Iterator it = this._components.iterator();
        while (it.hasNext()) {
            ComponentInfo componentInfo = (ComponentInfo)it.next();
            componentInfo.x += xdelta;
            componentInfo.y += ydelta;
        }
    }

    public class ComponentInfo
    extends Rectangle {
        Constraints constraints = null;
        Component component = null;
        Dimension preferredSize = null;
    }

    public static class Constraints {
        int _percent;
        int _resize;

        public Constraints(int percent, int resize) {
            this._percent = percent;
            this._resize = resize;
        }
    }
}

