/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.rtf;

import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.swing.ui.rtf.StyledText;
import com.jaxfront.swing.ui.rtf.StyledTextSelection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.MenuSelectionManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Caret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.rtf.RTFEditorKit;

public class JEditorComboStyledEditor
extends JTextPane
implements MouseListener {
    private JToolBar _toolBar;
    private JToggleButton _boldButton;
    private JToggleButton _italicButton;
    private JToggleButton _underlineButton;
    private JTextPane jEditorComboPane;
    private boolean _lastBoldState;
    private boolean _lastItalicState;
    private int fontSize = 0;
    private String fontName = "";
    private JComboBox cbFonts;
    private JComboBox cbSizes;
    private ColorMenu jLPopupforeground;
    private ColorMenu jLMenubarforeground;
    private Font defaultFont;
    private Font font;
    protected JMenuBar menuBar = new JMenuBar();
    private JPopupMenu popup;
    private DataFlavor df;
    private StyleContext context;
    protected DefaultStyledDocument doc;
    private JButton colorMenuButton;
    private JButton colorMenuButton2;
    private static ClipboardOwner defaultClipboardOwner = new ClipboardObserver();

    public JEditorComboStyledEditor() {
        this.font = this.defaultFont = new Font("monospaced", 0, 13);
        this.popup = new JPopupMenu("General");
        this.df = new DataFlavor(JEditorComboStyledEditor.class, "StyledText");
    }

    public void mouseExited(MouseEvent mouseevent) {
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public Font getCurrentFont() {
        return this.font;
    }

    public void setCurrentFont(Font font) {
        this.jEditorComboPane.setFont(font);
    }

    public void replaceSelection(StyledText content) {
        Document Zdoc = this.jEditorComboPane.getDocument();
        Caret caret = this.jEditorComboPane.getCaret();
        boolean insertPos = false;
        if (Zdoc != null) {
            try {
                int p0 = Math.min(caret.getDot(), caret.getMark());
                int p1 = Math.max(caret.getDot(), caret.getMark());
                if (p0 != p1) {
                    Zdoc.remove(p0, p1 - p0);
                }
                if (content != null) {
                    content.insert(Zdoc, p0);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void cut() {
        if (this.isEditable() && this.isEnabled()) {
            this.copy();
            this.jEditorComboPane.replaceSelection("");
        }
    }

    public void copy() {
        try {
            StyledText st = new StyledText(this, this.jEditorComboPane);
            StyledTextSelection contents = new StyledTextSelection(st);
            Clipboard clipboard = this.jEditorComboPane.getToolkit().getSystemClipboard();
            clipboard.setContents(contents, defaultClipboardOwner);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paste() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable content = clipboard.getContents(this);
        if (content != null) {
            try {
                if (content.isDataFlavorSupported(this.df)) {
                    StyledText st = (StyledText)content.getTransferData(this.df);
                    this.replaceSelection(st);
                } else if (content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String text = (String)content.getTransferData(DataFlavor.stringFlavor);
                    this.jEditorComboPane.replaceSelection(text);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JTextPane getNewEditor() {
        this.jEditorComboPane = new JTextPane();
        this.jEditorComboPane.setEditorKit(new RTFEditorKit());
        this.context = new StyleContext();
        this.doc = new DefaultStyledDocument(this.context);
        this.jEditorComboPane.setDocument(this.doc);
        this.initToolBar();
        CaretListener lst = new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                JEditorComboStyledEditor.this.showAttributes(e.getDot());
            }
        };
        this.jEditorComboPane.addCaretListener(lst);
        this.jEditorComboPane.addMouseListener(this);
        this.showAttributes(0);
        this.setCurrentFont(new Font("arial", 0, 14));
        return this.jEditorComboPane;
    }

    public JToolBar getNewToolBar() {
        return this._toolBar;
    }

    private void initToolBar() {
        this._toolBar = new JToolBar();
        this._toolBar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._toolBar.setBorder(new EtchedBorder());
        this._toolBar.setFloatable(false);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        this.cbFonts = new JComboBox<String>(fontNames);
        this.cbFonts.setMaximumSize(this.cbFonts.getPreferredSize());
        this.cbFonts.setEditable(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JEditorComboStyledEditor.this.fontName = JEditorComboStyledEditor.this.cbFonts.getSelectedItem().toString();
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setFontFamily(attr, JEditorComboStyledEditor.this.fontName);
                JEditorComboStyledEditor.this.setAttributeSet(attr);
                JEditorComboStyledEditor.this.jEditorComboPane.grabFocus();
            }
        };
        this.cbFonts.addActionListener(actionListener);
        this._toolBar.add(this.cbFonts);
        this._toolBar.addSeparator();
        this.cbSizes = new JComboBox<String>(new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"});
        this.cbSizes.setMaximumSize(this.cbSizes.getPreferredSize());
        this.cbSizes.setEditable(true);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int fontSize = 0;
                try {
                    fontSize = Integer.parseInt(JEditorComboStyledEditor.this.cbSizes.getSelectedItem().toString());
                }
                catch (NumberFormatException ex) {
                    return;
                }
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setFontSize(attr, fontSize);
                JEditorComboStyledEditor.this.setAttributeSet(attr);
                JEditorComboStyledEditor.this.jEditorComboPane.grabFocus();
            }
        };
        this.cbSizes.addActionListener(actionListener);
        this._toolBar.add(this.cbSizes);
        this._toolBar.addSeparator();
        Insets insets = new Insets(2, 2, 2, 2);
        ImageIcon boldIcon = JAXFrontProperties.getImageIcon((String)"com/jaxfront/swing/images/files/bold.gif");
        AbstractAction boldAction = new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setBold(attr, JEditorComboStyledEditor.this._boldButton.isSelected());
                JEditorComboStyledEditor.this.setAttributeSet(attr);
                JEditorComboStyledEditor.this.jEditorComboPane.grabFocus();
                JEditorComboStyledEditor.this._lastBoldState = JEditorComboStyledEditor.this._boldButton.isSelected();
            }
        };
        this._boldButton = new JToggleButton(boldAction);
        this._boldButton.setToolTipText("Set font bold");
        this._boldButton.setIcon(boldIcon);
        this._boldButton.setMargin(insets);
        this._toolBar.add(this._boldButton);
        this._toolBar.addSeparator();
        ImageIcon italicIcon = JAXFrontProperties.getImageIcon((String)"com/jaxfront/swing/images/files/italic.gif");
        AbstractAction italicAction = new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setItalic(attr, JEditorComboStyledEditor.this._italicButton.isSelected());
                JEditorComboStyledEditor.this.setAttributeSet(attr);
                JEditorComboStyledEditor.this.jEditorComboPane.grabFocus();
                JEditorComboStyledEditor.this._lastItalicState = JEditorComboStyledEditor.this._italicButton.isSelected();
            }
        };
        this._italicButton = new JToggleButton(italicAction);
        this._italicButton.setIcon(italicIcon);
        this._italicButton.setToolTipText("Set font italic");
        this._italicButton.setMargin(insets);
        this._toolBar.add(this._italicButton);
        this._toolBar.addSeparator();
        AbstractAction underlineAction = new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setUnderline(attr, JEditorComboStyledEditor.this._underlineButton.isSelected());
                JEditorComboStyledEditor.this.setAttributeSet(attr);
                JEditorComboStyledEditor.this.jEditorComboPane.grabFocus();
            }
        };
        this._underlineButton = new JToggleButton(underlineAction);
        this._underlineButton.setIcon(boldIcon);
        this._underlineButton.setToolTipText("Set font underlined");
        this._underlineButton.setMargin(insets);
        this._toolBar.add(this._underlineButton);
        AbstractAction leftAction = new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setAlignment(attr, 0);
                JEditorComboStyledEditor.this.jEditorComboPane.getStyledDocument().setParagraphAttributes(0, 0, attr, true);
            }
        };
        JToggleButton _leftButton = new JToggleButton(leftAction);
        this._toolBar.add(_leftButton);
        AbstractAction centerAction = new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setAlignment(attr, 1);
                Element el = JEditorComboStyledEditor.this.jEditorComboPane.getStyledDocument().getParagraphElement(JEditorComboStyledEditor.this.jEditorComboPane.getCaretPosition());
                JEditorComboStyledEditor.this.jEditorComboPane.getStyledDocument().setParagraphAttributes(el.getStartOffset(), el.getEndOffset() - el.getStartOffset(), attr, true);
            }
        };
        JToggleButton _centerButton = new JToggleButton(centerAction);
        this._toolBar.add(_centerButton);
        AbstractAction rightAction = new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                StyleConstants.setAlignment(attr, 2);
                JEditorComboStyledEditor.this.jEditorComboPane.getStyledDocument().setParagraphAttributes(1, 10, attr, true);
            }
        };
        JToggleButton _rightButton = new JToggleButton(rightAction);
        this._toolBar.add(_rightButton);
    }

    private void showAttributes(int p) {
        AttributeSet a = this.doc.getCharacterElement(p).getAttributes();
        if (p == 0) {
            boolean bold = StyleConstants.isBold(a);
            if (this.doc.getLength() == 0) {
                if (bold != this._lastBoldState) {
                    this._boldButton.setSelected(!this._boldButton.isSelected());
                    this._boldButton.doClick();
                } else {
                    this._boldButton.setSelected(bold);
                }
            } else {
                this._boldButton.setSelected(bold);
            }
            boolean italic = StyleConstants.isItalic(a);
            if (this.doc.getLength() == 0) {
                if (italic != this._lastItalicState) {
                    this._italicButton.doClick();
                }
                this._italicButton.setSelected(this._lastItalicState);
            } else {
                this._italicButton.setSelected(italic);
            }
        } else if (p == this.doc.getLength()) {
            this._boldButton.setSelected(this._lastBoldState);
            this._italicButton.setSelected(this._lastItalicState);
        } else {
            boolean italic;
            boolean bold;
            int size;
            String name = StyleConstants.getFontFamily(a);
            if (!this.fontName.equals(name)) {
                this.fontName = name;
                this.cbFonts.setSelectedItem(name);
            }
            if (this.fontSize != (size = StyleConstants.getFontSize(a))) {
                this.fontSize = size;
                this.cbSizes.setSelectedItem(Integer.toString(this.fontSize));
            }
            if ((bold = StyleConstants.isBold(a)) != this._boldButton.isSelected()) {
                this._boldButton.setSelected(bold);
            }
            if ((italic = StyleConstants.isItalic(a)) != this._italicButton.isSelected()) {
                this._italicButton.setSelected(italic);
            }
        }
    }

    private void setAttributeSet(AttributeSet attr) {
        int xFinish;
        int xStart = this.jEditorComboPane.getSelectionStart();
        if (xStart != (xFinish = this.jEditorComboPane.getSelectionEnd())) {
            this.doc.setCharacterAttributes(xStart, xFinish - xStart, attr, false);
        } else {
            MutableAttributeSet inputAttributes = ((RTFEditorKit)this.jEditorComboPane.getEditorKit()).getInputAttributes();
            inputAttributes.addAttributes(attr);
        }
    }

    void this_mouseReleased(MouseEvent e) {
    }

    void this_mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            // empty if block
        }
    }

    class ColorMenu
    extends JMenu
    implements ActionListener {
        private Border jLunselectedBorder;
        private Border jLselectedBorder;
        private Border jLactiveBorder;
        private Hashtable jLpanes;
        private ColorPane jLselected;
        ActionListener jColorChooserButton;

        public void setColor(Color c) {
            Object obj = this.jLpanes.get(c);
            if (obj == null) {
                return;
            }
            if (this.jLselected != null) {
                this.jLselected.setSelected(false);
            }
            this.jLselected = (ColorPane)obj;
            this.jLselected.setSelected(true);
        }

        public Color getColor() {
            if (this.jLselected == null) {
                return null;
            }
            return this.jLselected.getColor();
        }

        public void doSelection() {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }

        public void actionPerformed(ActionEvent actionevent) {
        }

        public ColorMenu(String name) {
            super(name);
            this.jColorChooserButton = new ActionListener(){

                public void actionPerformed(ActionEvent jColorChooserEvt) {
                    if (jColorChooserEvt.getSource() == JEditorComboStyledEditor.this.colorMenuButton || jColorChooserEvt.getSource() == JEditorComboStyledEditor.this.colorMenuButton2) {
                        JEditorComboStyledEditor.this.jEditorComboPane.setCursor(Cursor.getPredefinedCursor(3));
                        Color newColor = JColorChooser.showDialog(JEditorComboStyledEditor.this.jEditorComboPane, "Select Custom Color", Color.white);
                        if (newColor != null) {
                            SimpleAttributeSet attr = new SimpleAttributeSet();
                            StyleConstants.setForeground(attr, newColor);
                            JEditorComboStyledEditor.this.setAttributeSet(attr);
                            MenuSelectionManager.defaultManager().clearSelectedPath();
                        } else if (newColor == null) {
                            MenuSelectionManager.defaultManager().clearSelectedPath();
                            JEditorComboStyledEditor.this.jEditorComboPane.setCursor(Cursor.getPredefinedCursor(2));
                            return;
                        }
                    }
                    JEditorComboStyledEditor.this.jEditorComboPane.setCursor(Cursor.getPredefinedCursor(2));
                }
            };
            this.jLunselectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, this.getBackground()), new BevelBorder(1, Color.white, Color.gray));
            this.jLselectedBorder = new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.red), new MatteBorder(1, 1, 1, 1, this.getBackground()));
            this.jLactiveBorder = new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.blue), new MatteBorder(1, 1, 1, 1, this.getBackground()));
            JPanel mainPanel = new JPanel();
            JPanel p = new JPanel();
            JPanel bottomPanel = new JPanel();
            BorderLayout border = new BorderLayout();
            p.setBorder(new EmptyBorder(5, 5, 5, 5));
            p.setLayout(new GridLayout(8, 8));
            this.jLpanes = new Hashtable();
            int[] values = new int[]{0, 128, 192, 255};
            for (int r = 0; r < values.length; ++r) {
                for (int g = 0; g < values.length; ++g) {
                    for (int b = 0; b < values.length; ++b) {
                        Color c = new Color(values[r], values[g], values[b]);
                        ColorPane pn = new ColorPane(c);
                        p.add(pn);
                        this.jLpanes.put(c, pn);
                    }
                }
            }
            mainPanel.setLayout(border);
            bottomPanel.add(JEditorComboStyledEditor.this.colorMenuButton = new JButton("More colors"));
            JEditorComboStyledEditor.this.colorMenuButton.addActionListener(this.jColorChooserButton);
            mainPanel.add((Component)p, "North");
            mainPanel.add((Component)bottomPanel, "South");
            this.add(mainPanel);
        }

        public ColorMenu(String name, int number) {
            super(name);
            this.jLunselectedBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 1, this.getBackground()), new BevelBorder(1, Color.white, Color.gray));
            this.jLselectedBorder = new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.red), new MatteBorder(1, 1, 1, 1, this.getBackground()));
            this.jLactiveBorder = new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.blue), new MatteBorder(1, 1, 1, 1, this.getBackground()));
            JPanel mainPanel = new JPanel();
            JPanel p = new JPanel();
            JPanel bottomPanel = new JPanel();
            BorderLayout border = new BorderLayout();
            p.setBorder(new EmptyBorder(5, 5, 5, 5));
            p.setLayout(new GridLayout(8, 8));
            this.jLpanes = new Hashtable();
            int[] values = new int[]{0, 128, 192, 255};
            for (int r = 0; r < values.length; ++r) {
                for (int g = 0; g < values.length; ++g) {
                    for (int b = 0; b < values.length; ++b) {
                        Color c = new Color(values[r], values[g], values[b]);
                        ColorPane pn = new ColorPane(c);
                        p.add(pn);
                        this.jLpanes.put(c, pn);
                    }
                }
            }
            mainPanel.setLayout(border);
            bottomPanel.add(JEditorComboStyledEditor.this.colorMenuButton2 = new JButton("More colors"));
            JEditorComboStyledEditor.this.colorMenuButton2.addActionListener(this.jColorChooserButton);
            mainPanel.add((Component)p, "North");
            mainPanel.add((Component)bottomPanel, "South");
            this.add(mainPanel);
        }

        class ColorPane
        extends JPanel
        implements MouseListener {
            private Color jLc;
            private boolean jLselected;

            public Color getColor() {
                return this.jLc;
            }

            public Dimension getPreferredSize() {
                return new Dimension(15, 15);
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public void setSelected(boolean selected) {
                this.jLselected = selected;
                if (this.jLselected) {
                    this.setBorder(ColorMenu.this.jLselectedBorder);
                } else {
                    this.setBorder(ColorMenu.this.jLunselectedBorder);
                }
            }

            public boolean isSelected() {
                return this.jLselected;
            }

            public void mousePressed(MouseEvent mouseevent) {
            }

            public void mouseClicked(MouseEvent mouseevent) {
            }

            public void mouseReleased(MouseEvent e) {
                ColorMenu.this.setColor(this.jLc);
                MenuSelectionManager.defaultManager().clearSelectedPath();
                ColorMenu.this.doSelection();
            }

            public void mouseEntered(MouseEvent e) {
                this.setBorder(ColorMenu.this.jLactiveBorder);
            }

            public void mouseExited(MouseEvent e) {
                this.setBorder(this.jLselected ? ColorMenu.this.jLselectedBorder : ColorMenu.this.jLunselectedBorder);
            }

            public ColorPane(Color c) {
                this.jLc = c;
                this.setBackground(c);
                this.setBorder(ColorMenu.this.jLunselectedBorder);
                String msg = "R " + c.getRed() + ", G " + c.getGreen() + ", B " + c.getBlue();
                this.setToolTipText(msg);
                this.addMouseListener(this);
            }
        }
    }

    static class ClipboardObserver
    implements ClipboardOwner {
        public void lostOwnership(Clipboard clipboard1, Transferable transferable) {
        }

        ClipboardObserver() {
        }
    }
}

