/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.rtf;

import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.swing.ui.rtf.JEditorComboStyledEditor;
import com.jaxfront.swing.ui.visualizers.SimpleTypeStringView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import javax.swing.text.Document;

public class RTFEditor
extends SimpleTypeStringView {
    private JEditorComboStyledEditor _styledEditor;
    private JTextPane _textPane;
    private int _defaultHeight;

    public RTFEditor() {
        this(300);
    }

    public RTFEditor(int defaultHeight) {
        this._defaultHeight = defaultHeight;
    }

    protected JComponent createEditorComponent() {
        JPanel component = new JPanel(new BorderLayout());
        this._styledEditor = new JEditorComboStyledEditor();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JPanel bottomRTFPanel = new JPanel();
        bottomRTFPanel.setLayout(new GridLayout(1, 4));
        bottomRTFPanel.setBorder(new EtchedBorder());
        this.setEditorField(this._styledEditor.getNewEditor());
        JScrollPane scroller = new JScrollPane(this.getEditorField());
        JToolBar toolBar = this._styledEditor.getNewToolBar();
        mainPanel.add(scroller);
        mainPanel.add((Component)toolBar, "North");
        component.add((Component)mainPanel, "Center");
        this._textPane = (JTextPane)this.getEditorField();
        this._textPane.addFocusListener(this);
        this._editorComponent = component;
        this._firstFocusableComponent = this._textPane;
        component.setPreferredSize(new Dimension(300, this._defaultHeight));
        return component;
    }

    public static void main(String[] args) {
        String rtfName = null;
        String rtfContent = null;
        if (args.length == 1) {
            rtfName = args[0];
            URL url = URLHelper.getUserURL((String)rtfName);
            try {
                int ch;
                InputStream is = JAXFrontProperties.getInstance().getURLResolver().resolveURL(url);
                BufferedReader in = new BufferedReader(new InputStreamReader(is));
                char[] data = new char[is.available()];
                int index = 0;
                while ((ch = in.read()) != -1) {
                    data[index] = (char)ch;
                    ++index;
                }
                rtfContent = new String(data, 0, index);
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        RTFEditor rtfEditor = new RTFEditor(500);
        if (rtfContent != null) {
            rtfEditor.setText(rtfContent);
        }
        frame.getContentPane().add((Component)rtfEditor, "Center");
        frame.setSize(400, 400);
        frame.setVisible(true);
    }

    public void setText(String text) {
        this._textPane.setText(text);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public String getText() {
        String text = null;
        try {
            Document doc = this._textPane.getDocument();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this._textPane.getEditorKit().write(os, doc, 0, doc.getLength());
            text = os.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }
}

