/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.swing.ui.tools.BorderActionSet;
import com.jaxfront.swing.ui.tools.Collapsible;
import com.jaxfront.swing.ui.tools.GenericAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CollapsiblePanel
extends JPanel
implements Collapsible {
    private boolean _collapsed = false;
    private GridBagConstraints _constraints;
    private JComponent _content;
    private JPanel _spring;

    public CollapsiblePanel(JComponent content) {
        this._content = content;
        this.setLayout(new GridBagLayout());
        this._constraints = new GridBagConstraints();
        this.expand();
    }

    public boolean isCollapsed() {
        return this._collapsed;
    }

    public boolean isCollapsible() {
        return true;
    }

    public JComponent getContentPanel() {
        return this._content;
    }

    public void setContentPanel(JPanel newContent) {
        this._content = newContent;
        if (this._collapsed) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    public void collapse() {
        this._collapsed = true;
        this.setVisible(false);
        this.removeAll();
        this._constraints.gridx = -1;
        this._constraints.gridy = 0;
        this._constraints.gridheight = 0;
        this._constraints.gridwidth = 0;
        this._constraints.weightx = 1.0;
        this._constraints.weighty = 1.0;
        this._constraints.anchor = 17;
        this._constraints.fill = 1;
        this.add((Component)this.getSpring(), this._constraints);
        this.revalidate();
        this.setVisible(true);
        if (SwingUtilities.getRoot(this) != null) {
            SwingUtilities.getRoot(this).validate();
        }
    }

    public void expand() {
        this._collapsed = false;
        this.setVisible(false);
        this.removeAll();
        this._constraints.gridx = -1;
        this._constraints.gridy = 0;
        this._constraints.gridheight = 0;
        this._constraints.gridwidth = 0;
        this._constraints.weightx = 1.0;
        this._constraints.weighty = 1.0;
        this._constraints.anchor = 17;
        this._constraints.fill = 1;
        this.add((Component)this._content, this._constraints);
        this.revalidate();
        this.setVisible(true);
        if (SwingUtilities.getRoot(this) != null) {
            SwingUtilities.getRoot(this).validate();
        }
    }

    public static BorderActionSet getExpandCollapseBorderSet(Object controller) {
        return new BorderActionSet("collapse", new GenericAction("collapse", controller, "collapse"), new GenericAction("expand", controller, "expand"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/arrowDown_9x6.gif").getImage(), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/arrowUp_9x6.gif").getImage(), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/arrowUp_9x6.gif").getImage(), null, "bubbleHelpText", 0);
    }

    public void setSpring(JPanel _spring) {
        this._spring = _spring;
    }

    public JPanel getSpring() {
        if (this._spring == null) {
            this._spring = new JPanel();
        }
        return this._spring;
    }
}

