/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class Console
extends JPanel {
    PipedInputStream piOut;
    PipedInputStream piErr;
    PipedOutputStream poOut;
    PipedOutputStream poErr;
    JTextArea textArea = new JTextArea();

    public Console() throws IOException {
        this.setLayout(new BorderLayout());
        this.piOut = new PipedInputStream();
        this.poOut = new PipedOutputStream(this.piOut);
        System.setOut(new PrintStream(this.poOut, true));
        this.piErr = new PipedInputStream();
        this.poErr = new PipedOutputStream(this.piErr);
        System.setErr(new PrintStream(this.poErr, true));
        this.textArea.setEditable(false);
        this.add((Component)this.textArea, "Center");
        new ReaderThread(this.piOut).start();
        new ReaderThread(this.piErr).start();
    }

    class ReaderThread
    extends Thread {
        PipedInputStream pi;

        ReaderThread(PipedInputStream pi) {
            this.pi = pi;
        }

        public void run() {
            final byte[] buf = new byte[1024];
            try {
                int len;
                while ((len = this.pi.read(buf)) != -1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ((ReaderThread)ReaderThread.this).Console.this.textArea.append(new String(buf, 0, len));
                            ((ReaderThread)ReaderThread.this).Console.this.textArea.setCaretPosition(((ReaderThread)ReaderThread.this).Console.this.textArea.getDocument().getLength());
                            int idealSize = 1000;
                            int maxExcess = 500;
                            int excess = ((ReaderThread)ReaderThread.this).Console.this.textArea.getDocument().getLength() - idealSize;
                            if (excess >= maxExcess) {
                                ((ReaderThread)ReaderThread.this).Console.this.textArea.replaceRange("", 0, excess);
                            }
                        }
                    });
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

