/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.io.FileHelper;
import com.jaxfront.core.util.io.FileSelector;
import com.jaxfront.swing.ui.tools.FunctionalTitleBorder;
import com.jaxfront.swing.ui.tools.GenericAction;
import com.jaxfront.swing.ui.tools.TreeUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.xni.parser.XMLParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMTree
extends JTree {
    private FunctionalTitleBorder _functionalBorder;

    public DOMTree() {
        this((Document)null, false);
    }

    public DOMTree(boolean generateSequenceNumbers) {
        this((Document)null, generateSequenceNumbers);
    }

    public void release() {
        if (this.getFunctionalBorder() != null) {
            this.getFunctionalBorder().release();
        }
        this.setModel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize() {
        if (this.getDocument() != null) {
            FileSelector selector = new FileSelector("Save XPath result");
            selector.setRootDir(new File(JAXFrontProperties.getInstance().getLastOpenedFolder().getFile()));
            selector.showSaveDialog((Component)this);
            File selectedFile = selector.getSelectedFile();
            if (selectedFile == null) {
                return;
            }
            FileHelper xmlFile = null;
            try {
                xmlFile = new FileHelper(selectedFile);
                xmlFile.writeIntoFile(DOMHelper.serialize((Document)this.getDocument()));
                xmlFile.closeFileEntry();
            }
            catch (IOException e) {
                LogRegistry.getInstance().error(this.getClass(), (Exception)e);
            }
            finally {
                if (xmlFile != null) {
                    try {
                        xmlFile.closeFileEntry();
                    }
                    catch (IOException e1) {}
                }
            }
        }
    }

    public DOMTree(Document document, boolean generateSequenceNumbers) {
        super(new Model(generateSequenceNumbers));
        this.setRootVisible(false);
        this.setDocument(document);
        this.initBorder();
    }

    public DOMTree(List nodes, boolean generateSequenceNumbers) {
        super(new Model(generateSequenceNumbers));
        this.setRootVisible(false);
        this.setNodeList(nodes);
        this.initBorder();
    }

    public DOMTree(NodeList nodes, boolean generateSequenceNumbers) {
        super(new Model(generateSequenceNumbers));
        this.setNodeList(nodes);
        this.initBorder();
    }

    private void initBorder() {
        this.getFunctionalBorder().addBorderAction("collapse", (Action)new GenericAction("collapseAllNodes", this, "collapseAllNodes"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/collapse_16x16.gif").getImage(), "collapse all Reports beneath selection", 1);
        this.getFunctionalBorder().addBorderAction("expand", (Action)new GenericAction("expandAllNodes", this, "expandAllNodes"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/expand_16x16.gif").getImage(), "expand all Reports beneath selection", 1);
        this.getFunctionalBorder().addBorderActionSeparator(1);
        this.getFunctionalBorder().addBorderAction("search", (Action)new GenericAction("searchForNodes", this, "searchForNodes"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/search_16x16.gif").getImage(), "search all Reports for text", 1);
        this.getFunctionalBorder().addBorderActionSeparator(1);
        this.getFunctionalBorder().addBorderAction("save", (Action)new GenericAction("serialize", this, "serialize"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/saveFile_16x16.gif").getImage(), "save Result", 1);
    }

    public void collapseAllNodes() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (node != null) {
            TreeUtil.collapseJTreeNode(this, node, -1);
        }
    }

    public void setBorderActionRootComponent(JComponent borderActionRoot) {
        borderActionRoot.setBorder(this.getFunctionalBorder());
        this.getFunctionalBorder().setRootComponent(borderActionRoot);
    }

    public void expandAllNodes() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (node != null) {
            TreeUtil.expandJTreeNode((JTree)this, node, -1);
        }
    }

    public void searchForNodes() {
        TreeUtil.searchForNodes(this, this, "Search Node:", "Found Nodes:");
    }

    public void setDocument(Document document) {
        ((Model)this.getModel()).setDocument(document);
        this.expandRow(0);
    }

    public void setNodeList(NodeList nodes) {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = doc.createElement("Result");
            doc.appendChild(element);
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node aResultNode = doc.importNode(nodes.item(i), true);
                    this.insertResultNode(element, aResultNode);
                }
            }
        }
        catch (ParserConfigurationException e) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            // empty catch block
        }
        ((Model)this.getModel()).setDocument(doc);
        this.expandRow(0);
    }

    private void insertResultNode(Element where, Node what) {
        switch (what.getNodeType()) {
            case 2: {
                where.setAttributeNode((Attr)what);
                break;
            }
            case 1: {
                where.appendChild(what);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            case 8: {
                break;
            }
            case 10: {
                break;
            }
        }
    }

    public void setNodeList(List nodes) {
        Document doc = null;
        try {
            doc = DOMHelper.createDocument((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><Result/>");
        }
        catch (XMLParseException e1) {
            e1.printStackTrace();
        }
        catch (SAXException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Element element = doc.getDocumentElement();
        if (nodes != null) {
            for (int i = 0; i < nodes.size(); ++i) {
                if (nodes.get(i) instanceof Node) {
                    Node aResultNode = doc.importNode((Node)nodes.get(i), true);
                    this.insertResultNode(element, aResultNode);
                    continue;
                }
                this.insertResultNode(element, doc.createElement(nodes.get(i).toString()));
            }
        }
        ((Model)this.getModel()).setDocument(doc);
        this.expandRow(0);
    }

    public static String buildPath(Stack xpathStack) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < xpathStack.size(); ++i) {
            result.append(xpathStack.get(i));
        }
        return result.toString();
    }

    private static String[] buildChildNodeNameIndexes(NodeList childs) {
        String[] result = new String[childs.getLength()];
        Hashtable<String, Integer> names = new Hashtable<String, Integer>(childs.getLength());
        int[] resultIndex = new int[childs.getLength()];
        for (int i = 0; i < childs.getLength(); ++i) {
            Node aChild = childs.item(i);
            String nodeName = aChild.getNodeName() + "";
            if (names.get(nodeName) != null) {
                Integer index = (Integer)names.get(aChild.getNodeName());
                names.put(aChild.getNodeName(), new Integer(index + 1));
                resultIndex[i] = index + 1;
                continue;
            }
            names.put(aChild.getNodeName(), new Integer(1));
            resultIndex[i] = 1;
        }
        for (int col = 0; col < childs.getLength(); ++col) {
            result[col] = (Integer)names.get(childs.item(col).getNodeName()) > 1 ? "[" + resultIndex[col] + "]" : "";
        }
        return result;
    }

    public Document getDocument() {
        return ((Model)this.getModel()).getDocument();
    }

    public Node getNode(Object treeNode) {
        return ((Model)this.getModel()).getNode(treeNode);
    }

    public FunctionalTitleBorder getFunctionalBorder() {
        if (this._functionalBorder == null) {
            this._functionalBorder = new FunctionalTitleBorder(BorderFactory.createEmptyBorder(), " ");
        }
        return this._functionalBorder;
    }

    public static class Model
    extends DefaultTreeModel
    implements Serializable {
        private boolean _indexingEnabled = false;
        private Document document;
        private Hashtable nodeMap = new Hashtable();

        public Model(boolean generateSequenceNumbers) {
            this((Document)null, generateSequenceNumbers);
        }

        public Model(Document document, boolean generateSequenceNumbers) {
            super(new DefaultMutableTreeNode());
            this.setIndexingEnabled(generateSequenceNumbers);
            this.setDocument(document);
        }

        public synchronized void setDocument(Document document) {
            this.document = document;
            ((DefaultMutableTreeNode)this.getRoot()).removeAllChildren();
            this.nodeMap.clear();
            this.buildTree();
            this.fireTreeStructureChanged(this, new Object[]{this.getRoot()}, new int[0], new Object[0]);
        }

        public Document getDocument() {
            return this.document;
        }

        public Node getNode(Object treeNode) {
            return (Node)this.nodeMap.get(treeNode);
        }

        private void buildTree() {
            if (this.document == null) {
                return;
            }
            Stack<String> xpath = new Stack<String>();
            NodeList nodes = this.document.getChildNodes();
            int len = nodes != null ? nodes.getLength() : 0;
            MutableTreeNode root = (MutableTreeNode)this.getRoot();
            String[] possibleChildListIndexes = DOMTree.buildChildNodeNameIndexes(nodes);
            for (int i = 0; i < len; ++i) {
                Node node = nodes.item(i);
                xpath.push("/");
                if (this.isIndexingEnabled() && possibleChildListIndexes[i] != null && !possibleChildListIndexes[i].equals("")) {
                    xpath.push(node.getNodeName() + possibleChildListIndexes[i]);
                } else {
                    xpath.push(node.getNodeName());
                }
                switch (node.getNodeType()) {
                    case 9: {
                        root = this.insertDocumentNode(node, root, xpath);
                        break;
                    }
                    case 1: {
                        this.insertElementNode(node, root, xpath);
                        break;
                    }
                }
                xpath.pop();
                xpath.pop();
            }
        }

        public boolean isIndexingEnabled() {
            return this._indexingEnabled;
        }

        public void setIndexingEnabled(boolean enabled) {
            this._indexingEnabled = enabled;
        }

        private MutableTreeNode insertNode(String what, MutableTreeNode where, Stack xpath, String value) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(what);
            node.setUserObject(new XpathUserObject(xpath.peek().toString(), value, DOMTree.buildPath(xpath)));
            this.insertNodeInto(node, where, where.getChildCount());
            return node;
        }

        private MutableTreeNode insertDocumentNode(Node what, MutableTreeNode where, Stack xpath) {
            MutableTreeNode treeNode = this.insertNode("<" + what.getNodeName() + '>', where, xpath, "");
            xpath.push(what.getNodeName());
            this.nodeMap.put(treeNode, what);
            xpath.pop();
            return treeNode;
        }

        private MutableTreeNode insertElementNode(Node what, MutableTreeNode where, Stack xpath) {
            String name = what.getNodeName();
            MutableTreeNode element = this.insertNode(name.toString(), where, xpath, what.getNodeValue());
            this.nodeMap.put(element, what);
            NamedNodeMap attrs = what.getAttributes();
            int attrCount = attrs != null ? attrs.getLength() : 0;
            for (int i = 0; i < attrCount; ++i) {
                Node attr = attrs.item(i);
                xpath.push("/");
                xpath.push("@" + attr.getNodeName());
                this.insertAttributeNode(attr, element, xpath);
                xpath.pop();
                xpath.pop();
            }
            NodeList children = what.getChildNodes();
            String[] possibleChildListIndexes = DOMTree.buildChildNodeNameIndexes(children);
            int len = children != null ? children.getLength() : 0;
            block6: for (int i = 0; i < len; ++i) {
                Node node = children.item(i);
                switch (node.getNodeType()) {
                    case 4: {
                        this.insertCDataSectionNode(node, element, xpath);
                        continue block6;
                    }
                    case 3: {
                        this.insertTextNode(node, element, xpath);
                        continue block6;
                    }
                    case 1: {
                        xpath.push("/");
                        if (this.isIndexingEnabled() && possibleChildListIndexes[i] != null && !possibleChildListIndexes[i].equals("")) {
                            xpath.push(node.getNodeName() + possibleChildListIndexes[i]);
                        } else {
                            xpath.push(node.getNodeName());
                        }
                        this.insertElementNode(node, element, xpath);
                        xpath.pop();
                        xpath.pop();
                    }
                }
            }
            return element;
        }

        private MutableTreeNode insertTextNode(Node what, MutableTreeNode where, Stack xpath) {
            String value = what.getNodeValue().trim();
            if (value.length() > 0) {
                xpath.push("/text()");
                MutableTreeNode treeNode = this.insertNode("text()", where, xpath, value);
                this.nodeMap.put(treeNode, what);
                xpath.pop();
                return treeNode;
            }
            return null;
        }

        private MutableTreeNode insertAttributeNode(Node what, MutableTreeNode where, Stack xpath) {
            String value = what.getNodeValue().trim();
            if (value.length() > 0) {
                MutableTreeNode treeNode = this.insertNode(value, where, xpath, value);
                this.nodeMap.put(treeNode, what);
                return treeNode;
            }
            return null;
        }

        private MutableTreeNode insertCDataSectionNode(Node what, MutableTreeNode where, Stack xpath) {
            StringBuffer CSectionBfr = new StringBuffer();
            CSectionBfr.append(what.getNodeValue());
            if (CSectionBfr.length() > 0) {
                xpath.push(what.getNodeName());
                MutableTreeNode treeNode = this.insertNode(CSectionBfr.toString(), where, xpath, CSectionBfr.toString());
                this.nodeMap.put(treeNode, what);
                xpath.pop();
                return treeNode;
            }
            return null;
        }

        public class XpathUserObject {
            private String _visualName;
            private String _value;
            private String _xPath;
            private boolean showValue = true;

            public XpathUserObject(String visualName, String value, String xpath) {
                this.setVisualName(visualName);
                this.setValue(value);
                this.setXPath(xpath);
            }

            public String toString() {
                if (this.isShowValue() && this.getValue() != null) {
                    return this.getVisualName() + " : " + this.getValue();
                }
                return this.getVisualName();
            }

            public void setValue(String value) {
                this._value = value;
            }

            public String getValue() {
                return this._value;
            }

            public void setVisualName(String visualName) {
                this._visualName = visualName;
            }

            public String getVisualName() {
                return this._visualName;
            }

            public void setXPath(String _xPath) {
                this._xPath = _xPath;
            }

            public String getXPath() {
                return this._xPath;
            }

            void setShowValue(boolean showValue) {
                this.showValue = showValue;
            }

            private boolean isShowValue() {
                return this.showValue;
            }
        }
    }
}

