/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.swing.ui.editor.AbstractEditorPanel;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class Dialog
implements ActionListener,
ContainerListener,
KeyListener {
    private Component _root = null;
    private Component _content = null;
    private Type _rootType = null;
    private ActionListener _dialogListener;
    private JDialog _dialog = null;
    private JButton _okButton = null;
    private JButton _cancelButton = null;
    private JPanel _editButtonPanel;
    private int _OkButtonSequence = -1;
    private boolean _wasCanceled = false;
    public static final int DEFAULT_OK_BUTTON_SEQUENCE = 1;
    private static String okText = GUIComponentNLS.getInstance().getNLSText("button_ok", "Ok");
    private static String cancelText = GUIComponentNLS.getInstance().getNLSText("button_cancel", "Cancel");
    private static Object[] okCancelSequence = new Object[]{okText, cancelText};
    private static Object[] okSequence = new Object[]{okText};

    public Dialog(Component root, Type rootType) {
        this(root, null, rootType);
    }

    public Dialog(Component root, Type rootType, int okButtonSequence) {
        this(root, null, rootType, okButtonSequence);
    }

    public Dialog(Component root, Component content, Type rootType) {
        this(root, content, rootType, -1);
    }

    public Dialog(Component root, Component content, Type rootType, int okButtonSequence) {
        this._root = root;
        this._rootType = rootType;
        this._OkButtonSequence = okButtonSequence;
        this.build();
        this.setContent(content);
        this.addKeyAndContainerListenerRecursively(this.getDialog());
    }

    public JDialog build() {
        this.setDialog(GUITools.createDialogFor(this._root, true));
        String dialogText = GUIComponentNLS.getInstance().getNLSText("dialog_formulaEditor", "Formula Editor");
        this.getDialog().setTitle(dialogText);
        this.getDialog().addWindowListener(new WindowListener(){

            public void windowActivated(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
            }
        });
        this.getDialog().setSize(600, 450);
        this.getDialog().addKeyListener(this);
        JScrollPane expandedScrollPane = new JScrollPane(this.getContent());
        this.getDialog().getContentPane().add((Component)expandedScrollPane, "Center");
        this.getDialog().getContentPane().add((Component)this.getDialogButtonBar(), "South");
        return this.getDialog();
    }

    private JPanel getDialogButtonBar() {
        if (this._editButtonPanel == null) {
            this._editButtonPanel = new JPanel(new BorderLayout());
            String okButtonAlignment = "left";
            String cancelButtonAlignment = "right";
            if (this._rootType != null && this._rootType.getXUIDefinition().getStyle().getTableInfo() != null) {
                okButtonAlignment = this._rootType.getXUIDefinition().getStyle().getTableInfo().getOkButtonAlignment();
                cancelButtonAlignment = this._rootType.getXUIDefinition().getStyle().getTableInfo().getCancelButtonAlignment();
                if (this._OkButtonSequence == -1) {
                    this._OkButtonSequence = this._rootType.getXUIDefinition().getStyle().getTableInfo().getOkButtonSeqPos();
                }
            }
            if (this._OkButtonSequence == -1) {
                this._OkButtonSequence = 1;
            }
            if (okButtonAlignment.equalsIgnoreCase(cancelButtonAlignment)) {
                JPanel buttonBoxPanel = new JPanel();
                buttonBoxPanel.setLayout(new BoxLayout(buttonBoxPanel, 0));
                if (this._OkButtonSequence == 0) {
                    buttonBoxPanel.add(this.getOkButton());
                    buttonBoxPanel.add(this.getCancelButton());
                } else {
                    buttonBoxPanel.add(this.getCancelButton());
                    buttonBoxPanel.add(this.getOkButton());
                }
                if (okButtonAlignment.equalsIgnoreCase("left")) {
                    this._editButtonPanel.add((Component)buttonBoxPanel, "West");
                } else if (okButtonAlignment.equalsIgnoreCase("right")) {
                    this._editButtonPanel.add((Component)buttonBoxPanel, "East");
                } else {
                    this._editButtonPanel.add((Component)buttonBoxPanel, "Center");
                }
            } else {
                if (this._OkButtonSequence == 0) {
                    this._editButtonPanel.add((Component)this.getOkButton(), "West");
                    this._editButtonPanel.add((Component)this.getCancelButton(), "East");
                } else {
                    this._editButtonPanel.add((Component)this.getCancelButton(), "East");
                }
                this._editButtonPanel.add((Component)this.getOkButton(), "West");
            }
        }
        return this._editButtonPanel;
    }

    public void computeDialogBounds(Component containerComponent) {
        Rectangle result = new Rectangle(0, 0, 0, 0);
        if (containerComponent != null && this.getDialog() != null) {
            int x = containerComponent.getX() + (containerComponent.getWidth() - this.getDialog().getWidth()) / 2;
            int y = containerComponent.getY() + (containerComponent.getHeight() - this.getDialog().getHeight()) / 2;
            x = x >= 0 ? x : 0;
            y = y >= 0 ? y : 0;
            result.x = x;
            result.y = y;
            result.width = this.getDialog().getWidth();
            result.height = this.getDialog().getHeight();
        }
        this.getDialog().setBounds(result);
    }

    public void setContent(Component content) {
        if (content != null) {
            this.getDialog().getContentPane().add(content);
        }
        this._content = content;
    }

    private Component getContent() {
        if (this._content == null) {
            this._content = new JPanel();
        }
        return this._content;
    }

    public void setUndecorated(boolean undecorated) {
        this.getDialog().setUndecorated(undecorated);
    }

    public void setSize(Dimension d) {
        this.getDialog().setSize(d);
    }

    public void setLocation(int x, int y) {
        this.getDialog().setLocation(x, y);
    }

    public void setLocation(Point location) {
        this.getDialog().setLocation(location.x, location.y);
    }

    public void setVisible(boolean visible) {
        this.getDialog().setVisible(visible);
    }

    public void setTitle(String title) {
        this.getDialog().setTitle(title);
    }

    public void setBackground(Color c) {
        this.getDialog().getContentPane().setBackground(c);
        this.getDialogButtonBar().setBackground(c);
    }

    public void setForeground(Color c) {
        this.getDialog().getContentPane().setForeground(c);
        this.getDialogButtonBar().setForeground(c);
    }

    public void doLayout() {
        this.getDialog().doLayout();
    }

    public void repaint() {
        this.getDialog().repaint();
    }

    public int getWidth() {
        return this.getDialog().getWidth();
    }

    public int getHeight() {
        return this.getDialog().getHeight();
    }

    public void release() {
        if (this.getDialogListener() != null) {
            this.getOkButton().removeActionListener(this.getDialogListener());
            this.getCancelButton().removeActionListener(this.getDialogListener());
        }
        this.getDialog().removeKeyListener(this);
        this.removeKeyAndContainerListenerRecursively(this.getDialog());
    }

    private void setOkButton(JButton _okButton) {
        this._okButton = _okButton;
    }

    private JButton getOkButton() {
        if (this._okButton == null) {
            this.setOkButton(new JButton(Dialog.getOKButtonName()));
            this.getOkButton().addActionListener(this.getDialogListener());
            this.getOkButton().addActionListener(this);
        }
        return this._okButton;
    }

    public static String getOKButtonName() {
        return GUIComponentNLS.getInstance().getNLSText("button_ok", "Ok");
    }

    public static String getCANCELButtonName() {
        return GUIComponentNLS.getInstance().getNLSText("button_cancel", "Cancel");
    }

    private void setCancelButton(JButton _cancelButton) {
        this._cancelButton = _cancelButton;
    }

    private JButton getCancelButton() {
        if (this._cancelButton == null) {
            this.setCancelButton(new JButton(Dialog.getCANCELButtonName()));
            this.getCancelButton().addActionListener(this.getDialogListener());
            this.getCancelButton().addActionListener(this);
        }
        return this._cancelButton;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getCancelButton()) {
            this.setCanceled(true);
        }
        this.getDialog().setVisible(false);
    }

    public void setModal(boolean b) {
        this.getDialog().setModal(b);
    }

    public void setDialogListener(ActionListener dialogListener) {
        this._dialogListener = dialogListener;
        this.getOkButton().addActionListener(dialogListener);
        this.getCancelButton().addActionListener(dialogListener);
    }

    public static Rectangle computeDialogBounds(Component window, Component dialog) {
        Rectangle result = new Rectangle(0, 0, 0, 0);
        if (window != null && dialog != null) {
            int x = window.getX() + (window.getWidth() - dialog.getWidth()) / 2;
            int y = window.getY() + (window.getHeight() - dialog.getHeight()) / 2;
            x = x >= 0 ? x : 0;
            y = y >= 0 ? y : 0;
            result.x = x;
            result.y = y;
            result.width = dialog.getWidth();
            result.height = dialog.getHeight();
        }
        return result;
    }

    private ActionListener getDialogListener() {
        return this._dialogListener;
    }

    private void addKeyAndContainerListenerRecursively(Component c) {
        c.addKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    public void componentAdded(ContainerEvent e) {
        this.addKeyAndContainerListenerRecursively(e.getChild());
    }

    public void componentRemoved(ContainerEvent e) {
        this.removeKeyAndContainerListenerRecursively(e.getChild());
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.setCanceled(true);
            this.setVisible(false);
        } else if (code == 10) {
            this.getDialogListener().actionPerformed(new ActionEvent(e.getSource(), 1001, this.getOkButton().getActionCommand()));
            this.setVisible(false);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private void setCanceled(boolean _wasCanceled) {
        this._wasCanceled = _wasCanceled;
    }

    public boolean isCanceled() {
        return this._wasCanceled;
    }

    private void setDialog(JDialog _dialog) {
        this._dialog = _dialog;
    }

    public JDialog getDialogComponent() {
        return this.getDialog();
    }

    private JDialog getDialog() {
        return this._dialog;
    }

    public static synchronized void showErrorDialog(String message) {
        Dialog.showErrorDialog(JAXFrontProperties.getInstance().createDialogFrame(), message);
    }

    public static synchronized void showInformationDialog(String message) {
        Dialog.showInformationDialog(JAXFrontProperties.getInstance().createDialogFrame(), message);
    }

    public static synchronized int showConfirmDialog(String message) {
        return Dialog.showConfirmDialog(JAXFrontProperties.getInstance().createDialogFrame(), message);
    }

    public static synchronized void showWarningDialog(String message) {
        Dialog.showWarningDialog(JAXFrontProperties.getInstance().createDialogFrame(), message);
    }

    public static synchronized void showErrorDialog(Component parent, String message) {
        String title = GUIComponentNLS.getInstance().getNLSText("dialog_error", "Error");
        Dialog.showErrorDialog(parent, message, title);
    }

    public static synchronized void showErrorDialog(Component parent, String message, String title) {
        JTextArea textA = new JTextArea(message);
        textA.setEditable(false);
        JScrollPane sp = new JScrollPane(textA);
        sp.setPreferredSize(new Dimension(640, 256));
        JOptionPane.showOptionDialog(parent, sp, title, 0, 0, null, okSequence, null);
    }

    public static synchronized void showErrorDialog(Component parent, String message, Throwable t, String title) {
        JComponent errorContainer = null;
        JTextArea textA = new JTextArea(message);
        textA.setEditable(false);
        JScrollPane sp = new JScrollPane(textA);
        sp.setPreferredSize(new Dimension(640, 256));
        if (t != null) {
            String messageTitle = GUIComponentNLS.getInstance().getNLSText("checkbox_message", "Message");
            String detailTitle = GUIComponentNLS.getInstance().getNLSText("dialog_details", "Details");
            JTabbedPane tabP = new JTabbedPane();
            StringWriter errorWriter = new StringWriter();
            PrintWriter pw = new PrintWriter(errorWriter);
            t.printStackTrace(pw);
            JTextArea exA = new JTextArea(errorWriter.toString());
            exA.setEditable(false);
            JScrollPane spEx = new JScrollPane(exA);
            spEx.setPreferredSize(new Dimension(640, 256));
            tabP.addTab(messageTitle, sp);
            tabP.addTab(detailTitle, spEx);
            errorContainer = tabP;
        } else {
            errorContainer = sp;
        }
        JOptionPane.showOptionDialog(parent, errorContainer, title, 0, 0, null, okSequence, null);
    }

    public static synchronized void showErrorDialog(Component parent, Component content, String title) {
        JOptionPane.showOptionDialog(parent, content, title, 0, 0, null, okSequence, null);
    }

    public static synchronized void showInformationDialog(Component parent, String message) {
        String title = GUIComponentNLS.getInstance().getNLSText("dialog_info", "Information");
        Dialog.showInformationDialog(parent, title, message);
    }

    public static synchronized void showInformationDialog(Component parent, String title, String message) {
        JOptionPane.showOptionDialog(parent, message, title, 0, 1, null, okSequence, null);
    }

    public static synchronized int showComponentDialog(Component component, String title) {
        return Dialog.showComponentDialog(JAXFrontProperties.getInstance().createDialogFrame(), component, title);
    }

    public static synchronized int showComponentDialog(Component parent, Component component, String title) {
        return JOptionPane.showOptionDialog(parent, component, title, 2, -1, null, okCancelSequence, null);
    }

    public static synchronized int showConfirmDialog(Component parent, String message) {
        String title = GUIComponentNLS.getInstance().getNLSText("dialog_info", "Information");
        return Dialog.showConfirmDialog(parent, title, message);
    }

    public static synchronized int showConfirmDialog(Component parent, String title, String message) {
        return JOptionPane.showOptionDialog(parent, message, title, 2, 3, null, okCancelSequence, null);
    }

    public static synchronized void showWarningDialog(Component parent, String message) {
        String title = GUIComponentNLS.getInstance().getNLSText("dialog_warning", "Warning");
        Dialog.showWarningDialog(parent, message, title);
    }

    public static synchronized void showWarningDialog(Component parent, String message, String title) {
        JOptionPane.showOptionDialog(parent, message, title, 0, 2, null, okSequence, null);
    }

    public static boolean showListDeletionDialog(Type viewType, Type typeToDelete) {
        boolean deleteListItem = true;
        Document dom = viewType.getDOM();
        AbstractEditorPanel editor = (AbstractEditorPanel)dom.getEditor();
        int selection = 0;
        String message = viewType.getXUIDefinition().getStyle().getDeletionConfirmationMessageText();
        if (message == null || message.length() == 0 || message.equals(viewType.getName())) {
            message = GUIComponentNLS.getInstance().getNLSText(dom, "message_deletion_confirmation", "Do you really want to delete the selected item?");
        }
        Object[] options = new Object[]{GUIComponentNLS.getInstance().getNLSText(dom, "button_yes", "Yes"), GUIComponentNLS.getInstance().getNLSText(dom, "button_no", "No"), GUIComponentNLS.getInstance().getNLSText(dom, "button_cancel", "Cancel")};
        String dialogTitle = GUIComponentNLS.getInstance().getNLSText(dom, "dialog_deletion_confirmation", "Delete Selected Item");
        if (editor.getWorkspace() != null && (selection = JOptionPane.showOptionDialog(editor.getWorkspace(), message, dialogTitle, 1, 3, null, options, options[0])) != 0) {
            deleteListItem = false;
        }
        return deleteListItem;
    }

    private static JPanel buildKeyRefErrorPanel(Type typeToDelete, String message) {
        int listSize = 1;
        RowSpec[] rowSpec = new RowSpec[7 + listSize];
        for (int a = 0; a < listSize + 7; ++a) {
            rowSpec[a] = new RowSpec("p");
        }
        ColumnSpec[] colSpec = new ColumnSpec[]{new ColumnSpec("p")};
        FormLayout formLayout = new FormLayout(colSpec, rowSpec);
        JPanel messagePanel = new JPanel(formLayout);
        String contextDeletionWarning = GUIComponentNLS.getInstance().getNLSText(typeToDelete.getDOM(), "message_context_item_deletion_warning", "The following object cannot be deleted:");
        JLabel message1 = new JLabel(contextDeletionWarning);
        messagePanel.add((Component)message1, "1,1,L,C");
        messagePanel.add((Component)new JLabel(" "), "1,2,C,C");
        String contextItemValue = "";
        if (typeToDelete.getXUIDefinition().getStyle().hasDisplayValue()) {
            contextItemValue = typeToDelete.getXUIDefinition().getStyle().getDisplayValue();
        }
        JLabel message2 = new JLabel(contextItemValue);
        messagePanel.add((Component)message2, "1,3,L,C");
        messagePanel.add((Component)new JLabel(" "), "1,4,C,C");
        String useOfContextMessage = GUIComponentNLS.getInstance().getNLSText(typeToDelete.getDOM(), "message_context_items_usage", "It is still referenced in the following context(s):");
        JLabel message3 = new JLabel(useOfContextMessage);
        messagePanel.add((Component)message3, "1,5,L,C");
        messagePanel.add((Component)new JLabel(" "), "1,6,C,C");
        JLabel messageLabel = new JLabel(message);
        messagePanel.add((Component)messageLabel, "1," + message + ",L,C");
        return messagePanel;
    }

    public Container getContentPane() {
        return this._dialog.getContentPane();
    }
}

