/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.swing.ui.tools.BorderActionSet;
import com.jaxfront.swing.ui.tools.CollapsiblePanel;
import com.jaxfront.swing.ui.tools.GenericAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class FunctionalGraphics
implements MouseListener,
MouseMotionListener {
    private static Point _lastMouseLoc = new Point();
    private boolean _isEnabled = true;
    private boolean _listenerInitialized = false;
    private Component _rootComponent;
    private Vector _registeredBorderActions;
    public int _imageYOffset = 1;
    private static final int _imageXSpacer = 4;
    private static final int _imageYSpacer = 1;
    public int _imageXOffset = 5;
    public int _width = 0;
    public int _height = 0;
    int _titelH = 0;
    int _titelW = 0;
    private String _toolTipText;
    private Action _titleActionLeftMouse;
    private Action _titleActionRightMouse;
    private Action _titleActionCenterMouse;
    private String _text;
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    static final int EDGE_SPACING = 2;
    static final int TEXT_SPACING = 2;
    int TEXT_INSET_H = 5;
    int titelH = 0;
    int titelW = 0;
    private Point textLoc = new Point();

    public FunctionalGraphics(Component parent) {
        this.setRootComponent(parent);
    }

    public FunctionalGraphics(Component parent, String text) {
        this(parent);
        this._text = text;
    }

    private void initRootListeners(Component rootComponent) {
        if (rootComponent != null && !this._listenerInitialized) {
            this.removeRootListeners();
            rootComponent.addMouseListener(this);
            rootComponent.addMouseMotionListener(this);
            if (rootComponent instanceof JComponent) {
                ToolTipManager.sharedInstance().registerComponent((JComponent)rootComponent);
            }
            this._listenerInitialized = true;
        }
    }

    private void removeRootListeners() {
        if (this.getRootComponent() != null) {
            this.getRootComponent().removeMouseListener(this);
            this.getRootComponent().removeMouseMotionListener(this);
            if (this._rootComponent instanceof JComponent) {
                ToolTipManager.sharedInstance().registerComponent((JComponent)this.getRootComponent());
            }
        }
    }

    public void resetAllActions() {
        for (int i = 0; i < this.getRegisteredBorderActions().size(); ++i) {
            BorderActionSet aSet = (BorderActionSet)this.getRegisteredBorderActions().get(i);
            aSet.setWillToggled(false);
        }
        if (this.getRegisteredBorderActions().size() > 0) {
            this.getRootComponent().repaint();
        }
    }

    public BorderActionSet getActionInRange(Point p) {
        for (int i = 0; i < this.getRegisteredBorderActions().size(); ++i) {
            BorderActionSet aSet = (BorderActionSet)this.getRegisteredBorderActions().get(i);
            if (!aSet.isVisible() || !aSet.isMouseInRange(p, this.getRootComponent())) continue;
            return aSet;
        }
        return null;
    }

    public void paint(Graphics g, int x, int y, int width, int height) {
        this.paint(g, x, y, width, height, this._text, new Point(0, 8));
    }

    public int getTextInsetHorizontal() {
        Rectangle actionAreaRectLeft = FunctionalGraphics.getActionAreaRectangle(this.getRegisteredBorderActions(), 0);
        return actionAreaRectLeft.width + 5;
    }

    public void paint(Graphics g, int x, int y, int width, int height, String text, Point textLocation) {
        Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        this.TEXT_INSET_H = this.getTextInsetHorizontal();
        int highestLeft = -1;
        for (int i = this.getRegisteredBorderActions().size() - 1; i >= 0; --i) {
            BorderActionSet aSet = (BorderActionSet)this.getRegisteredBorderActions().get(i);
            if (!aSet.isVisible()) continue;
            Rectangle range = aSet.getPaintRectangle();
            int newX = 0;
            if (aSet.getAlignment() == 0) {
                newX = range.x;
                if (highestLeft < newX + range.width + 4) {
                    highestLeft = newX + range.width + 4;
                }
            } else {
                newX = grooveRect.width - range.x;
            }
            int drawedX = newX;
            int drawedY = range.y;
            if (aSet.willToggled() && aSet.isEnabled() && aSet.isActionEnabled()) {
                drawedX = newX + 4;
                drawedY = range.y + 1;
            }
            g.drawImage(aSet.getActionImageToBeDisplayed(), drawedX, drawedY, null, null);
        }
    }

    public void setEnabled(boolean enabled) {
        this._isEnabled = enabled;
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        BorderActionSet aSet;
        if (e.getSource() == this.getRootComponent() && this.isEnabled() && e.getButton() == 1 && (aSet = this.getActionInRange(e.getPoint())) != null) {
            aSet.setWillToggled(true);
            this.getRootComponent().repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.getRootComponent() && this.isEnabled() && e.getButton() == 1) {
            BorderActionSet aSet = this.getActionInRange(e.getPoint());
            if (aSet != null && aSet.isEnabled()) {
                aSet.setWillToggled(false);
                aSet.fireActualAction(new ActionEvent(e.getSource(), e.getID(), "mouseClicked"));
                this.getRootComponent().repaint();
            } else {
                this.resetAllActions();
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("TestBorder");
        JPanel aPanel = new JPanel();
        aPanel.add(new JButton("buttonjwingscheiss"));
        FunctionalGraphics border = new FunctionalGraphics(f);
        border.setToolTipText("bubbleTextBubble");
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel(aPanel);
        border.addBorderAction(CollapsiblePanel.getExpandCollapseBorderSet(collapsiblePanel));
        border.setRootComponent(collapsiblePanel);
        border.setTitleAction(new GenericAction("button1", border, "button1"), 1);
        border.setTitleAction(new GenericAction("button2", border, "button2"), 2);
        border.setTitleAction(new GenericAction("button3", border, "button3"), 3);
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)collapsiblePanel, "Center");
        f.setSize(300, 300);
        f.setVisible(true);
    }

    public Vector getRegisteredBorderActions() {
        if (this._registeredBorderActions == null) {
            this._registeredBorderActions = new Vector();
        }
        return this._registeredBorderActions;
    }

    public void addBorderAction(BorderActionSet aSet) {
        this.initRootListeners(this.getRootComponent());
        this.getRegisteredBorderActions().add(aSet);
        this.initActionDimensions(this.getRegisteredBorderActions());
        if (this.getRootComponent() != null) {
            this.getRootComponent().repaint();
        }
    }

    public static final Dimension calculateActionAreaDimension(Vector actionSets) {
        int x = 0;
        int y = 0;
        for (int i = 0; i < actionSets.size(); ++i) {
            BorderActionSet aSet = (BorderActionSet)actionSets.get(i);
            if (aSet.getActionImage() == null) continue;
            x += aSet.getActionImage().getWidth(null) + 3;
            y += aSet.getActionImage().getHeight(null);
        }
        return new Dimension(x, y);
    }

    public static final int getActionAreaX(Vector actionSets) {
        if (actionSets.size() > 0) {
            BorderActionSet aSet = (BorderActionSet)actionSets.get(0);
            return aSet.getUIRange().x;
        }
        return 0;
    }

    private static final Rectangle getActionAreaRectangle(Vector actionSets, int alignment) {
        int width = 0;
        int height = 0;
        for (int i = 0; i < actionSets.size(); ++i) {
            BorderActionSet aSet = (BorderActionSet)actionSets.get(i);
            if (aSet.getActionImage() == null || aSet.getAlignment() != alignment) continue;
            width += aSet.getActionImage().getWidth(null) + 3;
            int newHeight = aSet.getActionImage().getHeight(null);
            height = height <= newHeight ? newHeight : height;
        }
        return new Rectangle(0, 0, width, height);
    }

    private final void initActionDimensions(Vector actionSets) {
        BorderActionSet aSet;
        int i;
        int x = this._imageXOffset;
        int y = this._imageYOffset;
        for (i = 0; i < actionSets.size(); ++i) {
            aSet = (BorderActionSet)actionSets.get(i);
            if (aSet.getActionImage() != null && aSet.getAlignment() == 0 && aSet.isVisible()) {
                int oldx = x;
                int width = aSet.getActionImage().getWidth(null);
                int height = aSet.getActionImage().getHeight(null);
                x += aSet.getActionImage().getWidth(null) + 3;
                aSet.setUIRange(new Rectangle(oldx, y, width, height));
                this._height = Math.max(this._height, height);
            }
            this._width = x;
        }
        x = -1;
        y = this._imageYOffset;
        for (i = 0; i < actionSets.size(); ++i) {
            aSet = (BorderActionSet)actionSets.get(i);
            if (aSet.getActionImage() == null || aSet.getAlignment() != 1 || !aSet.isVisible()) continue;
            int width = aSet.getActionImage().getWidth(null);
            int height = aSet.getActionImage().getHeight(null);
            if (x == -1) {
                x = 2;
            }
            aSet.setUIRange(new Rectangle(x += aSet.getActionImage().getWidth(null) + 3, y, width, height));
            this._height = Math.max(this._height, height);
        }
        this._width += x >= 0 ? x : 0;
    }

    public Dimension getSize() {
        return new Dimension(this._width, this._height);
    }

    public void setRootComponent(Component rootComponent) {
        this.initRootListeners(rootComponent);
        this._rootComponent = rootComponent;
    }

    public Component getRootComponent() {
        return this._rootComponent;
    }

    public BorderActionSet addBorderAction(String name, Action mainAction, Action inverseAction, Image mainImage, Image inverseImage, Image actionImageShadowed, Image inverseActionImageShadowed, String toolTipText, int alignment) {
        BorderActionSet aBorderAction = new BorderActionSet(name, mainAction, inverseAction, mainImage, inverseImage, actionImageShadowed, inverseActionImageShadowed, toolTipText, alignment);
        this.addBorderAction(aBorderAction);
        return aBorderAction;
    }

    public BorderActionSet addBorderActionSeparator(Image mainImage, int alignment) {
        BorderActionSet aBorderAction = new BorderActionSet("Separator", null, null, mainImage, null, null, null, null, alignment);
        aBorderAction.setActionEnabled(false);
        this.addBorderAction(aBorderAction);
        return aBorderAction;
    }

    public BorderActionSet addBorderActionSeparator(int alignment) {
        return this.addBorderActionSeparator(JAXFrontProperties.getImage((String)"com/jaxfront/core/images/files/verticalLine_6x16.gif"), alignment);
    }

    public BorderActionSet addBorderAction(String name, Action mainAction, Image mainImage, Image actionImageShadowed, String toolTipText, int alignment) {
        BorderActionSet aBorderAction = new BorderActionSet(name, mainAction, null, mainImage, null, actionImageShadowed, null, toolTipText, alignment);
        this.addBorderAction(aBorderAction);
        return aBorderAction;
    }

    public BorderActionSet addBorderAction(String name, Action mainAction, Image mainImage, String toolTipText, int alignment) {
        BorderActionSet aBorderAction = new BorderActionSet(name, mainAction, null, mainImage, null, null, null, toolTipText, alignment);
        this.addBorderAction(aBorderAction);
        return aBorderAction;
    }

    public BorderActionSet addBorderAction(Action mainAction, int alignment) {
        ImageIcon mainImage = (ImageIcon)mainAction.getValue("SmallIcon");
        String name = mainAction.getValue("Name") != null ? mainAction.getValue("Name").toString() : "not set";
        String toolTipText = mainAction.getValue("ShortDescription") != null ? mainAction.getValue("ShortDescription").toString() : "";
        BorderActionSet aBorderAction = new BorderActionSet(name, mainAction, null, mainImage.getImage(), null, null, null, toolTipText, alignment);
        this.addBorderAction(aBorderAction);
        return aBorderAction;
    }

    public BorderActionSet addBorderAction(Action mainAction, Action inverseAction, Image actionImageShadowed, Image inverseActionImageShadowed, int alignment) {
        ImageIcon mainImage = (ImageIcon)mainAction.getValue("SmallIcon");
        String name = mainAction.getValue("Name") != null ? mainAction.getValue("Name").toString() : "not set";
        String toolTipText = mainAction.getValue("ShortDescription") != null ? mainAction.getValue("ShortDescription").toString() : "";
        ImageIcon inverseImage = (ImageIcon)mainAction.getValue("SmallIcon");
        BorderActionSet aBorderAction = new BorderActionSet(name, mainAction, inverseAction, mainImage.getImage(), inverseImage.getImage(), actionImageShadowed, inverseActionImageShadowed, toolTipText, alignment);
        this.addBorderAction(aBorderAction);
        return aBorderAction;
    }

    public BorderActionSet addBorderAction(Action mainAction, Action inverseAction, int alignment) {
        ImageIcon mainImage = (ImageIcon)mainAction.getValue("SmallIcon");
        String name = mainAction.getValue("Name") != null ? mainAction.getValue("Name").toString() : "not set";
        String toolTipText = mainAction.getValue("ShortDescription") != null ? mainAction.getValue("ShortDescription").toString() : "";
        ImageIcon inverseImage = (ImageIcon)inverseAction.getValue("SmallIcon");
        BorderActionSet aBorderAction = new BorderActionSet(name, mainAction, inverseAction, mainImage.getImage(), inverseImage.getImage(), null, null, toolTipText, alignment);
        this.addBorderAction(aBorderAction);
        return aBorderAction;
    }

    public BorderActionSet addBorderAction(String name, Action mainAction, Action inverseAction, Image mainImage, Image inverseImage, String toolTipText, int alignment) {
        BorderActionSet aBorderAction = new BorderActionSet(name, mainAction, inverseAction, mainImage, inverseImage, null, null, toolTipText, alignment);
        this.addBorderAction(aBorderAction);
        return aBorderAction;
    }

    public void removeBorderAction(String name) {
        for (int i = this.getRegisteredBorderActions().size() - 1; i >= 0; --i) {
            BorderActionSet aSet = (BorderActionSet)this.getRegisteredBorderActions().get(i);
            if (!aSet.getName().equals(name)) continue;
            this.removeBorderAction(aSet);
            break;
        }
    }

    public BorderActionSet getBorderAction(String name) {
        for (int i = this.getRegisteredBorderActions().size() - 1; i >= 0; --i) {
            BorderActionSet aSet = (BorderActionSet)this.getRegisteredBorderActions().get(i);
            if (!aSet.getName().equals(name)) continue;
            return aSet;
        }
        return null;
    }

    public void removeBorderAction(BorderActionSet aSet) {
        this.getRegisteredBorderActions().remove(aSet);
        this.initActionDimensions(this.getRegisteredBorderActions());
        if (this.getRootComponent() != null) {
            this.getRootComponent().repaint();
        }
    }

    public void toggleActionSet(BorderActionSet aSet, boolean toogle) {
        aSet.setToggled(toogle);
        this.getRootComponent().repaint();
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (e.getSource() == this.getRootComponent()) {
            FunctionalGraphics.setLastMouseLocation(e.getPoint());
        }
    }

    public String getToolTipText(MouseEvent e) {
        BorderActionSet aSet = this.getActionInRange(e.getPoint());
        if (aSet != null) {
            return aSet.getToolTipText();
        }
        return null;
    }

    public void setToolTipText(String toolTipText) {
        this.initRootListeners(this.getRootComponent());
        this._toolTipText = toolTipText;
    }

    public void setText(String text) {
        this._text = text;
    }

    public String getToolTipText() {
        return this._toolTipText;
    }

    public void release() {
        this.removeRootListeners();
        this.setRootComponent(null);
    }

    public void setTitleAction(Action titleAction, int mouseButton) {
        this.initRootListeners(this.getRootComponent());
        switch (mouseButton) {
            case 1: {
                this._titleActionLeftMouse = titleAction;
                break;
            }
            case 2: {
                this._titleActionCenterMouse = titleAction;
                break;
            }
            case 3: {
                this._titleActionRightMouse = titleAction;
                break;
            }
            default: {
                this._titleActionLeftMouse = titleAction;
            }
        }
    }

    public static ImageIcon createDisabledIcon(ImageIcon icon) {
        ImageIcon result = null;
        if (icon != null) {
            result = new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
        }
        return result;
    }

    public void setVisible(String borderActionName, boolean isActive) {
        BorderActionSet aSet = this.getBorderAction(borderActionName);
        if (aSet != null) {
            this.initActionDimensions(this.getRegisteredBorderActions());
            aSet.setVisible(isActive);
        }
    }

    public boolean istVisible(String borderActionName) {
        BorderActionSet aSet = this.getBorderAction(borderActionName);
        if (aSet != null) {
            return aSet.isVisible();
        }
        return false;
    }

    public Action getTitleAction(int mouseButton) {
        switch (mouseButton) {
            case 1: {
                return this._titleActionLeftMouse;
            }
            case 2: {
                return this._titleActionCenterMouse;
            }
            case 3: {
                return this._titleActionRightMouse;
            }
        }
        return this._titleActionLeftMouse;
    }

    private static void setLastMouseLocation(Point mouseLoc) {
        _lastMouseLoc = mouseLoc;
    }

    public static Point getLastMouseLocation() {
        return _lastMouseLoc;
    }

    public boolean isInTitelBox(Point p) {
        Rectangle titelBoxRectangle = new Rectangle(this.textLoc.x, this.titelH - this.textLoc.y, this.titelW, this.titelH);
        if (titelBoxRectangle != null) {
            return titelBoxRectangle.contains(p);
        }
        return false;
    }
}

