/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class InternalFrameManager {
    private static int computeFrameDistance(JInternalFrame frame) {
        return frame.getHeight() - frame.getContentPane().getHeight();
    }

    public static void cascadeWindows2(JDesktopPane desktop) {
        JInternalFrame[] frames = desktop.getAllFrames();
        int x = 0;
        int y = 0;
        int frameDistance = 20;
        int frameCount = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i].isIcon()) continue;
            ++frameCount;
        }
        int width = desktop.getWidth() - (frameCount - 1) * frameDistance;
        int height = desktop.getHeight() - (frameCount - 1) * frameDistance;
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i].isIcon()) continue;
            try {
                frames[i].setMaximum(false);
                frames[i].reshape(x, y, width, height);
                y += frameDistance;
                if ((x += frameDistance) + width > desktop.getWidth()) {
                    x = 0;
                }
                if (y + height <= desktop.getHeight()) continue;
                y = 0;
                continue;
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
    }

    public static void cascadeWindows(JDesktopPane desktop) {
        int computedFrameDistance = 0;
        JInternalFrame[] frames = desktop.getAllFrames();
        int x = 0;
        int y = 0;
        int width = desktop.getWidth() / 2;
        int height = desktop.getHeight() / 2;
        for (int i = 0; i < frames.length; ++i) {
            if (computedFrameDistance == 0) {
                computedFrameDistance = InternalFrameManager.computeFrameDistance(frames[i]);
            }
            if (frames[i].isIcon()) continue;
            try {
                frames[i].setMaximum(false);
                frames[i].reshape(x, y, width, height);
                y += computedFrameDistance;
                if ((x += computedFrameDistance) + width > desktop.getWidth()) {
                    x = 0;
                }
                if (y + height <= desktop.getHeight()) continue;
                y = 0;
                continue;
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
    }

    public static void tileWindows(JDesktopPane desktop) {
        JInternalFrame[] frames = desktop.getAllFrames();
        int frameCount = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i].isIcon()) continue;
            ++frameCount;
        }
        int rows = (int)Math.sqrt(frameCount);
        int cols = frameCount / rows;
        int extra = frameCount % rows;
        int width = desktop.getWidth() / cols;
        int height = desktop.getHeight() / rows;
        int r = 0;
        int c = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i].isIcon()) continue;
            try {
                frames[i].setMaximum(false);
                frames[i].reshape(c * width, r * height, width, height);
                if (++r != rows) continue;
                r = 0;
                if (++c != cols - extra) continue;
                height = desktop.getHeight() / ++rows;
                continue;
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
    }

    public static void selectNextWindow(JDesktopPane desktop) {
        JInternalFrame[] frames = desktop.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isSelected()) continue;
            try {
                int next;
                for (next = i + 1; next != i && frames[next].isIcon(); ++next) {
                }
                if (next == i) {
                    return;
                }
                frames[next].setSelected(true);
                frames[next].toFront();
                return;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public static void setDragOutline(JDesktopPane desktop, boolean dragOutLine) {
        desktop.putClientProperty("JDesktopPane.dragMode", dragOutLine ? "outline" : null);
    }
}

