/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.util.TextTools;
import com.jaxfront.swing.ui.tools.FontTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class Label2D
extends JPanel {
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    private String _caption;
    private boolean _antialiasing = false;
    private int _alignment = 1;

    public Label2D() {
        this("");
    }

    public Label2D(int alignment) {
        this("", alignment);
    }

    public Label2D(String caption) {
        this(caption, 1);
    }

    public Label2D(String caption, int alignment) {
        this._caption = caption;
        this._alignment = alignment;
        this.setBackground(Color.lightGray);
        this.setFont(FontTools.PLAINFONT);
    }

    private void clearBackground(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
    }

    private void drawLine(Graphics g, String line, int ypos) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (this._alignment == 0) {
            g.drawString(line, (this.getBounds().width - fm.stringWidth(line)) / 2, ypos);
        } else if (this._alignment == 1) {
            g.drawString(line, 4, ypos);
        } else if (this._alignment == 2) {
            g.drawString(line, this.getBounds().width - fm.stringWidth(line) - 4, ypos);
        }
    }

    public String getCaption() {
        return this._caption;
    }

    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (this._caption == null || this._caption.length() == 0) {
            return new Dimension(0, fm.getHeight());
        }
        String[] lines = TextTools.tokenize((String)this._caption, (String)"\r\n");
        int maxwidth = 0;
        for (int i = 0; i < lines.length; ++i) {
            maxwidth = Math.max(maxwidth, fm.stringWidth(lines[i]));
        }
        return new Dimension(8 + maxwidth, 4 + lines.length * fm.getHeight());
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.clearBackground(g);
        if (this._antialiasing) {
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2d.setRenderingHints(hints);
        }
        if (this._caption != null) {
            g.setColor(this.getForeground());
            g.setFont(this.getFont());
            FontMetrics fm = this.getFontMetrics(this.getFont());
            String[] lines = TextTools.tokenize((String)this._caption, (String)"\r\n");
            int fontheight = fm.getHeight();
            int ypos = fm.getAscent() + 2;
            int maxwidth = this.getSize().width - 4;
            for (int l = 0; l < lines.length; ++l) {
                String[] words = TextTools.tokenize((String)lines[l], (String)" \t");
                String line = "";
                for (int i = 0; i < words.length; ++i) {
                    if (fm.stringWidth(line + words[i]) > maxwidth) {
                        this.drawLine(g, line, ypos);
                        line = words[i];
                        ypos += fontheight;
                        continue;
                    }
                    if (line.length() != 0) {
                        line = line + " ";
                    }
                    line = line + words[i];
                }
                this.drawLine(g, line, ypos);
                ypos += fontheight;
            }
        }
    }

    public void setAlignment(int alignment) {
        this._alignment = alignment;
    }

    public void setAntialias(boolean a) {
        this._antialiasing = a;
        this.repaint();
    }

    public void setCaption(String caption) {
        if (this._caption != caption) {
            this._caption = caption;
            if (this.getParent() != null) {
                this.repaint();
            }
        }
    }
}

