/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.swing.ui.tools.PreviewCorner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

class PreviewPopup
extends JPopupMenu
implements MouseListener,
MouseMotionListener {
    private JScrollPane _scrollPane;
    private JViewport _viewPort;
    private JLabel _zoomWindow;
    private JLabel _cursorLabel;
    private JLayeredPane _layeredPane;
    private int _iconWidth;
    private int _iconHeight;
    private boolean _doCloseAfterClick;
    int _ratio;
    private static int DELTA = 5;
    private static int SCALEFACTOR = 4;

    public PreviewPopup(JScrollPane scrollPane, boolean doCloseAfterClick) {
        this.setBorder(BorderFactory.createEtchedBorder());
        this._doCloseAfterClick = doCloseAfterClick;
        this._scrollPane = scrollPane;
        this._viewPort = this._scrollPane.getViewport();
        this._zoomWindow = new JLabel();
        this._cursorLabel = this.createCursor();
        this._layeredPane = new JLayeredPane();
        this._layeredPane.add((Component)this._zoomWindow, new Integer(0));
        this._layeredPane.add((Component)this._cursorLabel, new Integer(1));
        BufferedImage bim = new BufferedImage(1, 1, 6);
        this.setCursor(this.getToolkit().createCustomCursor(bim, new Point(0, 0), "HiddenM"));
        this.add(this._layeredPane);
        this._layeredPane.addMouseListener(this);
        this._layeredPane.addMouseMotionListener(this);
    }

    public void showUpInCorner(Component c, String corner) {
        if (this._viewPort.getComponentCount() == 0) {
            return;
        }
        this._ratio = this._viewPort.getWidth() < this._viewPort.getHeight() * SCALEFACTOR ? this._viewPort.getComponent(0).getWidth() / (this._viewPort.getWidth() / SCALEFACTOR) : this._viewPort.getComponent(0).getHeight() / (this._viewPort.getHeight() / SCALEFACTOR);
        int zoomWindowImageWidth = this._viewPort.getComponent(0).getWidth() / this._ratio;
        int zoomWindowImageHeight = this._viewPort.getComponent(0).getHeight() / this._ratio;
        Image componentImage = PreviewPopup.captureComponentViewAsBufferedImage(this._viewPort.getComponent(0), Color.WHITE).getScaledInstance(zoomWindowImageWidth, zoomWindowImageHeight, 4);
        ImageIcon componentIcon = new ImageIcon(componentImage);
        this._iconWidth = componentIcon.getIconWidth();
        this._iconHeight = componentIcon.getIconHeight();
        this._zoomWindow.setIcon(componentIcon);
        this._zoomWindow.setBounds(0, 0, this._iconWidth, this._iconHeight);
        int cursorWidth = this._viewPort.getWidth() / this._ratio;
        int cursorHeight = this._viewPort.getHeight() / this._ratio;
        this._cursorLabel.setBounds(0, 0, cursorWidth, cursorHeight);
        this._layeredPane.setPreferredSize(new Dimension(this._iconWidth, this._iconHeight));
        int dx = componentIcon.getIconWidth() + DELTA;
        int dy = componentIcon.getIconHeight() + DELTA;
        if (corner != "UPPER_LEFT_CORNER") {
            if (corner == "UPPER_RIGHT_CORNER") {
                dx = -dx;
            } else if (corner == "LOWER_RIGHT_CORNER") {
                dx = -dx;
                dy = -dy;
            } else if (corner == "LOWER_LEFT_CORNER") {
                dy = -dy;
            }
        }
        this.show(c, dx, dy);
    }

    public static void main(String[] args) throws IOException {
        File imageFile;
        if (args.length != 1) {
            System.err.println("Usage: java SampleApp <ImageFilePath>");
            System.exit(-1);
        }
        if (!(imageFile = new File(args[0])).exists()) {
            System.err.println("The given image file does not exist:" + imageFile.getAbsolutePath());
            System.exit(-1);
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(imageFile);
        }
        catch (IOException ex2) {
            System.err.println("Could not read the given image file:" + imageFile.getAbsolutePath());
            System.exit(-1);
        }
        JScrollPane imagePane = new JScrollPane(new JLabel(new ImageIcon(image)));
        ImageIcon previewIcon = new ImageIcon("previewscroller.png");
        imagePane.setCorner("LOWER_RIGHT_CORNER", new PreviewCorner(imagePane, previewIcon, true, "LOWER_RIGHT_CORNER"));
        JFrame f = new JFrame("Press button at lower right corner to invoke previewer...");
        f.setDefaultCloseOperation(3);
        Container cp = f.getContentPane();
        cp.add((Component)imagePane, "Center");
        f.setSize(700, 300);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    public JLabel createCursor() {
        JLabel label = new JLabel();
        label.setBorder(BorderFactory.createLineBorder(Color.black));
        label.setVisible(false);
        return label;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this._cursorLabel.setVisible(true);
    }

    public void mouseExited(MouseEvent e) {
        this._cursorLabel.setVisible(false);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (this._doCloseAfterClick) {
            this.setVisible(false);
            this._cursorLabel.setVisible(false);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.moveCursor(e.getX(), e.getY());
        this.scrollViewPort();
    }

    public void mouseMoved(MouseEvent e) {
        this.moveCursor(e.getX(), e.getY());
        this.scrollViewPort();
    }

    private void moveCursor(int x, int y) {
        int dx = x - this._cursorLabel.getWidth() / 2;
        int dy = y - this._cursorLabel.getHeight() / 2;
        this._cursorLabel.setLocation(dx, dy);
    }

    private void scrollViewPort() {
        Point cursorLocation = this._cursorLabel.getLocation();
        int dx = (int)Math.max(cursorLocation.getX(), 0.0);
        int dy = (int)Math.max(cursorLocation.getY(), 0.0);
        ((JComponent)this._viewPort.getComponent(0)).scrollRectToVisible(new Rectangle(dx *= this._ratio, dy *= this._ratio, this._viewPort.getWidth(), this._viewPort.getHeight()));
    }

    public static BufferedImage captureComponentViewAsBufferedImage(Component c, Color backgroundColor) {
        Dimension size = c.getSize();
        BufferedImage bufferedImage = new BufferedImage(size.width, size.height, 1);
        Graphics2D bufferedGraphics = bufferedImage.createGraphics();
        bufferedGraphics.setColor(backgroundColor);
        bufferedGraphics.fillRect(0, 0, size.width, size.height);
        c.paint(bufferedGraphics);
        return bufferedImage;
    }
}

