/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.swing.ui.tools.ImageTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class SignView
extends JComponent
implements Runnable {
    private Image _bildchen = null;
    private Image _emptyBildchen = null;
    private Image _bildchenToShow = null;
    private Image _inverseBildchen = new ImageIcon().getImage();
    private String _refValue = "0";
    private int ahowManyBlinks = 10;
    private boolean _isRunning = false;
    private boolean _isTextBlinking = false;
    private Font _font = null;
    private Color _fontColor = Color.darkGray;
    private int _yOffest;
    private int _xOffset;
    private int _brightness = -1;

    public static void main(String[] args) {
        JFrame aFrame = new JFrame();
        SignView yellow = new SignView("com/jaxfront/core/images/files/arrowDown_16x16.gif");
        aFrame.getContentPane().setLayout(new FlowLayout());
        aFrame.getContentPane().add(yellow);
        aFrame.getContentPane().add(new SignView("com/jaxfront/core/images/files/arrowUp_16x16.gif"));
        aFrame.getContentPane().add(new SignView("com/jaxfront/core/images/files/arrowLeft_16x16.gif"));
        yellow.setText("a");
        yellow.flash();
        aFrame.setSize(300, 300);
        aFrame.setVisible(true);
    }

    public SignView(String imageName) {
        this(imageName, null);
    }

    public SignView(String imageName, String inverseImageName) {
        this.setBildchen(JAXFrontProperties.getImage((String)imageName));
        if (inverseImageName != null) {
            this.setInverseBildchen(JAXFrontProperties.getImage((String)inverseImageName));
        }
        this._bildchenToShow = this.getBildchen();
    }

    private Font createFont(Graphics g) {
        if (this._font == null) {
            this._font = g.getFont();
            this._font = this._font.deriveFont(1);
            this._font = this._font.deriveFont(10.0f);
        }
        return this._font;
    }

    public SignView(String imageName, String inverseImageName, int blinkCount) {
        this(imageName, inverseImageName);
        this.ahowManyBlinks = blinkCount;
    }

    public void paint(Graphics g) {
        g.setFont(this.createFont(g));
        g.drawImage(this._bildchenToShow, 0, 0, this);
        if (this._bildchenToShow != this._bildchen || !this.isTextBlinking()) {
            g.setColor(this.getFontColor());
            int bildchenWidth = this._bildchen.getWidth(this);
            int bildchenHeight = this._bildchen.getHeight(this);
            FontMetrics fm = g.getFontMetrics();
            int width = fm.stringWidth(this._refValue);
            int height = fm.getAscent() - fm.getDescent();
            int x = bildchenWidth / 2 - width / 2;
            int y = bildchenHeight / 2 + height / 2;
            String paintValue = "";
            if (!this._refValue.equals("0")) {
                paintValue = this._refValue;
            }
            g.drawString(paintValue, x + this.getXOffset(), y + this.getYOffest());
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getBildchen().getWidth(this), this.getBildchen().getHeight(this));
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.getBildchen().getWidth(this), this.getBildchen().getHeight(this));
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.getBildchen().getWidth(this), this.getBildchen().getHeight(this));
    }

    public void setOrderRefCount(int _orderRefCount) {
        if (this._refValue.equals("" + _orderRefCount)) {
            return;
        }
        this._refValue = _orderRefCount == 0 ? "0" : (_orderRefCount > 9 ? ">" : "" + _orderRefCount);
        this.flash();
    }

    public void setText(String signText) {
        if (this._refValue.equals("" + signText)) {
            return;
        }
        this._refValue = signText;
        this.flash();
    }

    public void flash() {
        if (!this.isRunning()) {
            this.setRunning(true);
            new Thread(this).start();
        }
    }

    private synchronized void blink() {
        for (int i = 0; i < this.ahowManyBlinks || this.ahowManyBlinks == -1 || this.isRunning(); ++i) {
            try {
                this._bildchenToShow = this._bildchenToShow == this.getBildchen() ? (this.getInverseBildchen() == null ? this.getEmptyBildchen() : this.getInverseBildchen()) : this.getBildchen();
                this.repaint();
                this.wait(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._bildchenToShow = this.getBildchen();
        this.repaint();
    }

    public synchronized void run() {
        if (this.isRunning()) {
            this.blink();
            this.setRunning(false);
        }
    }

    public void setRunning(boolean running) {
        this._isRunning = running;
    }

    private boolean isRunning() {
        return this._isRunning;
    }

    public void setInverseBrightness(int brightness) {
        this._brightness = brightness;
        this.setInverseBildchen(this.getInverseBildchen());
    }

    private int getInverseBrightness() {
        return this._brightness;
    }

    public void setInverseBildchen(Image inverseBildchen) {
        if (inverseBildchen != null) {
            this._inverseBildchen = this.getInverseBrightness() >= 0 ? ImageTools.changeBrightness(inverseBildchen, this.getInverseBrightness()) : inverseBildchen;
        }
    }

    public Image getInverseBildchen() {
        return this._inverseBildchen;
    }

    public void setBildchen(Image bildchen) {
        this._bildchen = bildchen;
    }

    public Image getBildchen() {
        return this._bildchen;
    }

    public void setBlinks(int blinks) {
        this.ahowManyBlinks = blinks;
    }

    private Color getFontColor() {
        return this._fontColor;
    }

    public void setTextBlinking(boolean isTextBlinking) {
        this._isTextBlinking = isTextBlinking;
    }

    private boolean isTextBlinking() {
        return this._isTextBlinking;
    }

    public void setXOffset(int xOffset) {
        this._xOffset = xOffset;
    }

    public int getXOffset() {
        return this._xOffset;
    }

    public void setYOffest(int yOffest) {
        this._yOffest = yOffest;
    }

    public int getYOffest() {
        return this._yOffest;
    }

    private Image getEmptyBildchen() {
        if (this._emptyBildchen == null) {
            this._emptyBildchen = ImageTools.createEmptyImage();
        }
        return this._emptyBildchen;
    }
}

