/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class VerticalTextIcon
implements Icon,
SwingConstants {
    private Font font = UIManager.getFont("Label.font");
    private FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
    private String text;
    private int width;
    private int height;
    private boolean clockwize;

    public VerticalTextIcon(String text, boolean clockwize) {
        this.text = text;
        this.width = SwingUtilities.computeStringWidth(this.fm, text);
        this.height = this.fm.getHeight();
        this.clockwize = clockwize;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        AffineTransform oldTransform = g2.getTransform();
        g.setFont(this.font);
        g.setColor(Color.black);
        if (this.clockwize) {
            g2.translate(x + this.getIconWidth(), y);
            g2.rotate(1.5707963267948966);
        } else {
            g2.translate(x, y + this.getIconHeight());
            g2.rotate(-1.5707963267948966);
        }
        g.drawString(this.text, 0, this.fm.getLeading() + this.fm.getAscent());
        g.setFont(oldFont);
        g.setColor(oldColor);
        g2.setTransform(oldTransform);
    }

    public int getIconWidth() {
        return this.height;
    }

    public int getIconHeight() {
        return this.width;
    }

    public static void addTab(JTabbedPane tabPane, String text, Component comp) {
        int tabPlacement = tabPane.getTabPlacement();
        switch (tabPlacement) {
            case 2: 
            case 4: {
                tabPane.addTab(null, new VerticalTextIcon(text, tabPlacement == 4), comp);
                return;
            }
        }
        tabPane.addTab(text, null, comp);
    }

    public static JTabbedPane createTabbedPane(int tabPlacement) {
        switch (tabPlacement) {
            case 2: 
            case 4: {
                Object textIconGap = UIManager.get("TabbedPane.textIconGap");
                Insets tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
                UIManager.put("TabbedPane.textIconGap", new Integer(1));
                UIManager.put("TabbedPane.tabInsets", new Insets(tabInsets.left, tabInsets.top, tabInsets.right, tabInsets.bottom));
                JTabbedPane tabPane = new JTabbedPane(tabPlacement);
                UIManager.put("TabbedPane.textIconGap", textIconGap);
                UIManager.put("TabbedPane.tabInsets", tabInsets);
                return tabPane;
            }
        }
        return new JTabbedPane(tabPlacement);
    }
}

