/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools.mask;

import com.jaxfront.swing.ui.tools.mask.MaskElement;
import com.jaxfront.swing.ui.tools.mask.MaskLiteral;
import com.jaxfront.swing.ui.tools.mask.MaskMacros;
import com.jaxfront.swing.ui.tools.mask.MaskParser;
import com.jaxfront.swing.ui.tools.mask.MaskToken;
import com.jaxfront.swing.ui.tools.mask.MaskTokenizer;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class MaskDocument
extends PlainDocument {
    protected char templateChar;
    protected MaskMacros macros;
    protected MaskTokenizer tokenizer;
    protected Vector pattern = new Vector();
    protected MaskParser parser = new MaskParser();

    public MaskDocument(String mask, MaskMacros macros, char templateChar) {
        this.templateChar = templateChar;
        this.macros = macros;
        this.parse(mask);
    }

    public void parse(String text) {
        MaskTokenizer tokenizer = new MaskTokenizer("&|![](){} ", "");
        this.pattern.removeAllElements();
        tokenizer.tokenize(text);
        while (tokenizer.hasMoreTokens()) {
            this.parseElement(tokenizer);
        }
    }

    private void parseElement(MaskTokenizer tokenizer) {
        MaskToken next = tokenizer.nextToken();
        if (next.equals('{')) {
            this.pattern.addElement(this.parser.parseCondition(tokenizer));
            MaskParser.expect(tokenizer.nextToken(), '}');
        } else {
            String text = next.text;
            for (int i = 0; i < text.length(); ++i) {
                this.pattern.addElement(new MaskLiteral(text.charAt(i)));
            }
        }
    }

    public MaskElement getRule(int index) {
        if (index < this.pattern.size()) {
            return (MaskElement)this.pattern.elementAt(index);
        }
        return null;
    }

    public String template() {
        int length = this.pattern.size();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buffer.append(this.template(i));
        }
        return buffer.toString();
    }

    public char template(int pos) {
        char literal;
        MaskElement rule = this.getRule(pos);
        if (rule instanceof MaskLiteral && !this.macros.containsMacro(literal = ((MaskLiteral)rule).chr)) {
            return literal;
        }
        return this.templateChar;
    }

    public boolean match(int pos, char chr) {
        char macro;
        MaskElement element = this.getRule(pos);
        if (element == null) {
            return false;
        }
        if (element instanceof MaskLiteral && this.macros.containsMacro(macro = ((MaskLiteral)element).chr)) {
            return this.macros.getMacro(macro).match(chr);
        }
        return element.match(chr);
    }

    public void insertString(int pos, String text, AttributeSet attr) throws BadLocationException {
        int len = text.length();
        if (len == 0) {
            return;
        }
        if (len > 1) {
            for (int i = pos; i < len; ++i) {
                this.insertString(pos, "" + text.charAt(i), attr);
            }
            return;
        }
        if (!this.match(pos, text.charAt(0))) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        super.remove(pos, 1);
        super.insertString(pos, text, attr);
    }

    public void remove(int pos, int length) throws BadLocationException {
        if (length > 1) {
            for (int i = pos; i < length; ++i) {
                this.remove(pos, 1);
            }
            return;
        }
        if (length == 0 && this.getLength() == 0) {
            String template = this.template();
            super.insertString(pos, template, null);
            return;
        }
        if (pos == this.getLength()) {
            return;
        }
        String text = "" + this.template(pos);
        super.remove(pos, 1);
        super.insertString(pos, text, null);
    }
}

