/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools.search;

import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.search.AbstractSearcher;
import com.jaxfront.core.util.search.SearchResultProcessor;
import com.jaxfront.swing.ui.beans.JTextAreaListRenderer;
import java.awt.Container;
import java.util.List;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class ListComponentSearcher
extends AbstractSearcher
implements SearchResultProcessor,
ListSelectionListener {
    private static final String LINE_DEF = "Line ";
    int currentListIndex = 0;
    int currentTextIndex = -1;
    int searchAllListIndex = 0;
    JList _searchList;
    ListModel _searchListModel;
    String _replaceText = null;

    public ListComponentSearcher(JList list) {
        this._searchList = list;
        this._searchListModel = list.getModel();
        list.addListSelectionListener(this);
    }

    public boolean search(String value) {
        this.setSearchValue(value);
        return true;
    }

    public void reset() {
        this.searchAllListIndex = 0;
        this.currentTextIndex = -1;
        super.reset();
    }

    public Object getPrevious() {
        String result = null;
        if (this.currentListIndex >= this._searchListModel.getSize()) {
            this.currentListIndex = this._searchListModel.getSize() - 1;
        }
        while (this.currentListIndex >= 0 && this.currentListIndex < this._searchListModel.getSize()) {
            int resultIndex = this.currentTextIndex;
            resultIndex = this.search(this.getSearchInText(this.currentListIndex), this.getSearchValue(), resultIndex + 1);
            if (resultIndex >= 0) {
                result = LINE_DEF + this.currentListIndex + ":" + resultIndex + "-" + (resultIndex + this.getSearchValue().length());
                this.currentTextIndex = resultIndex;
                break;
            }
            this.currentTextIndex = -1;
            --this.currentListIndex;
        }
        if (result == null) {
            this.reset();
        }
        return result;
    }

    public int getLineAtCaret(JTextComponent component) {
        return 0;
    }

    public int search(String text, String what, int from) {
        int fInd = -1;
        if (this._matchWord) {
            what = " " + what.trim() + " ";
        }
        fInd = this._matchCase ? text.indexOf(what, from) : StringUtil.indexOfIgnoreCase((String)text, (String)what, (int)from);
        if (this._matchWord && fInd >= 0) {
            ++fInd;
        }
        return fInd;
    }

    public Object getNext() {
        String result = null;
        if (this.currentListIndex < 0) {
            this.currentListIndex = 0;
        }
        while (this.currentListIndex >= 0 && this.currentListIndex < this._searchListModel.getSize()) {
            int resultIndex = this.currentTextIndex;
            resultIndex = this.search(this.getSearchInText(this.currentListIndex), this.getSearchValue(), resultIndex + 1);
            if (resultIndex >= 0) {
                result = LINE_DEF + this.currentListIndex + ":" + resultIndex + "-" + (resultIndex + this.getSearchValue().length());
                this.currentTextIndex = resultIndex;
                break;
            }
            this.currentTextIndex = -1;
            ++this.currentListIndex;
        }
        if (result == null) {
            this.reset();
        }
        return result;
    }

    public void process(Object aResult) {
        if (aResult != null) {
            String selection = aResult.toString();
            int lineSepIndex = selection.indexOf(58) + 1;
            int sepIndex = selection.indexOf(45);
            int line = Integer.parseInt(selection.substring(LINE_DEF.length(), lineSepIndex - 1).trim());
            int from = Integer.parseInt(selection.substring(lineSepIndex, sepIndex));
            int to = Integer.parseInt(selection.substring(sepIndex + 1, selection.length()));
            this._searchList.setSelectedIndex(line);
            this._searchList.ensureIndexIsVisible(line);
            JTextAreaListRenderer comp = (JTextAreaListRenderer)this._searchList.getCellRenderer();
            comp.setTextHighlighting(line, from, to);
            this.currentListIndex = line;
            this.currentTextIndex = from;
            this._searchList.repaint();
        }
    }

    protected void selectText(int from, int to) {
    }

    protected Container getParentContainer() {
        return this._searchList.getParent();
    }

    protected String getSearchInText(int index) {
        Object item = this._searchListModel.getElementAt(index);
        if (item != null) {
            return item.toString();
        }
        return "";
    }

    protected String getSelectedText() {
        return "";
    }

    protected int getSelectionStart() {
        return 0;
    }

    public List getAll() {
        Vector<String> result = new Vector<String>();
        while (this.searchAllListIndex < this._searchListModel.getSize()) {
            int resultIndex = -1;
            while (true) {
                int n = this.search(this.getSearchInText(this.searchAllListIndex), this.getSearchValue(), resultIndex + 1);
                resultIndex = n;
                resultIndex = n;
                if (n < 0) break;
                if (resultIndex < 0) continue;
                result.add(LINE_DEF + this.searchAllListIndex + ":" + resultIndex + "-" + (resultIndex + this.getSearchValue().length()));
            }
            ++this.searchAllListIndex;
        }
        return result;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getFirstIndex() >= 0) {
            this.currentListIndex = e.getFirstIndex();
        }
    }
}

