/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.EmptyType;
import com.jaxfront.core.type.SimpleTypeList;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.ChoiceComboboxRenderer;
import com.jaxfront.core.ui.ChoiceName;
import com.jaxfront.core.ui.EditablePanel;
import com.jaxfront.core.ui.TabbableView;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.ImageHelper;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.LicenseChecker;
import com.jaxfront.core.util.XMLSchemaPositionSorter;
import com.jaxfront.core.xui.FormLayoutInfo;
import com.jaxfront.core.xui.StyleDefinition;
import com.jaxfront.core.xui.TableCell;
import com.jaxfront.swing.ui.layout.ListLayout;
import com.jaxfront.swing.ui.layout.TabActionIcon;
import com.jaxfront.swing.ui.tools.FontFactory;
import com.jaxfront.swing.ui.tools.FontTools;
import com.jaxfront.swing.ui.tools.FormLayoutBuilder;
import com.jaxfront.swing.ui.tools.HyperTextLabel;
import com.jaxfront.swing.ui.tools.JAXJSplitPanePanel;
import com.jaxfront.swing.ui.visualizers.AbstractView;
import com.jaxfront.swing.ui.visualizers.UIController;
import com.jaxfront.swing.ui.wrapper.JAXJButton;
import com.jaxfront.swing.ui.wrapper.JAXJCheckBox;
import com.jaxfront.swing.ui.wrapper.JAXJComboBox;
import com.jaxfront.swing.ui.wrapper.JAXJRadioButton;
import com.jaxfront.swing.ui.wrapper.JAXJTabbedPane;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractCompositeView
extends AbstractView
implements TabbableView,
ActionListener,
DOMChangeListener,
ChangeListener,
ItemListener {
    protected ButtonGroup _group;
    protected JAXJComboBox _choiceComboBox;
    protected Hashtable _visualizers;
    private JAXJTabbedPane _tabbedPane;
    protected JComponent _visibleComponent;
    protected JAXJCheckBox _optionalCheckBox;
    protected JPanel _choicePanel;
    protected JPanel _selectedPanel;
    protected JPanel _selectionPanel;
    protected JPanel _componentHolderPanel;
    protected JPanel _choiceRadioButtonPanel;
    protected JPanel _choiceComboBoxPanel;
    protected JPanel _radioButtonPanel;
    protected FormLayout _componentHolderTableLayout;
    protected boolean _isUsingComboBox = false;
    private Vector _choiceGuiElements;
    protected boolean _isInitializing = false;
    protected boolean _isInsertingTab = false;
    private static final String noSelectionField = "None";
    protected static final String CLIENT_PROPERTY_TAB_TYPE = "TAB_TYPE";

    public AbstractCompositeView() {
    }

    public AbstractCompositeView(Type context) {
        super(context);
    }

    public void actionPerformed(ActionEvent e) {
        Type selectedType;
        block6: {
            block5: {
                ChoiceName selectedName;
                block7: {
                    selectedType = null;
                    if (!this.isUsingComboBox()) break block5;
                    selectedName = (ChoiceName)this.getComboBox().getSelectedItem();
                    if (selectedName.getTypeName().equals(" ")) break block6;
                    if (!this.getModel().isAbstract()) break block7;
                    selectedType = this.getModel().getChoosenType() == null || !selectedName.getTypeName().equals(this.getModel().getChoosenType().getName()) ? DOMHelper.getDerivedType((Type)this.getModel(), (String)selectedName.getTypeName(), (boolean)true) : this.getModel().getChoosenType();
                    break block6;
                }
                selectedType = this.getModel().getDirectChild(selectedName.getTypeName());
                if (selectedType != null) break block6;
                selectedType = ((CompositeType)this.getModel()).createChoiceType(selectedName.getTypeName());
                break block6;
            }
            if (this.getButtonGroup().getSelection() != null) {
                String name = this.getButtonGroup().getSelection().getActionCommand();
                selectedType = this.getModel().getDirectChild(name);
                if (!name.equals(" ") && (selectedType = this.getModel().getDirectChild(name)) == null) {
                    selectedType = ((CompositeType)this.getModel()).createChoiceType(name);
                }
                Enumeration<AbstractButton> radiobtns = this.getButtonGroup().getElements();
                while (radiobtns.hasMoreElements()) {
                    JRadioButton radioBtn = (JRadioButton)radiobtns.nextElement();
                    if (!radioBtn.getActionCommand().equals(name) || !radioBtn.isSelected()) continue;
                    this.setFirstFocusableComponent(radioBtn);
                    break;
                }
            }
        }
        if (this.getModel().isAbstract() && this.getModel().isRequired() && selectedType != null) {
            this.resetError();
        }
        ((AbstractType)this.getModel()).setChoosenType(null, selectedType, false, true, !this.hasBeenBuilt());
        if (this.getEditor() != null) {
            this.getEditor().updateUI();
        }
    }

    private JAXJRadioButton addButton(String id, String name, String toolTipText, JPanel radioBtnPanel, boolean selected, boolean readOnly) {
        JAXJRadioButton radioBtn = new JAXJRadioButton(name, selected);
        this.getChoiceGuiElements().add(radioBtn);
        radioBtn.setActionCommand(id);
        this.getButtonGroup().add(radioBtn);
        radioBtn.addActionListener(this);
        radioBtn.addFocusListener(this);
        radioBtn.setAlignmentX(0.0f);
        radioBtn.setEnabled(!readOnly);
        if (toolTipText != null && !toolTipText.equals("")) {
            radioBtn.setToolTipText(toolTipText);
        }
        radioBtnPanel.add(radioBtn);
        if (this.getStyle().isChoiceOrientationHorizontal()) {
            radioBtnPanel.add(new JLabel("  "));
        }
        return radioBtn;
    }

    private boolean isApplyCaptionOnLabel() {
        return this.getDOM().getGlobalDefinition().isGlobalApplyCaptionIndentOnLabel();
    }

    private boolean isApplyCaptionOnComponent() {
        return this.getDOM().getGlobalDefinition().isGlobalApplyCaptionIndentOnComponent();
    }

    private boolean isUsingCustomLayout() {
        return this.isUsingTableLayout() || this.isUsingSplitterLayout();
    }

    public void applyCustomLayout(JPanel compHolder, List childs, boolean isTabHolder) {
        if (this.isUsingTableLayout()) {
            this.applyTableLayout(compHolder);
            this.add((Component)compHolder, "Center");
        }
        if (this.isUsingSplitterLayout()) {
            this.applySplitterLayout(compHolder);
            this.add((Component)compHolder, "Center");
        }
    }

    private void applyTabbing(List childs, boolean isTabHolder) {
        if (isTabHolder && childs != null) {
            boolean isShowingTree = this.getDOM().getGlobalDefinition().isShowingTree();
            boolean rootIsTreeNode = this.getDOM().getRootType().isRepresentedAsTreeNode();
            for (int i = 0; i < childs.size(); ++i) {
                Type child = (Type)childs.get(i);
                StyleDefinition childStyle = child.getStyle();
                boolean childVisible = childStyle.isVisible();
                boolean childVisibleAtRuntime = childStyle.isVisibleAtRuntime();
                if (child.isSimple() || child.getTypeClassification() == 128 || !childVisible && !childVisibleAtRuntime || childStyle.isSelfViewHolder() && isShowingTree && rootIsTreeNode || !childStyle.isVisibleInOptionalTreeMode() || !child.isRenderable()) continue;
                this.addTab(child);
            }
        }
    }

    public void applyStandardLayout(JPanel compHolder, List childs, boolean isTabHolder) {
        int indexOfFirstVisibleItemVisualizer = -1;
        JComponent itemVisualizer = null;
        if (childs != null) {
            boolean isShowingTree = this.getDOM().getGlobalDefinition().isShowingTree();
            boolean rootIsTreeNode = this.getDOM().getRootType().isRepresentedAsTreeNode();
            for (int i = 0; i < childs.size(); ++i) {
                Visualizer visualizer;
                Type child = (Type)childs.get(i);
                StyleDefinition childStyle = child.getStyle();
                boolean childVisible = childStyle.isVisible();
                boolean childVisibleAtRuntime = childStyle.isVisibleAtRuntime();
                itemVisualizer = null;
                if (!childVisible && !childVisibleAtRuntime) continue;
                if (indexOfFirstVisibleItemVisualizer == -1) {
                    indexOfFirstVisibleItemVisualizer = i;
                }
                if (!isTabHolder && !childStyle.isSelfViewHolder() && (visualizer = TypeVisualizerFactory.getInstance().getVisualizer(child, this._context)) instanceof JComponent) {
                    itemVisualizer = (JComponent)visualizer;
                }
                if (!(!isTabHolder || childStyle.isSelfViewHolder() && isShowingTree && rootIsTreeNode)) {
                    if (child.isSimple() || child instanceof SimpleTypeList && !child.getStyle().isUsingSerialList()) {
                        itemVisualizer = (JComponent)TypeVisualizerFactory.getInstance().getVisualizer(child, this._context);
                        this.getVisualizers().put(child, itemVisualizer);
                        this.addComponentToComponentHolder(compHolder, itemVisualizer);
                    }
                } else if (itemVisualizer != null) {
                    this.getVisualizers().put(child.getName(), itemVisualizer);
                    this.addComponentToComponentHolder(compHolder, itemVisualizer, child);
                }
                if (i == indexOfFirstVisibleItemVisualizer && itemVisualizer != null) {
                    this.setFirstFocusableComponent(((AbstractView)itemVisualizer).getFirstFocusableComponent());
                }
                if (itemVisualizer == null || childStyle.isVisibleInOptionalTreeMode() || !child.isRepresentedAsTreeNode()) continue;
                itemVisualizer.setVisible(false);
            }
        }
    }

    protected void defaultBuild() {
        boolean isEditable;
        this.setName("mainVisualizerPanel");
        this._isInitializing = true;
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        CompositeType model = (CompositeType)this.getModel();
        StyleDefinition style = model.getStyle();
        Vector compChilds = model.getComposites();
        JPanel serialHolderPanel = null;
        JPanel compHolder = this.getComponentHolder();
        this._componentHolderTableLayout = new FormLayout("0:g(-1.0)", "p");
        compHolder.setLayout(this._componentHolderTableLayout);
        boolean isTabHolder = style.isTabHolder();
        if (model.isChoice()) {
            compChilds = model.getAttributes();
        }
        if (model.isAbstract()) {
            compChilds = new Vector();
        }
        if (isTabHolder) {
            this.getTabbedPane().addChangeListener(UIController.getInstance());
            this.getTabbedPane().addChangeListener(this);
        } else if (style.isSerialView()) {
            serialHolderPanel = new JPanel(new ListLayout(1));
            serialHolderPanel.setName("serialHolderPanel");
        }
        if (this.isUsingCustomLayout()) {
            this.applyCustomLayout(compHolder, compChilds, isTabHolder);
        } else {
            this.applyStandardLayout(compHolder, compChilds, isTabHolder);
        }
        if (style.isTabHolder()) {
            this.applyTabbing(compChilds, isTabHolder);
            this.addComponentToComponentHolder(compHolder, this.getTabbedPane());
            if (this.getTabbedPane().getTabCount() > 0) {
                this.getTabbedPane().setSelectedIndex(-1);
                this.getTabbedPane().setSelectedIndex(0);
            } else {
                this.getTabbedPane().setVisible(false);
            }
        } else if (style.isSerialView()) {
            this.addComponentToComponentHolder(compHolder, serialHolderPanel);
        }
        if (model.isChoice()) {
            this.initChoicePanel();
            this.addComponentToComponentHolder(compHolder, this.getChoicePanel());
        }
        JComponent editorComponent = !this.isUsingCustomLayout() && (this._componentHolderTableLayout.getColumnCount() > 1 || this._componentHolderTableLayout.getRowCount() > 1) ? this.getCaptionPanel(compHolder) : compHolder;
        this.setParentTableLayout(this._componentHolderTableLayout);
        this.setParentTablePanel(compHolder);
        this.add((Component)editorComponent, "Center");
        if (style.hasHint()) {
            String hintText = style.getHintText();
            Color color = style.getHintColor();
            boolean isFormula = style.isHintTextFormula();
            boolean isBold = style.isHintTextBold();
            this.showHint(hintText, isFormula, color, isBold);
        }
        if (!(isEditable = style.isEditable())) {
            this.setEditable(isEditable);
        }
        if (this.getModel().isRoot() && LicenseChecker.getInstance().hasCommunityLicense()) {
            JPanel bannerHolderPanel = new JPanel(new BorderLayout());
            JPanel bannerPanel = new JPanel();
            bannerPanel.setBackground(new Color(238, 244, 217));
            bannerPanel.setBorder(BorderFactory.createLineBorder(new Color(212, 243, 105)));
            JLabel l1 = new JLabel("Generated by");
            l1.setFont(FontTools.getBoldFont(10.0f));
            l1.setForeground(new Color(31, 97, 23));
            bannerPanel.add(l1);
            HyperTextLabel l2 = new HyperTextLabel("JAXFront", "http://www.jaxfront.com");
            l2.setFont(FontTools.getBoldFont(10.0f));
            l2.setForeground(new Color(31, 97, 23));
            bannerPanel.add(l2);
            JLabel l3 = new JLabel(" free community license. (C)copyright 2001-2009 by xcentric technology & consulting GmbH. All rights reserved.");
            bannerPanel.add(l3);
            l3.setFont(FontTools.getBoldFont(10.0f));
            l3.setForeground(new Color(31, 97, 23));
            bannerHolderPanel.add((Component)bannerPanel, "West");
            this.add((Component)bannerHolderPanel, "South");
        }
        this._isInitializing = false;
    }

    private void applySplitterLayout(JPanel holderPanel) {
        JAXJSplitPanePanel spanel = new JAXJSplitPanePanel(true);
        try {
            spanel.buildLayout(this.getModel(), this.getStyle().getSplitterLayoutDefinition());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addComponentToComponentHolder(holderPanel, spanel);
    }

    public void addTab(Type type) {
        if (type != null && this.getTabIndex(type) == -1) {
            int index = 0;
            int topIndent = this.getDOM().getGlobalDefinition().getGlobalTopIndent();
            int bottomIndent = this.getDOM().getGlobalDefinition().getGlobalBottomIndent();
            int leftIndent = this.getDOM().getGlobalDefinition().getGlobalLeftIndent();
            int rightIndent = this.getDOM().getGlobalDefinition().getGlobalRightIndent();
            String columnSpec = "" + leftIndent + ",f:400px:g(100)," + rightIndent;
            String rowSpec = "" + topIndent + ",pref," + bottomIndent;
            FormLayout formLayout = new FormLayout(columnSpec, rowSpec);
            JPanel indentPanel = new JPanel(formLayout);
            indentPanel.setName("indentPanel");
            indentPanel.putClientProperty(CLIENT_PROPERTY_TAB_TYPE, type);
            XMLSchemaPositionSorter sorter = new XMLSchemaPositionSorter(false);
            for (int a = 0; a < this.getTabbedPane().getTabCount(); ++a) {
                Type compareTabType = (Type)((JComponent)this.getTabbedPane().getComponentAt(a)).getClientProperty(CLIENT_PROPERTY_TAB_TYPE);
                if (compareTabType == null) continue;
                boolean isGreater = sorter.compare((Object)compareTabType, (Object)type);
                if (!isGreater) {
                    index = a;
                    break;
                }
                if (a != this.getTabbedPane().getTabCount() - 1) continue;
                index = a + 1;
                break;
            }
            this._isInsertingTab = true;
            TabActionIcon icon = null;
            if (type.getDOM().getGlobalDefinition().isUserModfiedTabSerialization() && !type.isRequired()) {
                icon = this.getTabActionIcon(index);
            }
            this.getTabbedPane().insertTab(type.getStyle().getCaptionTitleLabel(), icon, indentPanel, null, index);
            this._isInsertingTab = false;
            if (!this._isInitializing) {
                this.getTabbedPane().setSelectedIndex(-1);
                this.getTabbedPane().setSelectedIndex(index);
            }
            this.getTabbedPane().setVisible(true);
        }
    }

    public TabActionIcon getTabActionIcon(int index) {
        boolean isEditable = this.getStyle().isHierarchyEnabled(this.getModel());
        Action tabAction = this.getSerializeTabAction();
        tabAction.putValue("tabIndex", new Integer(index));
        Action inverseAction = this.getNotSerializeTabAction();
        tabAction.setEnabled(isEditable);
        inverseAction.setEnabled(isEditable);
        TabActionIcon icon = new TabActionIcon(tabAction, inverseAction);
        return icon;
    }

    public Action getSerializeTabAction() {
        AbstractAction aAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AbstractCompositeView.this.getSelectedTabType().setSerializable(true);
                AbstractCompositeView.this.getSelectedTabType().setEditable(true);
                AbstractCompositeView.this.getSelectedTabType().putClientProperty("userChangedSerialize", (Object)"true");
            }
        };
        aAction.putValue("SmallIcon", ImageHelper.getInstance().getImageIcon("com/jaxfront/core/images/files/serializeDelete.gif"));
        return aAction;
    }

    public Action getNotSerializeTabAction() {
        AbstractAction aAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AbstractCompositeView.this.getSelectedTabType().setSerializable(false);
                AbstractCompositeView.this.getSelectedTabType().setEditable(false);
                AbstractCompositeView.this.getSelectedTabType().removeClientProperty("userChangedSerialize");
            }
        };
        aAction.putValue("SmallIcon", ImageHelper.getInstance().getImageIcon("com/jaxfront/core/images/files/serializeNew.gif"));
        return aAction;
    }

    private int getTabIndex(Type type) {
        int tabIndex = -1;
        for (int a = 0; a < this.getTabbedPane().getTabCount(); ++a) {
            Type tabType = (Type)((JComponent)this.getTabbedPane().getComponentAt(a)).getClientProperty(CLIENT_PROPERTY_TAB_TYPE);
            if (tabType != type) continue;
            tabIndex = a;
            break;
        }
        return tabIndex;
    }

    public void removeTab(Type type) {
        if (this.getTabbedPane() != null && this.getTabbedPane().getTabCount() > 0) {
            int tabIndex = this.getTabIndex(type);
            if (tabIndex > -1) {
                this.getTabbedPane().removeTabAt(tabIndex);
                this.getVisualizers().remove(type.getName());
            }
            int selectedIndex = this.getTabbedPane().getSelectedIndex();
            this.getTabbedPane().setSelectedIndex(-1);
            if (selectedIndex > -1) {
                this.getTabbedPane().setSelectedIndex(selectedIndex);
            } else {
                this.getTabbedPane().setVisible(false);
            }
        }
    }

    private void addComponentToComponentHolder(JPanel holderPanel, JComponent newComponent) {
        if (newComponent != null && holderPanel != null && this._componentHolderTableLayout != null) {
            int numberOfRows = this._componentHolderTableLayout.getRowCount();
            RowSpec rowSpec = new RowSpec("pref");
            this._componentHolderTableLayout.insertRow(numberOfRows, rowSpec);
            holderPanel.add((Component)newComponent, "1," + numberOfRows);
        }
    }

    private void addComponentToComponentHolder(JPanel holderPanel, JComponent newComponent, Type type) {
        if (newComponent != null && holderPanel != null && this._componentHolderTableLayout != null) {
            int numberOfRows = this._componentHolderTableLayout.getRowCount();
            if (newComponent instanceof AbstractView) {
                AbstractView view = (AbstractView)newComponent;
                view.setRowIndexInParentTableLayout(numberOfRows);
                view.setParentTableLayout(this._componentHolderTableLayout);
            }
            if (type.getStyle().isVisibleAtRuntime() && !type.getStyle().isVisible()) {
                RowSpec rowSpec = new RowSpec("top:pref");
                this._componentHolderTableLayout.insertRow(numberOfRows, rowSpec);
            } else {
                this._componentHolderTableLayout.insertRow(numberOfRows, this.getRowSpec("pref"));
            }
            holderPanel.add((Component)newComponent, "1," + numberOfRows);
        }
    }

    private JPanel getComponentHolder() {
        if (this._componentHolderPanel == null) {
            this._componentHolderPanel = new JPanel();
            this._componentHolderPanel.setName("componentHolderPanel");
        }
        return this._componentHolderPanel;
    }

    public JPanel getChoicePanel() {
        if (this._choicePanel == null) {
            this._choicePanel = new JPanel();
            this._choicePanel.setName("choicePanel");
        }
        return this._choicePanel;
    }

    public void domChanged(DOMChangeEvent event) {
        if (this.getModel() != null && this.getModel().isChoice() && event.isAddingNode()) {
            Type source = (Type)event.getSource();
            if (source.isEmpty()) {
                EmptyType emptyType = ((CompositeType)this.getModel()).getEmptyType();
                if (emptyType != null && emptyType == source) {
                    this.showChoice(source);
                }
            } else if (this.isRelevant(source)) {
                this.showChoice(source);
            }
        }
    }

    public Border getBorder() {
        Border b = null;
        if (this._borderPanel != null) {
            b = this._borderPanel.getBorder();
        }
        return b;
    }

    private ButtonGroup getButtonGroup() {
        if (this._group == null) {
            this._group = new ButtonGroup();
        }
        return this._group;
    }

    private JAXJComboBox getComboBox() {
        if (this._choiceComboBox == null) {
            this._choiceComboBox = AbstractCompositeView.createChoiceComboBox(this.getModel(), this, this, null, this);
        }
        return this._choiceComboBox;
    }

    public static JAXJComboBox createChoiceComboBox(Type model, FocusListener focListener, ActionListener actListener, ItemListener itemListener, AbstractView view) {
        JAXJComboBox choiceComboBox = null;
        Document dom = model.getDOM();
        StyleDefinition style = model.getStyle();
        if (model.isAbstract()) {
            choiceComboBox = AbstractCompositeView.getDerrivedTypesComboBox(actListener, model, model.getChoosenType());
        } else {
            choiceComboBox = new JAXJComboBox();
            choiceComboBox = AbstractCompositeView.getChoiceComboBox(choiceComboBox, actListener, model, model.getChoosenType());
            choiceComboBox.setPreferredSize(new Dimension((int)choiceComboBox.getPreferredSize().getWidth(), (int)new JTextField().getPreferredSize().getHeight()));
        }
        view.setFirstFocusableComponent(choiceComboBox);
        choiceComboBox.setRenderer(new ChoiceComboboxRenderer());
        if (style.isEditable()) {
            if (style.getBackgroundColor() != null) {
                choiceComboBox.setBackground(style.getBackgroundColor());
            } else if (model.isRequired()) {
                if (style.isApplicationRequired()) {
                    choiceComboBox.setBackground(dom.getApplicationFieldColor());
                } else {
                    choiceComboBox.setBackground(dom.getSchemaRequiredFieldColor());
                }
            } else {
                choiceComboBox.setBackground(dom.getOptionalFieldColor());
            }
        }
        if (itemListener != null) {
            choiceComboBox.addItemListener(itemListener);
        }
        if (focListener != null) {
            choiceComboBox.addFocusListener(focListener);
        }
        return choiceComboBox;
    }

    protected Hashtable getVisualizers() {
        if (this._visualizers == null) {
            this._visualizers = new Hashtable();
        }
        return this._visualizers;
    }

    protected void initChoicePanel() {
        this.getChoicePanel().setLayout(new BorderLayout());
        this.getSelectedPanel().setLayout(new BorderLayout());
        if (this.getStyle().isChoiceAsRadioButton()) {
            this.setSelectionPanel(this.getChoiceRadioButtonPanel());
        } else {
            this.setSelectionPanel(this.getChoiceComboBoxPanel());
        }
        this.getChoicePanel().add((Component)this.getSelectionPanel(), "North");
        this.getChoicePanel().add((Component)this.getSelectedPanel(), "Center");
        this.getDOM().addDOMChangeListener((DOMChangeListener)this);
        Type type = this.getModel().getChoosenType();
        if (type != null) {
            this.showChoice(type);
        }
        if (!this.getModel().isRoot() && this.getModel().getParent().isList() && this.getDOM().getGlobalDefinition().isUsingQuickChooserForChoiceListEntries()) {
            if (this._choiceComboBoxPanel != null) {
                this._choiceComboBoxPanel.setVisible(false);
            }
            if (this._choiceRadioButtonPanel != null) {
                this._choiceRadioButtonPanel.setVisible(false);
            }
            if (this._label != null) {
                this._label.setVisible(false);
            }
        }
        if (!this.getStyle().isChoiceAvailable().booleanValue()) {
            this.getSelectionPanel().setVisible(false);
        }
    }

    protected JPanel getChoiceComboBoxPanel() {
        if (this._choiceComboBoxPanel == null) {
            this._choiceComboBoxPanel = this.initComboBox();
        }
        return this._choiceComboBoxPanel;
    }

    private JPanel initComboBox() {
        this._isUsingComboBox = true;
        if (this.getStyle().isRepresentedAsTab()) {
            String label = this.getModel().getRepresentedTabParent(true).getStyle().getCaptionTitleLabel();
            this._visualizerPanel = this.createVisualizerPanel(this.getLabelPanel(this.createLabel(label, false, false)), this.getComboBox());
        }
        this._visualizerPanel = this.createVisualizerPanel(this.getLabelPanel(this.createLabel()), this.getComboBox());
        return this._visualizerPanel;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this._optionalCheckBox) {
            if (this._choiceComboBox != null) {
                this._choiceComboBox.setEnabled(this._optionalCheckBox.isSelected());
            }
            if (this._label != null) {
                this._label.setEnabled(this._optionalCheckBox.isSelected());
            }
            if (this._visibleComponent != null) {
                this._visibleComponent.setEnabled(this._optionalCheckBox.isSelected());
            }
        }
    }

    protected JPanel getChoiceRadioButtonPanel() {
        if (this._choiceRadioButtonPanel == null) {
            this._choiceRadioButtonPanel = this.initRadioButtons();
        }
        return this._choiceRadioButtonPanel;
    }

    private JPanel initRadioButtons() {
        boolean selected = false;
        this._radioButtonPanel = new JPanel();
        this._radioButtonPanel.setName("radioButtonPanel");
        int orientation = 0;
        if (!this.getStyle().isChoiceOrientationHorizontal()) {
            orientation = 1;
        }
        this._radioButtonPanel.setLayout(new BoxLayout(this._radioButtonPanel, orientation));
        ChoiceName[] names = ChoiceName.get((CompositeType)((CompositeType)this.getModel()));
        for (int i = 0; i < names.length; ++i) {
            ChoiceName name = names[i];
            String label = name.getVisualName();
            if (this.getModel().getChoosenType() != null) {
                if (this.getModel().getChoosenType().getName().equals(name.getTypeName())) {
                    selected = true;
                }
            } else if (label.equals(" ")) {
                selected = true;
            }
            if (label.equals(" ")) {
                label = GUIComponentNLS.getInstance().getNLSNoneText(this.getDOM());
            }
            JAXJRadioButton newRadioButton = this.addButton(name.getTypeName(), label, name.getTooltip(), this._radioButtonPanel, selected, false);
            if (i != 0) continue;
            this.setFirstFocusableComponent(newRadioButton);
        }
        if (this.getStyle().isRepresentedAsTab()) {
            String tabLabel = this.getModel().getRepresentedTabParent(true).getStyle().getCaptionTitleLabel();
            this.createLabel(tabLabel);
        }
        this._visualizerPanel = this.createVisualizerPanel(this.createLabel(), this._radioButtonPanel);
        return this._visualizerPanel;
    }

    protected boolean isRelevant(Type type) {
        if (this.getModel().isAbstract()) {
            if (type.getParent() == this.getModel()) {
                return true;
            }
        } else if (type.isAbstract()) {
            List choices = ((CompositeType)this.getModel()).getDirectChildren();
            Iterator choiceTypes = choices.iterator();
            while (choiceTypes.hasNext()) {
                if (!type.equals(choiceTypes.next())) continue;
                return true;
            }
        } else {
            Iterator choiceTypes = ((CompositeType)this.getModel()).getRelevantChoiceTypes().iterator();
            while (choiceTypes.hasNext()) {
                if (!type.equals(choiceTypes.next())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSimpleComposite(Type type) {
        if (!type.isComposite()) {
            return false;
        }
        CompositeType composite = (CompositeType)type;
        return composite.getComposites().size() == 1 && ((Type)composite.getComposites().get(0)).isSimple();
    }

    protected boolean isUsingComboBox() {
        return this._isUsingComboBox;
    }

    protected boolean isUsingTableLayout() {
        return this.getStyle().getLayoutManager("main") != null;
    }

    protected boolean isUsingSplitterLayout() {
        return this.getStyle().getSplitterLayoutDefinition() != null;
    }

    public void markError() {
        Border border = BorderFactory.createEtchedBorder(this.getDOM().getErrorMarkingColor(), Color.lightGray);
        this.setBorder(border);
    }

    public void populateModel() {
        if (((CompositeType)this.getModel()).isChoice()) {
            Visualizer visualizer;
            Type type = this.getModel().getChoosenType();
            if (type != null && (!type.isRepresentedAsTreeNode() || this.getModel().isRepresentedAsTreeNode()) && (visualizer = (Visualizer)this.getVisualizers().get(type.getName())) != null) {
                visualizer.populateModel();
            }
        } else {
            Iterator iterator = ((CompositeType)this.getModel()).getComposites().iterator();
            while (iterator.hasNext()) {
                Visualizer visualizer;
                Type type = (Type)iterator.next();
                if (type.isRepresentedAsTreeNode() || (visualizer = (Visualizer)this.getVisualizers().get(type.getName())) == null) continue;
                visualizer.populateModel();
            }
        }
    }

    public void populateView() {
        block3: {
            block4: {
                block6: {
                    block5: {
                        if (this.getModel() == null) break block3;
                        if (!((CompositeType)this.getModel()).isChoice()) break block4;
                        if (!this.getStyle().isChoiceAsRadioButton()) break block5;
                        String name = noSelectionField;
                        if (this.getModel().getChoosenType() != null) {
                            name = this.getModel().getChoosenType().getStyle().getLabelText().trim();
                        }
                        this.selectRadioButton(name);
                        break block3;
                    }
                    if (this.getModel().getChoosenType() == null) break block6;
                    this.getComboBox().setSelectedItem(this.getModel().getChoosenType());
                    break block3;
                }
                if (!this.getModel().isRequired()) break block3;
                this.getComboBox().setSelectedIndex(0);
                break block3;
            }
            Iterator composites = ((CompositeType)this.getModel()).getComposites().iterator();
            Type childContext = this._context;
            while (composites.hasNext()) {
                if (childContext == null && this.isUsingTableLayout()) {
                    childContext = this.getModel();
                }
                Type subType = (Type)composites.next();
                Visualizer visualizer = TypeVisualizerFactory.getInstance().getVisualizer(subType, childContext, false);
                if (visualizer == null || visualizer.getModel() == null || !visualizer.getModel().getStyle().isEditorComponentVisible()) continue;
                visualizer.populateView();
            }
        }
    }

    public void resetError() {
        this.setBorder(this._originalBorder);
    }

    private void selectRadioButton(String name) {
        Enumeration<AbstractButton> radiobtns = this.getButtonGroup().getElements();
        while (radiobtns.hasMoreElements()) {
            JRadioButton radioBtn = (JRadioButton)radiobtns.nextElement();
            if (!radioBtn.getActionCommand().equals(name) || radioBtn.isSelected()) continue;
            radioBtn.setSelected(true);
            this.actionPerformed(null);
            break;
        }
    }

    public void setBorder(Border border) {
        if (this._componentHolderPanel != null) {
            this._componentHolderPanel.setBorder(border);
        }
    }

    public void setEnabled(boolean enabled) {
        List compositeTypes = ((CompositeType)this.getModel()).getComposites();
        if (compositeTypes != null) {
            Iterator iterator = compositeTypes.iterator();
            while (iterator.hasNext()) {
                Type currentType = (Type)iterator.next();
                if (currentType == null) continue;
                currentType.setEnabled(enabled);
            }
        }
        for (int i = 0; i < this.getChoiceGuiElements().size(); ++i) {
            Object o = this.getChoiceGuiElements().get(i);
            if (!(o instanceof JAXJRadioButton)) continue;
            ((JAXJRadioButton)o).setEnabled(enabled);
        }
        if (this._choiceComboBox != null) {
            this._choiceComboBox.setEnabled(enabled);
        }
        if (this._label != null) {
            this._label.setEnabled(enabled);
        }
        if (this._visibleComponent != null) {
            this._visibleComponent.setEnabled(enabled);
        }
        if (this._borderPanel != null) {
            this._borderPanel.setEnabled(enabled);
        }
        if (this._optionalCheckBox != null) {
            this._optionalCheckBox.setEnabled(enabled);
        }
        if (this._buttons != null) {
            Iterator iterator = this._buttons.iterator();
            while (iterator.hasNext()) {
                ((JAXJButton)iterator.next()).setEnabled(enabled);
            }
        }
    }

    public void setEnabled(boolean enabled, boolean setOptionalToo) {
        this.setEnabled(enabled);
        if (this._optionalCheckBox != null && setOptionalToo) {
            this._optionalCheckBox.setEnabled(enabled);
        }
    }

    public void setEditable(boolean editable) {
        Iterator iterator;
        if (this._optionalCheckBox != null) {
            this._optionalCheckBox.setEditable(editable);
        }
        if (this._choiceComboBox != null) {
            this.getChoicePanel().setEnabled(editable);
            this._choiceComboBox.setEditable(editable, false);
            this._choiceComboBox.setFocusable(editable);
        }
        for (int i = 0; i < this.getChoiceGuiElements().size(); ++i) {
            Object o = this.getChoiceGuiElements().get(i);
            if (!(o instanceof JAXJRadioButton)) continue;
            ((JAXJRadioButton)o).setEditable(editable);
        }
        List compositeTypes = ((CompositeType)this.getModel()).getComposites();
        if (compositeTypes != null) {
            iterator = compositeTypes.iterator();
            while (iterator.hasNext()) {
                Type currentType = (Type)iterator.next();
                if (currentType == null || currentType.isLocked()) continue;
                currentType.setEditable(editable);
            }
        }
        if (this._buttons != null) {
            iterator = this._buttons.iterator();
            while (iterator.hasNext()) {
                ((JAXJButton)iterator.next()).setEditable(editable);
            }
        }
    }

    public void setLabelColor(Color color) {
    }

    public abstract void setRequired(boolean var1);

    public abstract void setApplicationRequired(boolean var1);

    private void removeChoiceTreeEntry(Type type) {
        if (type != null) {
            List childs;
            if (type.isRepresentedAsTreeNode() && type.getDOM().getEditor().getTreeModel() != null) {
                type.getDOM().getEditor().getTreeModel().removeNode(type);
            }
            if (type.isComposite() && type.isChoice()) {
                this.removeChoiceTreeEntry(type.getChoosenType());
            } else if (type.getDirectChildren() != null && (childs = type.getDirectChildren()).size() > 0) {
                Iterator iterator = childs.iterator();
                while (iterator.hasNext()) {
                    Type child = (Type)iterator.next();
                    this.removeChoiceTreeEntry(child);
                }
            }
        }
    }

    private void addChoiceTreeEntry(Type type) {
        if (type != null) {
            Vector childs;
            if (type.isRepresentedAsTreeNode() && type.getDOM().getEditor() != null && type.getDOM().getEditor().getTreeModel() != null) {
                type.getDOM().getEditor().getTreeModel().insertNode(type);
            }
            if (type.isComposite() && type.isChoice() && type.hasChoosenType()) {
                this.addChoiceTreeEntry(type.getChoosenType());
            } else if (type.getDirectChildren() != null && (childs = new Vector(type.getDirectChildren())).size() > 0) {
                Iterator iterator = childs.iterator();
                while (iterator.hasNext()) {
                    Type child = (Type)iterator.next();
                    this.addChoiceTreeEntry(child);
                }
            }
        }
    }

    public void showChoice(Type type) {
        if (this._visibleComponent != null) {
            Type visibleType = ((Visualizer)this._visibleComponent).getModel();
            this.removeChoiceTreeEntry(visibleType);
            this.getSelectedPanel().remove(this._visibleComponent);
        }
        if (type != null) {
            if (!type.getStyle().isRepresentedAsTreeNode() || !type.getStyle().isSelfViewHolder()) {
                if (this.isUsingComboBox()) {
                    this.getComboBox().removeActionListener(this);
                    int indexOfType = -1;
                    for (int a = 0; a < this.getComboBox().getItemCount(); ++a) {
                        ChoiceName choiceName = (ChoiceName)this.getComboBox().getItemAt(a);
                        if (!choiceName.getTypeName().equals(type.getName())) continue;
                        indexOfType = a;
                        break;
                    }
                    this.getComboBox().setSelectedIndex(indexOfType);
                    this.getComboBox().addActionListener(this);
                } else {
                    this.selectRadioButton(type.getName());
                }
                if (!type.isEmpty()) {
                    if (this.getStyle().isSingleChoiceAndSerialize()) {
                        if (this.isUsingComboBox()) {
                            ChoiceName choiceName = (ChoiceName)this._choiceComboBox.getModel().getElementAt(0);
                            if (choiceName.getTypeName().equals(" ")) {
                                this._choiceComboBox.removeItemAt(0);
                                type.setSerializable(true, false);
                            }
                        } else {
                            Enumeration<AbstractButton> buttons = this.getButtonGroup().getElements();
                            JAXJRadioButton button = (JAXJRadioButton)buttons.nextElement();
                            if (button.getText() != null && button.getText().equals(GUIComponentNLS.getInstance().getNLSNoneText(this.getDOM()))) {
                                this.getButtonGroup().remove(button);
                                this.getRadioButtonPanel().remove(0);
                                if (button.getUI().getClass().getName().equals("com.jgoodies.plaf.plastic.PlasticXPRadioButtonUI")) {
                                    this.getRadioButtonPanel().remove(0);
                                }
                                type.setSerializable(true, false);
                            }
                        }
                    }
                    this._visibleComponent = (JComponent)TypeVisualizerFactory.getInstance().getVisualizer(type, this._context);
                    if (this._visibleComponent != null) {
                        if (this.isSimpleComposite(type)) {
                            this._visibleComponent.setBorder(null);
                        }
                        this.showSelection(this._visibleComponent);
                    }
                }
            }
            if (!type.isEmpty()) {
                this.addChoiceTreeEntry(type);
            }
        }
        this.updateUI();
    }

    public void showLabel(boolean show) {
    }

    private void showSelection(JComponent component) {
        this.getSelectedPanel().add(component);
    }

    public void showTab(Type selectedType, Object component) {
        Component swingComponent = (Component)component;
        if (this.getTabbedPane() != null) {
            int index = this.getTabbedPane().indexOfComponent(swingComponent);
            if (index == -1) {
                Type tabbedType = ((Visualizer)swingComponent).getModel();
                index = this.getTabbedPane().indexOfTab(tabbedType.getStyle().getCaptionTitleLabel());
                if (index != -1) {
                    this.getTabbedPane().setSelectedIndex(index);
                    JPanel holderPanel = (JPanel)this.getTabbedPane().getSelectedComponent();
                    holderPanel.removeAll();
                    holderPanel.setLayout(new BorderLayout());
                    holderPanel.add(swingComponent, "Center");
                }
            } else {
                this.getTabbedPane().setSelectedIndex(index);
            }
        }
    }

    public void release() {
        FormLayoutInfo layout;
        if (this.getModel() != null && this.getModel().hasUIDefinition() && (layout = (FormLayoutInfo)this.getStyle().getLayoutManager("main")) != null) {
            List cellList = layout.getCells();
            for (int i = 0; i < cellList.size(); ++i) {
                Type virtuellType = ((TableCell)cellList.get(i)).getType();
                if (virtuellType == null || !virtuellType.isVirtual()) continue;
                TypeVisualizerFactory.getInstance().releaseCache(virtuellType);
            }
        }
        if (this._choiceComboBox != null) {
            this._choiceComboBox.removeFocusListener(this);
        }
        if (this.getDOM() != null) {
            this.getDOM().removeDOMChangeListener((DOMChangeListener)this);
        }
        this._group = null;
        this._choiceComboBox = null;
        this._visualizers = null;
        if (this._tabbedPane != null) {
            this._tabbedPane.removeChangeListener(UIController.getInstance());
            this._tabbedPane.removeChangeListener(this);
        }
        this._tabbedPane = null;
        this._visibleComponent = null;
        this._choicePanel = null;
        this._selectedPanel = null;
        this._selectionPanel = null;
        this._optionalCheckBox = null;
        this._componentHolderPanel = null;
        this._choiceRadioButtonPanel = null;
        this._choiceComboBoxPanel = null;
        this._componentHolderTableLayout = null;
        this.getChoiceGuiElements().clear();
        this._choiceGuiElements = null;
        super.release();
    }

    protected JComponent createEditorComponent() {
        return null;
    }

    void showTabType(JTabbedPane pane, Type tabType) {
        if (pane.getSelectedComponent() != null && tabType != null) {
            Visualizer visualizer = (Visualizer)this.getVisualizers().get(tabType.getName());
            if (visualizer == null) {
                JPanel tabSpaceHolder = null;
                tabType.putClientProperty("tabHolder", (Object)pane);
                visualizer = TypeVisualizerFactory.getInstance().getVisualizer(tabType, this._context);
                if (this.getDOM().getGlobalDefinition().hasTabsTopSpace() || this.getDOM().getGlobalDefinition().hasTabsBottomSpace()) {
                    int topSpace = this.getDOM().getGlobalDefinition().getTopSpaceTabs();
                    int bottomSpace = this.getDOM().getGlobalDefinition().getBottomSpaceTabs();
                    String pref = "pref";
                    String column = "f:p:g(100)";
                    String row = topSpace + "px" + "," + pref + "," + bottomSpace + "px";
                    FormLayout verticalIndentForTabsTL = new FormLayout(column, row);
                    tabSpaceHolder = new JPanel(verticalIndentForTabsTL);
                    tabSpaceHolder.setName("tabSpaceHolder");
                    tabSpaceHolder.add((Component)((JComponent)visualizer), "1,2");
                }
                this.getVisualizers().put(tabType.getName(), visualizer);
                if (tabSpaceHolder == null) {
                    JPanel holderPanel = (JPanel)pane.getSelectedComponent();
                    if (holderPanel.getLayout().getClass() == BorderLayout.class) {
                        holderPanel.add((Component)((JComponent)visualizer), "Center");
                    } else {
                        holderPanel.add((Component)((JComponent)visualizer), "2,2");
                    }
                } else {
                    ((JPanel)pane.getSelectedComponent()).add(tabSpaceHolder, "2,2");
                }
                EditablePanel editor = this.getDOM().getEditor();
                if (editor != null) {
                    ((JComponent)editor).updateUI();
                }
            }
            AbstractView view = (AbstractView)visualizer;
            if (!this._isInitializing && !this.getEditor().isSelectingTreeNode()) {
                view.highlightTreeEntry(tabType);
            }
            view.focusFirstComponent(true);
        }
    }

    public void stateChanged(ChangeEvent event) {
        if (this.getModel() == null) {
            return;
        }
        if (!this._isInsertingTab) {
            JTabbedPane pane = (JTabbedPane)event.getSource();
            Type tabType = this.getSelectedTabType();
            this.showTabType(pane, tabType);
        }
    }

    protected double getDefaultComponentHeight() {
        if (this.getStyle().isUsingPlugIn() || this.getStyle().isChoiceAsRadioButton() && !this.getStyle().isChoiceOrientationHorizontal()) {
            return 0.0;
        }
        return super.getDefaultComponentHeight();
    }

    protected String getStringDefaultComponentHeight() {
        if (this.getStyle().isUsingPlugIn() || this.getStyle().isChoiceAsRadioButton() && !this.getStyle().isChoiceOrientationHorizontal()) {
            return "pref";
        }
        return super.getStringDefaultComponentHeight();
    }

    public void setChoosenKeyValue(String xpathRelativeToChoosenKey, String newValue) {
    }

    public void setChoosenKeyContextValue(String xpathRelativeToChoosenKeyContext, String newValue) {
    }

    public Type getModel() {
        return this._model;
    }

    protected Vector getChoiceGuiElements() {
        if (this._choiceGuiElements == null) {
            this._choiceGuiElements = new Vector();
        }
        return this._choiceGuiElements;
    }

    protected JPopupMenu createPopUpMenu() {
        JPopupMenu popUpMenu = new JPopupMenu("------");
        AbstractAction copyContentAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_copy_content", "copy content"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/copy_16x16.gif")){

            public void actionPerformed(ActionEvent e) {
                Type tabType = AbstractCompositeView.this.getSelectedTabType();
                if (tabType != null) {
                    AbstractCompositeView.this.getDOM().getClipBoard().copy(tabType);
                }
            }
        };
        popUpMenu.add(new JMenuItem(copyContentAction));
        AbstractAction pasteContentAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_paste_content", "paste content"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/pasteContent_16x16.gif")){

            public void actionPerformed(ActionEvent e) {
                Type tabType = AbstractCompositeView.this.getSelectedTabType();
                if (tabType != null && AbstractCompositeView.this.getDOM().getClipBoard().canPaste(tabType)) {
                    AbstractCompositeView.this.getDOM().getClipBoard().paste(tabType, null, false, false);
                    AbstractCompositeView.this.getDOM().validateKeyRefIntegrity(true);
                }
            }
        };
        popUpMenu.add(new JMenuItem(pasteContentAction));
        return popUpMenu;
    }

    public Type getSelectedTabType() {
        Type tabType = null;
        if (this.getTabbedPane() != null && this.getTabbedPane().getSelectedComponent() != null) {
            tabType = (Type)((JComponent)this.getTabbedPane().getSelectedComponent()).getClientProperty(CLIENT_PROPERTY_TAB_TYPE);
        }
        return tabType;
    }

    private JPanel getSelectedPanel() {
        if (this._selectedPanel == null) {
            this._selectedPanel = new JPanel();
            this._selectedPanel.setName("selectedPanel");
        }
        return this._selectedPanel;
    }

    private JPanel getSelectionPanel() {
        return this._selectionPanel;
    }

    private void setSelectionPanel(JPanel selectionPanel) {
        this._selectionPanel = selectionPanel;
    }

    private int getCurrentTabIndex(Type type) {
        if (type != null && this.getTabbedPane() != null) {
            for (int a = 0; a < this.getTabbedPane().getTabCount(); ++a) {
                Type tabType = (Type)((JComponent)this.getTabbedPane().getComponentAt(a)).getClientProperty(CLIENT_PROPERTY_TAB_TYPE);
                if (tabType != type) continue;
                return a;
            }
        }
        return -1;
    }

    public void setSelectedTab(Type type) {
        int currentTabIndex;
        if (type != null && this.getTabbedPane() != null && (currentTabIndex = this.getCurrentTabIndex(type)) > -1 && currentTabIndex < this.getTabbedPane().getTabCount()) {
            this.getTabbedPane().setSelectedIndex(currentTabIndex);
        }
    }

    protected void setTabbedPane(JAXJTabbedPane _tabbedPane) {
        this._tabbedPane = _tabbedPane;
    }

    protected JAXJTabbedPane getTabbedPane() {
        if (this._tabbedPane == null) {
            this._tabbedPane = new JAXJTabbedPane();
            this._tabbedPane.setFont(FontFactory.getTabFontDefinition().createFont());
            this._tabbedPane.setPopUpMenu(this.createPopUpMenu());
        }
        return this._tabbedPane;
    }

    public void setTabName(String oldName, String newName) {
        int index = this.getTabbedPane().indexOfTab(oldName);
        if (index != -1) {
            this.getTabbedPane().setTitleAt(index, newName);
        }
    }

    private JPanel getRadioButtonPanel() {
        return this._radioButtonPanel;
    }

    private void applyTableLayout(JPanel holderPanel) {
        FormLayoutInfo layout = (FormLayoutInfo)this.getStyle().getLayoutManager("main");
        JPanel tablePanel = FormLayoutBuilder.applyTableLayout(this, this.getModel(), this._context, layout, holderPanel);
        FormLayout tableLayout = (FormLayout)tablePanel.getLayout();
        JComponent captionPanel = tablePanel;
        if (this.getStyle().hasCaption()) {
            tablePanel.setBorder(null);
            captionPanel = this.getCaptionPanel(captionPanel);
        } else if (this.getStyle().isRepresentedAsTab() || this.getModel().getParent() != null && this.getModel().getParent().isChoice()) {
            tablePanel.setBorder(null);
        }
        this.setParentTableLayout(tableLayout);
        this.setParentTablePanel(tablePanel);
        this.addComponentToComponentHolder(holderPanel, captionPanel);
    }
}

