/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.VirtualType;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.tools.HeaderPanel;
import com.jaxfront.swing.ui.visualizers.AbstractView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class FormulaVisualizerView
extends AbstractView
implements DOMChangeListener,
PropertyChangeListener {
    private boolean _dirty = true;

    public FormulaVisualizerView(VirtualType type) {
        this(type, null);
    }

    public FormulaVisualizerView(VirtualType type, Type context) {
        super(context);
        this.setModel((Type)type);
        type.getDOM().addDOMChangeListener((DOMChangeListener)this);
        type.getDOM().getController().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void release() {
        if (this._model != null && this._model.getDOM() != null) {
            this.getModel().getDOM().removeDOMChangeListener((DOMChangeListener)this);
            this.getModel().getDOM().getController().removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.release();
    }

    protected JComponent createEditorComponent() {
        JComponent comp = null;
        String labelType = "label";
        if (this.getModel().getXUIDefinition().getXUIType() != null && (labelType = this.getModel().getXUIDefinition().getXUIType().getParent().getDirectChildValue("labelType")) == null) {
            labelType = "";
        }
        String text = ((VirtualType)this.getModel()).getValue() + "test";
        if (labelType.startsWith("separator")) {
            if (labelType.equals("separator_classic")) {
                comp = GUITools.createSeparatorClassic(null, text);
            }
            if (labelType.equals("separator_modern")) {
                comp = GUITools.createSeparatorModern(null, text);
            }
        } else {
            comp = labelType.equals("header") ? GUITools.createHeader(null, text) : new JLabel(text);
        }
        return comp;
    }

    protected void defaultBuild() {
        this.setLayout(new BorderLayout());
        this._editorComponent = this.createEditorComponent();
        this.add((Component)this._editorComponent, "Center");
    }

    public void markError() {
    }

    public void populateModel() {
    }

    public void populateView() {
        if (this._editorComponent != null) {
            String text = ((VirtualType)this.getModel()).getValue();
            if (this._editorComponent instanceof JLabel) {
                ((JLabel)this._editorComponent).setText(text);
            } else if (this._editorComponent instanceof HeaderPanel) {
                ((HeaderPanel)this._editorComponent).setHeaderTitle(text);
            }
        }
    }

    public void paint(Graphics g) {
        if (this._dirty) {
            this.populateView();
            this._dirty = false;
        }
        super.paint(g);
    }

    public void resetError() {
    }

    public void setLabelColor(Color color) {
    }

    public void setRequired(boolean aBoolean) {
    }

    public void setApplicationRequired(boolean aBoolean) {
    }

    public void showLabel(boolean show) {
    }

    public void itemStateChanged(ItemEvent e) {
    }

    public void setChoosenKeyValue(String xpathRelativeToChoosenKey, String newValue) {
    }

    public void setChoosenKeyContextValue(String xpathRelativeToChoosenKeyContext, String newValue) {
    }

    public void setToolTipText(String text) {
        if (this._editorComponent != null) {
            this._editorComponent.setToolTipText(text);
        } else {
            super.setToolTipText(text);
        }
    }

    public void setFont(Font font) {
        if (this._editorComponent != null) {
            this._editorComponent.setFont(font);
        } else {
            super.setFont(font);
        }
    }

    public void setForeground(Color fg) {
        if (this._editorComponent != null) {
            this._editorComponent.setForeground(fg);
        } else {
            super.setForeground(fg);
        }
    }

    public void domChanged(DOMChangeEvent event) {
        this._dirty = true;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this._dirty = true;
        super.propertyChange(evt);
    }
}

