/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.KeyRefException;
import com.jaxfront.core.schema.SchemaKey;
import com.jaxfront.core.schema.impl.KeyContainer;
import com.jaxfront.core.schema.impl.KeyDefinition;
import com.jaxfront.core.schema.impl.KeyKeyRefEvent;
import com.jaxfront.core.schema.impl.KeyKeyRefListener;
import com.jaxfront.core.type.ListModificationException;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.ChoiceName;
import com.jaxfront.core.ui.SimpleTypeVisualizer;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.sort.FastQSort;
import com.jaxfront.swing.helpers.StringDocument;
import com.jaxfront.swing.ui.tools.FocusHelper;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.visualizers.AbstractCompositeView;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.visualizers.KeyRefCellRenderer;
import com.jaxfront.swing.ui.visualizers.TypeXPathListCellRenderer;
import com.jaxfront.swing.ui.wrapper.JAXJButton;
import com.jaxfront.swing.ui.wrapper.JAXJComboBox;
import com.jaxfront.swing.ui.wrapper.JAXJDialog;
import com.jaxfront.swing.ui.wrapper.JAXJList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class KeyView
extends AbstractSimpleTypeView
implements SimpleTypeVisualizer,
MouseListener,
KeyKeyRefListener {
    private Vector _allRefs = null;
    private JAXJDialog _dialog = null;
    private JAXJList _list = null;
    private JAXJButton _button = null;
    private JComponent _lineEditor = null;
    private boolean _useCombobox = false;

    public KeyView() {
    }

    public KeyView(SimpleType type, Type context) {
        super(context);
        this.setModel((Type)type);
    }

    public KeyView(SimpleType type) {
        this.setModel((Type)type);
    }

    private Vector getRefs() {
        Vector refs = new Vector();
        List containers = this.getDOM().getKeyKeyRefManager().getKeyContainer((SimpleType)this.getModel(), this.getModel().getSchemaElement().getSchemaKeys());
        for (int c = 0; c < containers.size(); ++c) {
            KeyContainer kc = (KeyContainer)containers.get(c);
            refs.addAll(kc.getAllReferencesFor(((SimpleType)this.getModel()).getPlainValue()));
        }
        this._allRefs = refs;
        return refs;
    }

    private JAXJButton createJumpButton() {
        JAXJButton button = new JAXJButton();
        button.setPreferredSize(new Dimension(22, 16));
        button.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/jump_Back12x16.gif"));
        String buttonTooltip = GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "jumpTo_KeyReference", "jump to reference");
        button.setToolTipText(buttonTooltip);
        button.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                KeyView.this.jumpTo();
            }
        });
        return button;
    }

    protected JAXJButton createShowRefsButton() {
        JAXJButton button = new JAXJButton();
        button.setPreferredSize(new Dimension(22, 16));
        this._list = new JAXJList(this._allRefs);
        this._list.addMouseListener(this);
        KeyRefCellRenderer renderer = new KeyRefCellRenderer(this.getModel());
        this._list.setCellRenderer(renderer);
        button.setIcon(JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/showList_16x16.gif"));
        String buttonTooltip = GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "show_KeyReferences", "show all references");
        button.setToolTipText(buttonTooltip);
        button.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                KeyView.this.showDialog();
            }
        });
        return button;
    }

    public void jumpTo() {
        FocusHelper.focus((Type)this._allRefs.get(0));
    }

    private Vector sort(Vector toSort) {
        FastQSort qSort = new FastQSort();
        try {
            qSort.sort((List)toSort, StringUtil.getNaturalTypeXPathComparator(), 0);
        }
        catch (Exception e) {
            LogRegistry.getInstance().warn(this.getClass(), "sort failed:" + e.getMessage());
        }
        return toSort;
    }

    private void showDialog() {
        String dialogTitle = GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "key_references", "Key references");
        this._dialog = GUITools.createDialogFor(this, true, dialogTitle);
        this._allRefs = this.sort(this.getRefs());
        this._list.setModel(new AbstractListModel(){

            public int getSize() {
                return KeyView.this._allRefs.size();
            }

            public Object getElementAt(int i) {
                return KeyView.this._allRefs.elementAt(i);
            }
        });
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)new JScrollPane(this._list), "Center");
        this._dialog.getContentPane().add(p);
        this._dialog.setSize(300, 200);
        this._dialog.setCloseAtEscape();
        this._dialog.showCentered();
    }

    public static void handleKeyError(ListModificationException e, Document dom) {
        String dialogTitle = GUIComponentNLS.getInstance().getNLSText(dom, "dialog_deletion_confirmation", "Delete Selected Item");
        if (e.getCause() instanceof KeyRefException) {
            KeyRefException keyRefEx = (KeyRefException)e.getCause();
            if (keyRefEx.getReferences() != null) {
                JAXJList refList = new JAXJList(keyRefEx.getReferences());
                refList.setCellRenderer(new TypeXPathListCellRenderer());
                refList.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() >= 2) {
                            JAXJList sourceList = (JAXJList)e.getSource();
                            Type sType = (Type)sourceList.getSelectedValue();
                            FocusHelper.focus(sType);
                            Component root = SwingUtilities.getRoot(sourceList);
                            root.setVisible(false);
                        }
                    }
                });
                JScrollPane scroller = new JScrollPane(refList, 20, 32);
                scroller.setPreferredSize(new Dimension(300, 100));
                JOptionPane.showMessageDialog(dom.getEditor().getWindow(), scroller, "Key has open references to:", 0);
            }
        } else {
            JOptionPane.showMessageDialog(dom.getEditor().getWindow(), e.getMessage(), dialogTitle, 0);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2 && e.getSource() == this._list) {
            JAXJList sourceList = (JAXJList)e.getSource();
            Type sType = (Type)sourceList.getSelectedValue();
            FocusHelper.focus(sType);
            if (this._dialog != null) {
                this._dialog.setVisible(false);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    protected JComponent createEditorComponent() {
        boolean useErrorSound = this.getDOM().getGlobalDefinition().isErrorSound();
        SimpleType st = this.getSimpleModel();
        long maxLengthOfCharacter = st.getMaxLength();
        this._editorComponent = new JPanel(new BorderLayout());
        if (this.getStyle().isEnumeration()) {
            this._useCombobox = true;
            this._lineEditor = AbstractCompositeView.createChoiceComboBox(this.getModel(), null, null, this, this);
            this.setEditorField(this._lineEditor);
        } else {
            this._lineEditor = this.createSingleLineEditorComponent(useErrorSound, maxLengthOfCharacter);
        }
        this._editorComponent.add(this._lineEditor);
        Vector refs = this.getRefs();
        if (refs != null) {
            if (refs.size() == 1) {
                this._button = this.createJumpButton();
                this._editorComponent.add((Component)this._button, "East");
            } else if (refs.size() > 1) {
                this._button = this.createShowRefsButton();
                this._editorComponent.add((Component)this._button, "East");
            }
        }
        this.getEditorField().addFocusListener(this);
        this.getEditorField().addKeyListener(this);
        this.setFirstFocusableComponent(this.getEditorField());
        this.getDOM().getKeyKeyRefManager().addKeyKeyRefListener((KeyKeyRefListener)this);
        return this._editorComponent;
    }

    public void itemStateChanged(ItemEvent e) {
        String currentValue;
        super.itemStateChanged(e);
        if (e.getSource() == this._lineEditor && this._useCombobox && (currentValue = ((ChoiceName)((JAXJComboBox)this._lineEditor).getSelectedItem()).getTypeName()) != null) {
            ((SimpleType)this.getModel()).setValue((Object)this, currentValue, false);
        }
    }

    protected void updateEditorComponent() {
        Vector refs = this.getRefs();
        if (this._button != null) {
            this._editorComponent.remove(this._button);
        }
        if (refs != null) {
            if (refs.size() == 1) {
                this._button = this.createJumpButton();
                this._editorComponent.add((Component)this._button, "East");
            } else if (refs.size() > 1) {
                this._button = this.createShowRefsButton();
                this._editorComponent.add((Component)this._button, "East");
            }
        }
        this._editorComponent.validate();
    }

    public String getText() {
        String text = "";
        if (this.getEditorField() != null) {
            text = this._useCombobox ? ((ChoiceName)((JAXJComboBox)this._lineEditor).getSelectedItem()).getTypeName() : ((JTextComponent)this.getEditorField()).getText();
            return text;
        }
        return text;
    }

    public void populateView() {
        if (this.getEditorField() != null && this.getSimpleModel() != null) {
            String modelValue = this.getSimpleModel().getValue();
            if (modelValue == null) {
                modelValue = "";
            }
            if (this._useCombobox) {
                ((JAXJComboBox)this.getEditorField()).setSelectedItem(modelValue);
            } else {
                ((JTextComponent)this.getEditorField()).setText(modelValue);
            }
        }
    }

    private JComponent createSingleLineEditorComponent(boolean useErrorSound, long maxLengthOfCharacter) {
        this.setEditorField(new JTextField());
        ((JTextField)this.getEditorField()).setColumns(1);
        ((JTextComponent)this.getEditorField()).setDocument(new StringDocument(useErrorSound, maxLengthOfCharacter, this.getWhiteSpaceType()));
        return this.getEditorField();
    }

    public void release() {
        if (this.getDOM() != null) {
            this.getDOM().getKeyKeyRefManager().removeKeyKeyRefListener((KeyKeyRefListener)this);
        }
        if (this.getEditorField() != null) {
            this.getEditorField().removeFocusListener(this);
            this.getEditorField().removeKeyListener(this);
        }
        this._lineEditor = null;
        super.release();
    }

    public void keyAdded(KeyKeyRefEvent event) {
    }

    public void keyChanged(KeyKeyRefEvent event) {
        String keyName = event.getKeyName();
        if (this.doesConcern(keyName)) {
            this.updateEditorComponent();
        }
    }

    public void keyRefChanged(KeyKeyRefEvent event) {
        String keyName = event.getKeyName();
        if (this.doesConcern(keyName)) {
            this.updateEditorComponent();
        }
    }

    public boolean doesConcern(String keyName) {
        if (this.getModel().isReleased()) {
            return false;
        }
        Iterator keys = this.getModel().getSchemaElement().getSchemaKeys().values().iterator();
        while (keys.hasNext()) {
            KeyDefinition keyDef = (KeyDefinition)keys.next();
            SchemaKey aSC = keyDef.getSchemakey();
            if (!aSC.getName().equals(keyName)) continue;
            return true;
        }
        return false;
    }

    public void keyRefAdded(KeyKeyRefEvent event) {
        String keyName = event.getKeyName();
        if (this.doesConcern(keyName)) {
            this.updateEditorComponent();
        }
    }

    public void keyRefRemoved(KeyKeyRefEvent event) {
    }

    public void keyRemoved(KeyKeyRefEvent event) {
    }

    public static JAXJButton createShowRefsButton(Vector references, Type model) {
        JAXJButton button = new JAXJButton();
        button.setPreferredSize(new Dimension(22, 16));
        JAXJList list = new JAXJList(references);
        return button;
    }
}

