/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.dom.CodeTables;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.swing.ui.tools.AutoCompletion;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.visualizers.SimpleTypeComboBoxRenderer;
import com.jaxfront.swing.ui.wrapper.JAXJComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SimpleTypeComboView
extends AbstractSimpleTypeView {
    private JPanel _abstractPanel;
    private JAXJComboBox _abstractComboBox;
    private JComponent _choosenComponent;
    private JAXJComboBox _editComboComponent;

    public SimpleTypeComboView() {
        this((Type)null);
    }

    public SimpleTypeComboView(Type type) {
        this.setModel(type);
    }

    public SimpleTypeComboView(Type type, Type context) {
        super(context);
        this.setModel(type);
    }

    private JComponent createAbstractComponent() {
        this._abstractPanel = new JPanel(new BorderLayout());
        this._abstractComboBox = SimpleTypeComboView.getDerrivedTypesComboBox(null, this.getModel(), null);
        this._abstractComboBox.addItemListener(this);
        this._editorComponent = this._abstractComboBox;
        this._abstractPanel.add((Component)this._abstractComboBox, "North");
        return this._abstractPanel;
    }

    protected JComponent createEditorComponent() {
        if (this.getModel().isAbstract()) {
            return this.createAbstractComponent();
        }
        JAXJComboBox editor = new JAXJComboBox();
        SimpleTypeComboBoxRenderer renderer = new SimpleTypeComboBoxRenderer();
        String defaultVal = null;
        if (this.getSimpleModel().getStyle().isEnumeration()) {
            defaultVal = this.getStyle().translateToCodeSetValue(this.getModel(), this.getSimpleModel().getStyle().getLeafEnumerationDefaultSelection());
        }
        if (defaultVal == null || defaultVal.length() == 0) {
            defaultVal = this.getSimpleModel().getDefaultValue();
        }
        renderer.setDefaultValue(defaultVal);
        renderer.setDefaultPostfix(this.getDOM().getGlobalDefinition().getDefaultValuePostFix());
        renderer.setDefaultPrefix(this.getDOM().getGlobalDefinition().getDefaultValuePreFix());
        editor.setRenderer(renderer);
        AutoCompletion.enable(editor, this.getStyle().isEnumerationAllowingInvalidCodes());
        editor.addItemListener(this);
        editor.getEditor().getEditorComponent().addFocusListener(this);
        this.setFirstFocusableComponent(editor.getEditor().getEditorComponent());
        editor.getEditor().getEditorComponent().addKeyListener(this);
        editor.setAutoscrolls(true);
        this._editorComponent = editor;
        this.setChoices(((SimpleType)this.getModel()).getEnumeration());
        this._editComboComponent = editor;
        return this._editorComponent;
    }

    public String getText() {
        String codeSetID;
        String currentValue = (String)((JAXJComboBox)this._editorComponent).getSelectedItem();
        if (currentValue == null) {
            return "";
        }
        String codeset = ((SimpleType)this.getModel()).getXUIDefinition().getStyle().getCodeSetName();
        if (codeset != null && !currentValue.equals("") && (codeSetID = this.getDOM().getSchema().getCodeTables().getId(this.getModel(), codeset, currentValue, this.getDOM().getLanguage())) != null) {
            currentValue = codeSetID;
        }
        return currentValue;
    }

    public void populateView() {
        if (this.getModel().isAbstract()) {
            SimpleType choosenType = (SimpleType)this.getModel().getChoosenType();
            if (choosenType != null) {
                this._abstractComboBox.setSelectedItem(choosenType);
            }
        } else {
            this.setChoices(((SimpleType)this.getModel()).getEnumeration());
            String value = ((SimpleType)this.getModel()).getValue();
            if (value != null) {
                String codeValue;
                String codeset;
                if (!this.getStyle().isUsingCodeSet() || (codeset = ((SimpleType)this.getModel()).getXUIDefinition().getStyle().getCodeSetName()) == null || value == null || (codeValue = this.getDOM().getSchema().getCodeTables().getText(this.getModel(), codeset, value, this.getDOM().getLanguage())) == null || !CodeTables.isValueInvalid((String)(value = codeValue), (String)this.getDOM().getLanguage())) {
                    // empty if block
                }
                ((JAXJComboBox)this._editorComponent).setSelectedItem(value);
            } else if (((JAXJComboBox)this._editorComponent).getItemCount() > 0) {
                ((JAXJComboBox)this._editorComponent).setSelectedIndex(0);
            }
        }
    }

    public void release() {
        this._abstractPanel = null;
        this._abstractComboBox = null;
        this._choosenComponent = null;
        if (this._firstFocusableComponent != null) {
            this._firstFocusableComponent.removeFocusListener(this);
        }
        if (this._editComboComponent != null && this._editComboComponent.getEditor() != null) {
            this._editComboComponent.getEditor().getEditorComponent().removeKeyListener(this);
        }
        super.release();
    }

    public void setCodeSetValues(String url, String codeSetName, String[] codes, String defaultSelection) {
        this.getModel().setCodeSetValues(url, codeSetName, codes, defaultSelection);
        this.populateView();
    }

    private void showSelection(JComponent component) {
        this.add((Component)component, "South");
    }

    public void populateModel() {
        String currentValue;
        String modelValue = ((SimpleType)this.getModel()).getValue();
        if (modelValue == null) {
            modelValue = "";
        }
        if ((currentValue = this.getText()) != null && !modelValue.equals(currentValue)) {
            ((SimpleType)this.getModel()).setValue((Object)this, currentValue, false);
        }
    }

    public void setRequired(boolean required) {
        Component comboBoxEditor = ((JAXJComboBox)this._editorComponent).getEditor().getEditorComponent();
        if (comboBoxEditor != null) {
            if (required) {
                if (this.getStyle().isApplicationRequired()) {
                    comboBoxEditor.setBackground(this.getDOM().getApplicationFieldColor());
                } else {
                    comboBoxEditor.setBackground(this.getDOM().getSchemaRequiredFieldColor());
                }
            } else {
                comboBoxEditor.setBackground(this.getDOM().getOptionalFieldColor());
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        JAXJComboBox comboBox;
        super.itemStateChanged(e);
        if (e.getSource() == this._abstractComboBox) {
            Type selectedType = (Type)this._abstractComboBox.getSelectedItem();
            if (selectedType.isEmpty()) {
                selectedType = null;
            }
            this.getModel().setChoosenType(selectedType);
            if (this._choosenComponent != null) {
                this.remove(this._choosenComponent);
                this._choosenComponent = null;
            }
            if (selectedType != null && !selectedType.isRepresentedAsTreeNode()) {
                this._choosenComponent = (JComponent)TypeVisualizerFactory.getInstance().getVisualizer(selectedType, this._context);
                if (this._choosenComponent != null && selectedType.isSimple()) {
                    ((Visualizer)this._choosenComponent).showLabel(false);
                    ((Visualizer)this._choosenComponent).populateView();
                    this._choosenComponent.setBorder(null);
                }
                if (this._choosenComponent != null) {
                    this.showSelection(this._choosenComponent);
                }
                this.updateUI();
            }
        } else if (e.getStateChange() == 1 && (comboBox = (JAXJComboBox)this._editorComponent).isPopupVisible() && e.getItem() != null) {
            this.populateModel();
        }
    }

    public void setEditable(boolean editable) {
        if (this._editComboComponent != null) {
            this._editComboComponent.setEditable(editable, true);
            this._editComboComponent.setFocusable(editable);
        }
    }

    private void setChoices(String[] choices) {
        if (this._editorComponent != null) {
            String codeset = this.getStyle().getCodeSetName();
            if (codeset != null) {
                String currentValue = this.getDOM().getSchema().getCodeTables().getText(this.getModel(), codeset, ((SimpleType)this.getModel()).getValue(), this.getDOM().getLanguage());
                if (CodeTables.isValueInvalid((String)currentValue, (String)this.getDOM().getLanguage())) {
                    ((JAXJComboBox)this._editorComponent).setEditable(true, false);
                }
                Vector<String> tempChoices = new Vector<String>();
                for (int i = 0; i < choices.length; ++i) {
                    if (!this.getStyle().isEnumerationAllowingInvalidCodes() && CodeTables.isValueInvalid((String)choices[i], (String)this.getDOM().getLanguage())) continue;
                    tempChoices.add(choices[i]);
                }
                choices = tempChoices.toArray(new String[tempChoices.size()]);
            }
            ((JAXJComboBox)this._editorComponent).setModel(new DefaultComboBoxModel<String>(choices));
        }
    }
}

