/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.ListModificationException;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.SimpleTypeList;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.xui.TableInfo;
import com.jaxfront.swing.ui.visualizers.AbstractListTypeView;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.visualizers.KeyView;
import com.jaxfront.swing.ui.visualizers.SimpleTypeComboBoxEditor;
import com.jaxfront.swing.ui.visualizers.SimpleTypeComboBoxRenderer;
import com.jaxfront.swing.ui.wrapper.DefaultTypeComboBoxModel;
import com.jaxfront.swing.ui.wrapper.JAXJComboBox;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class SimpleTypeListView
extends AbstractListTypeView
implements ActionListener {
    private SimpleTypeComboBoxEditor _editor;
    private String _lastValueOfSelectedItem;
    SimpleType _comboTemplate = null;

    public SimpleTypeListView(SimpleTypeList type) {
        super((Type)type, null);
        this.setModel((Type)type);
    }

    public SimpleTypeListView(SimpleTypeList type, Type context) {
        super((Type)type, context);
        this.setModel((Type)type);
    }

    protected ComboBoxEditor getComboBoxEditor() {
        if (this._editor == null) {
            this.getComboboxTemplateType().setValue((Object)this, "", false);
            this._editor = new SimpleTypeComboBoxEditor(this.getComboboxTemplateType(), this._context);
        }
        return this._editor;
    }

    private SimpleType getComboboxTemplateType() {
        if (this._comboTemplate == null) {
            try {
                this._comboTemplate = (SimpleType)((ListType)this.getModel()).getEditingType().deepClone(this.getDOM(), false, false);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return this._comboTemplate;
    }

    protected JComponent initComboBoxPanel() {
        this._addButton = this.createButton(this.getAddAction());
        this._addButton.setMargin(new Insets(2, 2, 2, 2));
        this._addButton.setPreferredSize(new Dimension((int)this._addButton.getPreferredSize().getWidth(), (int)this.getDefaultComponentHeight()));
        this._deleteButton = this.createButton(this.getDeleteAction());
        this._deleteButton.setMargin(new Insets(2, 2, 2, 2));
        this._deleteButton.setPreferredSize(new Dimension((int)this._deleteButton.getPreferredSize().getWidth(), (int)this.getDefaultComponentHeight()));
        this._comboBox = new JAXJComboBox((ComboBoxModel)new DefaultTypeComboBoxModel((ListType)this.getModel()));
        this._comboBox.setEditable(true, true);
        this._comboBox.setPreferredSize(new Dimension(20, (int)this.getDefaultComponentHeight()));
        SimpleType editingType = this.getComboboxTemplateType();
        editingType.setParent(this.getModel());
        if (editingType != null && editingType.getStyle().isVisible()) {
            this._comboBox.setEditor(this.getComboBoxEditor());
            SimpleTypeComboBoxRenderer renderer = new SimpleTypeComboBoxRenderer();
            renderer.setDefaultValue(this.getModel().getSchemaElement().getDefaultValue());
            renderer.setDefaultPostfix(this.getDOM().getGlobalDefinition().getDefaultValuePostFix());
            renderer.setDefaultPrefix(this.getDOM().getGlobalDefinition().getDefaultValuePreFix());
            this._comboBox.setRenderer(renderer);
            this._comboBox.addActionListener(this);
            this.setFirstFocusableComponent((JComponent)this.getComboBoxEditor().getEditorComponent());
        } else {
            this._comboBox.removeAllItems();
            this.setEnabled(false);
        }
        if (this.getListModel().size() == 0) {
            this._comboBox.setEnabled(false);
        }
        String colSpec = "fill:p:g,pref,pref";
        String rowSpec = "pref";
        FormLayout formLayout = new FormLayout(colSpec, rowSpec);
        JPanel containerPanel = new JPanel(formLayout);
        containerPanel.setName("containerPanel");
        containerPanel.add((Component)this._comboBox, "1,1,");
        this._errorContainer = containerPanel;
        TableInfo tableInfo = this.getStyle().getTableInfo();
        if (tableInfo == null) {
            containerPanel.add((Component)this._addButton, "2,1");
            containerPanel.add((Component)this._deleteButton, "3,1");
        } else if (this.getStyle().getTableInfo().isShowingButtons()) {
            if (this.getStyle().getTableInfo().isShowingNewButton()) {
                containerPanel.add((Component)this._addButton, "2,1");
            }
            if (this.getStyle().getTableInfo().isShowingDeleteButton()) {
                containerPanel.add((Component)this._deleteButton, "3,1");
            }
            containerPanel.setFocusable(false);
        }
        boolean isEditable = this.getStyle().isEditable();
        if (!isEditable) {
            this.setEditable(isEditable);
        }
        this.handleButtonEnabling(-1);
        return containerPanel;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this._comboBox != null) {
            this._comboBox.setEnabled(enabled);
            this._comboBox.setEditable(enabled, enabled);
        }
        if (this.getLabel() != null) {
            this.getLabel().setEnabled(enabled);
        }
    }

    public Type doAddAction(boolean holdCTRL) {
        if (this._comboBox == null) {
            return super.doAddAction(holdCTRL);
        }
        if (this._editor != null && this._editor.getEditorComponent().hasFocus()) {
            this.transferFocus();
        }
        this.getDOM().getController().getErrorController().removeValidationError(this.getModel());
        Type currentSelectedType = ((ListType)this.getModel()).addNewChild();
        this._comboBox.setSelectedItem(currentSelectedType);
        Cursor currentCursor = this._comboBox.getEditor().getEditorComponent().getCursor();
        this._comboBox.getEditor().getEditorComponent().setCursor(currentCursor);
        this._comboBox.getEditor().getEditorComponent().requestFocus();
        if (this.getComboBoxEditorTextComponent() != null) {
            this.getComboBoxEditorTextComponent().selectAll();
        }
        this.handleButtonEnabling(((ListType)this.getModel()).indexOf((Object)currentSelectedType));
        return currentSelectedType;
    }

    public JTextComponent getComboBoxEditorTextComponent() {
        if (this._comboBox.getEditor().getEditorComponent() instanceof JTextComponent) {
            return (JTextComponent)this._comboBox.getEditor().getEditorComponent();
        }
        return null;
    }

    public List doDeleteAction() {
        if (this._comboBox == null) {
            return super.doDeleteAction();
        }
        Vector<SimpleType> deletedItems = new Vector<SimpleType>();
        int index = this._comboBox.getSelectedIndex();
        if (index != -1) {
            this.getDOM().getController().getErrorController().removeValidationError(this.getModel());
            SimpleType simpleType = (SimpleType)((ListType)this.getModel()).getList().get(index);
            try {
                this.getListModel().isListItemRemoveable((Type)simpleType);
                TypeVisualizerFactory.getInstance().removeVisualizerStructure((Type)simpleType, true);
                ((ListType)this.getModel()).removeChild((Type)simpleType);
                deletedItems.add(simpleType);
                if (this._comboBox.getItemCount() > 0) {
                    if (this._comboBox.getItemCount() - 1 >= index) {
                        this._comboBox.setSelectedIndex(index);
                    } else {
                        this._comboBox.setSelectedIndex(this._comboBox.getItemCount() - 1);
                    }
                }
            }
            catch (ListModificationException e) {
                LogRegistry.getInstance().error(this.getClass(), e.getLocalizedMessage());
                KeyView.handleKeyError(e, this.getDOM());
            }
        }
        if (this.getModel().getDirectChildren().size() <= 0) {
            if (this.getComboBoxEditorTextComponent() != null) {
                this.getComboBoxEditorTextComponent().setText("");
            }
            this._comboBox.setSelectedItem(null);
            this.getComboBoxEditor().setItem(null);
            if (deletedItems != null && deletedItems.size() > 0) {
                this._comboBox.removeItem(deletedItems.get(0));
            }
        }
        this.handleButtonEnabling(this._comboBox.getSelectedIndex());
        return deletedItems;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.isUsingComboView()) {
            Type currentSelectedType;
            if (e.getSource() == this._comboBox && (currentSelectedType = (Type)this._comboBox.getSelectedItem()) != null) {
                this._lastValueOfSelectedItem = ((SimpleType)currentSelectedType).getValue();
                if (this._comboBox.getEditor().getItem() != null) {
                    ((SimpleType)this._comboBox.getEditor().getItem()).setValue((Object)this, this._lastValueOfSelectedItem, false);
                }
                AbstractSimpleTypeView visualizer = ((SimpleTypeComboBoxEditor)this._comboBox.getEditor()).getVisualizer();
                visualizer.populateView();
                visualizer.requestFocus();
                if (this._currentSelection == null) {
                    this._currentSelection = new Vector();
                }
                this._currentSelection.clear();
                this._currentSelection.add(currentSelectedType);
                this.handleButtonEnabling(((ListType)this.getModel()).indexOf((Object)currentSelectedType));
            }
            this.getEditor().repaint();
        }
    }

    protected void defaultBuild() {
        this.getDOM().addDOMChangeListener((DOMChangeListener)this);
        this.setLayout(new BorderLayout());
        this.setFocusable(false);
        JPanel labelComp = this.getLabelPanel(this.createLabel());
        this._visualizerPanel = this.createVisualizerPanel(labelComp, this.getEditorComponentPanel(this.createEditorComponent()));
        this.add((Component)this.getCaptionPanel(this.getVisualizerPanel()), "Center");
        this.setParentTablePanel(this.getVisualizerPanel());
    }

    protected JComponent createEditorComponent() {
        this._editorComponent = this.isUsingComboView() ? this.initComboBoxPanel() : super.createEditorComponent();
        return this._editorComponent;
    }

    public boolean isUsingComboView() {
        return this.getStyle().getListInfo() == null && this.getStyle().isUsingTableList();
    }

    public void release() {
        if (this._comboTemplate != null) {
            TypeVisualizerFactory.getInstance().releaseCache((Type)this._comboTemplate);
        }
        if (this._comboBox != null) {
            ((DefaultTypeComboBoxModel)this._comboBox.getModel()).release();
        }
        this._comboTemplate = null;
        this._comboBox = null;
        this._editor = null;
        this._lastValueOfSelectedItem = null;
        super.release();
    }

    public void domChanged(DOMChangeEvent event) {
        super.domChanged(event);
        if (event.isFinishedBinding() && event.getSource() == this.getModel() && this._editor != null && ((ListType)this.getModel()).getList().size() > 0) {
            this._editor.setItem(((ListType)this.getModel()).getList().get(0));
        }
        if (this._comboBox != null && (event.isAddingNode() || event.isRemovingNode())) {
            this._comboBox.setEnabled(this.getListModel().size() > 0);
        }
    }
}

