/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.xui.StyleDefinition;
import com.jaxfront.swing.helpers.ByteDocument;
import com.jaxfront.swing.helpers.DecimalDocument;
import com.jaxfront.swing.helpers.DoubleDocument;
import com.jaxfront.swing.helpers.FloatDocument;
import com.jaxfront.swing.helpers.IntDocument;
import com.jaxfront.swing.helpers.IntegerDocument;
import com.jaxfront.swing.helpers.LongDocument;
import com.jaxfront.swing.helpers.NegativeIntegerDocument;
import com.jaxfront.swing.helpers.NonNegativeIntegerDocument;
import com.jaxfront.swing.helpers.NonPositiveIntegerDocument;
import com.jaxfront.swing.helpers.NumericDocument;
import com.jaxfront.swing.helpers.PositiveIntegerDocument;
import com.jaxfront.swing.helpers.ShortDocument;
import com.jaxfront.swing.helpers.UnsignedByteDocument;
import com.jaxfront.swing.helpers.UnsignedIntDocument;
import com.jaxfront.swing.helpers.UnsignedLongDocument;
import com.jaxfront.swing.helpers.UnsignedShortDocument;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.text.MaskFormatter;

public class SimpleTypeNumericView
extends AbstractSimpleTypeView {
    private NumericDocument _numericDocument = null;

    public SimpleTypeNumericView(SimpleType type, Type context) {
        super(context);
        this.setModel((Type)type);
    }

    public SimpleTypeNumericView(SimpleType type) {
        this.setModel((Type)type);
    }

    protected JComponent createEditorComponent() {
        StyleDefinition style = this.getStyle();
        String mask = style.getLeafMask();
        this.initNumericType();
        if (mask != null && !mask.equals("")) {
            String validChars = style.getLeafMaskValidChars();
            String invalidChars = style.getLeafMaskInvalidChars();
            String placeHolder = style.getLeafMaskPlaceHolder();
            boolean allowInvalid = style.getLeafMaskAllowInvalid();
            boolean commitOnValidEnd = style.getLeafMaskCommitOnValidEnd();
            boolean overwriteMode = style.getLeafMaskOverwriteMode();
            MaskFormatter formatter = null;
            try {
                formatter = new MaskFormatter(mask);
            }
            catch (ParseException e) {
                // empty catch block
            }
            if (validChars != null && validChars.length() > 0) {
                formatter.setValidCharacters(validChars);
            }
            if (invalidChars != null && invalidChars.length() > 0) {
                formatter.setInvalidCharacters(invalidChars);
            }
            if (placeHolder != null && placeHolder.length() > 0) {
                formatter.setPlaceholderCharacter(placeHolder.toCharArray()[0]);
            }
            formatter.setAllowsInvalid(allowInvalid);
            formatter.setCommitsOnValidEdit(commitOnValidEnd);
            formatter.setOverwriteMode(overwriteMode);
            JFormattedTextField formattedField = new JFormattedTextField(formatter);
            formattedField.setValue(null);
            this.setEditorField(formattedField);
        } else {
            this.setEditorField(new JTextField(this._numericDocument, "", 0));
        }
        this.getEditorField().addKeyListener(this);
        this.setFirstFocusableComponent(this.getEditorComponent());
        this.setEditorComponent(this.getEditorField());
        return this._editorComponent;
    }

    public String getText() {
        return ((JTextField)this._editorComponent).getText();
    }

    private void initNumericType() {
        boolean useErrorSound = this.getDOM().getGlobalDefinition().isErrorSound();
        int primitiveType = ((SimpleType)this.getModel()).getPrimitiveDataType();
        double maxIncl = ((SimpleType)this.getModel()).getMaxInclValue();
        double maxExcl = ((SimpleType)this.getModel()).getMaxExclValue();
        double minIncl = ((SimpleType)this.getModel()).getMinInclValue();
        double minExcl = ((SimpleType)this.getModel()).getMinExclValue();
        int totalDigit = ((SimpleType)this.getModel()).getTotalDigit();
        switch (primitiveType) {
            case 4: {
                this._numericDocument = new DecimalDocument(useErrorSound, this.getWhiteSpaceType());
                break;
            }
            case 30: {
                this._numericDocument = new IntegerDocument(useErrorSound, this.getWhiteSpaceType());
                break;
            }
            case 33: {
                this._numericDocument = new LongDocument(useErrorSound, this.getWhiteSpaceType());
                break;
            }
            case 31: {
                this._numericDocument = new NonPositiveIntegerDocument(useErrorSound, this.getWhiteSpaceType());
                break;
            }
            case 37: {
                this._numericDocument = new NonNegativeIntegerDocument(useErrorSound, this.getWhiteSpaceType());
                break;
            }
            case 34: {
                this._numericDocument = new IntDocument(useErrorSound, this.getWhiteSpaceType());
                break;
            }
            case 36: {
                this._numericDocument = new ByteDocument(useErrorSound);
                break;
            }
            case 32: {
                this._numericDocument = new NegativeIntegerDocument(useErrorSound, this.getWhiteSpaceType());
                break;
            }
            case 42: {
                this._numericDocument = new PositiveIntegerDocument(useErrorSound, this.getWhiteSpaceType());
                break;
            }
            case 35: {
                this._numericDocument = new ShortDocument(useErrorSound, this.getWhiteSpaceType());
                break;
            }
            case 38: {
                this._numericDocument = new UnsignedLongDocument(useErrorSound, this.getWhiteSpaceType());
                break;
            }
            case 39: {
                this._numericDocument = new UnsignedIntDocument(useErrorSound, this.getWhiteSpaceType());
                break;
            }
            case 40: {
                this._numericDocument = new UnsignedShortDocument(useErrorSound, this.getWhiteSpaceType());
                break;
            }
            case 41: {
                this._numericDocument = new UnsignedByteDocument(useErrorSound);
                break;
            }
            case 5: {
                this._numericDocument = new FloatDocument(useErrorSound, this.getWhiteSpaceType());
                break;
            }
            case 6: {
                this._numericDocument = new DoubleDocument(useErrorSound, this.getWhiteSpaceType());
            }
        }
        this._numericDocument.setMinInclValue(minIncl);
        this._numericDocument.setMinExclValue(minExcl);
        this._numericDocument.setAllowInvalidMinValues(true);
        this._numericDocument.setMaxInclValue(maxIncl);
        this._numericDocument.setMaxExclValue(maxExcl);
        this._numericDocument.setTotalDigit(totalDigit);
        this._numericDocument.setDecimalSymbols(this.getDOM().getGlobalDefinition().getDecimalFormat().getDecimalFormatSymbols());
    }

    public void populateView() {
        if (this.getModel() != null) {
            String modelValue = ((SimpleType)this.getModel()).getValue();
            if (modelValue == null) {
                modelValue = "";
            }
            modelValue = TextTools.convertNumbersToView((String)modelValue, (DecimalFormat)this.getDOM().getGlobalDefinition().getDecimalFormat(), (boolean)this.getStyle().isUsingGroupingDelimiters());
            ((JTextField)this._editorComponent).setText(modelValue);
        }
    }

    public void populateModel() {
        super.populateModel();
        String modelViewValue = ((SimpleType)this.getModel()).getDisplayValue();
        if (!modelViewValue.equals(this.getText())) {
            this.populateView();
        }
    }

    public void release() {
        super.release();
        if (this._editorField != null) {
            this._editorField.removeKeyListener(this);
        }
        this._numericDocument = null;
    }
}

