/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.xui.StyleDefinition;
import com.jaxfront.swing.helpers.StringDocument;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.wrapper.JAXJLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import javax.swing.text.MaskFormatter;

public class SimpleTypeStringView
extends AbstractSimpleTypeView {
    boolean _actAsLabel = false;

    public SimpleTypeStringView() {
    }

    public SimpleTypeStringView(SimpleType type, Type context) {
        super(context);
        this.setModel((Type)type);
    }

    public SimpleTypeStringView(SimpleType type) {
        this.setModel((Type)type);
    }

    public void setFont(Font newFont) {
        if (this.getEditorField() != null) {
            this.getEditorField().setFont(newFont);
        }
    }

    private SimpleType model() {
        return (SimpleType)this.getModel();
    }

    private JComponent createMaskEditorComponent(boolean useErrorSound, long maxLengthOfCharacter) {
        JFormattedTextField formattedField;
        MaskFormatter formatter;
        boolean overwriteMode;
        boolean commitOnValidEnd;
        boolean allowInvalid;
        String placeHolder;
        String invalidChars;
        String validChars;
        block6: {
            StyleDefinition style = this.getStyle();
            String mask = style.getLeafMask();
            if ((long)mask.length() > maxLengthOfCharacter) {
                maxLengthOfCharacter = mask.length();
            }
            validChars = style.getLeafMaskValidChars();
            invalidChars = style.getLeafMaskInvalidChars();
            placeHolder = style.getLeafMaskPlaceHolder();
            allowInvalid = style.getLeafMaskAllowInvalid();
            commitOnValidEnd = style.getLeafMaskCommitOnValidEnd();
            overwriteMode = style.getLeafMaskOverwriteMode();
            formatter = null;
            formattedField = null;
            try {
                formatter = new MaskFormatter(mask);
            }
            catch (ParseException e) {
                if (!LogRegistry.getInstance().logWarnings()) break block6;
                LogRegistry.getInstance().warn(this.getClass(), "can't apply mask pattern:" + mask + " on type:" + this.getModel().getXPathLocation());
            }
        }
        if (validChars != null && validChars.length() > 0) {
            formatter.setValidCharacters(validChars);
        }
        if (invalidChars != null && invalidChars.length() > 0) {
            formatter.setInvalidCharacters(invalidChars);
        }
        if (placeHolder != null && placeHolder.length() > 0) {
            formatter.setPlaceholderCharacter(placeHolder.toCharArray()[0]);
        }
        formatter.setAllowsInvalid(allowInvalid);
        formatter.setCommitsOnValidEdit(commitOnValidEnd);
        formatter.setOverwriteMode(overwriteMode);
        formattedField = new JFormattedTextField(formatter);
        formattedField.setDocument(new StringDocument(useErrorSound, maxLengthOfCharacter, this.getWhiteSpaceType()));
        this.setEditorField(formattedField);
        formattedField.setValue(null);
        return this.getEditorField();
    }

    private JComponent createLabelEditorComponent(boolean useErrorSound, long maxLengthOfCharacter) {
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BorderLayout());
        JAXJLabel editorArea = new JAXJLabel(10);
        this.setEditorField(editorArea);
        aPanel.add(editorArea);
        return aPanel;
    }

    private JComponent createMultiLineEditorComponent(boolean useErrorSound, long maxLengthOfCharacter) {
        JTextArea editorArea = null;
        SimpleType st = this.model();
        if (st.getStyle().getMultiLineNumberComponent() == -1) {
            editorArea = new JTextArea();
            editorArea.setColumns(1);
        } else {
            editorArea = new JTextArea(st.getStyle().getMultiLineNumberComponent(), 1);
        }
        editorArea.setLineWrap(true);
        editorArea.setWrapStyleWord(true);
        editorArea.setDocument(new StringDocument(useErrorSound, maxLengthOfCharacter, this.getWhiteSpaceType()));
        JScrollPane scrollPane = new JScrollPane();
        for (int a = 0; a < scrollPane.getComponents().length; ++a) {
            Component component = scrollPane.getComponent(a);
            if (component == null) continue;
            component.setFocusable(false);
        }
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        editorArea.setBorder(null);
        scrollPane.getViewport().add(editorArea);
        this.setEditorField(editorArea);
        return scrollPane;
    }

    private JComponent createSingleLineEditorComponent(boolean useErrorSound, long maxLengthOfCharacter) {
        this.setEditorField(new JTextField());
        ((JTextComponent)this.getEditorField()).setDocument(new StringDocument(useErrorSound, maxLengthOfCharacter, this.getWhiteSpaceType()));
        return this.getEditorField();
    }

    protected JComponent createEditorComponent() {
        boolean useErrorSound = this.getDOM().getGlobalDefinition().isErrorSound();
        SimpleType st = this.model();
        long maxLengthOfCharacter = st.getMaxLength();
        StyleDefinition style = st.getStyle();
        String mask = style.getLeafMask();
        this._actAsLabel = style.showAsLabel();
        this._editorComponent = this._actAsLabel ? this.createLabelEditorComponent(useErrorSound, maxLengthOfCharacter) : (mask != null && !mask.equals("") ? this.createMaskEditorComponent(useErrorSound, maxLengthOfCharacter) : (st.getStyle().isComponentMulti() ? this.createMultiLineEditorComponent(useErrorSound, maxLengthOfCharacter) : this.createSingleLineEditorComponent(useErrorSound, maxLengthOfCharacter)));
        this.getEditorField().addFocusListener(this);
        this.getEditorField().addKeyListener(this);
        this.setFirstFocusableComponent(this.getEditorField());
        return this._editorComponent;
    }

    public String getText() {
        if (this.getEditorField() != null) {
            String text = ((JTextComponent)this.getEditorField()).getText();
            return text;
        }
        return "";
    }

    public void populateView() {
        if (this.getEditorField() != null && this.model() != null) {
            String modelValue = this.model().getValue();
            if (modelValue == null) {
                modelValue = "";
            }
            if (this._actAsLabel) {
                modelValue = TextTools.createHTMLString((String)modelValue);
                ((JLabel)this.getEditorField()).setText(modelValue);
            } else {
                ((JTextComponent)this.getEditorField()).setText(modelValue);
                ((JTextComponent)this.getEditorField()).getCaret().setDot(0);
            }
        }
    }

    public void release() {
        if (this._editorComponent != null) {
            this._editorComponent.removeFocusListener(this);
            this._editorComponent.removeKeyListener(this);
        }
        super.release();
    }

    public void setRequired(boolean required) {
        if (!this._actAsLabel) {
            super.setRequired(required);
        }
    }
}

