/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.wrapper;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import javax.swing.DefaultListModel;

public class DefaultTypeListModel
extends DefaultListModel
implements DOMChangeListener {
    private ListType _listSource;

    public void domChanged(DOMChangeEvent event) {
        long eventType = event.getType();
        if (!event.isTemporary() && (eventType == 2L || eventType == 4096L || eventType == 256L || eventType == 2L || eventType == 512L || eventType == 1024L) && this.isRelevant(this._listSource, (Type)event.getSource())) {
            this.performEvent(event);
        }
    }

    public DefaultTypeListModel(ListType list) {
        this._listSource = list;
        for (int i = 0; i < list.getDirectChildren().size(); ++i) {
            this.addElement(list.getDirectChildren().get(i));
        }
        list.getDOM().addDOMChangeListener((DOMChangeListener)this);
    }

    public Type getListEntryHolder(Type type) {
        if (type.getParent() != null && type.getParent().isList()) {
            return type;
        }
        if (type.getParent() != null) {
            return this.getListEntryHolder(type.getParent());
        }
        return null;
    }

    public boolean isRelevant(ListType base, Type toBeChecked) {
        if (toBeChecked.getParent() != null && !toBeChecked.getParent().isList()) {
            return false;
        }
        Type toBeCheckedListHolder = toBeChecked.getParent();
        return toBeCheckedListHolder == this._listSource;
    }

    protected void performEvent(DOMChangeEvent event) {
        Type type = (Type)event.getSource();
        int listIndex = type.getParentList().getList().indexOf(type);
        if (event.isChangingNode()) {
            this.fireContentsChanged(this, listIndex, listIndex);
        } else if (event.isAddingNode()) {
            if (listIndex >= 0) {
                this.add(listIndex, type);
            } else {
                this.addElement(type);
            }
        } else if (event.isRemovingNode()) {
            this.removeElementAt(event.getIndex());
        } else if (event.isMovingNode()) {
            int from = event.getMovedFromIndex();
            int to = event.getMovedToIndex();
            Object fromObj = this.get(from);
            this.add(to, fromObj);
            this.remove(from);
        }
    }
}

