/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.wrapper;

import com.jaxfront.core.util.JAXFrontProperties;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class JAXJDialog
extends JDialog
implements WindowListener {
    public JAXJDialog() throws HeadlessException {
        this.addWindowListener(this);
    }

    public JAXJDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.addWindowListener(this);
    }

    public JAXJDialog(Dialog owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.addWindowListener(this);
    }

    public JAXJDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.addWindowListener(this);
    }

    public JAXJDialog(Frame owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.addWindowListener(this);
    }

    public JAXJDialog(Dialog owner, String title) throws HeadlessException {
        super(owner, title);
        this.addWindowListener(this);
    }

    public JAXJDialog(Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.addWindowListener(this);
    }

    public JAXJDialog(Frame owner, String title) throws HeadlessException {
        super(owner, title);
        this.addWindowListener(this);
    }

    public JAXJDialog(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.addWindowListener(this);
    }

    public void showCentered() {
        Container parent = this.getParent();
        if (parent == null || !parent.isShowing()) {
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            return;
        }
        Point loc = parent.getLocationOnScreen();
        Dimension dim = parent.getSize();
        Dimension size = this.getSize();
        loc.x += (dim.width - size.width) / 2;
        loc.y += (dim.height - size.height) / 2;
        if (loc.x < 0) {
            loc.x = 0;
        }
        if (loc.y < 0) {
            loc.y = 0;
        }
        Dimension screen = this.getToolkit().getScreenSize();
        if (size.width > screen.width) {
            size.width = screen.width;
        }
        if (size.height > screen.height) {
            size.height = screen.height;
        }
        if (loc.x + size.width > screen.width) {
            loc.x = screen.width - size.width;
        }
        if (loc.y + size.height > screen.height) {
            loc.y = screen.height - size.height;
        }
        this.setBounds(loc.x, loc.y, size.width, size.height);
        this.setVisible(true);
    }

    public void showCentered(Component comp) {
        if (comp == null) {
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            return;
        }
        Window wind = SwingUtilities.getWindowAncestor(comp);
        Dimension dim = null;
        Point loc = null;
        if (wind == null || !wind.isShowing()) {
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            return;
        }
        loc = wind.getLocationOnScreen();
        dim = wind.getSize();
        Dimension size = this.getSize();
        loc.x += (dim.width - size.width) / 2;
        loc.y += (dim.height - size.height) / 2;
        if (loc.x < 0) {
            loc.x = 0;
        }
        if (loc.y < 0) {
            loc.y = 0;
        }
        Dimension screen = this.getToolkit().getScreenSize();
        if (size.width > screen.width) {
            size.width = screen.width;
        }
        if (size.height > screen.height) {
            size.height = screen.height;
        }
        if (loc.x + size.width > screen.width) {
            loc.x = screen.width - size.width;
        }
        if (loc.y + size.height > screen.height) {
            loc.y = screen.height - size.height;
        }
        this.setBounds(loc.x, loc.y, size.width, size.height);
        this.setVisible(true);
    }

    public JAXJDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc) throws HeadlessException {
        super(owner, title, modal, gc);
        this.addWindowListener(this);
    }

    public JAXJDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.addWindowListener(this);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
        JAXFrontProperties.getInstance().putGUIMetrics((Component)this);
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
    }

    public void setCloseAtEscape() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAXJDialog.this.setVisible(false);
            }
        };
        this.getRootPane().registerKeyboardAction(actionListener, stroke, 2);
    }
}

