/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.dom;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.LogEntry;
import com.jaxfront.core.rule.ScopeChecker;
import com.jaxfront.core.type.Type;
import java.beans.PropertyChangeEvent;

public class LoggingListener {
    private Type _source;
    private String _scope = "";
    private String _logLevel;
    private boolean _logPropChanges = true;

    public LoggingListener(Type source, String scope, String logLevel) {
        this._source = source;
        this._scope = scope;
        this._logLevel = logLevel;
    }

    public void apply(Type source, DOMChangeEvent event, String oldValue) {
        if (this._logLevel != null && this.doesConcern(source)) {
            LogEntry logEntry = new LogEntry(source, event, this._logLevel, oldValue);
            source.getDOM().getController().addChangeLog(logEntry);
        }
    }

    public void apply(Type source, PropertyChangeEvent event, String oldValue) {
        if (this._logPropChanges && this.doesConcern(source) && this._logLevel != null) {
            LogEntry logEntry = new LogEntry(source, event, this._logLevel, oldValue);
            source.getDOM().getController().addChangeLog(logEntry);
        }
    }

    protected boolean doesConcern(Type sourceType) {
        if (this._scope != null) {
            return ScopeChecker.doesConcern(this._scope, this._source, sourceType, null, false, null);
        }
        return false;
    }

    public Type getSource() {
        return this._source;
    }

    public String getLogLevel() {
        return this._logLevel;
    }

    public String getLogScope() {
        return this._scope;
    }

    public void setLogLevel(String logLevel) {
        this._logLevel = logLevel;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void setLogPropertyChanges(boolean doLog) {
        this._logPropChanges = doLog;
    }

    public boolean getLogPropChanges() {
        return this._logPropChanges;
    }
}

