/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.jep.ArrayResult;
import com.jaxfront.core.jep.JaxfrontMathCommand;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.util.VectorHelper;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.NULL;

public class ArrayHelper
extends JaxfrontMathCommand {
    public ArrayHelper() {
        this.numberOfParameters = -1;
    }

    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        Object ares;
        this.checkStack(stack);
        if (this.curNumberOfParameters == 2) {
            ares = stack.pop();
            Object action = stack.pop();
            if (ares == NULL._null) {
                stack.push(NULL._null);
                return;
            }
            if (ares instanceof List) {
                List array = (List)ares;
                if ("getFirst".equals(action)) {
                    if (array.size() > 0) {
                        this.pushToStack(stack, array.get(0));
                    } else {
                        stack.push(NULL._null);
                    }
                    return;
                }
                if ("getLast".equals(action)) {
                    if (array.size() > 0) {
                        this.pushToStack(stack, array.get(array.size() - 1));
                    } else {
                        stack.push(NULL._null);
                    }
                    return;
                }
                if ("size".equals(action)) {
                    stack.push(array.size());
                    return;
                }
                if ("removeDuplicates".equals(action)) {
                    stack.push(new ArrayResult((Collection)VectorHelper.removeDuplicates(array)));
                    return;
                }
                if ("removeNull".equals(action)) {
                    array.remove(null);
                    stack.push(ares);
                    return;
                }
            }
        }
        if (this.curNumberOfParameters == 3) {
            ares = stack.pop();
            Object oIdx = stack.pop();
            Object action = stack.pop();
            if (ares == NULL._null || oIdx == NULL._null || action == NULL._null) {
                stack.push(NULL._null);
                return;
            }
            if (ares instanceof List) {
                List array = (List)ares;
                if (oIdx instanceof Number) {
                    int idx = ((Number)oIdx).intValue();
                    if ("get".equals(action)) {
                        if (this.checkIDx(idx, array.size(), true)) {
                            Object result = array.get(idx);
                            this.pushToStack(stack, result);
                        } else {
                            stack.push(NULL._null);
                        }
                        return;
                    }
                    if ("remove".equals(action) && this.checkIDx(idx, array.size(), true)) {
                        ((List)ares).remove(idx);
                        stack.push(ares);
                        return;
                    }
                    if ("removeEvery".equals(action) && this.checkIDx(idx, array.size(), false)) {
                        VectorHelper.removeEvery((List)ares, idx);
                        stack.push(ares);
                        return;
                    }
                    if ("keepEvery".equals(action) && this.checkIDx(idx, array.size(), false)) {
                        VectorHelper.keepEvery((List)ares, idx);
                        stack.push(ares);
                        return;
                    }
                    stack.push(ares);
                    return;
                }
                if (oIdx instanceof String) {
                    if ("startsWith".equals(action)) {
                        String sword = oIdx.toString();
                        ArrayResult result = new ArrayResult((Collection)VectorHelper.getStartsWith(array, sword));
                        this.pushToStack(stack, result);
                        return;
                    }
                    if ("endsWith".equals(action)) {
                        String sword = oIdx.toString();
                        ArrayResult result = new ArrayResult((Collection)VectorHelper.getEndsWith(array, sword));
                        this.pushToStack(stack, result);
                        return;
                    }
                    if ("contains".equals(action)) {
                        String sword = oIdx.toString();
                        ArrayResult result = new ArrayResult((Collection)VectorHelper.getContains(array, sword));
                        this.pushToStack(stack, result);
                        return;
                    }
                }
            }
        }
        stack.push(NULL._null);
    }

    private boolean checkIDx(int idx, int size, boolean zeroBased) {
        if (zeroBased) {
            return idx > -1 && idx < size;
        }
        return idx > 0 && idx <= size;
    }
}

