/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.rule;

import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.Visualizer;
import java.lang.reflect.Method;
import java.util.EventObject;

public class ActionPerformEvent
extends EventObject {
    private String _xpath;
    private String _methodName;
    private Method _method;
    private Object[] _values;
    private String _toString;

    public ActionPerformEvent(Object source, Method method, Object[] values) {
        this(source, null, method.getName(), values);
        this._method = method;
    }

    public ActionPerformEvent(Object source, String xpath, String methodName, Object[] values) {
        super(source);
        this._xpath = xpath;
        this._methodName = methodName;
        this._values = values;
    }

    public String getName() {
        return this._methodName;
    }

    public Method getMethod() {
        return this._method;
    }

    public Object[] getParamValues() {
        return this._values;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return -1;
    }

    public Type getTarget() {
        Type actionTarget = null;
        Object actionSource = this.getSource();
        if (actionSource instanceof Visualizer) {
            actionTarget = ((Visualizer)this.getSource()).getModel();
        }
        if (actionSource instanceof Type) {
            actionTarget = (Type)this.getSource();
        }
        return actionTarget;
    }

    public String toString() {
        if (this._toString == null) {
            String toString = this._xpath;
            toString = toString + "_method: " + this.getMethodString(this._method);
            if (this._values != null) {
                toString = toString + "_[";
                for (int i = 0; i < this._values.length; ++i) {
                    if (this._values[i] == null) continue;
                    toString = toString + this._values[i].toString() + ",";
                }
                toString = toString + "]";
            }
            if (this.getSource() != null) {
                toString = this.getSource() instanceof Visualizer ? toString + "_" + ((Visualizer)this.getSource()).getModel().getXPathLocation() : (this.getSource() instanceof Type ? toString + "_" + ((Type)this.getSource()).getXPathLocation() : toString + "_" + this.getSource().toString());
            }
            this._toString = toString;
        }
        return this._toString;
    }

    public String getXPath() {
        return this._xpath;
    }

    public String getXPathLocation() {
        if (this._xpath != null) {
            return this._xpath;
        }
        if (this.getSource() instanceof Visualizer) {
            return ((Visualizer)this.getSource()).getModel().getXPathLocation();
        }
        if (this.getSource() instanceof Type) {
            return ((Type)this.getSource()).getXPathLocation();
        }
        return null;
    }

    private String getMethodString(Method method) {
        StringBuffer sb = new StringBuffer();
        if (this._method == null) {
            sb.append(this._methodName);
        } else {
            sb.append(method.getName() + "(");
            Class<?>[] params = method.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(params[j].getName());
                if (j >= params.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

