/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.schema.impl;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.SchemaComplexType;
import com.jaxfront.core.schema.SchemaKey;
import com.jaxfront.core.schema.SchemaKeyRef;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.SchemaSimpleType;
import com.jaxfront.core.schema.SchemaType;
import com.jaxfront.core.schema.XMLSchema;
import com.jaxfront.core.schema.impl.KeyDefinition;
import com.jaxfront.core.schema.impl.KeyRefDefinition;
import com.jaxfront.core.schema.impl.SchemaComplexTypeImpl;
import com.jaxfront.core.schema.impl.SchemaSimpleTypeImpl;
import com.jaxfront.core.schema.impl.XMLSchemaImpl;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.TextTools;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.KeyRef;
import org.apache.xerces.impl.xs.identity.UniqueOrKey;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeGroupDefinition;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSTypeDefinition;

public class SchemaNodeImpl
implements SchemaNode {
    private String _xpath;
    private String _nodeName;
    private String _qName;
    private String _nsPrefix;
    private String _refName;
    private String _location;
    private SchemaNode _parent;
    private Hashtable _annotation;
    private boolean _hasUnnamedOptionalParent = false;
    private boolean _isGlobal = false;
    private short _globalTypeType = (short)-1;
    public static final short GLOBAL_TYPE = 3;
    public static final short GLOBAL_ELEMENT = 2;
    public static final short GLOBAL_ATTRIBUTE = 1;
    public static final short GLOBAL_ATTRIBUTEGROUP = 5;
    public static final short GLOBAL_GROUP = 7;
    private boolean _isTypeReference = false;
    private boolean _isElementReference = false;
    private boolean _isGroupReference = false;
    private String _groupRefName;
    protected boolean _isAnonymous = false;
    protected transient XSObject _node;
    private int _minOccurs = -2;
    private int _maxOccurs = -2;
    private String _defaultValue;
    private String _fixedValue;
    private String _targetNS;
    private boolean _ignoreNameSpace = JAXFrontProperties.getInstance().ignoreNamespace();
    private SchemaType _type;
    public static final String UNNAMED_ELEMENT = "UNNAMED";
    protected transient XMLSchema _schema;
    private ArrayList _keyRefNames;
    private Hashtable _keyNames;
    private int _anonymousGroupIndex = -1;
    private byte _isRefWithNoExtension = (byte)-1;
    private byte _hasExtension = (byte)-1;

    public SchemaNodeImpl(XSObject node, XMLSchema schema, int minOccurs, int maxOccurs, String defaultValue, String fixedValue, SchemaNode parent) {
        this(node, schema, minOccurs, maxOccurs, 0, defaultValue, fixedValue, parent, false);
    }

    public SchemaNodeImpl(XSObject node, XMLSchema schema, int minOccurs, int maxOccurs, SchemaNode parent) {
        this(node, schema, minOccurs, maxOccurs, 0, parent);
    }

    public SchemaNodeImpl(XSObject node, XMLSchema schema, int minOccurs, int maxOccurs, SchemaNode parent, boolean isGlobal) {
        this(node, schema, minOccurs, maxOccurs, 0, null, null, parent, isGlobal);
    }

    public SchemaNodeImpl(XSObject node, XMLSchema schema, int minOccurs, int maxOccurs, int unnamedCounter, SchemaNode parent) {
        this(node, schema, minOccurs, maxOccurs, unnamedCounter, null, null, parent, false);
    }

    public SchemaNodeImpl(XSObject node, XMLSchema schema, int minOccurs, int maxOccurs, int unnamedCounter, String defaultValue, String fixedValue, SchemaNode parent, boolean isGlobal) {
        this(node, schema, minOccurs, maxOccurs, unnamedCounter, defaultValue, fixedValue, parent, isGlobal, true);
    }

    public SchemaNodeImpl(XSObject node, XMLSchema schema, int minOccurs, int maxOccurs, int unnamedCounter, String defaultValue, String fixedValue, SchemaNode parent, boolean isGlobal, boolean initialize) {
        this._node = node;
        this._parent = parent;
        this._minOccurs = minOccurs;
        this._maxOccurs = maxOccurs;
        this._schema = schema;
        this._defaultValue = defaultValue;
        this._fixedValue = fixedValue;
        this._isGlobal = isGlobal;
        if (this._node != null) {
            if (this._isGlobal) {
                switch (this._node.getType()) {
                    case 3: {
                        this._globalTypeType = (short)3;
                        break;
                    }
                    case 2: {
                        this._globalTypeType = (short)2;
                        break;
                    }
                    case 5: {
                        this._globalTypeType = (short)5;
                        break;
                    }
                    case 1: {
                        this._globalTypeType = 1;
                        break;
                    }
                    case 6: {
                        this._globalTypeType = (short)7;
                    }
                }
            }
            this._nodeName = node.getName();
            if (this._nodeName == null) {
                this._nodeName = UNNAMED_ELEMENT + unnamedCounter;
                this._isAnonymous = true;
            }
            if (initialize) {
                this.initialize(node, unnamedCounter);
            }
        } else {
            this._nodeName = "none";
        }
        if (this._defaultValue != null && this.isSimple() && ((SchemaSimpleType)this.getSchemaType()).isFloatingNumber()) {
            this._defaultValue = TextTools.convertExponentialValue(this._defaultValue);
        }
    }

    public void finalAnalyse() {
        if (this._node != null) {
            this.initDefaultValue(this._node);
            this.initFixedValue(this._node);
            this.initCardinalities(this._node);
            this.initIdentities(this._node);
            this.initTargetNS(this._node);
            if (this._node != null && this._isGlobal) {
                switch (this._globalTypeType) {
                    case 3: {
                        XSTypeDefinition typeDefinition = (XSTypeDefinition)this._node;
                        if (typeDefinition.getTypeCategory() == 15) {
                            this.initGlobalTypeRef((XSComplexTypeDecl)this._node);
                            break;
                        }
                        if (typeDefinition.getTypeCategory() != 16) break;
                        this.initGlobalTypeRef((XSSimpleTypeDecl)this._node);
                        break;
                    }
                    case 2: {
                        this.initGlobalTypeRef((XSElementDecl)this._node);
                        break;
                    }
                    case 1: {
                        this.initGlobalTypeRef((XSAttributeDecl)this._node);
                        break;
                    }
                    case 5: {
                        this.initGlobalTypeRef((XSAttributeGroupDecl)this._node);
                        break;
                    }
                    case 7: {
                        this.initGlobalTypeRef((XSGroupDecl)this._node);
                        break;
                    }
                }
            } else {
                this.initLocalRef(this._node);
            }
        }
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public String getFixedValue() {
        return this._fixedValue;
    }

    public int getMaxOccurs() {
        return this._maxOccurs;
    }

    public int getMinOccurs() {
        return this._minOccurs;
    }

    public String getQName() {
        if (this._qName == null) {
            String nameSpace = null;
            this._qName = !this._ignoreNameSpace && (nameSpace = this.getTargetNS()) != null && nameSpace.length() > 0 ? nameSpace + ":" + this._nodeName : this._nodeName;
        }
        return this._qName;
    }

    public String getName() {
        return this._nodeName;
    }

    public String getNamespacePrefix() {
        if (!this._ignoreNameSpace && this._nsPrefix == null && this.getSchema() != null && this.getTargetNS() != null) {
            this._nsPrefix = ((XMLSchemaImpl)this.getSchema()).getNamespacePrefix(this.getTargetNS());
        }
        return this._nsPrefix;
    }

    public String getRefName() {
        if (this._node != null) {
            return this._refName;
        }
        return null;
    }

    public XMLSchema getSchema() {
        return this._schema;
    }

    public SchemaType getSchemaType() {
        if (this._type == null) {
            this.initializeSchemaType();
        }
        return this._type;
    }

    public String getTargetNS() {
        return this._node.getNamespace();
    }

    public boolean hasType() {
        return this._type != null;
    }

    private void initCardinalities(XSObject node) {
        if (this._minOccurs == -2 || this._maxOccurs == -2) {
            this._minOccurs = 1;
            this._maxOccurs = 1;
        }
    }

    private void initDefaultValue(XSObject node) {
        if (node.getType() == 2) {
            XSElementDeclaration dec = (XSElementDeclaration)node;
            if (dec.getAnnotation() != null) {
                this.initAnnotation(dec.getAnnotation());
            }
            if (dec.getConstraintType() == 1) {
                this._defaultValue = dec.getConstraintValue();
                this.initTargetNS(node);
                if (this.isSimple() && ((SchemaSimpleType)this.getSchemaType()).isFloatingNumber()) {
                    this._defaultValue = TextTools.convertExponentialValue(this._defaultValue);
                }
            }
        } else if (node.getType() == 1 && node.getType() == 1) {
            XSAttributeDeclaration dec = (XSAttributeDeclaration)node;
            if (dec.getConstraintType() == 1) {
                this._defaultValue = dec.getConstraintValue();
                if (this.isSimple() && ((SchemaSimpleType)this.getSchemaType()).isFloatingNumber()) {
                    this._defaultValue = TextTools.convertExponentialValue(this._defaultValue);
                }
            }
            if (dec.getAnnotation() != null) {
                this.initAnnotation(dec.getAnnotation());
            }
        }
    }

    private void initAnnotation(XSAnnotation annotation) {
        this._annotation = DOMHelper.extractAnnotation(annotation);
    }

    private void initFixedValue(XSObject node) {
        XSAttributeDeclaration dec;
        if (node.getType() == 2) {
            XSElementDeclaration dec2 = (XSElementDeclaration)node;
            if (dec2.getConstraintType() == 2) {
                this._fixedValue = dec2.getConstraintValue();
            }
        } else if (node.getType() == 1 && (dec = (XSAttributeDeclaration)node).getConstraintType() == 2) {
            this._fixedValue = dec.getConstraintValue();
        }
    }

    private void initialize(XSObject node, int unnamedCounter) {
        if (!this._isGlobal) {
            this.initDefaultValue(node);
            this.initFixedValue(node);
            this.initCardinalities(node);
            this.initIdentities(node);
            this.initTargetNS(node);
            this.initLocalRef(node);
        }
    }

    private void initializeSchemaType() {
        SchemaNode globalElement;
        SchemaType globalType = null;
        if (this.isReferenceWithNoExtension()) {
            globalElement = this.getSchema().getGlobalEntity(this);
            if (globalElement != null && globalElement != this && (globalType = globalElement.getSchemaType()) != null) {
                this.setSchemaType(globalType);
            }
        } else if (this._groupRefName != null && (globalType = (globalElement = this.getSchema().getGlobalEntity(this.getNode().getType(), this._groupRefName)).getSchemaType()) != null) {
            this.setSchemaType(globalType);
        }
        if (globalType == null) {
            XSTypeDefinition type = null;
            switch (this._node.getType()) {
                case 2: {
                    XSElementDeclaration element = (XSElementDeclaration)this._node;
                    type = element.getTypeDefinition();
                    break;
                }
                case 3: {
                    type = (XSTypeDefinition)this._node;
                    break;
                }
                case 1: {
                    this._type = new SchemaSimpleTypeImpl(this._node.getNamespace(), this._node.getName(), (XSTypeDefinition)((XSAttributeDecl)this._node).getTypeDefinition(), this._schema, (SchemaNode)this);
                    break;
                }
                case 9: {
                    type = new XSSimpleTypeDecl();
                    break;
                }
                case 7: {
                    this._type = new SchemaComplexTypeImpl(this.getNamespace(), this.getName(), (XSModelGroup)this._node, this._schema, (SchemaNode)this);
                    break;
                }
                case 6: {
                    XSModelGroup group = ((XSGroupDecl)this._node).getModelGroup();
                    this._type = new SchemaComplexTypeImpl(this.getNamespace(), this.getName(), group, this._schema, (SchemaNode)this);
                    break;
                }
                case 5: {
                    this._type = new SchemaComplexTypeImpl(this.getNamespace(), this.getName(), (XSAttributeGroupDefinition)this._node, this._schema, (SchemaNode)this);
                    break;
                }
            }
            if (type != null) {
                if (type.getTypeCategory() == 15) {
                    XSComplexTypeDefinition xsdComplexType = (XSComplexTypeDefinition)type;
                    if (xsdComplexType.getName() != null && xsdComplexType.getName().equals("anyType")) {
                        this._type = new SchemaSimpleTypeImpl(xsdComplexType.getNamespace(), this.getName(), (XSTypeDefinition)new XSSimpleTypeDecl(), this._schema, (SchemaNode)this);
                    } else {
                        String name = xsdComplexType.getName();
                        String nameSpace = xsdComplexType.getNamespace();
                        if (this.isGlobalReference()) {
                            name = this.getName();
                            nameSpace = xsdComplexType.getNamespace();
                        }
                        if (name == null) {
                            name = xsdComplexType.getBaseType().getName();
                            nameSpace = xsdComplexType.getBaseType().getNamespace();
                        }
                        this._type = new SchemaComplexTypeImpl(nameSpace, name, (XSTypeDefinition)xsdComplexType, this._schema, (SchemaNode)this);
                    }
                } else {
                    this._type = new SchemaSimpleTypeImpl(type.getNamespace(), this.getName(), type, this._schema, (SchemaNode)this);
                }
            }
            if (this._type == null && LogRegistry.getInstance().logWarnings()) {
                LogRegistry.getInstance().warn(this.getClass(), "unable to create type: " + this._node.getClass());
            }
        }
    }

    private void initIdentities(XSObject node) {
        XSElementDeclaration elementDec;
        XSNamedMap map;
        if (node.getType() == 2 && (map = (elementDec = (XSElementDeclaration)node).getIdentityConstraints()).getLength() > 0) {
            for (int i = 0; i < map.getLength(); ++i) {
                IdentityConstraint iConstraint = (IdentityConstraint)map.item(i);
                if (iConstraint.getCategory() == 1) {
                    UniqueOrKey key = (UniqueOrKey)iConstraint;
                    String keyName = key.getName();
                    String selectorXPath = key.getSelectorStr();
                    String[] fields = new String[key.getFieldCount()];
                    for (int j = 0; j < fields.length; ++j) {
                        String xpathToField = key.getFieldAt(j).getXPath().toString();
                        fields[j] = xpathToField = xpathToField.substring(xpathToField.indexOf("/") + 1, xpathToField.length());
                    }
                    SchemaKey keyObject = new SchemaKey(this, keyName, selectorXPath, fields);
                    this.getSchema().registerKey(keyName, keyObject);
                    continue;
                }
                if (iConstraint.getCategory() != 2) continue;
                KeyRef keyRef = (KeyRef)iConstraint;
                String keyRefName = keyRef.getName();
                String referName = keyRef.getRefKey().getName();
                String selectorXPath = keyRef.getSelectorStr();
                String[] fields = new String[keyRef.getFieldCount()];
                for (int j = 0; j < fields.length; ++j) {
                    String xpathToField = keyRef.getFieldAt(j).getXPath().toString();
                    fields[j] = xpathToField = xpathToField.substring(xpathToField.indexOf("/") + 1, xpathToField.length());
                }
                SchemaKeyRef keyRefHolder = new SchemaKeyRef(this, keyRefName, referName, selectorXPath, fields);
                this.getSchema().registerKeyRef(keyRefName, keyRefHolder);
            }
        }
    }

    protected void initGlobalTypeRef(XSComplexTypeDecl complexType) {
        String refName = null;
        if (!"anyType".equals(complexType.getTypeName())) {
            refName = !complexType.getAnonymous() ? this.evalAnonymousRefName(complexType, refName) : SchemaNodeImpl.createQName(complexType.getNamespace(), complexType.getTypeName());
        }
        if (refName != null) {
            this.applyReference(refName);
        }
    }

    private void applyReference(String refName) {
        SchemaNode globalNode = this._schema.getGlobalEntity(this.getNode().getType(), refName);
        if (globalNode != null) {
            this.setRefName(globalNode, refName);
        }
    }

    protected void initGlobalTypeRef(XSSimpleTypeDecl node) {
        String name = node.getName();
        this.analyseRef(node, name);
    }

    protected void initGlobalTypeRef(XSAttributeDecl node) {
        if (node != null) {
            XSSimpleTypeDecl simpleDefinition = (XSSimpleTypeDecl)node.getTypeDefinition();
            this.analyseRef(simpleDefinition, node.getName());
        }
    }

    protected void initGlobalTypeRef(XSAttributeGroupDecl node) {
        XSObjectList attrs = node.getAttributeUses();
        for (int a = 0; a < attrs.getLength(); ++a) {
            XSAttributeUse aUse = (XSAttributeUse)attrs.item(a);
            this.initGlobalTypeRef((XSAttributeDecl)aUse.getAttrDeclaration());
        }
    }

    protected void initGlobalTypeRef(XSGroupDecl node) {
    }

    protected void initGlobalTypeRef(XSElementDecl element) {
        XSTypeDefinition typeDefinition = element.getTypeDefinition();
        if (typeDefinition.getTypeCategory() == 15) {
            XSComplexTypeDecl complexType = (XSComplexTypeDecl)typeDefinition;
            String refName = this.evaluateRefName(complexType, complexType.getTypeName());
            if (refName != null) {
                this.applyReference(refName);
            }
        } else {
            String name = element.getName();
            this.analyseRef((XSSimpleTypeDecl)typeDefinition, name);
        }
    }

    private String evalAnonymousRefName(XSComplexTypeDecl complexType, String refName) {
        String baseTypeName = complexType.getBaseType().getName();
        if (baseTypeName != null && !baseTypeName.equals("anyType")) {
            refName = SchemaNodeImpl.createQName(complexType.getBaseType().getNamespace(), baseTypeName);
        }
        return refName;
    }

    private void initLocalRef(XSAttributeDecl attributeDecl) {
        XSSimpleTypeDecl simpleDefinition = (XSSimpleTypeDecl)attributeDecl.getTypeDefinition();
        this.analyseRef(simpleDefinition, attributeDecl.getName());
    }

    private String evaluateRefName(XSComplexTypeDecl complexType, String name) {
        String refName = null;
        refName = complexType.getAnonymous() ? this.evalAnonymousRefName(complexType, refName) : ("anyType".equals(complexType.getTypeName()) ? SchemaNodeImpl.createQName(complexType.getNamespace(), name) : SchemaNodeImpl.createQName(complexType.getNamespace(), complexType.getTypeName()));
        return refName;
    }

    private void initLocalRef(XSElementDecl element) {
        XSTypeDefinition typeDefinition = element.getTypeDefinition();
        if (typeDefinition.getTypeCategory() == 15) {
            XSComplexTypeDecl complexType = (XSComplexTypeDecl)typeDefinition;
            String name = this.getName();
            String refName = null;
            refName = element.getScope() == 1 ? SchemaNodeImpl.createQName(this.getNamespace(), name) : this.evaluateRefName(complexType, name);
            if (refName != null) {
                this.applyReference(refName);
            }
        } else {
            String name = SchemaNodeImpl.createQName(this.getNamespace(), element.getName());
            if (element.getScope() == 1) {
                SchemaNode globalNode = this._schema.getGlobalEntity(this.getNode().getType(), name);
                this.setRefName(globalNode, name);
            }
            this.analyseRef((XSSimpleTypeDecl)typeDefinition, name);
        }
    }

    private void initLocalRef(XSModelGroupImpl modelGroupImpl) {
        if (this._groupRefName != null) {
            this.applyReference(this._groupRefName);
        }
    }

    private void initLocalRef(XSObject node) {
        switch (node.getType()) {
            case 1: {
                this.initLocalRef((XSAttributeDecl)node);
                break;
            }
            case 2: {
                this.initLocalRef((XSElementDecl)node);
                break;
            }
            case 7: {
                this.initLocalRef((XSModelGroupImpl)node);
                break;
            }
        }
    }

    private void analyseRef(XSSimpleTypeDecl typeDefinition, String name) {
        if (typeDefinition.getAnonymous()) {
            SchemaNode globalNode = null;
            String refName = null;
            if (typeDefinition.getBaseType() != null) {
                refName = SchemaNodeImpl.createQName(typeDefinition.getBaseType().getNamespace(), typeDefinition.getBaseType().getName());
                globalNode = this._schema.getGlobalEntity(this.getNode().getType(), refName);
                if (globalNode != null) {
                    this.setRefName(globalNode, refName);
                }
            }
        } else if (typeDefinition.getName() != null) {
            String refName = SchemaNodeImpl.createQName(typeDefinition.getNamespace(), typeDefinition.getName());
            this.applyReference(refName);
        }
    }

    private void setRefName(SchemaNode globalNode, String name) {
        this._refName = name;
        if (globalNode.isGlobalType()) {
            this.setReferenceToGlobalType(true);
        } else {
            this.setReferenceToGlobalElement(true);
        }
    }

    private void initTargetNS(XSObject node) {
        this._targetNS = node.getNamespace();
    }

    public SchemaNode getRoot() {
        SchemaNode found;
        for (found = this; found != null; found = found.getParent()) {
            if (found.getParent() != null) continue;
            return found;
        }
        return found;
    }

    public String getXPath() {
        if (this._xpath == null) {
            Vector<SchemaNodeImpl> names = new Vector<SchemaNodeImpl>();
            if (this.getParent() == null) {
                this._xpath = "/" + this.getName();
            } else {
                StringBuffer sb = new StringBuffer();
                for (SchemaNode found = this; found != null; found = found.getParent()) {
                    names.add((SchemaNodeImpl)found);
                }
                for (int i = names.size() - 1; i >= 0; --i) {
                    sb.append("/");
                    sb.append(((SchemaNode)names.get(i)).getName());
                }
                this._xpath = sb.toString();
            }
        }
        return this._xpath;
    }

    public String getXPath(SchemaNode root) {
        if (this._xpath == null) {
            Vector<SchemaNodeImpl> names = new Vector<SchemaNodeImpl>();
            if (this.getParent() == null) {
                this._xpath = ".";
            } else {
                StringBuffer sb = new StringBuffer();
                for (SchemaNode found = this; found != null && found.getSchemaType() != root.getSchemaType(); found = found.getParent()) {
                    if (found.getParent() == null) continue;
                    names.add((SchemaNodeImpl)found);
                }
                for (int i = names.size() - 1; i >= 0; --i) {
                    if (i == names.size() - 1) {
                        sb.append("./");
                    } else {
                        sb.append("/");
                    }
                    sb.append(((SchemaNode)names.get(i)).getName());
                }
                this._xpath = sb.toString();
            }
        }
        return this._xpath;
    }

    public boolean isAnonymous() {
        return this._isAnonymous;
    }

    public boolean isChoice() {
        return this.getSchemaType().isChoice();
    }

    public boolean isGlobalReference() {
        return this.isReferenceToGlobalType() || this.isReferenceToGlobalElement() || this.isReferenceToGlobalGroup();
    }

    public boolean isGroup() {
        return this.getSchemaType().isGroup();
    }

    public boolean isRequired() {
        return this.getMinOccurs() != 0;
    }

    public boolean isSimple() {
        return this.getSchemaType().isSimple();
    }

    public XSObject getNode() {
        return this._node;
    }

    public void release() {
        this._node = null;
        this._minOccurs = -2;
        this._maxOccurs = -2;
        if (this._type != null) {
            this._type.release();
            this._type = null;
        }
        this._schema = null;
    }

    public void setSchemaType(SchemaType type) {
        this._type = type;
    }

    public String toString() {
        return this.getClass().getName() + "\n" + "Name   : " + this.getQName() + "\n" + "Type   : " + this.getSchemaType() + "\n" + "$ this : " + this.hashCode() + "\"n" + "$ type : " + this.getSchemaType().hashCode();
    }

    public void markAsOptional() {
        this._minOccurs = 0;
    }

    public SchemaNode getSubElement(String name) {
        if (!this.getSchemaType().isSimple()) {
            SchemaComplexType schemaType = (SchemaComplexType)this.getSchemaType();
            SchemaNode[] subElements = schemaType.getElementSet();
            for (int i = 0; i < subElements.length; ++i) {
                if (!subElements[i].getName().equals(name)) continue;
                return subElements[i];
            }
        }
        return null;
    }

    public boolean isGlobal() {
        return this._isGlobal;
    }

    public Hashtable getAnnotation() {
        return this._annotation;
    }

    public SchemaNode getParent() {
        return this._parent;
    }

    public String getLocation() {
        if (this._location == null) {
            this.initializeLocation();
        }
        return this._location;
    }

    private void initializeLocation() {
        StringBuffer xpath = new StringBuffer();
        this.getLocation(xpath, 0);
        this._location = xpath.toString();
    }

    private void getLocation(StringBuffer xpath, int level) {
        SchemaNode parent = this.getParent();
        if (parent != null) {
            ((SchemaNodeImpl)parent).getLocation(xpath, ++level);
            String name = this.getName();
            xpath.append("/");
            xpath.append(name);
            if (level == 1 && this.isList()) {
                xpath.append("[list]");
            }
        } else {
            xpath.append("/");
            String name = this.getName();
            xpath.append(name);
        }
    }

    public void setName(String name) {
        this._qName = name;
    }

    private boolean isList() {
        return this.getMaxOccurs() == -1 || this.getMaxOccurs() > 1;
    }

    public ArrayList getSchemaKeyRefs() {
        return this._keyRefNames;
    }

    public Hashtable getSchemaKeys() {
        return this._keyNames;
    }

    public boolean hasSchemaKeys() {
        return this._keyNames != null && this._keyNames.size() > 0;
    }

    public void putSchemaKey(SchemaNode selectorNode, SchemaKey schemakey) {
        if (this._keyNames == null) {
            this._keyNames = new Hashtable(1);
        }
        KeyDefinition def = new KeyDefinition(selectorNode, schemakey);
        this._keyNames.put(schemakey.getName(), def);
    }

    public boolean hasSchemaKeyRefs() {
        return this._keyRefNames != null && this._keyRefNames.size() > 0;
    }

    public void putSchemaKeyRef(SchemaNode selectorKeyRefNode, SchemaKeyRef schemakey) {
        if (this._keyRefNames == null) {
            this._keyRefNames = new ArrayList(1);
        }
        KeyRefDefinition def = new KeyRefDefinition(selectorKeyRefNode, schemakey);
        this._keyRefNames.add(def);
    }

    public SchemaNode[] getElementSet() {
        if (this.getSchemaType().isSimple()) {
            return null;
        }
        return ((SchemaComplexType)this.getSchemaType()).getElementSet();
    }

    public String getNamespace() {
        return this.getTargetNS();
    }

    public static String createQName(String nameSpace, String name) {
        return SchemaComplexTypeImpl.createQName(nameSpace, name);
    }

    public boolean isReferenceToGlobalType() {
        return this._isTypeReference;
    }

    public boolean isReferenceToGlobalGroup() {
        return this._isGroupReference;
    }

    public boolean isReferenceToGlobalElement() {
        return this._isElementReference;
    }

    private void setReferenceToGlobalType(boolean typeRef) {
        this._isTypeReference = typeRef;
    }

    private void setReferenceToGlobalElement(boolean elementRef) {
        this._isElementReference = elementRef;
    }

    public void setGroupRefName(String groupRefName) {
        this._isGroupReference = true;
        this._groupRefName = groupRefName;
        this._refName = groupRefName;
    }

    public boolean hasUnnamedOptionalParent() {
        return this._hasUnnamedOptionalParent;
    }

    public void markAsUnnamedOptionalParent() {
        this._hasUnnamedOptionalParent = true;
    }

    public void setAnonymousGroupIndex(int anonymousGroupIndex) {
        this._anonymousGroupIndex = anonymousGroupIndex;
    }

    public boolean hasExtension() {
        if (this._hasExtension == -1) {
            boolean hasExtension = false;
            if (this.isGlobalType()) {
                XSTypeDefinition type = null;
                switch (this._node.getType()) {
                    case 2: {
                        XSElementDeclaration element = (XSElementDeclaration)this._node;
                        type = element.getTypeDefinition();
                        break;
                    }
                    case 3: {
                        type = (XSTypeDefinition)this._node;
                    }
                }
                if (type != null && type.getTypeCategory() == 15) {
                    XSComplexTypeDefinition complex = (XSComplexTypeDefinition)type;
                    hasExtension = this.isReferenceToGlobalType() && complex.getBaseType() != null && (complex.getDerivationMethod() == 1 || complex.getDerivationMethod() == 2) ? !complex.getAnonymous() : true;
                }
            } else if ((this.isReferenceToGlobalElement() || this.isReferenceToGlobalType() || this.isReferenceToGlobalGroup()) && this.getRefName() != null) {
                if (this._groupRefName != null) {
                    hasExtension = true;
                } else {
                    XSTypeDefinition type = null;
                    switch (this._node.getType()) {
                        case 2: {
                            XSElementDeclaration element = (XSElementDeclaration)this._node;
                            type = element.getTypeDefinition();
                            break;
                        }
                        case 3: {
                            type = (XSTypeDefinition)this._node;
                        }
                    }
                    if (type != null && type.getTypeCategory() == 15) {
                        XSComplexTypeDefinition complex = (XSComplexTypeDefinition)type;
                        hasExtension = this.isReferenceToGlobalType() && complex.getBaseType() != null && (complex.getDerivationMethod() == 1 || complex.getDerivationMethod() == 2) ? !complex.getAnonymous() : true;
                    }
                }
            }
            this._hasExtension = hasExtension ? (byte)1 : 0;
        }
        return this._hasExtension == 1;
    }

    public boolean isReferenceWithNoExtension() {
        if (this._isRefWithNoExtension == -1) {
            boolean usesNoEnhancedInheritance = false;
            if ((this.isReferenceToGlobalElement() || this.isReferenceToGlobalType() || this.isReferenceToGlobalGroup()) && this.getRefName() != null) {
                if (this._groupRefName != null) {
                    usesNoEnhancedInheritance = true;
                } else {
                    XSTypeDefinition type = null;
                    switch (this._node.getType()) {
                        case 2: {
                            XSElementDeclaration element = (XSElementDeclaration)this._node;
                            type = element.getTypeDefinition();
                            break;
                        }
                        case 3: {
                            type = (XSTypeDefinition)this._node;
                        }
                    }
                    if (type != null && type.getTypeCategory() == 15) {
                        XSComplexTypeDefinition complex = (XSComplexTypeDefinition)type;
                        usesNoEnhancedInheritance = this.isReferenceToGlobalType() && complex.getBaseType() != null && (complex.getDerivationMethod() == 1 || complex.getDerivationMethod() == 2) ? !complex.getAnonymous() : true;
                    }
                }
            }
            this._isRefWithNoExtension = usesNoEnhancedInheritance ? (byte)1 : 0;
        }
        return this._isRefWithNoExtension == 1;
    }

    public int getAnonymousGroupIndex() {
        return this._anonymousGroupIndex;
    }

    public boolean isGlobalType() {
        return this._globalTypeType == 3;
    }

    public boolean isGlobalElement() {
        return this._globalTypeType == 2;
    }

    public boolean isGlobalAttribute() {
        return this._globalTypeType == 1;
    }

    public boolean isGlobalAttributeGroup() {
        return this._globalTypeType == 5;
    }

    public boolean isGlobalGroup() {
        return this._globalTypeType == 7;
    }
}

