/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.schema.impl;

import com.jaxfront.core.dom.CodeTables;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.SchemaComplexType;
import com.jaxfront.core.schema.SchemaCreationException;
import com.jaxfront.core.schema.SchemaKey;
import com.jaxfront.core.schema.SchemaKeyRef;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.SchemaType;
import com.jaxfront.core.schema.XMLSchema;
import com.jaxfront.core.schema.impl.KeyContainer;
import com.jaxfront.core.schema.impl.SchemaNodeImpl;
import com.jaxfront.core.schema.impl.TreeWalkingElementAnalyser;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.ComplexGroup;
import com.jaxfront.core.type.ComplexGroupList;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleGroupList;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.SimpleTypeList;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.xpath.schema.SchemaXPathExecuterImpl;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.w3c.dom.ls.LSInput;

public class XMLSchemaImpl
implements XMLSchema {
    private static Map GLOBAL_XSD_INTERNALENTITIES;
    private XSModel _schema;
    private String _rootName;
    private String _rootNS;
    private SchemaNode _schemaRoot;
    private Hashtable _keys;
    private Hashtable _editingTypes;
    private Hashtable _keyRefs;
    private Hashtable _schemaRootNodeAttributes;
    private Vector _badInitializedCodetables;
    private URL _schemaURL;
    private LSInput _schemaInput;
    private InputStream _schemaIS;
    private static CodeTables _codeTables;
    private Hashtable _globalEntities;
    private Hashtable _derivedTypes;
    private Hashtable _derivedTypeNames;
    private Hashtable _recursiveElements;
    private Map _edTypeCache;
    private String _defaultRootName;
    private Hashtable _namespaceMapping;
    private boolean _ignoreNameSpace = JAXFrontProperties.getInstance().ignoreNamespace();
    private boolean _isXUISchema = false;
    private String _defaultNameSpace;
    private String _targetNameSpace;
    private boolean _keepInMemory;
    private Document _scDom;
    private boolean _synced;
    static /* synthetic */ Class class$com$jaxfront$core$schema$SchemaNode;

    public XMLSchemaImpl(XSModel schema, URL schemaURL, String rootName, Hashtable namespaceMapping, Hashtable schemaRootNodeAttributes) {
        this._schema = schema;
        this._schemaURL = schemaURL;
        this._namespaceMapping = namespaceMapping;
        this._schemaRootNodeAttributes = schemaRootNodeAttributes;
        this.setRootName(rootName);
    }

    public XMLSchemaImpl(XSModel schema, LSInput schemaInput, String rootName, Hashtable namespaceMapping, Hashtable schemaRootNodeAttributes) {
        this._schema = schema;
        this._schemaInput = schemaInput;
        this._namespaceMapping = namespaceMapping;
        this._schemaRootNodeAttributes = schemaRootNodeAttributes;
        this.setRootName(rootName);
    }

    public Map getSchemaRootNodeAttributes() {
        if (this._schemaRootNodeAttributes == null) {
            this._schemaRootNodeAttributes = new Hashtable();
        }
        return this._schemaRootNodeAttributes;
    }

    public Type buildType(SchemaNode element) {
        if (element.isSimple()) {
            return this.createSimpleType(element);
        }
        return this.buildType(element, new TreeWalkingElementAnalyser(element), true);
    }

    public Type buildType(SchemaNode element, TreeWalkingElementAnalyser analyser) {
        if (element.isSimple()) {
            return this.createSimpleType(element);
        }
        TreeWalkingElementAnalyser newAnalyser = new TreeWalkingElementAnalyser(element);
        newAnalyser.getCallStack().addAll(analyser.getCallStack());
        return this.buildType(element, newAnalyser, true);
    }

    private Type buildType(SchemaNode element, TreeWalkingElementAnalyser analyser, boolean handleRecursion) {
        Type smartType = null;
        SchemaComplexType complexType = (SchemaComplexType)element.getSchemaType();
        if (analyser.isAnalysingGlobalType()) {
            analyser.addCurrentTypeToResolve(element);
        }
        SchemaNode[] childElements = complexType.getElementSet();
        int[] recursiveIndex = new int[]{};
        Object[] recursiveStartElements = new SchemaNode[]{};
        if (complexType.getAttributeSet() != null && complexType.getAttributeSet().length > 0 || childElements != null && childElements.length > 0) {
            int i;
            analyser.setContext(element);
            analyser.increaseLevel();
            Vector attribs = analyser.analyseAttributes();
            if (attribs != null && attribs.size() > 0) {
                analyser.increaseCounter();
            }
            for (int childIndex = 0; childElements != null && childIndex < childElements.length; ++childIndex) {
                SchemaNode child = childElements[childIndex];
                if (!child.getSchemaType().isSimple()) {
                    boolean containsType = analyser.containsCurrentTypeToResolve(child);
                    if (!containsType && element.isGlobal()) {
                        containsType = analyser.getCallStack().contains(element);
                    }
                    if (!handleRecursion) {
                        containsType = false;
                    }
                    if (!containsType) {
                        if (element.isGlobal()) {
                            analyser.getCallStack().add(element);
                        }
                        if (child.isReferenceWithNoExtension()) {
                            if (!child.getSchemaType().hasBeenAnalysed()) {
                                this.initializeGlobalType(child, analyser);
                            }
                            smartType = this.createTypeCopy(analyser, child);
                        } else {
                            if (child.getRefName() != null && !analyser.isAnalysingGlobalType()) {
                                handleRecursion = false;
                            }
                            smartType = this.buildType(child, analyser, handleRecursion);
                        }
                        if (element.isGlobal()) {
                            analyser.getCallStack().pop();
                        }
                    } else if (child.getRefName() != null) {
                        recursiveIndex = ArrayUtil.addToArray(recursiveIndex, childIndex);
                        recursiveStartElements = (SchemaNode[])ArrayUtil.addToArray(class$com$jaxfront$core$schema$SchemaNode == null ? XMLSchemaImpl.class$("com.jaxfront.core.schema.SchemaNode") : class$com$jaxfront$core$schema$SchemaNode, recursiveStartElements, child);
                        child.getSchemaType().setRecursive(true);
                        analyser.setContext(child);
                        analyser.analyse(true);
                        analyser.setContext(element);
                    }
                } else {
                    AbstractType simpleType;
                    if (child.getRefName() != null) {
                        if (!child.getSchemaType().hasBeenAnalysed()) {
                            this.initializeGlobalType(child, analyser);
                        }
                        if (child.getSchemaType().getType() == null) {
                            child.getSchemaType().setType(new SimpleType(child));
                        }
                        Type simpleType2 = this.createTypeCopy(analyser, child);
                        if (child.getMaxOccurs() > 1 || child.getMaxOccurs() == -1) {
                            simpleType2 = new SimpleTypeList(child, simpleType2);
                        }
                    }
                    if (child.getMaxOccurs() > 1 || child.getMaxOccurs() == -1) {
                        SimpleType edType = new SimpleType(child);
                        simpleType = new SimpleTypeList(child, edType);
                    } else {
                        simpleType = new SimpleType(child);
                    }
                    simpleType.setId(analyser.getCurrentId());
                    analyser.put(child, simpleType);
                    smartType = simpleType;
                    if (child.getSchemaType().isGlobal()) {
                        if (child.getSchemaType().getType() == null) {
                            child.getSchemaType().setType(simpleType);
                        }
                    } else {
                        child.getSchemaType().setType(simpleType);
                    }
                }
                analyser.increaseCounter();
            }
            analyser.decreaseLevel();
            analyser.setContext(element);
            smartType = analyser.analyse(recursiveStartElements != null && recursiveStartElements.length > 0);
            if (recursiveStartElements != null && LogRegistry.getInstance().logWarnings()) {
                for (i = 0; i < recursiveStartElements.length; ++i) {
                    LogRegistry.getInstance().warn(this.getClass(), recursiveStartElements[i].getQName() + " has Recursion");
                }
            }
            if (handleRecursion && recursiveStartElements != null) {
                for (i = 0; i < recursiveStartElements.length; ++i) {
                    this.handleRecursiveElement(smartType, element.getSchemaType().getType(), recursiveIndex[i], recursiveStartElements[i]);
                }
            }
        } else {
            analyser.setContext(element);
            smartType = analyser.analyse();
        }
        analyser.removeCurrentTypeToResolve(element);
        return smartType;
    }

    private Type createSimpleType(SchemaNode element) {
        AbstractType type;
        if (element.getMaxOccurs() == 0 || element.getMaxOccurs() == 1) {
            type = new SimpleType(element);
        } else {
            SimpleType edType = new SimpleType(element);
            type = new SimpleTypeList(element, edType);
        }
        return type;
    }

    public String getNamespacePrefix(String nsURI) {
        if (this.getNamespaceMapping() != null && nsURI != null) {
            return (String)this.getNamespaceMapping().get(nsURI);
        }
        return null;
    }

    private void buildTypes() {
        SchemaNode rootElement;
        String file = "no file found";
        if (this._schemaURL != null) {
            file = this._schemaURL.getFile();
        }
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(this.getClass(), "*** (analysing XML-Schema: " + file + ") *** START ***");
        }
        if ((rootElement = this.getRootElement()) != null) {
            Type smartType;
            SchemaType rootType = rootElement.getSchemaType();
            if (!rootType.isSimple()) {
                TreeWalkingElementAnalyser analyser = new TreeWalkingElementAnalyser(rootElement);
                analyser.setIsAnalysingGlobalType(true);
                smartType = this.buildType(rootElement, analyser, true);
            } else {
                smartType = this.createSimpleType(rootElement);
            }
            if (this.getRecursiveElements().size() > 0) {
                this.handleRecursiveElements();
            }
            rootElement.getSchemaType().setType(smartType);
            this.handleKeys();
            this.handleKeysRefs();
        }
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(this.getClass(), "*** (analysing XML-Schema: " + file + ") *** END ***");
        }
    }

    public Document createDocument() {
        return this.createDocument(null);
    }

    public Document createDocument(Hashtable params) {
        Document dom = new Document(this, this.getRootElement().getSchemaType().getType(), params);
        return dom;
    }

    private Type createTypeCopy(TreeWalkingElementAnalyser analyser, SchemaNode element) {
        Type copy = null;
        try {
            Type typeToCopy = element.getSchemaType().getType();
            if (typeToCopy == null) {
                Type analysedType = element.getSchema().getType(element, analyser);
                element.getSchemaType().setType(analysedType);
                typeToCopy = analysedType;
            }
            copy = typeToCopy.deepClone(null, analyser != null, false, false, element, null);
            copy.setSchemaElement(element);
            if (element.getMaxOccurs() > 1 || element.getMaxOccurs() == -1) {
                if (typeToCopy.isSimple()) {
                    copy = new SimpleTypeList(element, copy);
                } else if (typeToCopy.getTypeClassification() == 65) {
                    if (((CompositeType)typeToCopy).hasOnlySimpleTypes()) {
                        copy = new SimpleGroupList(element, copy);
                    } else {
                        copy = new ComplexGroup(element, copy.getDirectChildren());
                        copy = new ComplexGroupList(element, copy);
                    }
                } else if (typeToCopy.getTypeClassification() == 66) {
                    copy = new ComplexGroupList(element, copy);
                }
            }
            if (analyser != null) {
                copy.setId(analyser.getCurrentId());
                analyser.put(element, copy);
            }
        }
        catch (CloneNotSupportedException ex) {
            // empty catch block
        }
        return copy;
    }

    public Type createTypeCopy(SchemaNode element) {
        return this.createTypeCopy(null, element);
    }

    public CodeTables getCodeTables() {
        if (_codeTables == null) {
            _codeTables = new CodeTables(this);
        }
        return _codeTables;
    }

    public static void releaseCodeTables() {
        if (_codeTables != null) {
            _codeTables.release();
            _codeTables = null;
        }
    }

    public static CodeTables getCodes() {
        return _codeTables;
    }

    public CodeTables getCodeTables(XMLSchema schema, String url, URL xuiURL, XMLEntityResolver resolver) {
        boolean hasBeenLoaded;
        if (url == null) {
            url = "default";
        }
        if (!(hasBeenLoaded = this.getCodeTables().initialize(schema, url, xuiURL, resolver))) {
            this.getBadInitializedCodeTables().add(url);
        }
        if (this.getBadInitializedCodeTables().contains(url)) {
            return null;
        }
        return this.getCodeTables();
    }

    private Vector getBadInitializedCodeTables() {
        if (this._badInitializedCodetables == null) {
            this._badInitializedCodetables = new Vector();
        }
        return this._badInitializedCodetables;
    }

    private Hashtable getDerivedTypes() {
        if (this._derivedTypes == null) {
            this._derivedTypes = new Hashtable();
        }
        return this._derivedTypes;
    }

    private Hashtable getDerivedTypeNames() {
        if (this._derivedTypeNames == null) {
            this._derivedTypeNames = new Hashtable();
        }
        return this._derivedTypeNames;
    }

    public Set getDerivedTypes(String abstractName, String name) {
        LinkedHashSet set = new LinkedHashSet();
        this.getDerivedTypes(abstractName, name, set);
        this.getDerivedTypes().put(abstractName, set);
        return set;
    }

    public String[] getDerivedTypeNames(String abstractName) {
        String[] names = (String[])this.getDerivedTypeNames().get(abstractName);
        if (names != null) {
            return names;
        }
        LinkedHashSet temp = new LinkedHashSet();
        this.initializeDerivedTypeNames(abstractName, temp);
        names = new String[temp.size()];
        temp.toArray(names);
        this.getDerivedTypeNames().put(abstractName, names);
        return names;
    }

    private Set initializeDerivedTypeNames(String abstractName, Set derivedTypeNames) {
        int index;
        Collection values = this.getGlobalEntities().values();
        Iterator iterator = values.iterator();
        LinkedHashSet<String> localDerivates = new LinkedHashSet<String>();
        if (abstractName != null && (index = abstractName.indexOf(":")) != -1) {
            abstractName = abstractName.substring(index + 1, abstractName.length());
        }
        while (iterator.hasNext()) {
            SchemaNode element = (SchemaNode)iterator.next();
            String baseName = element.getSchemaType().getBaseName();
            if (baseName == null || !baseName.equals(abstractName)) continue;
            Type derivedType = this.getType(element);
            if (derivedType.isAbstract()) {
                this.initializeDerivedTypeNames(derivedType.getName(), derivedTypeNames);
                continue;
            }
            localDerivates.add(derivedType.getName());
        }
        derivedTypeNames.addAll(localDerivates);
        return localDerivates;
    }

    public Set getDerivedTypes(String abstractName, String name, Set derivedTypes) {
        Set cachedSet;
        int index;
        if (abstractName != null && (index = abstractName.indexOf(":")) != -1) {
            abstractName = abstractName.substring(index + 1, abstractName.length());
        }
        if ((cachedSet = (Set)this.getDerivedTypes().get(abstractName)) != null) {
            derivedTypes.addAll(cachedSet);
            return cachedSet;
        }
        Collection values = this.getGlobalEntities().values();
        Iterator iterator = values.iterator();
        LinkedHashSet<Type> localDerivates = new LinkedHashSet<Type>();
        while (iterator.hasNext()) {
            SchemaNode element = (SchemaNode)iterator.next();
            String baseName = element.getSchemaType().getBaseName();
            if (baseName == null || !baseName.equals(abstractName)) continue;
            Type derivedType = this.getType(element);
            if (derivedType.isAbstract()) {
                Set subSet = this.getDerivedTypes(derivedType.getName(), name, derivedTypes);
                continue;
            }
            localDerivates.add(derivedType);
        }
        derivedTypes.addAll(localDerivates);
        return localDerivates;
    }

    public Map getGlobalEntities() {
        if (this._globalEntities == null) {
            this.initializeGlobalEntities();
        }
        return this._globalEntities;
    }

    public SchemaNode getGlobalEntity(short type, String name) {
        return (SchemaNode)this.getGlobalEntities().get(name);
    }

    public SchemaKey getKey(String keyName) {
        return (SchemaKey)this.getKeys().get(keyName);
    }

    public SchemaKeyRef getKeyRef(String keyName) {
        return (SchemaKeyRef)this.getKeyRefs().get(keyName);
    }

    private Hashtable getKeyRefs() {
        if (this._keyRefs == null) {
            this._keyRefs = new Hashtable();
        }
        return this._keyRefs;
    }

    private Hashtable getKeys() {
        if (this._keys == null) {
            this._keys = new Hashtable();
        }
        return this._keys;
    }

    private Hashtable getRecursiveElements() {
        if (this._recursiveElements == null) {
            this._recursiveElements = new Hashtable();
        }
        return this._recursiveElements;
    }

    public Map getEditingTypeCache() {
        if (this._edTypeCache == null) {
            this._edTypeCache = new Hashtable();
        }
        return this._edTypeCache;
    }

    public void putEditingTypeCache(Type edType) {
        this.getEditingTypeCache().put(((AbstractType)edType).getAbsoluteXPathLocation(), edType);
    }

    private int getRecursiveIndex(CompositeType holder, SchemaNode startElement) {
        SchemaComplexType complexType = (SchemaComplexType)holder.getSchemaElement().getSchemaType();
        SchemaNode[] elements = complexType.getElementSet();
        String startElementName = startElement.getQName();
        int index = -99;
        for (int i = 0; i < elements.length && index == -99; ++i) {
            if (!elements[i].getQName().equals(startElementName)) continue;
            index = holder.isAnonymous() ? i + ((SchemaComplexType)holder.getParent().getSchemaElement().getSchemaType()).getAttributeSet().length : i + complexType.getAttributeSet().length;
        }
        return index;
    }

    public SchemaNode getRootElement() {
        return this._schemaRoot;
    }

    public String getRootName() {
        if (this._schemaURL != null && this._schemaURL.getFile().endsWith(JAXFrontProperties.getInstance().getXUIXsdName())) {
            this._rootName = "XUI";
        }
        if (this._rootName == null) {
            this._rootName = this._defaultRootName;
        }
        return this._rootName;
    }

    public Type getRootType() {
        return this.getRootElement().getSchemaType().getType();
    }

    public String getTargetNamespace() {
        if (this._targetNameSpace == null) {
            StringList nas;
            this._targetNameSpace = this._schema != null ? ((nas = this._schema.getNamespaces()) != null && nas.getLength() > 0 ? nas.item(0) : "") : "";
        }
        return this._targetNameSpace;
    }

    public boolean isDefaultNamespace(String ns) {
        return this.getTargetNamespace() != null && this.getTargetNamespace().equals(ns);
    }

    public String getDefaultNamespace() {
        if (this._defaultNameSpace == null) {
            String defaultNameSpace = (String)this.getSchemaRootNodeAttributes().get(DOMHelper.XMLNS);
            if (defaultNameSpace == null) {
                defaultNameSpace = "";
            }
            this._defaultNameSpace = defaultNameSpace;
        }
        return this._defaultNameSpace;
    }

    public URL getURL() {
        return this._schemaURL;
    }

    public String getLocationPath() {
        String locationPath = null;
        if (this.getURL() != null) {
            locationPath = this.getURL().getPath();
            int lastIndex = locationPath.lastIndexOf("/") + 1;
            if (locationPath.length() > lastIndex) {
                locationPath = locationPath.substring(0, lastIndex);
            }
        }
        return locationPath;
    }

    private void handleKeysRefs() {
        Enumeration keysEnum = this.getKeyRefs().keys();
        while (keysEnum.hasMoreElements()) {
            SchemaKeyRef keyRef = this.getKeyRef((String)keysEnum.nextElement());
            try {
                SchemaNode keyBaseSNode = keyRef.getSchemaElement();
                String selectorXPath = keyRef.getSelectorXPath();
                String[] fields = keyRef.getFields();
                List resultKeys = SchemaXPathExecuterImpl.getInstance().processXPath(selectorXPath, null, keyBaseSNode, true);
                if (LogRegistry.getInstance().logInfos()) {
                    LogRegistry.getInstance().info(this.getClass(), "search selectors for key ref:" + keyRef.getKeyName());
                }
                if (resultKeys != null) {
                    for (int i = 0; i < resultKeys.size(); ++i) {
                        SchemaNode selectorKeyNode = (SchemaNode)resultKeys.get(i);
                        for (int f = 0; f < fields.length; ++f) {
                            List resultTNodes = SchemaXPathExecuterImpl.getInstance().processXPath(fields[f], null, selectorKeyNode, true);
                            if (resultTNodes.size() <= 0) {
                                if (!LogRegistry.getInstance().logWarnings()) continue;
                                LogRegistry.getInstance().warn(this.getClass(), "defined reference not found for:" + keyRef.getName() + " selector:" + selectorXPath);
                                continue;
                            }
                            for (int a = 0; a < resultTNodes.size(); ++a) {
                                SchemaNode kfNode = (SchemaNode)resultTNodes.get(a);
                                kfNode.putSchemaKeyRef(selectorKeyNode, keyRef);
                                keyRef.addSelector(kfNode);
                            }
                        }
                    }
                    continue;
                }
                if (!LogRegistry.getInstance().logErrors()) continue;
                LogRegistry.getInstance().error(this.getClass(), "can't find keyrefs  for:" + selectorXPath + " on basenode:" + keyBaseSNode.getName());
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleKeys() {
        Enumeration keysEnum = this.getKeys().keys();
        while (keysEnum.hasMoreElements()) {
            SchemaKey key = this.getKey((String)keysEnum.nextElement());
            String keyName = key.getName();
            if (LogRegistry.getInstance().logInfos()) {
                LogRegistry.getInstance().info(this.getClass(), "search selectors for key :" + keyName);
            }
            try {
                SchemaNode keyBaseSNode = key.getSchemaElement();
                String selectorXPath = key.getSelectorXPath();
                String[] fields = key.getFields();
                List resultKeys = SchemaXPathExecuterImpl.getInstance().processXPath(selectorXPath, null, keyBaseSNode, true);
                if (resultKeys != null) {
                    for (int i = 0; i < resultKeys.size(); ++i) {
                        SchemaNode selectorKeyNode = (SchemaNode)resultKeys.get(i);
                        if (LogRegistry.getInstance().logInfos()) {
                            LogRegistry.getInstance().info(this.getClass(), "selector node found:" + selectorKeyNode.getName());
                        }
                        for (int f = 0; f < fields.length; ++f) {
                            List resultTNodes = SchemaXPathExecuterImpl.getInstance().processXPath(fields[f], null, selectorKeyNode, true);
                            for (int a = 0; a < resultTNodes.size(); ++a) {
                                SchemaNode kfNode = (SchemaNode)resultTNodes.get(a);
                                kfNode.putSchemaKey(selectorKeyNode, key);
                                key.addSelector(kfNode);
                            }
                        }
                    }
                    continue;
                }
                if (!LogRegistry.getInstance().logErrors()) continue;
                LogRegistry.getInstance().error(this.getClass(), "can't find keys for:" + selectorXPath + " on basenode:" + keyBaseSNode.getName());
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
    }

    public void initializeXSDKeySystem(Document dom) {
        Iterator keys = this.getKeys().entrySet().iterator();
        while (keys.hasNext()) {
            Map.Entry element = keys.next();
            String keyName = (String)element.getKey();
            SchemaKey scNode = (SchemaKey)element.getValue();
            dom.getKeyKeyRefManager().addKeyContainer(keyName, KeyContainer._defaultContextWrapper, new KeyContainer(keyName, scNode, dom));
        }
    }

    private void handleRecursiveElement(Type smartType, Type currentAnalysingTpe, int recursiveIndex, SchemaNode recursiveStartElement) {
        Vector<SchemaNode> values = (Vector<SchemaNode>)this.getRecursiveElements().get(smartType);
        if (values == null) {
            values = new Vector<SchemaNode>();
        }
        values.add(recursiveStartElement);
        this.getRecursiveElements().put(smartType, values);
    }

    private void handleRecursiveElements() {
        Enumeration keys = this.getRecursiveElements().keys();
        while (keys.hasMoreElements()) {
            Type holder = (Type)keys.nextElement();
            Vector recursiveElements = (Vector)this.getRecursiveElements().get(holder);
            Iterator elements = recursiveElements.iterator();
            CompositeType compositeType = null;
            if (holder.isList()) {
                compositeType = (CompositeType)((ListType)holder).getEditingType();
            } else if (holder.isComposite()) {
                compositeType = (CompositeType)holder;
            }
            if (compositeType == null) continue;
            while (elements.hasNext()) {
                SchemaNode schemaElement = (SchemaNode)elements.next();
                compositeType.getSchemaElement().getSchemaType().addRecursiveElement(schemaElement);
            }
        }
        this._recursiveElements = null;
    }

    private void initializeGlobalEntities() {
        XSNamedMap globalElementMap;
        XSNamedMap globalAttributeGroupMap;
        XSNamedMap globalAttributeMap;
        XSNamedMap globalGroupMap;
        this._globalEntities = new Hashtable();
        Vector<XSObject> globalNodes = new Vector<XSObject>();
        boolean addXSDInternalTypes = false;
        XSNamedMap globalTypeMap = this._schema.getComponents((short)3);
        if (globalTypeMap.getLength() != 0) {
            for (int i = 0; i < globalTypeMap.getLength(); ++i) {
                XSObject item = globalTypeMap.item(i);
                globalNodes.add(item);
            }
        }
        if ((globalGroupMap = this._schema.getComponents((short)6)).getLength() != 0) {
            for (int i = 0; i < globalGroupMap.getLength(); ++i) {
                XSObject item = globalGroupMap.item(i);
                globalNodes.add(item);
            }
        }
        if ((globalAttributeMap = this._schema.getComponents((short)1)).getLength() != 0) {
            for (int i = 0; i < globalAttributeMap.getLength(); ++i) {
                XSObject item = globalAttributeMap.item(i);
                globalNodes.add(item);
            }
        }
        if ((globalAttributeGroupMap = this._schema.getComponents((short)5)).getLength() != 0) {
            for (int i = 0; i < globalAttributeGroupMap.getLength(); ++i) {
                XSObject item = globalAttributeGroupMap.item(i);
                globalNodes.add(item);
            }
        }
        if ((globalElementMap = this._schema.getComponents((short)2)).getLength() != 0) {
            for (int i = 0; i < globalElementMap.getLength(); ++i) {
                XSObject item = globalElementMap.item(i);
                globalNodes.add(item);
            }
        }
        Iterator<Object> iterator = globalNodes.iterator();
        while (iterator.hasNext()) {
            XSObject node = (XSObject)iterator.next();
            String name = node.getName();
            String nameSpace = null;
            if (!this._ignoreNameSpace && (nameSpace = node.getNamespace()) != null && nameSpace.length() > 0) {
                String string = name = nameSpace != null && nameSpace.length() > 0 ? nameSpace + ":" + name : name;
            }
            if (node.getNamespace() != null && "http://www.w3.org/2001/XMLSchema-instance".indexOf(node.getNamespace()) != -1) {
                if (GLOBAL_XSD_INTERNALENTITIES == null) {
                    GLOBAL_XSD_INTERNALENTITIES = new HashMap();
                    addXSDInternalTypes = true;
                }
                if (!addXSDInternalTypes) continue;
                GLOBAL_XSD_INTERNALENTITIES.put(node.getName(), node);
                continue;
            }
            SchemaNodeImpl element = new SchemaNodeImpl(node, (XMLSchema)this, -2, -2, null, true);
            this.putGlobalEntity(node, name, element);
        }
        iterator = this._globalEntities.values().iterator();
        while (iterator.hasNext()) {
            SchemaNodeImpl scNode = (SchemaNodeImpl)iterator.next();
            scNode.finalAnalyse();
        }
    }

    private void putGlobalEntity(XSObject node, String name, SchemaNodeImpl element) {
        this._globalEntities.put(name, element);
    }

    public String getGroupName(XSObject modelGroup) {
        Iterator globals = this.getGlobalEntities().values().iterator();
        Object name = null;
        SchemaNode schemaNode = null;
        XSObject global = null;
        while (globals.hasNext()) {
            schemaNode = (SchemaNode)globals.next();
            global = schemaNode.getNode();
            if (global.getType() != 6 || modelGroup != ((XSGroupDecl)global).getModelGroup()) continue;
            return global.getName();
        }
        return null;
    }

    public String getGroupQName(XSObject modelGroup) {
        Iterator globals = this.getGlobalEntities().values().iterator();
        String name = null;
        SchemaNode schemaNode = null;
        XSObject global = null;
        while (globals.hasNext()) {
            schemaNode = (SchemaNode)globals.next();
            global = schemaNode.getNode();
            if (global.getType() != 6 || modelGroup != ((XSGroupDecl)global).getModelGroup()) continue;
            name = global.getName();
            String nameSpace = global.getNamespace();
            if (nameSpace != null) {
                name = nameSpace + ":" + name;
            }
            return name;
        }
        return name;
    }

    private void initializeGlobalType(SchemaNode element, TreeWalkingElementAnalyser analyser) {
        SchemaNode globalElement = this.getGlobalEntity(element);
        if (globalElement != null) {
            Type globalType;
            if (globalElement.isSimple()) {
                globalType = new SimpleType(globalElement);
            } else {
                boolean wasAnalysingGlobalType = analyser.isAnalysingGlobalType();
                analyser.setIsAnalysingGlobalType(true);
                Vector currentTypesToResolve = analyser.getCurrentTypesToResolve();
                globalType = this.buildType(globalElement, analyser, true);
                analyser.setCurrentTypesToResolve(currentTypesToResolve);
                if (!wasAnalysingGlobalType) {
                    analyser.setIsAnalysingGlobalType(false);
                }
            }
            globalElement.getSchemaType().setType(globalType);
        }
    }

    private void initializeRootElement() {
        Iterator globalEntities = this.getGlobalEntities().values().iterator();
        SchemaNode found = null;
        while (found == null && globalEntities.hasNext()) {
            SchemaNode globalEntity = (SchemaNode)globalEntities.next();
            if (!globalEntity.getName().equals(this.getRootName())) continue;
            if (this._rootNS == null) {
                found = globalEntity;
                continue;
            }
            if (!StringUtil.equals(this._rootNS, globalEntity.getNamespace())) continue;
            found = globalEntity;
        }
        String location = null;
        if (this.getURL() != null) {
            location = this.getURL().toExternalForm();
        }
        if (found != null) {
            this._schemaRoot = found;
            if (this._schemaRoot.getSchemaType().getType() == null) {
                long start = System.currentTimeMillis();
                this.buildTypes();
                long stop = System.currentTimeMillis();
                if (LogRegistry.getInstance().logInfos()) {
                    LogRegistry.getInstance().info(this.getClass(), "Time needed to build _schemaroot:" + (stop - start) + " " + location);
                }
            }
        } else {
            String schemaFileName = "no name";
            if (this.getURL() != null) {
                schemaFileName = this.getURL().toExternalForm();
            }
            throw new SchemaCreationException("Specified root name (" + this._rootName + ") not found in schema file: " + schemaFileName);
        }
    }

    public boolean isXUISchema() {
        return this._isXUISchema;
    }

    public void setXUISchema(boolean isXUISchema) {
        this._isXUISchema = isXUISchema;
        if (isXUISchema) {
            this.setKeepInMemory(true);
        }
    }

    public boolean keepInMemory() {
        return this._keepInMemory;
    }

    public void setKeepInMemory(boolean keep) {
        this._keepInMemory = keep;
    }

    public void registerKey(String keyName, SchemaKey element) {
        this.getKeys().put(keyName, element);
    }

    public void registerKeyRef(String keyName, SchemaKeyRef element) {
        this.getKeyRefs().put(keyName, element);
    }

    public void release() {
        if (LogRegistry.getInstance().logLogs()) {
            LogRegistry.getInstance().log(this.getClass(), "START releasing schema (" + this.getURL() + ") resources...");
        }
        this._schema = null;
        if (this._schemaRoot != null) {
            this._schemaRoot = null;
        }
        if (this._schemaURL != null) {
            this._schemaURL = null;
        }
        if (this._edTypeCache != null) {
            this._edTypeCache = null;
        }
        if (_codeTables != null) {
            _codeTables.release();
        }
        if (this._keys != null) {
            this._keys.clear();
        }
        if (this._keyRefs != null) {
            this._keyRefs.clear();
        }
        if (this._schemaIS != null) {
            this._schemaIS = null;
        }
        if (this._globalEntities != null) {
            this.releaseGlobalEntities();
        }
        if (this._derivedTypes != null) {
            this._derivedTypes.clear();
        }
        if (this._recursiveElements != null) {
            this._recursiveElements.clear();
        }
        this.releaseGlobalXUIDefinitions();
        if (LogRegistry.getInstance().logLogs()) {
            LogRegistry.getInstance().log(this.getClass(), "END releasing schema (" + this.getURL() + ") resources...");
        }
    }

    private void releaseGlobalEntities() {
        Iterator iterator = this.getGlobalEntities().values().iterator();
        while (iterator.hasNext()) {
            SchemaNode element = (SchemaNode)iterator.next();
            element.release();
        }
        this.getGlobalEntities().clear();
        this._globalEntities = null;
    }

    public void setRootName(String rootName) {
        String rootNS = null;
        int nsIdx = -1;
        if (rootName != null && (nsIdx = rootName.lastIndexOf(":")) >= 0) {
            rootNS = rootName.substring(0, nsIdx);
            rootName = rootName.substring(nsIdx + 1);
        }
        this.setRootName(rootName, rootNS);
    }

    public void setRootName(String rootName, String rootNS) {
        Map globalElements;
        if ((rootName == null || rootName.trim().length() == 0) && (globalElements = this.getGlobalElements()).size() > 0) {
            String[] names = new String[globalElements.size()];
            Set keySet = globalElements.keySet();
            keySet.toArray(names);
            Iterator iterator = keySet.iterator();
            SchemaNode deepestElement = null;
            int noOfSubNodes = 0;
            while (iterator.hasNext()) {
                String globalName = (String)iterator.next();
                SchemaNode schemaElement = (SchemaNode)this.getGlobalElements().get(globalName);
                int currentSubNodes = schemaElement.getSchemaType().countSubNodes();
                if (LogRegistry.getInstance().logInfos()) {
                    LogRegistry.getInstance().info(this.getClass(), "No Of SubNodes (" + schemaElement.getQName() + "): " + currentSubNodes);
                }
                if (currentSubNodes < noOfSubNodes) continue;
                noOfSubNodes = currentSubNodes;
                deepestElement = schemaElement;
            }
            rootName = deepestElement.getName();
            rootNS = deepestElement.getNamespace();
        }
        this._rootName = rootName;
        if (rootName != null) {
            this._rootName = this._rootName.trim();
            if (this._rootName.length() == 0) {
                this._rootName = null;
            }
            this._rootNS = rootNS;
            this.initializeRootElement();
        }
    }

    public String toString() {
        String fileLocation = "";
        fileLocation = this._schemaURL != null ? this._schemaURL.toExternalForm() : "(no url)";
        return this.getClass().getName() + fileLocation;
    }

    public void releaseGlobalXUIDefinitions() {
        if (this._schema != null) {
            Iterator iterator = this.getGlobalEntities().values().iterator();
            while (iterator.hasNext()) {
                Type type;
                SchemaNode schemaElement = (SchemaNode)iterator.next();
                if (!schemaElement.hasType() || (type = schemaElement.getSchemaType().getType()) == null) continue;
                this.releaseGlobalXUIDefinitions(type);
            }
        }
    }

    private void releaseGlobalXUIDefinitions(Type globalType) {
        globalType.setUIDefinition(null);
        globalType.setDOM(null);
        List<Type> children = null;
        if (globalType.isList()) {
            children = new Vector<Type>();
            children.add(((ListType)globalType).getEditingType());
        } else if (globalType.isComposite()) {
            children = ((CompositeType)globalType).getComposites();
        }
        if (children != null) {
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                this.releaseGlobalXUIDefinitions((Type)iterator.next());
            }
        }
    }

    public Type getType(SchemaNode element) {
        SchemaType schemaType = element.getSchemaType();
        if (schemaType.getType() != null) {
            return schemaType.getType();
        }
        Type analysedType = this.buildType(element);
        schemaType.setType(analysedType);
        return analysedType;
    }

    public Type getType(SchemaNode element, TreeWalkingElementAnalyser analyser) {
        SchemaType schemaType = element.getSchemaType();
        if (schemaType.getType() != null) {
            return schemaType.getType();
        }
        Type analysedType = this.buildType(element, analyser);
        schemaType.setType(analysedType);
        return analysedType;
    }

    public void registerEditingType(Type edType) {
        if (this._editingTypes == null) {
            this._editingTypes = new Hashtable();
        }
        this._editingTypes.put(edType.getSchemaType(), edType);
    }

    public Type getEditingType(Type edType) {
        if (this._editingTypes == null) {
            this._editingTypes = new Hashtable();
        }
        return (Type)this._editingTypes.get(edType.getSchemaType());
    }

    public Map getGlobalElements() {
        Hashtable<String, SchemaNode> globalElements = new Hashtable<String, SchemaNode>();
        Iterator globalEntities = this.getGlobalEntities().values().iterator();
        while (globalEntities.hasNext()) {
            Object object = globalEntities.next();
            SchemaNode schemaElement = (SchemaNode)object;
            if (schemaElement.getNode().getType() != 2) continue;
            globalElements.put(schemaElement.getQName(), schemaElement);
        }
        return globalElements;
    }

    public StringList getNamespaceURIs() {
        return this._schema.getNamespaces();
    }

    public Vector getNamespaceDeclarations(String schemaLocation) {
        return this.getNamespaceDeclarations(schemaLocation, false);
    }

    public Vector getNamespaceDeclarations(String schemaLocation, boolean isXuiDom) {
        StringList uris = this.getNamespaceURIs();
        Vector<String> xmlNS = null;
        if (uris != null) {
            xmlNS = new Vector<String>();
            for (int a = 0; a < uris.getLength(); ++a) {
                String uri = uris.item(a);
                String xmlNSText = null;
                if (uri == null || uri.length() <= 0 || uri.equals("http://www.w3.org/2001/XMLSchema")) continue;
                String prefix = this.getNamespacePrefix(uri);
                if (prefix != null && prefix.length() > 0) {
                    if (prefix.startsWith("xsd")) continue;
                    xmlNSText = "xmlns:" + prefix + "=" + "\"" + uri + "\"";
                    xmlNS.add(xmlNSText);
                    continue;
                }
                xmlNSText = this.getRootType().getDOM()._enforcePrefixSerialization && isXuiDom ? "xmlns:" + prefix + "=" + "\"" + uri + "\"" : "xmlns=\"" + uri + "\"";
                xmlNS.add(xmlNSText);
            }
            String instanceNS = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
            xmlNS.add(instanceNS);
            String location = DOMHelper.extractSchemaLocation(this.getURL(), schemaLocation, this.getTargetNamespace());
            if (location != null) {
                xmlNS.add(location);
            }
        }
        return xmlNS;
    }

    public Hashtable getNamespaceMapping() {
        return this._namespaceMapping;
    }

    public void setBase(URL base) {
        this._schemaURL = base;
    }

    public boolean isGlobalEntity(short type, String name) {
        return this.getGlobalEntity(type, name) != null;
    }

    public SchemaNode getGlobalEntity(SchemaNode node) {
        XMLSchema schema = node.getSchema();
        if ((node.isReferenceToGlobalElement() || node.isReferenceToGlobalType() || node.isReferenceToGlobalGroup()) && schema != null) {
            if (node.getNode().getType() == 2) {
                XSElementDecl xsEleDec = (XSElementDecl)node.getNode();
                if (xsEleDec.getTypeDefinition().getTypeCategory() == 15) {
                    XSComplexTypeDecl xsdTypeDecl = (XSComplexTypeDecl)xsEleDec.getTypeDefinition();
                    String ns = xsdTypeDecl.getNamespace();
                    String name = null;
                    if (node.isReferenceToGlobalElement() || node.isReferenceToGlobalGroup()) {
                        name = node.getName();
                        return schema.getGlobalEntity(node.getNode().getType(), (ns == null ? "" : ns + ":") + name);
                    }
                    if (node.isReferenceToGlobalType()) {
                        name = xsdTypeDecl.getName();
                        return schema.getGlobalEntity(node.getNode().getType(), (ns == null ? "" : ns + ":") + name);
                    }
                }
            } else if (node.getNode().getType() == 7) {
                String ns = node.getNode().getNamespace();
                String name = node.getRefName();
                return schema.getGlobalEntity(node.getNode().getType(), (ns == null ? "" : ns + ":") + name);
            }
        }
        return null;
    }

    public CodeTables getCodeTables(XMLSchema schema, String url, URL xuiURL) {
        return this.getCodeTables(schema, url, xuiURL, null);
    }

    public static void releaseCodeTable(String id) {
        String codeSetName = null;
        if (id != null && id.endsWith(".codes")) {
            codeSetName = id.substring(id.lastIndexOf("/") + 1);
        }
        if (_codeTables != null && codeSetName != null) {
            Enumeration cachedURLs = _codeTables.getCachedURLs().keys();
            Vector<String> toBeRemoved = new Vector<String>();
            while (cachedURLs.hasMoreElements()) {
                String url = (String)cachedURLs.nextElement();
                if (url.indexOf(codeSetName) == -1) continue;
                toBeRemoved.add(url);
            }
            Iterator toBeRemovedIterator = toBeRemoved.iterator();
            while (toBeRemovedIterator.hasNext()) {
                String url = (String)toBeRemovedIterator.next();
                _codeTables.getCachedURLs().remove(url);
            }
        }
    }

    public void setSCDom(Document document) {
        this._scDom = document;
    }

    public Document getSCDom() {
        return this._scDom;
    }

    private static String getInternalEntityMapping(int type) {
        switch (type) {
            case 27: {
                return "ID";
            }
            case 26: {
                return "NCName";
            }
            case 3: {
                return "boolean";
            }
            case 17: {
                return "base64Binary";
            }
            case 31: {
                return "nonPositiveInteger";
            }
            case 29: {
                return "ENTITIES";
            }
            case 24: {
                return "NMTOKENS";
            }
            case 12: {
                return "gYearMonth";
            }
            case 41: {
                return "unsignedByte";
            }
            case 37: {
                return "nonNegativeInteger";
            }
            case 25: {
                return "Name";
            }
            case 20: {
                return "NOTATION";
            }
            case 42: {
                return "positiveInteger";
            }
            case 7: {
                return "duration";
            }
            case 13: {
                return "gMonthDay";
            }
            case 22: {
                return "token";
            }
            case 6: {
                return "double";
            }
            case 32: {
                return "negativeInteger";
            }
            case 28: {
                return "IDREFS";
            }
            case 5: {
                return "float";
            }
            case 10: {
                return "date";
            }
            case 33: {
                return "long";
            }
            case 21: {
                return "normalizedString";
            }
            case 1: {
                return "anySimpleType";
            }
            case 18: {
                return "anyURI";
            }
            case 8: {
                return "dateTime";
            }
            case 2: {
                return "string";
            }
            case 39: {
                return "unsignedInt";
            }
            case 40: {
                return "unsignedShort";
            }
            case 38: {
                return "unsignedLong";
            }
            case 19: {
                return "QName";
            }
            case 15: {
                return "gMonth";
            }
            case 14: {
                return "gDay";
            }
            case 16: {
                return "hexBinary";
            }
            case 9: {
                return "time";
            }
            case 4: {
                return "decimal";
            }
            case 23: {
                return "language";
            }
            case 34: {
                return "int";
            }
            case 35: {
                return "short";
            }
        }
        return null;
    }

    public static XSObject getGlobalXSDInternalTypes(int type) {
        if (GLOBAL_XSD_INTERNALENTITIES != null) {
            return (XSObject)GLOBAL_XSD_INTERNALENTITIES.get(XMLSchemaImpl.getInternalEntityMapping(type));
        }
        return null;
    }

    public void setSynced(boolean synced) {
        this._synced = synced;
    }

    public boolean isSynced() {
        return this._synced;
    }
}

