/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.type;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.JAXFrontUserEvent;
import com.jaxfront.core.dom.SerializationModifier;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.SchemaComplexType;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.impl.SchemaComplexTypeImpl;
import com.jaxfront.core.type.AbstractListType;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.EmptyType;
import com.jaxfront.core.type.ListModificationException;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.RelativeTypePath;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypeMatcher;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.xui.BehaviourDefinition;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Element;

public abstract class AbstractCompositeType
extends AbstractType
implements CompositeType {
    protected List _types;
    private Hashtable _choiceTypes;
    private boolean _choicesCreated = false;
    private short _hasAttributes = (short)-1;
    private EmptyType _emptyType;
    private boolean _needRecursiveRepresentation = false;
    private String[] _relevantChoiceNames;
    private String _dispValue = null;
    private long _lastUpdate = -1L;

    public AbstractCompositeType(SchemaNode schemaElement, List types) {
        super(schemaElement);
        this.setCompositeTypes(types);
    }

    public void bind(Object trigger, Type type) {
        this._hasParentListBeenResolved = false;
        this._parentList = null;
        if (trigger == JAXFrontUserEvent.class && this.getStyle().isSelectionOnly()) {
            return;
        }
        if (type.isComposite()) {
            this._serializable = ((AbstractCompositeType)type)._serializable;
        }
        if (this.isChoice()) {
            if (type.getChoosenType() == null) {
                if (this.getChoosenType() != null) {
                    this.setChoosenType(null);
                }
            } else {
                Type choiceType = this.getDirectChild(type.getChoosenType().getName());
                if (choiceType == null) {
                    choiceType = this.createChoiceType(type.getChoosenType().getName());
                }
                if (choiceType != null) {
                    this.setChoosenType(choiceType, true);
                }
            }
        }
        Iterator compositeIterator = this.getComposites().iterator();
        while (compositeIterator.hasNext()) {
            Type composite = (Type)compositeIterator.next();
            Type bindType = type.getChild(composite.getName());
            if (bindType == null) continue;
            composite.bind(trigger, bindType);
        }
        if (this.getStyle().isUsingPlugIn()) {
            this.informPlugin(this);
        }
    }

    public void bind(Document DOM, Element instanceElement, boolean bindOnlyAvailable) {
        super.bind(DOM, instanceElement, bindOnlyAvailable);
        this._choosen = null;
        if (this.isChoice() && instanceElement == null) {
            this.setChoosenType(null);
        }
        Type choiceType = null;
        if (this.isAbstract()) {
            this.bindDerivate(DOM, instanceElement);
        } else {
            Element choosenElement = null;
            if (instanceElement != null && this.isChoice()) {
                String elementName;
                if (DOMHelper.hasAnonymousChildren(this.getTemplate())) {
                    Type templateChoice = TypeMatcher.bestMatchBaseType(this.getTemplate(), instanceElement);
                    if (templateChoice != null && (choiceType = this.getDirectChild(templateChoice.getName())) == null) {
                        choiceType = this.createChoiceType(templateChoice.getName());
                    }
                    if (choiceType != null) {
                        choosenElement = choiceType.isAnonymous() ? instanceElement : this.getRelevantInstanceElement(choiceType, instanceElement);
                    }
                } else if (this.isAnonymous() && (choosenElement = TypeMatcher.getInstancFromPossibles(this.getDOM().getSchema(), this, instanceElement)) != null) {
                    elementName = choosenElement.getLocalName();
                    if (elementName == null) {
                        elementName = choosenElement.getNodeName();
                    }
                    if ((choiceType = this.getDirectChild(elementName, choosenElement.getNamespaceURI())) == null) {
                        choiceType = this.createChoiceType(elementName);
                    }
                }
                if (choosenElement == null && (choosenElement = DOMHelper.getFirstChild(instanceElement)) != null) {
                    elementName = choosenElement.getLocalName();
                    if (elementName == null) {
                        elementName = choosenElement.getNodeName();
                    }
                    if ((choiceType = this.getDirectChild(elementName, choosenElement.getNamespaceURI())) == null) {
                        choiceType = this.createChoiceType(elementName);
                    }
                }
                if (choiceType != null) {
                    this.setChoosenType(choiceType, true);
                    choiceType.bind(DOM, choosenElement, bindOnlyAvailable);
                }
            }
            if (instanceElement != null && this.isRecursive() && !this.hasRecursionBeenBuilt() && (this.getComposites() == null || this.getComposites().size() == 0)) {
                String[] recElementNames = this.getSchemaType().getRecursiveElementNames();
                if (recElementNames != null && recElementNames.length > 0) {
                    for (int r = 0; r < recElementNames.length; ++r) {
                        if (DOMHelper.getChildren(null, instanceElement, recElementNames[r]) == null) continue;
                        try {
                            this.completeRecursion();
                            break;
                        }
                        catch (CloneNotSupportedException e) {
                            // empty catch block
                        }
                    }
                } else {
                    try {
                        this.completeRecursion();
                    }
                    catch (CloneNotSupportedException e) {
                        // empty catch block
                    }
                }
            }
            List composites = this.getComposites();
            Vector<Type> toRemove = null;
            for (int c = 0; c < composites.size(); ++c) {
                Type composite = (Type)composites.get(c);
                if (this.isChoice() && choiceType != null && choiceType == composite) continue;
                Element childInstanceElement = this.getRelevantInstanceElement(composite, instanceElement);
                if (bindOnlyAvailable && composite.getParent() != null && composite.getParent().getParentList() != null) {
                    if (childInstanceElement != null) {
                        composite.bind(this._DOM, childInstanceElement, bindOnlyAvailable);
                        if (!composite.isSimple() || this.getDOM().isXUIDOMInstance() || this.getDOM().isPDFXUIDOM() || composite.isSerializable()) continue;
                        if (toRemove == null) {
                            toRemove = new Vector();
                        }
                        toRemove.add(composite);
                        continue;
                    }
                    if (this.getDOM().isXUIDOMInstance() || this.getDOM().isPDFXUIDOM()) continue;
                    if (toRemove == null) {
                        toRemove = new Vector<Type>();
                    }
                    toRemove.add(composite);
                    continue;
                }
                composite.bind(this._DOM, childInstanceElement, bindOnlyAvailable);
            }
            if (bindOnlyAvailable && toRemove != null) {
                for (int r = toRemove.size() - 1; r >= 0; --r) {
                    this.removeChild((Type)toRemove.get(r));
                }
                toRemove = null;
            }
        }
    }

    public void bind(Document DOM, Element instanceElement) {
        boolean bindOnylAvailable = JAXFrontProperties.getInstance(this.getDOM().getAppContext()).isBindingOnlyAvailable();
        if (this.getDOM().isXUIDOMInstance()) {
            bindOnylAvailable = false;
        }
        this.bind(DOM, instanceElement, bindOnylAvailable);
    }

    private Element getRelevantInstanceElement(Type composite, Element instanceElement) {
        Element childInstanceElement = null;
        if (instanceElement != null) {
            boolean isSimpleContent;
            boolean bl = isSimpleContent = composite.isSimple() && ((SimpleType)composite).isSimpleContent();
            childInstanceElement = composite.isAnonymous() && !isSimpleContent ? instanceElement : (composite.isAttribute() ? instanceElement : (composite.isAbstract() ? instanceElement : (isSimpleContent ? instanceElement : (this.getParent() != null && this.getParent().isAnonymous() && DOMHelper.equalsTypeElement(this.getDOM().getSchema(), instanceElement, composite, false) ? instanceElement : DOMHelper.getChild(this.getDOM().getSchema(), instanceElement, composite)))));
        }
        return childInstanceElement;
    }

    private Type bindDerivate(Document DOM, Element instanceElement) {
        Type derivateType;
        if (instanceElement != null) {
            instanceElement = DOMHelper.getChild(this.getDOM().getSchema(), instanceElement, this.getName());
        }
        String concreteName = "";
        if (instanceElement != null) {
            concreteName = instanceElement.getAttribute("xsi:type");
        }
        if ((derivateType = DOMHelper.getDerivedType(this, concreteName, true)) != null) {
            derivateType.bind(DOM, instanceElement);
        }
        return derivateType;
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractCompositeType clone = (AbstractCompositeType)super.clone();
        clone._emptyType = null;
        clone._types = new Vector(this._types.size());
        return clone;
    }

    public void createChoices() {
        if (!this._choicesCreated) {
            Iterator choices = this.getChoiceNames().iterator();
            while (choices.hasNext()) {
                String choiceName = (String)choices.next();
                Type choiceType = this.getDirectChild(choiceName);
                if (choiceType != null) continue;
                Type type = this.buildChoiceType(choiceName);
            }
            this._choicesCreated = true;
            this.updateChoiceXUI(this);
        }
    }

    public Type createChoiceType(String name) {
        Type choiceType = this.getDirectChild(name);
        if (choiceType == null && name != null) {
            SchemaNode schemaElement = (SchemaNode)this.getChoiceTypes().get(name);
            if (schemaElement != null) {
                choiceType = schemaElement.getSchema().createTypeCopy(schemaElement);
                choiceType.setParent(this);
                this.initDOMReference(choiceType);
                this.getComposites().add(choiceType);
                this.updateChoiceXUI(choiceType);
            } else if (JAXFrontProperties.LOG_ENABLED) {
                // empty if block
            }
        }
        return choiceType;
    }

    private void updateChoiceXUI(Type choiceType) {
        Type parentEditingClone;
        ListType parentList;
        if (!this.getDOM().isBinding() && (parentList = this.getLastParentList()) != null && choiceType != null && (parentEditingClone = this.getParentEditingTypeClone(parentList, choiceType)) != null) {
            parentList.maintainXUIDefinitions(parentEditingClone);
        }
    }

    public Type getParentEditingTypeForName(String name) {
        ListType parentList = this.getLastParentList();
        if (parentList != null) {
            List found;
            String choiceXPath = DOMHelper.getRelativeEditingTypeXPath(parentList.getEditingType(), this);
            if (choiceXPath != null && name != null) {
                choiceXPath = choiceXPath + "/" + name;
            }
            if ((found = TypePathExecuter.getInstance().processXPath(parentList.getEditingType(), choiceXPath, false, true)) != null && found.size() > 0) {
                return (Type)found.get(0);
            }
        }
        return null;
    }

    private void initDOMReference(Type type) {
        type.setDOM(this.getDOM());
        List types = type.getDirectChildren();
        for (int i = 0; i < types.size(); ++i) {
            this.initDOMReference((Type)types.get(i));
        }
        if (type.isList()) {
            this.initDOMReference(((ListType)type).getEditingType());
        }
    }

    public void completeRecursion() throws CloneNotSupportedException {
        Type recursionType = this.getSchemaType().getType();
        Type newTemplateType = null;
        newTemplateType = recursionType.isList() ? ((ListType)recursionType).getEditingType().deepClone(this._DOM, false, false) : recursionType.deepClone(this._DOM, false, false);
        if (newTemplateType.isComposite()) {
            Vector<Type> comps = ((CompositeType)newTemplateType).getComposites();
            if (this.isChoice()) {
                Vector<Type> tempList = new Vector<Type>(this.getAttributes().size());
                tempList.addAll(this.getAttributes());
                if (this.getChoosenType() != null) {
                    tempList.add(this.getChoosenType());
                }
                comps = tempList;
            }
            for (int i = 0; i < comps.size(); ++i) {
                Type typeToClone = (Type)comps.get(i);
                Type clonedComposite = null;
                clonedComposite = typeToClone.deepClone(this.getDOM(), true, false, false, null, null);
                if (clonedComposite == null) continue;
                clonedComposite.setParent(this);
                this.getComposites().add(clonedComposite);
            }
        } else if (JAXFrontProperties.LOG_ENABLED) {
            LogRegistry.getInstance().error(this.getClass(), "recursion can only built by a compositeType! this is a " + recursionType.getTypeClassification());
        }
    }

    public Type deepClone(Document dom, boolean cloneChoices, boolean includingData) throws CloneNotSupportedException {
        return this.deepClone(dom, cloneChoices, includingData, false, null, null);
    }

    public Type deepClone(Document dom, boolean cloneChoices, boolean includingData, boolean includeEditingType, SchemaNode schemaNode, Element element) throws CloneNotSupportedException {
        if (dom != null) {
            this.setDOM(dom);
        }
        Vector<Type> comps = this.getComposites();
        AbstractCompositeType copy = (AbstractCompositeType)this.clone();
        if (schemaNode != null) {
            copy.setSchemaElement(schemaNode);
        }
        Vector<Type> composites = new Vector<Type>(comps.size());
        String choosenName = null;
        if (this.getChoosenType() != null) {
            choosenName = this.getChoosenType().getName();
        }
        if (this.isChoice() && !cloneChoices) {
            Vector<Type> tempList = new Vector<Type>(this.getAttributes().size());
            tempList.addAll(this.getAttributes());
            if (this.getChoosenType() != null) {
                tempList.add(this.getChoosenType());
            }
            comps = tempList;
        }
        int attribCount = -1;
        int elemCount = -1;
        int compCount = comps.size();
        for (int i = 0; i < compCount; ++i) {
            Type typeToClone = (Type)comps.get(i);
            Type clonedComposite = null;
            SchemaNode childSchemaNode = null;
            if (schemaNode != null) {
                childSchemaNode = ((SchemaComplexTypeImpl)schemaNode.getSchemaType()).getChild(typeToClone.getName());
            }
            if (element != null) {
                Element foundElement = this.getRelevantInstanceElement(typeToClone, element);
                if (foundElement != null) {
                    clonedComposite = typeToClone.deepClone(dom, cloneChoices, includingData, includeEditingType, childSchemaNode, foundElement);
                }
            } else {
                clonedComposite = typeToClone.deepClone(dom, cloneChoices, includingData, includeEditingType, childSchemaNode, element);
            }
            if (clonedComposite == null) continue;
            composites.add(clonedComposite);
            clonedComposite.setParent(copy);
        }
        copy.setCompositeTypes(composites);
        if (cloneChoices && this.isChoice() && choosenName != null) {
            copy.setChoosenType(copy.getDirectChild(choosenName), true, includingData);
        }
        copy.setTemplate(this);
        if (schemaNode != null) {
            copy.setName(schemaNode.getName());
            copy.setName(null);
        }
        return copy;
    }

    public List getAllRepresentableTypes() {
        List comps = this.getComposites();
        int compCount = comps.size();
        Vector<Type> found = new Vector<Type>(compCount);
        for (int i = 0; i < compCount; ++i) {
            Type type = (Type)comps.get(i);
            boolean hasOwnTreeContext = false;
            if (type.isRepresentedAsTreeNode() && type.getStyle().isSelfViewHolder()) {
                hasOwnTreeContext = true;
            }
            if (hasOwnTreeContext || !type.getStyle().isVisible()) continue;
            if (this.isChoice()) {
                if (!type.isAttribute()) continue;
                found.addElement(type);
                continue;
            }
            found.addElement(type);
        }
        return found;
    }

    public List getAllRepresentedTreeTypes() {
        List comps = this.getComposites();
        int compCount = comps.size();
        Vector<Type> found = new Vector<Type>(compCount);
        for (int i = 0; i < compCount; ++i) {
            Type type = (Type)comps.get(i);
            if (!type.isRepresentedAsTreeNode() || !type.isList()) continue;
            found.addElement(type);
        }
        return found;
    }

    public List getAttributes() {
        List comps = this.getComposites();
        int compCount = comps.size();
        Vector<Type> attributes = new Vector<Type>(compCount);
        for (int i = 0; i < compCount; ++i) {
            Type composite = (Type)comps.get(i);
            if (!composite.isAttribute()) continue;
            attributes.add(composite);
        }
        return attributes;
    }

    public Type getDirectChild(String name) {
        if (name != null) {
            if (this.getComposites() == null) {
                return null;
            }
            List childs = this.getComposites();
            int cs = childs.size();
            for (int i = 0; i < cs; ++i) {
                Type type = (Type)childs.get(i);
                if (!type.getName().equals(name)) continue;
                return type;
            }
        }
        return null;
    }

    public Type getDirectChild(String name, String ns) {
        if (name != null) {
            if (this.getComposites() == null) {
                return null;
            }
            List childs = this.getComposites();
            int cs = childs.size();
            for (int i = 0; i < cs; ++i) {
                Type type = (Type)childs.get(i);
                if (!type.getName().equals(name) || ns != null && ns != type.getNamespace() && !ns.equals(type.getNamespace())) continue;
                return type;
            }
        }
        return null;
    }

    public List getDirectChildren() {
        return this.getComposites();
    }

    public int getDirectChildrenSize() {
        return this.getComposites().size();
    }

    public List getDirectChildren(String name) {
        List childs = this.getComposites();
        int childCount = childs.size();
        Vector<Type> found = new Vector<Type>(childCount);
        for (int i = 0; i < childCount; ++i) {
            Type type = (Type)childs.get(i);
            if (!type.getName().equals(name)) continue;
            found.add(type);
        }
        return found;
    }

    public Set getChoiceNames() {
        return this.getChoiceTypes().keySet();
    }

    private Hashtable getChoiceTypes() {
        if (this._choiceTypes == null) {
            this._choiceTypes = new Hashtable();
            this.initializeChoiceTypes(this.getSchemaElement(), 0);
        }
        return this._choiceTypes;
    }

    private void initializeChoiceTypes(SchemaNode element, int anonymousLevelCounter) {
        if (!element.getSchemaType().isSimple()) {
            SchemaNode[] elementSet = ((SchemaComplexType)element.getSchemaType()).getElementSet();
            SchemaNode innerElement = null;
            for (int i = 0; i < elementSet.length; ++i) {
                innerElement = elementSet[i];
                this._choiceTypes.put(innerElement.getName(), innerElement);
            }
        }
    }

    public Type getChoosenType() {
        if (this.isNoneChoosen()) {
            return null;
        }
        String[] names = this.getRelevantChoiceNames();
        if (this.isChoice() && this._choosen == null && this.isMandatoryAxis(false) && !this.isGlobal() && names.length > 0) {
            String defaultSelectedType = this.getStyle().getChoiceDefaultSelection();
            if (defaultSelectedType != null && defaultSelectedType.length() > 0) {
                this._choosen = this.isAbstract() ? DOMHelper.getDerivedType(this, defaultSelectedType, true) : this.getDirectChild(defaultSelectedType);
            }
            if (this._choosen == null) {
                String firstName = names[0];
                if (!this.isAbstract() && this.getMinOccursForChoice() > 0) {
                    Type choosen = this.getDirectChild(firstName);
                    if (choosen == null) {
                        choosen = this.createChoiceType(firstName);
                    }
                    this._choosen = choosen;
                }
            }
        } else if (this._choosen == null && this.getXUIDefinition(false) != null) {
            String defaultSelectedType = this.getStyle().getChoiceDefaultSelection();
            if (defaultSelectedType != null && defaultSelectedType.length() > 0) {
                Type selectedType;
                this._choosen = this.isAbstract() ? DOMHelper.getDerivedType(this, defaultSelectedType, true) : (selectedType = this.getDirectChild(defaultSelectedType));
            }
            if (this._choosen == null && this.isMandatoryAxis() && names != null && names.length > 0) {
                String firstName = names[0];
                Type choosen = this.getDirectChild(firstName);
                if (choosen == null) {
                    choosen = this.createChoiceType(firstName);
                }
                this._choosen = choosen;
            }
        }
        return this._choosen;
    }

    public List getComposites() {
        return this._types;
    }

    public SimpleType getContentType() {
        List comps = this.getComposites();
        SimpleType contentType = null;
        for (int i = 0; i < comps.size() && contentType == null; ++i) {
            Type childType = (Type)comps.get(i);
            if (!childType.isSimple() || !((SimpleType)childType).isSimpleContent()) continue;
            contentType = (SimpleType)childType;
        }
        return contentType;
    }

    public EmptyType getEmptyType() {
        if (this.isMandatoryAxis()) {
            return null;
        }
        if (this.isChoice() && this._emptyType == null) {
            this._emptyType = new EmptyType(null, this.getDOM());
        }
        return this._emptyType;
    }

    private int getMinOccursForChoice() {
        int min = 0;
        if (!this.isAbstract()) {
            min = this.getSchemaType().isGroup() ? this.getSchemaElement().getMinOccurs() : this.getSchemaType().getChoiceMinOccurs();
        }
        return min;
    }

    public List getRelevantChoiceTypes() {
        List comps;
        Vector<Type> newList = new Vector<Type>();
        if (this.isChoice() && (comps = this.getComposites()) != null) {
            for (int i = 0; i < comps.size(); ++i) {
                Type type = (Type)comps.get(i);
                if (type.isSimple() && ((SimpleType)type).isAttribute()) continue;
                if (type.isAbstract()) {
                    newList.addAll(type.getDerivedTypes());
                    continue;
                }
                newList.add(type);
            }
        }
        return newList;
    }

    public String[] getRelevantChoiceNames() {
        if (this._relevantChoiceNames == null && this.isChoice()) {
            if (this.isAbstract()) {
                this._relevantChoiceNames = this.getDerivedTypeNames();
            } else {
                SchemaNode[] schemaElements = ((SchemaComplexType)this.getSchemaType()).getElementSet();
                this._relevantChoiceNames = new String[schemaElements.length];
                for (int i = 0; i < schemaElements.length; ++i) {
                    this._relevantChoiceNames[i] = schemaElements[i].getName();
                }
            }
        }
        return this._relevantChoiceNames;
    }

    public boolean hasAttributes() {
        if (this._hasAttributes == -1) {
            this._hasAttributes = 0;
            List comps = this.getComposites();
            for (int i = 0; i < comps.size(); ++i) {
                Type type = (Type)comps.get(i);
                if (!type.isAttribute()) continue;
                this._hasAttributes = 1;
                break;
            }
        }
        return this._hasAttributes == 1;
    }

    public boolean hasDialogChildren() {
        List comps = this.getComposites();
        boolean dialogFound = false;
        for (int i = 0; i < comps.size() && !dialogFound; ++i) {
            Type type = (Type)comps.get(i);
            if (!type.isList() || type.getStyle().getTableInfo() == null) continue;
            dialogFound = type.getStyle().getTableInfo().isDialogEditMode();
        }
        return dialogFound;
    }

    public boolean hasEmptyContent(boolean checkSerializeDefaults, boolean checkDefaultValue) {
        if (this.checkForEmptyContent()) {
            String defaultSelection;
            boolean canRemove = true;
            if (this.isChoice()) {
                if (!this.hasEmptyAttributes(checkSerializeDefaults, checkDefaultValue)) {
                    return false;
                }
                Type aChoosenType = this._choosen;
                if (aChoosenType != null && !aChoosenType.isEmpty()) {
                    String defaultSelection2 = this.getStyle().getChoiceDefaultSelection();
                    if (defaultSelection2 != null) {
                        if (aChoosenType.getName().equals(defaultSelection2)) {
                            return ((AbstractType)aChoosenType).hasEmptyContent(checkSerializeDefaults, checkDefaultValue);
                        }
                        return false;
                    }
                    if (this.getSchemaType().getChoiceMinOccurs() == 0) {
                        return false;
                    }
                    if (aChoosenType.getName().equals(this.getRelevantChoiceNames()[0])) {
                        return ((AbstractType)aChoosenType).hasEmptyContent(checkSerializeDefaults, checkDefaultValue);
                    }
                    return false;
                }
                return true;
            }
            if (this.getParent() != null && this.getParent().isChoice() && (defaultSelection = this.getParent().getStyle().getChoiceDefaultSelection()) != null && !this.getName().equals(defaultSelection)) {
                return false;
            }
            if (this.getClientProperty("userChangedSerialize") != null) {
                return false;
            }
            List comps = this.getComposites();
            if (comps != null) {
                for (int i = comps.size() - 1; i >= 0 && canRemove; --i) {
                    AbstractType type = (AbstractType)comps.get(i);
                    if (type.getDOM() == null && this.getDOM() != null) {
                        type.setDOM(this.getDOM());
                    }
                    canRemove = type.hasEmptyContent(checkSerializeDefaults, checkDefaultValue);
                }
            }
            return canRemove;
        }
        return true;
    }

    private boolean hasEmptyAttributes(boolean checkSerializeDefaults, boolean checkDefaultValue) {
        if (this.checkForEmptyContent()) {
            boolean canRemove = true;
            if (this.hasAttributes()) {
                List attrs = this.getAttributes();
                for (int i = 0; i < attrs.size() && canRemove; ++i) {
                    AbstractType type = (AbstractType)attrs.get(i);
                    canRemove = type.hasEmptyContent(checkSerializeDefaults, checkDefaultValue);
                }
            }
            return canRemove;
        }
        return true;
    }

    public boolean isComposite() {
        return true;
    }

    public boolean needRecursiveRepresentation() {
        return this._needRecursiveRepresentation;
    }

    public void release() {
        if (!this.isDerivedFromGlobalEditingType(this)) {
            this._choiceTypes = null;
            if (this._types != null) {
                List types = this._types;
                for (int i = 0; i < types.size(); ++i) {
                    ((Type)types.get(i)).release();
                }
                this._types = null;
            }
            if (this._emptyType != null) {
                this._emptyType.release();
            }
            super.release();
        }
    }

    public void removeAll() throws ListModificationException {
        List clonedList = (List)((Vector)this.getComposites()).clone();
        for (int i = 0; i < clonedList.size(); ++i) {
            Type child = (Type)clonedList.get(i);
            child.removeAll();
        }
    }

    public boolean removeChild(Type child) {
        return this.getComposites().remove(child);
    }

    public void removeChoices() throws ListModificationException {
        Vector choices = null;
        List clonedList = null;
        choices = (Vector)this.getRelevantChoiceTypes();
        clonedList = (List)choices.clone();
        for (int i = 0; i < clonedList.size(); ++i) {
            Type child = (Type)clonedList.get(i);
            child.remove();
        }
    }

    public void serialize(StringBuffer sb, int indent, boolean writeName, boolean recursive, boolean serializeEmptyContent) {
        super.serialize(sb, indent, writeName, recursive, serializeEmptyContent);
        Document dom = this.getDOM();
        SerializationModifier serModifier = this.getDOM().getSerializationModifier();
        if (serModifier != null && !serModifier.serialize(this)) {
            return;
        }
        Type parentType = this.getParent();
        boolean hasEmptyContent = false;
        if (!serializeEmptyContent) {
            hasEmptyContent = this.hasEmptyContent(true, true);
        }
        if (!hasEmptyContent && this.isSerializable() || dom.getGlobalDefinition().isSerializingEmptyContent() && this.isMandatoryAxis() || this.isChoice() && this.getChoosenType() != null) {
            Type aChoosenType = this.getChoosenType();
            String name = this.getSerializationName();
            boolean hasSimpleContent = false;
            boolean onlyAttribute = true;
            boolean isUnChoosenAbstract = false;
            int tagStartIndex = sb.length();
            if (writeName) {
                if (!this.isAnonymous()) {
                    if (parentType != null && parentType.isList() && this.getParentList().getEditingType().isAbstract()) {
                        String editingTypeName = ((AbstractType)((ListType)parentType).getEditingType()).getSerializationName();
                        String derivateName = this.getSchemaElement().getQName();
                        String typeName = editingTypeName + " xsi:type=\"" + derivateName + "\"";
                        if (indent > 0) {
                            sb.append("\n");
                        }
                        if (indent > 0) {
                            this.makeIndent(sb, indent);
                        }
                        sb.append("<");
                        sb.append(typeName);
                        name = editingTypeName;
                    } else {
                        if (this.isAbstract() && aChoosenType == null) {
                            isUnChoosenAbstract = true;
                        }
                        if (!isUnChoosenAbstract) {
                            if (indent > 0) {
                                sb.append("\n");
                            }
                            if (indent > 0) {
                                this.makeIndent(sb, indent);
                            }
                            sb.append("<");
                            sb.append(name);
                            if (this.isAbstract()) {
                                sb.append(" xsi:type=\"");
                                sb.append(((AbstractType)aChoosenType).getName());
                                sb.append("\"");
                            }
                        }
                    }
                    if (this.isAbstract()) {
                        if (aChoosenType != null) {
                            this.serializeAttributes((CompositeType)aChoosenType, sb);
                        }
                    } else {
                        this.serializeAttributes(sb);
                    }
                }
            } else if (this.hasAttributes()) {
                this.serializeAttributes(sb);
            }
            if (serModifier != null) {
                serModifier.modifyStartTag(this, sb, tagStartIndex);
            }
            int noOfLinesStart = sb.length();
            if (recursive) {
                List comps = this.getComposites();
                if (!this.isRoot() && !this.isAnonymous()) {
                    ++indent;
                }
                for (int i = 0; i < comps.size(); ++i) {
                    Type composite = (Type)comps.get(i);
                    if (composite.isAttribute() || !composite.isSerializable() && (!dom.getGlobalDefinition().isSerializingEmptyContent() || !this.isMandatoryAxis(composite, true))) continue;
                    if (this.isChoice()) {
                        if (aChoosenType == null || aChoosenType != composite) continue;
                        if (onlyAttribute && !this.isAnonymous()) {
                            sb.append(">");
                        }
                        composite.serialize(sb, indent, true, recursive, serializeEmptyContent);
                        onlyAttribute = false;
                        if (!composite.isSimple() || !composite.isAnonymous() && !((SimpleType)composite).isSimpleContent()) continue;
                        hasSimpleContent = true;
                        continue;
                    }
                    if (onlyAttribute && !this.isAnonymous()) {
                        sb.append(">");
                    }
                    if (composite.isAttribute()) continue;
                    composite.serialize(sb, indent, true, recursive, serializeEmptyContent);
                    onlyAttribute = false;
                    if (!composite.isSimple() || !composite.isAnonymous() && !((SimpleType)composite).isSimpleContent()) continue;
                    hasSimpleContent = true;
                }
                --indent;
            }
            int noOfLinesEnd = sb.length();
            if (serModifier != null) {
                serModifier.modifyCompositeTagValue(this, sb.substring(noOfLinesStart), sb, noOfLinesStart);
            }
            if (!isUnChoosenAbstract && writeName && !this.isAnonymous()) {
                if (onlyAttribute) {
                    sb.append("/>");
                } else {
                    if (!hasSimpleContent && (!hasEmptyContent || dom.getGlobalDefinition().isSerializingEmptyContent() && this.isMandatoryAxis()) && noOfLinesEnd - 1 > noOfLinesStart) {
                        sb.append("\n");
                        if (indent > 0) {
                            this.makeIndent(sb, indent);
                        }
                    }
                    sb.append("</");
                    sb.append(name);
                    sb.append(">");
                }
            } else if (!writeName & this.isRoot() && (hasEmptyContent || onlyAttribute)) {
                sb.append(">");
            }
        } else if (!writeName & this.isRoot()) {
            sb.append(">");
        }
    }

    private void serializeAttributes(StringBuffer sb) {
        this.serializeAttributes(this, sb);
    }

    private void serializeAttributes(CompositeType type, StringBuffer sb) {
        List attrs = type.getAttributes();
        for (int i = 0; i < attrs.size(); ++i) {
            SimpleType simple = (SimpleType)attrs.get(i);
            this.serializeAttribute(sb, simple);
        }
    }

    private void setCompositeTypes(List list) {
        this._types = list;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ((Type)list.get(i)).setParent(this);
            }
        }
    }

    public void setNeedRecursiveRepresentation(boolean needRecursiveRepresantation) {
        this._needRecursiveRepresentation = needRecursiveRepresantation;
    }

    public String getDisplayValue() {
        if (this.getDOM().getLastDomUpdateTimeStamp() != this._lastUpdate) {
            this._lastUpdate = this.getDOM().getLastDomUpdateTimeStamp();
            this._dispValue = null;
        }
        if (this._dispValue == null) {
            String value = null;
            if (this.isChoice()) {
                Type relevantType = this.getChoosenType();
                if (relevantType != null) {
                    value = relevantType.getStyle().getLabelChoiceText();
                    String v = relevantType.getDisplayValue();
                    if (v != null && !v.equals("")) {
                        value = value + ", " + v;
                    }
                }
            } else {
                StringBuffer buf = new StringBuffer();
                List comps = this.getComposites();
                boolean first = true;
                boolean wasEmpty = false;
                for (int i = 0; i < comps.size(); ++i) {
                    Type childType = (Type)comps.get(i);
                    if (!childType.getStyle().isVisible()) continue;
                    String v = childType.getDisplayValue();
                    boolean bl = wasEmpty = v == null || v.equals("");
                    if (first) {
                        first = false;
                    } else if (!wasEmpty) {
                        buf.append(", ");
                    }
                    buf.append(wasEmpty ? "" : v);
                }
                value = buf.toString();
            }
            this._dispValue = value;
        }
        return this._dispValue;
    }

    public Type getChild(String name) {
        Type directChild = this.getDirectChild(name);
        if (directChild != null) {
            return directChild;
        }
        if (name != null) {
            List childs = this.getComposites();
            for (int i = 0; i < childs.size(); ++i) {
                Type type = (Type)childs.get(i);
                directChild = type.getChild(name);
                if (directChild == null) continue;
                return directChild;
            }
        }
        return null;
    }

    public Type getChild(String name, String namespace) {
        Type directChild = this.getDirectChild(name, namespace);
        if (directChild != null) {
            return directChild;
        }
        if (name != null) {
            List childs = this.getComposites();
            for (int i = 0; i < childs.size(); ++i) {
                Type type = (Type)childs.get(i);
                directChild = type.getChild(name, namespace);
                if (directChild == null) continue;
                return directChild;
            }
        }
        return null;
    }

    public void setChoosenKeyValue(String xpathRelativeToChoosenKey, String newValue) {
    }

    public void setChoosenKeyContextValue(String xpathRelativeToChoosenKeyContext, String newValue) {
    }

    public Type getMixedContent() {
        List comps = this.getComposites();
        for (int i = 0; i < comps.size(); ++i) {
            Type type = (Type)comps.get(i);
            if (!type.getSchemaType().isMixedContent()) continue;
            return type;
        }
        return null;
    }

    public void markAsDirtyXPath() {
        this.setDirtyXPath(true);
        List comps = this.getComposites();
        for (int i = 0; i < comps.size(); ++i) {
            ((Type)comps.get(i)).markAsDirtyXPath();
        }
    }

    public boolean hasOnlySimpleTypes() {
        List comps = this.getComposites();
        for (int i = 0; i < comps.size(); ++i) {
            if (((Type)comps.get(i)).getTypeClassification() == 128 || ((Type)comps.get(i)).isSimple()) continue;
            return false;
        }
        return true;
    }

    public void completeMissingTypes(boolean includingList) {
        if (this.getClientProperty("missingTypesCreated") == null) {
            Type parentEditingType = this.getParentList().getEditingType();
            if (!this.getParent().isList()) {
                String relativeXPath = RelativeTypePath.createRelativeXPath(this.getLastParentList().getEditingType(), this, false);
                List found = TypePathExecuter.getInstance().processXPath(this.getLastParentList().getEditingType(), relativeXPath, true);
                if (found.size() > 0) {
                    parentEditingType = (Type)found.get(found.size() - 1);
                } else if (LogRegistry.getInstance().logWarnings()) {
                    LogRegistry.getInstance().warn(this.getClass(), "Error while getting relative xpath (" + relativeXPath + "for: " + parentEditingType.getXPathLocation());
                }
            }
            Vector rulesToInitialize = new Vector();
            this.completeMissingTypes(parentEditingType, this, includingList, rulesToInitialize);
            if (rulesToInitialize.size() > 0) {
                Iterator it = rulesToInitialize.iterator();
                while (it.hasNext()) {
                    ((BehaviourDefinition)it.next()).applyInitializationRules();
                }
            }
        }
    }

    private void completeMissingTypes(Type editingType, Type original, boolean includingList, List rulesToInitialize) {
        if (editingType.isComposite()) {
            List originalComposites = ((CompositeType)original).getComposites();
            List comps = ((CompositeType)editingType).getComposites();
            Type editingTypeChild = null;
            Type originalFound = null;
            int counter = 0;
            Type newType = null;
            for (int i = 0; i < comps.size(); ++i) {
                block6: {
                    editingTypeChild = (Type)comps.get(i);
                    originalFound = original.getDirectChild(editingTypeChild.getName());
                    if (originalFound == null) {
                        try {
                            newType = (Type)((AbstractType)editingTypeChild).clone();
                            newType.setParent(original);
                            if (includingList && newType.isList()) {
                                Type newEditingType = ((AbstractType)((ListType)editingTypeChild).getEditingType()).deepClone(this.getDOM(), false, false);
                                newEditingType.setParent(newType);
                                ((ListType)newType).setEditingType(newEditingType);
                                ((ListType)newType).autoCreateEntries();
                            }
                            newType.markAsDirtyXPath();
                            originalComposites.add(counter, newType);
                            originalFound = newType;
                        }
                        catch (CloneNotSupportedException ex) {
                            if (!LogRegistry.getInstance().logWarnings()) break block6;
                            LogRegistry.getInstance().warn(this.getClass(), "Error while complete missing types during clone: " + editingTypeChild.getXPathLocation());
                        }
                    }
                }
                this.completeMissingTypes(editingTypeChild, originalFound, includingList, rulesToInitialize);
                ++counter;
            }
        }
        ((AbstractListType)original.getParentList()).checkXUIDefinition(editingType, original, rulesToInitialize);
        original.putClientProperty("missingTypesCreated", "");
    }

    public boolean hasOnlyOneVisibleChild() {
        List children = this.getAllRepresentableTypes();
        return children.size() == 1 && ((Type)children.get(0)).isSimple();
    }

    private Type buildChoiceType(String name) {
        Type choiceType = null;
        SchemaNode schemaElement = (SchemaNode)this.getChoiceTypes().get(name);
        if (schemaElement != null) {
            choiceType = schemaElement.getSchema().createTypeCopy(schemaElement);
            choiceType.setParent(this);
            this.initDOMReference(choiceType);
            this.getComposites().add(choiceType);
        } else if (JAXFrontProperties.LOG_ENABLED) {
            // empty if block
        }
        return choiceType;
    }
}

