/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.type;

import com.jaxfront.core.dom.CodeTables;
import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.JAXFrontPropertyChangeEvent;
import com.jaxfront.core.dom.JAXFrontUserEvent;
import com.jaxfront.core.dom.SerializationModifier;
import com.jaxfront.core.keyRef.KeyContextWrapper;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.SchemaComplexType;
import com.jaxfront.core.schema.SchemaKeyRef;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.SchemaSimpleType;
import com.jaxfront.core.schema.ValidationException;
import com.jaxfront.core.schema.impl.KeyContainer;
import com.jaxfront.core.schema.impl.KeyRefDefinition;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.ISimpleType;
import com.jaxfront.core.type.ListModificationException;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.EmptyUnmodifiableList;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontDateTools;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.xui.GlobalDefinition;
import com.jaxfront.core.xui.StyleDefinition;
import com.jaxfront.core.xui.XUIDefinition;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.function.TypeObject;
import org.nfunk.jep.type.NULL;
import org.w3c.dom.Element;

public class SimpleType
extends AbstractType
implements ISimpleType,
TypeObject {
    private static final List EMPTY_VECTOR = new EmptyUnmodifiableList();
    private static final String DATETIME_ZERO = "T00:00:00";
    private static final String TIME_ZERO = "00:00";
    private static final String BOOLEAN_FALSE = "false";
    private static final String ZERO_NUMBER = "0";
    private static final String NOT_SET = "";
    private String _value;
    private Integer _actAsDataType;
    protected String _extendedType;
    private static List _list;
    private SimpleType _contextKeyRefType;
    private String _origValue = "";
    private byte _keyType = (byte)-1;

    public SimpleType(SchemaNode schemaElement) {
        super(schemaElement);
        this._typeClassification = 1;
        if (schemaElement != null) {
            this.checkForSimpleContent(schemaElement);
        }
    }

    public void actAsBoolean() {
        this.actAs(null, (short)3);
    }

    public void actAsColor() {
        this.actAs("Color", (short)2);
    }

    public void actAsDate() {
        this.actAs(null, (short)10);
    }

    public void actAsTime() {
        this.actAs(null, (short)9);
    }

    public void actAsPassword() {
        this.actAs("password", (short)2);
    }

    public void actAsHTML() {
        this.actAs("html", (short)2);
    }

    public void actAsDateTime() {
        this.actAs(null, (short)8);
    }

    public void actAsInt() {
        this.actAs(null, (short)4);
    }

    public void actAsInteger() {
        this.actAs(null, (short)4);
    }

    public void actAsDouble() {
        this.actAs(null, (short)6);
    }

    public void actAsString() {
        this.actAs(null, (short)2);
    }

    public void actAsVisualizer() {
        this.actAs("Visualizer", (short)2);
    }

    public void actAs(String extendedType, short dataType) {
        this._extendedType = extendedType;
        this._actAsDataType = new Integer(dataType);
    }

    public void bind(Object trigger, Type type) {
        if (trigger == JAXFrontUserEvent.class && this.getStyle().isSelectionOnly()) {
            return;
        }
        if (type.isSimple() && this.getPrimitiveDataType() == ((SimpleType)type).getPrimitiveDataType()) {
            this._serializable = ((SimpleType)type)._serializable;
            this.setValue(((SimpleType)type).getValue());
        }
    }

    public void bind(Document DOM, Element instanceElement) {
        boolean bindOnylAvailable = false;
        if (this.getDOM() != null) {
            bindOnylAvailable = JAXFrontProperties.getInstance(this.getDOM().getAppContext()).isBindingOnlyAvailable();
            if (this.getDOM().isXUIDOMInstance()) {
                bindOnylAvailable = false;
            }
        }
        this.bind(DOM, instanceElement, bindOnylAvailable);
    }

    public void bind(Document DOM, Element instanceElement, boolean bindOnlyAvailable) {
        super.bind(DOM, instanceElement, bindOnlyAvailable);
        if (this.isAbstract()) {
            this.bindDerivate(DOM, instanceElement);
        } else {
            String value = null;
            if (this.isAnyType()) {
                value = DOMHelper.serializeElement(instanceElement);
                if (value != null) {
                    value = TextTools.replace(value, "<" + instanceElement.getNodeName() + ">", NOT_SET);
                    value = TextTools.replace(value, "</" + instanceElement.getNodeName() + ">", NOT_SET);
                }
            } else if (this.isAttribute()) {
                if (instanceElement != null) {
                    value = instanceElement.getAttribute(this.getName());
                }
            } else if (this.isSimpleContent() && instanceElement != null) {
                value = DOMHelper.getMixedContentText(instanceElement);
            } else if (instanceElement != null) {
                String concreteDerrivationName;
                String text = DOMHelper.getText(instanceElement);
                if (text != null) {
                    value = text;
                }
                if (this.getParent() != null && this.getParent().isAbstract() && (concreteDerrivationName = instanceElement.getAttribute("xsi:type")) != null && concreteDerrivationName.equals(this.getName())) {
                    this.getParent().setChoosenType(this, true);
                }
            }
            if (instanceElement != null && !this.isAttribute() && this.getParent() != null && this.getParent().isAnonymous() && !instanceElement.getNodeName().equals(this.getSerializationName())) {
                value = null;
            }
            if (this.getDOM().getGlobalDefinition().isSoftBinding()) {
                if (this._value == null || this._value.length() == 0 || this._value.equals(this.getDefaultValue())) {
                    this.setValue(null, value, true, false);
                }
            } else {
                this.setValue(null, value, true, false);
            }
        }
    }

    private void bindDerivate(Document DOM, Element instanceElement) {
        Iterator iterator = this.getDerivedTypes().iterator();
        if (instanceElement != null) {
            instanceElement = DOMHelper.getChild(this.getDOM().getSchema(), instanceElement, this.getName());
        }
        while (iterator.hasNext()) {
            Type derrivateType = (Type)iterator.next();
            derrivateType.bind(DOM, instanceElement);
        }
    }

    protected void checkForSimpleContent(SchemaNode schemaElement) {
        SchemaSimpleType schemaSimpleType;
        if (schemaElement.hasType() && !schemaElement.getSchemaType().isAbstract() && !schemaElement.getSchemaType().isSimple() && (schemaSimpleType = ((SchemaComplexType)schemaElement.getSchemaType()).getSimpleContent()) != null) {
            schemaSimpleType.setIsSimpleContent(false);
            schemaElement.setSchemaType(schemaSimpleType);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleType clone = (SimpleType)super.clone();
        clone._actAsDataType = this._actAsDataType;
        clone._value = this._value;
        clone._isAttribute = this._isAttribute;
        clone._extendedType = this._extendedType;
        clone._contextKeyRefType = this._contextKeyRefType;
        clone._keyType = (byte)-1;
        return clone;
    }

    public Type deepClone(Document dom, boolean cloneChoices, boolean includingData) throws CloneNotSupportedException {
        return this.deepClone(dom, cloneChoices, includingData, null, null);
    }

    public Type getDirectChild(String name) {
        return null;
    }

    public Type getDirectChild(String name, String namespace) {
        return null;
    }

    public String[] getEnumeration() {
        StyleDefinition style = this.getStyle();
        String[] choices = style.getEnumeration();
        if (choices == null) {
            choices = new String[]{};
        }
        return choices;
    }

    public String[][] getChoices() {
        Object[][] choices = this.getStyle().getCodeEnumeration();
        String[] enumChoices = this.getStyle().getEnumeration();
        if (choices == null && enumChoices != null) {
            choices = ArrayUtil.meltArray(enumChoices, enumChoices);
        }
        if (enumChoices != null && this.getStyle().isUsingExternalEnumeration()) {
            boolean addEmptyChoice;
            boolean bl = addEmptyChoice = this.getStyle().getMultiLineNumberComponent() == 1 && this.getStyle().allowEmptyChoice() && !this.getStyle().isEnumerationAsListBoxMultipleSelect() && ArrayUtil.contains(choices, 0, NOT_SET) == -1;
            if (addEmptyChoice) {
                choices = ArrayUtil.addTo2DimArrayY(new String[][]{{NOT_SET, NOT_SET}}, (String[][])choices);
            }
        }
        return choices;
    }

    public List getDirectChildren() {
        return this.getList();
    }

    public int getDirectChildrenSize() {
        if (_list == null) {
            return 0;
        }
        return this.getList().size();
    }

    public List getDirectChildren(String name) {
        return this.getList();
    }

    public String getDefaultValue() {
        String defaultValue = this.getSchemaElement().getDefaultValue();
        if (defaultValue == null && this.hasUIDefinition() && this.getEnumeration().length > 0 && (defaultValue = this.getStyle().getLeafDefaultValue()) == null && this.isChoice() && (defaultValue = this.getStyle().getChoiceDefaultSelection()) == null) {
            defaultValue = this.getStyle().getLeafEnumerationDefaultSelection();
        }
        return defaultValue;
    }

    public static String createVisibleDefaultValue(String modelValue, String defaultValue, String displayValue, String defPrefix, String defPostfix) {
        String value = displayValue;
        if (defaultValue != null && defaultValue.length() > 0 && defaultValue.equals(modelValue)) {
            value = (defPrefix != null ? defPrefix : NOT_SET) + displayValue + (defPostfix != null ? defPostfix : NOT_SET);
        }
        return value;
    }

    public String getFixedValue() {
        return this.getSchemaElement().getFixedValue();
    }

    private List getList() {
        if (_list == null) {
            _list = EMPTY_VECTOR;
        }
        return _list;
    }

    public Object getMathValueTyped() {
        String result = this.getValue();
        this.getStyle();
        if (result == null) {
            return NULL._null;
        }
        int basicType = this.getPrimitiveDataType();
        Double deResult = null;
        switch (basicType) {
            case 3: {
                if (result.equals("true")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 4: {
                return new Double(result);
            }
            case 6: {
                return new Double(result);
            }
            case 5: {
                deResult = new Double(result);
                return new Float(deResult.floatValue());
            }
            case 34: {
                deResult = new Double(result);
                return new Integer(deResult.intValue());
            }
            case 30: {
                deResult = new Double(result);
                return new Integer(deResult.intValue());
            }
            case 33: {
                deResult = new Double(result);
                return new Long(deResult.longValue());
            }
            case 32: {
                deResult = new Double(result);
                deResult.intValue();
            }
            case 37: {
                deResult = new Double(result);
                deResult.intValue();
            }
            case 31: {
                deResult = new Double(result);
                deResult.intValue();
            }
            case 42: {
                deResult = new Double(result);
                deResult.intValue();
            }
            case 35: {
                deResult = new Double(result);
                deResult.shortValue();
            }
            case 39: {
                deResult = new Double(result);
                deResult.intValue();
            }
            case 38: {
                deResult = new Double(result);
                deResult.longValue();
            }
            case 40: {
                deResult = new Double(result);
                deResult.shortValue();
            }
            case 41: {
                deResult = new Double(result);
                deResult.intValue();
            }
            case 36: {
                deResult = new Double(result);
                deResult.intValue();
            }
        }
        return result;
    }

    public int getMaxDigits() {
        long maxRestrictDigits = ((SchemaSimpleType)this.getSchemaType()).getTotalDigits();
        int maxDigits = -1;
        int basicType = this.getPrimitiveDataType();
        switch (basicType) {
            case 4: 
            case 5: 
            case 6: {
                maxDigits = -1;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 39: 
            case 42: {
                maxDigits = 10;
                break;
            }
            case 35: 
            case 40: {
                maxDigits = 5;
                break;
            }
            case 33: 
            case 38: {
                maxDigits = 19;
                break;
            }
            case 36: 
            case 41: {
                maxDigits = 3;
                break;
            }
            default: {
                maxDigits = -1;
            }
        }
        if (maxRestrictDigits != -1L && maxRestrictDigits < (long)maxDigits) {
            maxDigits = (int)maxRestrictDigits;
        }
        return maxDigits;
    }

    public boolean isFloatingNumber() {
        switch (this.getPrimitiveDataType()) {
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public int getPrimitiveDataType() {
        if (this._actAsDataType != null) {
            return this._actAsDataType;
        }
        if (!this.getSchemaType().isSimple()) {
            return 2;
        }
        return this.getSimpleSchemaType().getPrimitiveDataType();
    }

    public String getPlainValue() {
        return this._value;
    }

    public String getValue() {
        block16: {
            if (this._value != null) {
                return this._value;
            }
            XUIDefinition xuiDefinition = this.getXUIDefinition(false);
            if (this._value == null || this._value.length() == 0) {
                this._value = this.getSchemaElement().getFixedValue();
            }
            if (xuiDefinition != null) {
                StyleDefinition style = xuiDefinition.getStyle();
                if (this._value == null || this._value.length() == 0) {
                    this._value = style.getLeafDefaultValue();
                }
                if ((this._value == null || this._value.length() == 0) && style.isEnumeration()) {
                    String defaultSelection = style.getLeafEnumerationDefaultSelection();
                    if (defaultSelection != null) {
                        this._value = defaultSelection;
                    } else if (!(style.allowEmptyChoice() || style.getEnumeration() == null || style.getEnumeration().length <= 0 || style.isEnumerationAsRadioButton() || style.isEnumerationAsListBoxMultipleSelect())) {
                        this._value = this.getChoices()[0][0];
                    }
                }
            }
            if (this._value == null || this._value.length() == 0) {
                this._value = this.getDefaultValue();
            }
            if ((this._value == null || this._value.length() == 0) && this.isBoolean()) {
                if (xuiDefinition != null && xuiDefinition.getStyle().isBooleanViewRadioButtonUnselected()) {
                    this._value = null;
                } else if (this.isMandatoryAxis(false)) {
                    this._value = BOOLEAN_FALSE;
                }
            }
            if (this.isFloatingNumber()) {
                try {
                    this._value = TextTools.convertExponentialValue(this._value);
                }
                catch (NumberFormatException ex) {
                    if (!LogRegistry.getInstance().logInfos()) break block16;
                    LogRegistry.getInstance().info(this.getClass(), "Unable to convert exponential value: " + this._value);
                }
            }
        }
        return this._value;
    }

    public boolean isUsingDefaultValue() {
        return this.isUsingDefaultValue(true);
    }

    public boolean isUsingDefaultValue(boolean checkXuiDefault) {
        if (this._value == null || this._value.length() == 0) {
            return true;
        }
        XUIDefinition xuiDefinition = this.getXUIDefinition(false);
        StyleDefinition style = null;
        if (this._value.equals(this.getSchemaElement().getDefaultValue())) {
            return true;
        }
        if (this._value.equals(this.getSchemaElement().getFixedValue())) {
            return true;
        }
        if (xuiDefinition != null && (style = xuiDefinition.getStyle()) != null) {
            String defaultSelection;
            if (checkXuiDefault && this._value.equals(style.getLeafDefaultValue())) {
                return true;
            }
            if (style.isEnumeration() && (defaultSelection = style.getLeafEnumerationDefaultSelection()) != null && this._value.equals(defaultSelection)) {
                return true;
            }
        }
        return this._value.equals(this.getDefaultValue());
    }

    protected List initializeDerivedTypes() {
        if (this.getParent() != null && this.getParent().isList()) {
            this.getParent().getSchemaType();
        } else {
            this.getSchemaType();
        }
        return this.initializeDerivedTypes(this.getSchemaElement().getRefName());
    }

    public boolean isBoolean() {
        if (this._actAsDataType != null) {
            return this._actAsDataType == 3;
        }
        if (this.getSchemaType().isSimple()) {
            return this.getSimpleSchemaType().isBoolean();
        }
        return false;
    }

    public boolean isChoice() {
        boolean typeChoice = super.isChoice();
        if (typeChoice) {
            return true;
        }
        XUIDefinition xuiDef = this.getXUIDefinition(false);
        return xuiDef != null && xuiDef.getStyle().isEnumeration();
    }

    public boolean isColor() {
        String xsdBaseName = this.getSchemaElement().getRefName();
        return this._extendedType != null && this._extendedType.equals("Color");
    }

    public boolean isPassword() {
        return this._extendedType != null && this._extendedType.equals("password");
    }

    public boolean isHTMLContent() {
        return this._extendedType != null && this._extendedType.equals("html");
    }

    public boolean isDate() {
        if (this._actAsDataType != null) {
            return this._actAsDataType == 10;
        }
        if (!this.getSchemaType().isSimple()) {
            return false;
        }
        return this.getSimpleSchemaType().isDate();
    }

    public boolean isDateTime() {
        if (this._actAsDataType != null) {
            return this._actAsDataType == 8;
        }
        if (!this.getSchemaType().isSimple()) {
            return false;
        }
        return this.getSimpleSchemaType().isDateTime();
    }

    public boolean isDuration() {
        if (this._actAsDataType != null) {
            return this._actAsDataType == 7;
        }
        if (!this.getSchemaType().isSimple()) {
            return false;
        }
        return this.getSimpleSchemaType().isDuration();
    }

    public boolean isNumber() {
        if (this._actAsDataType != null) {
            switch (this._actAsDataType) {
                case 4: 
                case 5: 
                case 6: 
                case 33: 
                case 36: {
                    return true;
                }
            }
        }
        if (!this.getSchemaType().isSimple()) {
            return false;
        }
        return this.getSimpleSchemaType().isNumber();
    }

    public boolean isAnyType() {
        if (this.getSchemaType().isSimple()) {
            return this.getSimpleSchemaType().isAnyType();
        }
        return false;
    }

    public boolean isSimpleContent() {
        return this.getSchemaType().isMixedContent();
    }

    public boolean isSimple() {
        return true;
    }

    public boolean isString() {
        if (this._actAsDataType != null) {
            return this._actAsDataType == 2;
        }
        if (!this.getSchemaType().isSimple()) {
            return true;
        }
        return this.getSimpleSchemaType().isString();
    }

    public int compareValue(SimpleType with) {
        String valueString = this.getValue();
        String withString = with.getValue();
        if (valueString == null && withString == null) {
            return 0;
        }
        if (valueString == null) {
            return -1;
        }
        if (withString == null) {
            return 1;
        }
        if (this.isNumber() && with.isNumber()) {
            double withValue;
            double selfValue = Double.parseDouble(valueString);
            if (selfValue == (withValue = Double.parseDouble(withString))) {
                return 0;
            }
            if (selfValue < withValue) {
                return -1;
            }
            return 1;
        }
        return this.getValue().compareTo(with.getValue());
    }

    public boolean isTime() {
        if (this._actAsDataType != null) {
            return this._actAsDataType == 9;
        }
        if (!this.getSchemaType().isSimple()) {
            return false;
        }
        return this.getSimpleSchemaType().isTime();
    }

    public boolean isVisualizer() {
        return this._extendedType != null && this._extendedType.equals("Visualizer");
    }

    public void release() {
        _list = EMPTY_VECTOR;
        this._contextKeyRefType = null;
        this._value = null;
        super.release();
    }

    public boolean remove() throws ListModificationException {
        boolean removed = false;
        if (this.getParent() != null) {
            removed = this.getParent().removeChild(this);
            this._value = null;
        }
        return removed;
    }

    public void removeAll() {
    }

    public boolean removeChild(Type child) {
        return false;
    }

    private void addXLink(StringBuffer sb) {
        if (this.getStyle().serializeAsXLink()) {
            sb.append(" xlink:");
            sb.append("href=");
            sb.append("\"");
            sb.append(this.getStyle().getCodeSetURL());
            sb.append("#xpointer(");
            sb.append(this.getStyle().getCodeSetXPointer());
            sb.append("[.=" + this.getValue() + "])");
            sb.append("\"");
        }
    }

    public void serialize(StringBuffer sb, int indent, boolean writeName, boolean recursive, boolean serializeEmptyContent) {
        SerializationModifier serModifier = this.getDOM().getSerializationModifier();
        if (serModifier != null && !serModifier.serialize(this)) {
            return;
        }
        super.serialize(sb, indent, writeName, recursive, serializeEmptyContent);
        if (!serializeEmptyContent) {
            serializeEmptyContent = this.getDOM().getGlobalDefinition().isSerializingEmptyContent() && this.isMandatoryAxis();
        }
        int tagStartIndex = sb.length();
        if (serializeEmptyContent || this.isSerializable()) {
            String name = this.getSerializationName();
            String value = this.getValue();
            if (value == null) {
                value = NOT_SET;
                if ((serializeEmptyContent || this.getParent().isChoice() && this.getParent().getChoosenType() == this) && this.getDOM().getGlobalDefinition().isSerializingSimpleDefaultNullValue()) {
                    value = this.getDefaultNullValue();
                }
            }
            if (this.isAnyType()) {
                this.serializeExtendedPI(sb, indent);
                sb.append(value);
            } else {
                value = this.getStyle().isSerializableAsCDATA() ? "<![CDATA[" + value + "]]>" : TextTools.replaceGlobalEntities(value);
                this.serializeExtendedPI(sb, indent);
                if (this.isSimpleContent()) {
                    sb.append(value);
                } else {
                    if (writeName && !this.isAnonymous()) {
                        sb.append("\n");
                        if (indent > 0) {
                            this.makeIndent(sb, indent);
                        }
                        if (value.length() == 0) {
                            sb.append("<");
                            sb.append(name);
                            if (serModifier != null) {
                                serModifier.modifyStartTag(this, sb, tagStartIndex);
                            }
                            this.addXLink(sb);
                            sb.append("/>");
                            return;
                        }
                        sb.append("<");
                        sb.append(name);
                        if (serModifier != null) {
                            serModifier.modifyStartTag(this, sb, tagStartIndex);
                        }
                        this.addXLink(sb);
                        sb.append(">");
                    }
                    if (serModifier != null) {
                        serModifier.modifySimpleTagValue(this, value, sb);
                    } else {
                        sb.append(value);
                    }
                    if (writeName && !this.isAnonymous()) {
                        sb.append("</");
                        sb.append(name);
                        sb.append(">");
                    }
                }
            }
        }
    }

    private String serializeExtendedPI(StringBuffer value, int indent) {
        String piVal = null;
        return piVal;
    }

    public String translateToCodeSetValue() {
        return this.getStyle().translateToCodeSetValue(this, this.getValue());
    }

    public String translateToCodeSetValue(String value) {
        return this.getStyle().translateToCodeSetValue(this, value);
    }

    public String getCodeSetParam() {
        String codeset = this.getStyle().getCodeSetName();
        String value = this.getValue();
        if (codeset != null) {
            if (value == null || value.equals(NOT_SET)) {
                return NOT_SET;
            }
        } else {
            return null;
        }
        value = this.getDOM().getSchema().getCodeTables().getEntryParam(this, codeset, value, this.getDOM().getLanguage());
        return value;
    }

    public String getCodeSetHelp() {
        String codeset = this.getStyle().getCodeSetName();
        String value = this.getValue();
        if (codeset != null) {
            if (value == null || value.equals(NOT_SET)) {
                return NOT_SET;
            }
        } else {
            return null;
        }
        value = this.getDOM().getSchema().getCodeTables().getEntryHelp(this, codeset, value, this.getDOM().getLanguage());
        return value;
    }

    private String handleDotZero(String newValue) {
        if (newValue != null) {
            if (this.isBoolean()) {
                if (newValue.endsWith(".0")) {
                    newValue = newValue.substring(0, newValue.length() - 2);
                }
                if (newValue.equals("1")) {
                    newValue = "true";
                } else if (newValue.equals(ZERO_NUMBER)) {
                    newValue = BOOLEAN_FALSE;
                }
            }
            if (this.isNumber() && newValue.endsWith(".0") && !this.isFloatingNumber()) {
                newValue = newValue.substring(0, newValue.length() - 2);
            }
        }
        return newValue;
    }

    public void setValue(String newValue, boolean isTemporary) {
        this.setValue(null, newValue, isTemporary);
    }

    public void setValue(Object eventSource, String newValue, boolean isTemporary) {
        this.setValue(eventSource, newValue, isTemporary, true);
    }

    public void setValue(Object eventSource, String newValue, boolean isTemporary, boolean localeConversion) {
        this.setValue(eventSource, newValue, isTemporary, localeConversion, null);
    }

    public void setValue(Object eventSource, String newValue, boolean isTemporary, boolean localeConversion, Stack callStack) {
        String oldValue = null;
        newValue = this.applyWhiSpRestrict(newValue);
        if (!this.isReleased() && this.hasChanged(oldValue = this.getValue(), newValue)) {
            GlobalDefinition gDef = this.getDOM().getGlobalDefinition();
            try {
                if (newValue != null && newValue.length() == 0) {
                    newValue = null;
                }
                newValue = this.handleDotZero(newValue);
                try {
                    if (newValue != null) {
                        String parsedValue;
                        if (this.isNumber()) {
                            if (gDef.getDecimalFormat() != null) {
                                if (localeConversion) {
                                    newValue = TextTools.convertNumbersToNative(newValue, gDef.getDecimalFormat().getDecimalFormatSymbols());
                                }
                                newValue = gDef.convertExponentialValue(newValue);
                            }
                        } else if (this.isDate()) {
                            if (!JAXFrontDateTools.isISODate(newValue)) {
                                parsedValue = JAXFrontDateTools.formatToISODate(gDef.getDateFormat(), newValue);
                                newValue = parsedValue != null && parsedValue.length() > 0 ? parsedValue : newValue;
                            }
                        } else if (this.isDateTime()) {
                            if (!JAXFrontDateTools.isISODateTime(newValue)) {
                                if (newValue.startsWith("null")) {
                                    newValue = newValue.replaceFirst("null", gDef.getDateFormat().format(new Date()));
                                }
                                newValue = (parsedValue = JAXFrontDateTools.formatToISODateTime(gDef.getDateTimeFormat(), newValue, ((SchemaSimpleType)this.getSchemaType()).hasRegularExpression())) != null && parsedValue.length() > 0 ? parsedValue : newValue;
                            }
                        } else if (this.isTime()) {
                            if (!JAXFrontDateTools.isISOTime(newValue)) {
                                parsedValue = JAXFrontDateTools.formatToISOTime(gDef.getTimeFormat(), newValue);
                                newValue = parsedValue != null && parsedValue.length() > 0 ? parsedValue : newValue;
                            } else if (newValue.endsWith(".00")) {
                                newValue = newValue.substring(0, newValue.length() - 3);
                            }
                        } else if (this.isBoolean()) {
                            if ("1".equals(newValue)) {
                                newValue = "true";
                            } else if (ZERO_NUMBER.equals(newValue)) {
                                newValue = BOOLEAN_FALSE;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this._value = newValue;
                if (this.hasChanged(oldValue, newValue)) {
                    boolean isBinding = this.getDOM().isBinding();
                    if (!isBinding) {
                        if (!this.getDOM().getController().isBlockDirtyChange()) {
                            if (this._origValue == NOT_SET) {
                                this._origValue = oldValue;
                            }
                            if (this.hasChanged()) {
                                this.setHasChanged(true);
                            }
                        }
                        this.getDOM().getUndoManager().addPropertyChangeEditEvent(eventSource, this, newValue, oldValue);
                    }
                    this.getDOM().getController().getErrorController().removeValidationError(this);
                    String changeType = "propertyChange";
                    if (isTemporary) {
                        changeType = "propertyChange_temporary";
                    }
                    JAXFrontPropertyChangeEvent event = new JAXFrontPropertyChangeEvent(eventSource == null ? this : eventSource, this, changeType, oldValue, newValue, callStack);
                    this.getPropertyChangeSupport().firePropertyChange(event);
                    newValue = this._value;
                    if (!isBinding && newValue != null) {
                        this.validate(newValue, false);
                    }
                    if (!isBinding && eventSource != KeyContainer.class && !this.getDOM().isPasteMode()) {
                        if (this.isKey()) {
                            this.getDOM().getKeyKeyRefManager().keyChanged(this);
                        }
                        if (this.isKeyRef()) {
                            this.getDOM().getKeyKeyRefManager().keyRefChanged(this);
                        }
                    }
                }
            }
            catch (ValidationException ex) {
                this.getDOM().getController().getErrorController().handleValidationException(this, ex);
            }
        }
    }

    private String applyWhiSpRestrict(String newValue) {
        if (newValue != null) {
            boolean spAsNull = JAXFrontProperties.getInstance(this.getDOM().getAppContext()).handleOnlySpacesAsNull();
            if (spAsNull && newValue.trim().length() == 0) {
                return null;
            }
            if (this.getSchemaType().isSimple()) {
                switch (this.getPrimitiveDataType()) {
                    case 16: 
                    case 17: 
                    case 36: {
                        break;
                    }
                    default: {
                        newValue = TextTools.applyWhiteSpaceRestriction(newValue, ((SchemaSimpleType)this.getSchemaType()).getWhitespace());
                    }
                }
            }
            if (spAsNull && newValue.trim().length() == 0) {
                newValue = null;
            }
        }
        return newValue;
    }

    public void setValue(String newValue) {
        this.setValue(newValue, false);
    }

    public String toString() {
        return this.getDisplayValue();
    }

    public String toInfoString() {
        String parentString = this.getParent() != null ? this.getParent().getXPathLocation() : "(no parent)";
        return this.getClass().getName() + "\n" + "Name:       " + this.getName() + "\n" + "Value:      " + this.getPlainValue() + "\n" + "XPath:      " + this.getXPathLocation() + "\n" + "Parent:     " + parentString + "\n" + "HashCode:   " + this.hashCode() + "\n" + "ID:         " + SimpleType.printId(this.getId()) + "\n" + "isDerrived: " + this.isDerived() + "\n" + "isAbstract: " + this.isAbstract() + "\n" + "isReleased: " + this.isReleased();
    }

    public static String printId(short[] id) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < id.length; ++i) {
            result.append(id[i] + "_");
        }
        return result.toString();
    }

    public String getDisplayValue() {
        return this.getDisplayValue(this.getValue());
    }

    public String getDisplayValue(String value) {
        String result = value;
        if (result == null) {
            return NOT_SET;
        }
        try {
            DecimalFormat dformat = this.getDOM().getGlobalDefinition().getDecimalFormat();
            boolean isUsingGroupDelim = this.getStyle().isUsingGroupingDelimiters();
            int basicType = this.getPrimitiveDataType();
            switch (basicType) {
                case 4: {
                    return TextTools.convertNumbersToView(result, dformat, isUsingGroupDelim);
                }
                case 6: {
                    return TextTools.convertNumbersToView(result, dformat, isUsingGroupDelim);
                }
                case 5: {
                    return TextTools.convertNumbersToView(result, dformat, isUsingGroupDelim);
                }
                case 33: {
                    return TextTools.convertNumbersToView(result, dformat, isUsingGroupDelim);
                }
                case 38: {
                    return TextTools.convertNumbersToView(result, dformat, isUsingGroupDelim);
                }
                case 10: {
                    return this.getDOM().getGlobalDefinition().getDateFormat().format(JAXFrontDateTools.isoDateFormat.parse(result));
                }
                case 8: {
                    return this.getDOM().getGlobalDefinition().getDateTimeFormat().format(JAXFrontDateTools.isoDateTimeFormat.parse(result));
                }
                case 9: {
                    if (this.getStyle().getTimeFormat() != null) {
                        try {
                            return JAXFrontDateTools.formatTo(JAXFrontDateTools.isoTimeFormat, result, this.getStyle().getTimeFormat());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return this.getDOM().getGlobalDefinition().getTimeFormat().format(JAXFrontDateTools.isoTimeFormat.parse(result));
                }
                case 3: {
                    return "true".equals(result) ? GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_yes", "Yes") : GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_no", "No");
                }
            }
            if (result.length() > 0) {
                String translation;
                result = String.valueOf(TextTools.replace(result, '\n', ' '));
                if (this.getXUIDefinition().getStyle().isUsingCodeSet() && (translation = this.translateToCodeSetValue(result)) != null) {
                    result = translation;
                }
            }
            return result;
        }
        catch (Exception e) {
            return NOT_SET;
        }
    }

    public void validate() {
        try {
            this.validate(this.getValue());
        }
        catch (ValidationException ex) {
            this.getDOM().getController().getErrorController().handleValidationException(this, ex);
        }
    }

    public void validate(boolean domIsValidating) {
        try {
            this.validate(this.getValue(), false, domIsValidating);
        }
        catch (ValidationException ex) {
            this.getDOM().getController().getErrorController().handleValidationException(this, ex);
        }
    }

    private void validate(String newValue) throws ValidationException {
        this.validate(newValue, false);
    }

    private void validate(String newValue, boolean allowEmptyValue) throws ValidationException {
        this.validate(newValue, allowEmptyValue, false);
    }

    private void validate(String newValue, boolean allowEmptyValue, boolean domIsValidating) throws ValidationException {
        if (this.getSchemaType() instanceof SchemaSimpleType) {
            if (!(this.isRequired() || newValue != null && newValue.length() != 0)) {
                return;
            }
            if (!this.getSchemaType().isSimple()) {
                return;
            }
            SchemaSimpleType simpleType = (SchemaSimpleType)this.getSchemaType();
            if (newValue != null) {
                String text;
                boolean isBinding = this.getDOM().isBinding();
                simpleType.validate(this, newValue);
                String codeSet = this.getStyle().getCodeSetName();
                if (codeSet != null && CodeTables.isValueInvalid(text = this.getDOM().getSchema().getCodeTables().getText(this, codeSet, newValue, this.getDOM().getLanguage()), this.getDOM().getLanguage()) && this.getStyle().isEnumerationShowErrorForInvalidCodes()) {
                    throw ValidationException.createInvalidCodeSetCodeException(this, text);
                }
                if (!isBinding) {
                    if (!domIsValidating) {
                        if (this.isKeyRef()) {
                            this.checkKeyExist(newValue);
                        }
                        if (this.isKey()) {
                            this.checkDuplicateKey(newValue);
                        }
                    }
                    if (domIsValidating && this.getSchemaType().isSimple() && this.getSimpleSchemaType().isID()) {
                        this.checkDuplicateID(newValue);
                    }
                }
            }
        }
    }

    public void checkKeyExist(String keyValue) throws ValidationException {
        KeyRefDefinition refDef;
        if (keyValue != null && (refDef = this.getKeyRefDefinition()) != null) {
            SchemaKeyRef skr = refDef.getSchemakeyRef();
            KeyContextWrapper context = new KeyContextWrapper(KeyContainer.createContext(this, skr.getKey().getSchemaElement()));
            KeyContainer container = this.getDOM().getKeyKeyRefManager().getKeyContainer(this.getReferencedKeyName(), context);
            Type refKey = container.getKeyTypeForValue(keyValue);
            if (refKey == null) {
                throw ValidationException.createMissingKeyException(this, keyValue);
            }
        }
    }

    public void checkKeyExist() throws ValidationException {
        this.checkKeyExist(this._value);
    }

    public void checkDuplicateKey(String newValue) throws ValidationException {
        if (newValue != null) {
            List containers = this.getDOM().getKeyKeyRefManager().getKeyContainer(this, this.getSchemaElement().getSchemaKeys());
            for (int c = 0; c < containers.size(); ++c) {
                KeyContainer container = (KeyContainer)containers.get(c);
                List foundKeys = container.getKeyTypesForValue(newValue);
                if (foundKeys == null || foundKeys.size() <= 1) continue;
                throw ValidationException.createDuplicateKeyException(this, newValue);
            }
        }
    }

    public void checkDuplicateID(String newValue) throws ValidationException {
        List ids = TypePathExecuter.getInstance().getAllIDs(this.getDOM(), this.getName(), false);
        ids.remove(this);
        Iterator idIterator = ids.iterator();
        String currentValue = null;
        while (idIterator.hasNext()) {
            SimpleType aType = (SimpleType)idIterator.next();
            if (!aType.isSerializable(false) || !newValue.equals(currentValue = aType.getPlainValue())) continue;
            throw ValidationException.createDuplicateIDException(this, newValue);
        }
    }

    public List checkForDuplicateID() throws ValidationException {
        List ids = TypePathExecuter.getInstance().getAllIDs(this.getDOM(), this.getName(), false);
        Vector<ValidationException> duplicateIDs = new Vector<ValidationException>();
        Hashtable<String, Type> allKeyType = new Hashtable<String, Type>();
        for (int i = 0; i < ids.size(); ++i) {
            Type oldElement;
            Type aType = (Type)ids.get(i);
            if (!aType.isSerializable(false) || (oldElement = allKeyType.put(aType.getDisplayValue(), aType)) == null) continue;
            duplicateIDs.add(ValidationException.createDuplicateIDException((SimpleType)oldElement, oldElement.getDisplayValue()));
        }
        return duplicateIDs;
    }

    public long getMinLength() {
        if (!this.getSchemaType().isSimple()) {
            return Long.MIN_VALUE;
        }
        return this.getSimpleSchemaType().getMinLength();
    }

    public double getMaxInclValue() {
        return this.getSimpleSchemaType().getMaxInclValue();
    }

    public double getMaxExclValue() {
        return this.getSimpleSchemaType().getMaxExclValue();
    }

    public double getMinInclValue() {
        return this.getSimpleSchemaType().getMinInclValue();
    }

    public int getTotalDigit() {
        return this.getSimpleSchemaType().getTotalDigits();
    }

    public double getMinExclValue() {
        return this.getSimpleSchemaType().getMinExclValue();
    }

    public long getMaxLength() {
        if (!this.getSchemaType().isSimple()) {
            return Long.MAX_VALUE;
        }
        return this.getSimpleSchemaType().getMaxLength();
    }

    public boolean hasRegularExpression() {
        if (!this.getSchemaType().isSimple()) {
            return false;
        }
        return this.getSimpleSchemaType().hasRegularExpression();
    }

    public Type getChild(String name) {
        return null;
    }

    public Type getChild(String name, String nameSpace) {
        return null;
    }

    public String getReferencedKeyName() {
        KeyRefDefinition refDef;
        if (this.isKeyRef() && (refDef = this.getKeyRefDefinition()) != null) {
            return refDef.getKeyName();
        }
        return null;
    }

    public Type getReferencedKeyType() {
        KeyRefDefinition refDef;
        Type key = null;
        if (this.isKeyRef() && (refDef = this.getKeyRefDefinition()) != null) {
            SchemaKeyRef skr = refDef.getSchemakeyRef();
            KeyContextWrapper context = new KeyContextWrapper(KeyContainer.createContext(this, skr.getKey().getSchemaElement()));
            KeyContainer keyContainer = this.getDOM().getKeyKeyRefManager().getKeyContainer(skr.getKeyName(), context);
            if (keyContainer != null) {
                key = keyContainer.getKeyTypeForValue(this.getPlainValue());
            }
        }
        return key;
    }

    public ListType evaluateKeyHolderList() {
        KeyRefDefinition refDef;
        ListType key = null;
        if (this.isKeyRef() && (refDef = this.getKeyRefDefinition()) != null) {
            SchemaKeyRef skr = refDef.getSchemakeyRef();
            KeyContextWrapper context = new KeyContextWrapper(KeyContainer.createContext(this, skr.getKey().getSchemaElement()));
            KeyContainer keyContainer = this.getDOM().getKeyKeyRefManager().getKeyContainer(skr.getKeyName(), context);
            if (keyContainer != null) {
                key = keyContainer.getHolderList();
            }
        }
        return key;
    }

    public Type evaluatePossibleKeyType() {
        Type key = null;
        KeyContainer keyContainer = this.evaluatePossibleKeyContainer();
        if (keyContainer != null) {
            key = keyContainer.getPossibleKeyType();
        }
        return key;
    }

    public KeyContainer evaluatePossibleKeyContainer() {
        KeyRefDefinition refDef;
        KeyContainer keyContainer = null;
        if (this.isKeyRef() && (refDef = this.getKeyRefDefinition()) != null) {
            SchemaKeyRef skr = refDef.getSchemakeyRef();
            KeyContextWrapper context = new KeyContextWrapper(KeyContainer.createContext(this, skr.getKey().getSchemaElement()));
            keyContainer = this.getDOM().getKeyKeyRefManager().getKeyContainer(skr.getKeyName(), context);
        }
        return keyContainer;
    }

    public KeyRefDefinition getKeyRefDefinition() {
        ArrayList refDefs = this.getSchemaElement().getSchemaKeyRefs();
        for (int r = 0; r < refDefs.size(); ++r) {
            KeyRefDefinition refDef = (KeyRefDefinition)refDefs.get(0);
            if (!KeyContainer.isSelectorParent(refDef.getSelectorNode(), this)) continue;
            return refDef;
        }
        return null;
    }

    private boolean hasChanged(String oldValue, String newValue) {
        boolean hasChanged = false;
        if (newValue == null && oldValue != null) {
            hasChanged = true;
        } else if (newValue != null && oldValue == null) {
            hasChanged = true;
        } else if (newValue != null && !oldValue.equals(newValue)) {
            hasChanged = true;
        }
        return hasChanged;
    }

    public void domChanged(DOMChangeEvent event) {
    }

    public String getName() {
        if (this.isSimpleContent()) {
            return "text()";
        }
        return super.getName();
    }

    public void markAsDirtyXPath() {
        this.setDirtyXPath(true);
    }

    public boolean hasEmptyContent(boolean validationContext) {
        return this.hasEmptyContent(true, true);
    }

    public boolean hasEmptyContent(boolean checkSerializeDefaults, boolean checkDefaultValue) {
        if (this.getDOM() != null && this.getDOM().getSerializationModifier() != null && !this.getDOM().getSerializationModifier().serialize(this)) {
            return true;
        }
        boolean isEmpty = true;
        if (this.checkForEmptyContent()) {
            if (this.getDOM().getGlobalDefinition().isSerializingEmptyContent() && this.isRequired() && this.isMandatoryAxis(false)) {
                isEmpty = false;
            } else {
                String aValue = this.getValue();
                if (aValue != null && aValue.length() > 0 && this.getFixedValue() == null) {
                    isEmpty = false;
                    if (checkSerializeDefaults && this.getDOM().isSerializingDefaults() && this.isRequired() && this.isMandatoryAxis(false)) {
                        isEmpty = false;
                    } else if (checkDefaultValue && this.isUsingDefaultValue()) {
                        isEmpty = true;
                    }
                }
            }
        }
        return isEmpty;
    }

    public void setIsAttribute(boolean isAttribute) {
        this._isAttribute = isAttribute;
    }

    public Type deepClone(Document dom, boolean cloneChoices, boolean includingData, boolean includeEditingType, SchemaNode schemaNode, Element element) throws CloneNotSupportedException {
        if (dom != null) {
            this.setDOM(dom);
        }
        if (!includingData) {
            this._value = null;
        }
        Type clone = (Type)this.clone();
        return clone;
    }

    public String getDefaultNullValue() {
        String value = NOT_SET;
        String[][] enums = null;
        if (enums != null && enums.length > 0) {
            value = enums[0][0];
        } else if (this.isNumber()) {
            value = ZERO_NUMBER;
        } else if (this.isBoolean()) {
            value = this.getStyle().isBooleanViewRadioButtonUnselected() ? NOT_SET : BOOLEAN_FALSE;
        } else {
            if (this.isDate()) {
                return JAXFrontDateTools.getCurrentISODate();
            }
            if (this.isTime()) {
                value = TIME_ZERO;
            } else if (this.isDateTime()) {
                return JAXFrontDateTools.getCurrentISODate() + DATETIME_ZERO;
            }
        }
        if (this.getStyle().getSchemaEnumeration() != null && this.getStyle().getSchemaEnumeration().length > 0) {
            value = this.getStyle().getSchemaEnumeration()[0];
        }
        return value;
    }

    private byte initKeyType() {
        int type = 0;
        if (this.getSchemaElement().hasSchemaKeys() && this.getDOM().getKeyKeyRefManager().isKeyType(this, this.getSchemaElement().getSchemaKeys())) {
            type = 1;
        }
        if (this.getSchemaElement().hasSchemaKeyRefs() && this.getDOM().getKeyKeyRefManager().isKeyRefType(this, this.getSchemaElement().getSchemaKeyRefs())) {
            type = type == 1 ? 2 : 3;
        }
        return (byte)type;
    }

    public boolean isKey() {
        if (this._keyType == -1) {
            this._keyType = this.initKeyType();
        }
        return this._keyType <= 2 && this._keyType > 0;
    }

    public boolean isKeyRef() {
        if (this._keyType == -1) {
            this._keyType = this.initKeyType();
        }
        return this._keyType >= 2;
    }

    public SchemaSimpleType getSimpleSchemaType() {
        return (SchemaSimpleType)this.getSchemaType();
    }

    public String getUserDefaultValue() {
        String aDefault = this.getSchemaElement().getFixedValue();
        XUIDefinition xuiDefinition = this.getXUIDefinition(false);
        if (xuiDefinition != null) {
            String defaultSelection;
            StyleDefinition style = xuiDefinition.getStyle();
            if (aDefault == null || aDefault.length() == 0) {
                aDefault = style.getLeafDefaultValue();
            }
            if ((aDefault == null || aDefault.length() == 0) && style.isEnumeration() && (defaultSelection = style.getLeafEnumerationDefaultSelection()) != null) {
                aDefault = defaultSelection;
            }
        }
        if (aDefault == null || aDefault.length() == 0) {
            aDefault = this.getDefaultValue();
        }
        if ((aDefault == null || aDefault.length() == 0) && this.isBoolean()) {
            if (xuiDefinition != null && xuiDefinition.getStyle().isBooleanViewRadioButtonUnselected()) {
                aDefault = null;
            } else if (this.isMandatoryAxis(false)) {
                aDefault = BOOLEAN_FALSE;
            }
        }
        return aDefault;
    }

    public Type deepClone(Document dom, boolean cloneChoices, boolean includingData, SchemaNode schemaNode, Element element) throws CloneNotSupportedException {
        return this.deepClone(dom, cloneChoices, includingData, false, null, null);
    }

    public void removeChanged() {
        this._origValue = this._value;
    }

    public String getOriginalValue() {
        if (this._origValue == NOT_SET) {
            return null;
        }
        return this._origValue;
    }

    public boolean hasChanged() {
        if (this._origValue == NOT_SET) {
            return false;
        }
        if (this._origValue != null && this._origValue.equals(this._value)) {
            return false;
        }
        return this._value != this._origValue;
    }

    public Integer getActAsDataType() {
        return this._actAsDataType;
    }
}

