/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.type;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.xpath.XPathExecuterImpl;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class TypePathExecuter {
    private static TypePathExecuter _singleton;
    private static final String PREDICATE_START = "[";
    private static final String PREDICATE_END = "]";
    public static final String PREDICATE_LIST = "list";
    private static final String PREDICATE_LIST_IDENTIFIER = "[list]";
    private static final String PREDICATE_PATH_SEPARATOR = "/";

    public static ListType getIndexedComponentListType(Type rootType, String xpath) {
        String listPredicate = PREDICATE_LIST_IDENTIFIER;
        xpath = TextTools.replace(xpath, listPredicate, "");
        int lastIndex = xpath.lastIndexOf(PREDICATE_START);
        xpath = xpath.substring(0, lastIndex);
        String relativeXPath = TypePathExecuter.getRelativeXPathLocation(xpath);
        relativeXPath = relativeXPath + listPredicate;
        List result = TypePathExecuter.getInstance().processXPath(rootType, relativeXPath);
        if (result.size() == 1) {
            return (ListType)result.get(0);
        }
        return null;
    }

    public static TypePathExecuter getInstance() {
        if (_singleton == null) {
            _singleton = new TypePathExecuter();
            return _singleton;
        }
        return _singleton;
    }

    public static String getRelativeXPathLocation(String xpath) {
        StringTokenizer st = new StringTokenizer(xpath, "[]");
        String token = null;
        int counter = 0;
        String newXPath = null;
        while (st.hasMoreElements()) {
            token = st.nextToken();
            if (counter % 2 == 0) {
                newXPath = counter > 0 ? newXPath + token : token;
            } else if (token.equals(PREDICATE_LIST)) {
                newXPath = newXPath + PREDICATE_LIST_IDENTIFIER;
            }
            ++counter;
        }
        return newXPath;
    }

    public static boolean isAddressingIndexedComponent(String xpath) {
        boolean isAddressingIndexedComponent = false;
        int lastIndex = xpath.indexOf(PREDICATE_START);
        while (lastIndex != -1) {
            String indexArea = (xpath = xpath.substring(lastIndex + 1, xpath.length())).substring(0, xpath.indexOf(PREDICATE_END));
            if (!StringUtil.isInteger(indexArea)) {
                isAddressingIndexedComponent = false;
                break;
            }
            isAddressingIndexedComponent = true;
            lastIndex = xpath.indexOf(PREDICATE_START);
        }
        return isAddressingIndexedComponent;
    }

    public static boolean isLastAddressingIndexedComponent(String xpath) {
        boolean isAddressingIndexedComponent = false;
        int lastIndexPathSeparator = xpath.lastIndexOf(PREDICATE_PATH_SEPARATOR);
        int lastIndexStart = xpath.lastIndexOf(PREDICATE_START);
        if (lastIndexStart != -1 && lastIndexStart > lastIndexPathSeparator) {
            int lastIndexEnd = xpath.indexOf(PREDICATE_END, lastIndexStart);
            String indexArea = xpath.substring(lastIndexStart + 1, lastIndexEnd);
            isAddressingIndexedComponent = StringUtil.isNumeric(indexArea);
        }
        return isAddressingIndexedComponent;
    }

    public Type getTypeForXPath(Type rootType, String xpath) {
        return this.getTypeForXPath(rootType, xpath, false);
    }

    public Type getTypeForXPath(Type rootType, String xpath, boolean isEditingTypeIncluded) {
        return this.getTypeForXPath(rootType, xpath, isEditingTypeIncluded, false);
    }

    public Type getTypeForXPath(Type rootType, String xpath, boolean isEditingTypeIncluded, boolean isListTypeIncluded) {
        List list = this.processXPath(rootType, xpath, isEditingTypeIncluded, isListTypeIncluded, false);
        if (list != null && list.size() > 0) {
            return (Type)list.get(0);
        }
        return null;
    }

    public Type getTypeForXPath(Type rootType, String xpath, boolean isEditingTypeIncluded, boolean isListTypeIncluded, boolean edTypeTraversal, boolean serializableOnly, boolean buildLazyChoices) {
        List list = this.processXPath(rootType, xpath, isEditingTypeIncluded, isListTypeIncluded, edTypeTraversal, serializableOnly, buildLazyChoices);
        if (list != null && list.size() > 0) {
            return (Type)list.get(0);
        }
        return null;
    }

    public List processXPath(Type rootType, String path) {
        return this.processXPath(rootType, path, false);
    }

    public List getAllIDs(Document dom, String idName, boolean onlySerializable) {
        List result = null;
        try {
            result = XPathExecuterImpl.getInstance().processXPath("//" + idName, dom.getRootType(), false, false, false, onlySerializable, false, true);
            return result;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return new Vector();
        }
    }

    public List processXPath(Type rootType, String path, boolean isEditingTypeIncluded) {
        return this.processXPath(rootType, path, isEditingTypeIncluded, false, false);
    }

    public List processXPath(Type rootType, String path, boolean isEditingTypeIncluded, boolean isListTypeIncluded) {
        return this.processXPath(rootType, path, isEditingTypeIncluded, isListTypeIncluded, false);
    }

    public List processXPath(Type rootType, String path, boolean isEditingTypeIncluded, boolean isListTypeIncluded, boolean edTypeTraversal) {
        return this.processXPath(rootType, path, isEditingTypeIncluded, isListTypeIncluded, edTypeTraversal, false);
    }

    public List processXPath(Type rootType, String path, boolean isEditingTypeIncluded, boolean isListTypeIncluded, boolean edTypeTraversal, boolean serializableOnly) {
        return this.processXPath(rootType, path, isEditingTypeIncluded, isListTypeIncluded, edTypeTraversal, serializableOnly, false);
    }

    public List processXPath(Type rootType, String path, boolean isEditingTypeIncluded, boolean isListTypeIncluded, boolean edTypeTraversal, boolean serializableOnly, boolean buildLazyChoices) {
        return this.processXPath(rootType, path, isEditingTypeIncluded, isListTypeIncluded, edTypeTraversal, serializableOnly, buildLazyChoices, false);
    }

    public List processXPath(Type rootType, String path, boolean isEditingTypeIncluded, boolean isListTypeIncluded, boolean edTypeTraversal, boolean serializableOnly, boolean buildLazyChoices, boolean cachedMode) {
        return this.processXPath(rootType, path, isEditingTypeIncluded, isListTypeIncluded, edTypeTraversal, serializableOnly, buildLazyChoices, cachedMode, false);
    }

    public List processXPath(Type rootType, String path, boolean isEditingTypeIncluded, boolean isListTypeIncluded, boolean edTypeTraversal, boolean serializableOnly, boolean buildLazyChoices, boolean cachedMode, boolean choosenOnly) {
        try {
            return XPathExecuterImpl.getInstance().processXPath(path, rootType, isEditingTypeIncluded, isListTypeIncluded, edTypeTraversal, serializableOnly, buildLazyChoices, cachedMode, choosenOnly);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return new Vector(1);
        }
    }
}

