/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.ui;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TreeModel;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.XMLSchemaPositionSorter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class TreeNode
extends DefaultMutableTreeNode
implements PropertyChangeListener {
    protected TreeModel _model;
    protected String _toolTip;
    protected String _name;
    protected Document _DOM;
    protected Type _smartType;
    protected Icon _icon;
    protected Boolean _isCheckBoxSelected;
    protected long lastUpdateNameTS = -1L;
    protected long lastUpdateTTTS = -1L;

    public TreeNode(Object userObject) {
        super(userObject);
    }

    public TreeNode(TreeModel model, Type type) {
        super(type);
        ImageIcon icon;
        this._model = model;
        this._DOM = type.getDOM();
        this._smartType = type;
        if (type.getStyle().getTreeIcon() != null && (icon = JAXFrontProperties.getImageIcon(this._DOM.getFingerPrint().getXUIURL(), type.getStyle().getTreeIcon())) != null) {
            this.setIcon(icon);
        }
        type.getStyle().addPropertyChangeListener(this);
    }

    public void setType(Type type) {
        this._smartType = type;
    }

    public String getXPath() {
        StringBuffer xpath = new StringBuffer();
        this.getXPathLocation(xpath, 0, true, true);
        return xpath.toString();
    }

    private int getXPathLocation(StringBuffer xpath, int level, boolean prefixed, boolean uNameIncluded) {
        TreeNode nodeParent;
        Type localType = this.getType();
        String name = null;
        name = prefixed ? localType.getSerializationName() : localType.getName();
        if (!uNameIncluded && localType.isAnonymous()) {
            name = null;
        }
        if ((nodeParent = (TreeNode)this.getParent()) != null && nodeParent.getType() != null && nodeParent.getType().getSchemaElement() != null) {
            Type parent = nodeParent.getType();
            ++level;
            level = nodeParent.getXPathLocation(xpath, level, prefixed, uNameIncluded);
            String parentName = null;
            parentName = prefixed ? ((AbstractType)parent).getSerializationName() : ((AbstractType)parent).getName();
            if (!uNameIncluded && parent.isAnonymous()) {
                parentName = null;
            }
            if (name != null) {
                if (localType.isAttribute()) {
                    xpath.append("/");
                    xpath.append("@");
                    xpath.append(name);
                } else if (!localType.isList()) {
                    xpath.append("/");
                    xpath.append(name);
                } else if (localType.isList() && level == 0) {
                    xpath.append("/");
                    xpath.append(name);
                    xpath.append("[list]");
                }
            }
            if (parent.isList()) {
                boolean found = false;
                ListType parentList = localType.getParentList();
                int plSize = parentList.size();
                for (int counter = 0; counter < plSize; ++counter) {
                    if (this != parentList.get(counter)) continue;
                    found = true;
                    xpath.append("[");
                    xpath.append(counter + 1);
                    xpath.append("]");
                    break;
                }
                if (parentName != null && localType.isAttribute() && !found && !localType.isEditingType()) {
                    xpath.append("@");
                    xpath.append(parentName);
                }
            }
        } else if (name != null) {
            xpath.append("/");
            xpath.append(name);
        }
        return --level;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public int getPosition(TreeNode node) {
        if (this.children() == null) {
            return this.getChildCount();
        }
        Enumeration<javax.swing.tree.TreeNode> childs = this.children();
        TreeNode compareNode = null;
        int position = -1;
        int counter = 0;
        XMLSchemaPositionSorter sorter = this.getSorter();
        while (childs.hasMoreElements()) {
            compareNode = (TreeNode)childs.nextElement();
            boolean isGreater = sorter.compare(node.getType(), compareNode.getType());
            if (isGreater) {
                position = counter;
                break;
            }
            ++counter;
        }
        if (position == -1) {
            position = this.getChildCount();
        }
        return position;
    }

    public Type getType() {
        return this._smartType;
    }

    public String getVisualName() {
        String name = "";
        if (this.getType() == null) {
            this._name = name;
            return name;
        }
        if (this.lastUpdateNameTS < this._DOM.getLastDomUpdateTimeStamp()) {
            this.lastUpdateNameTS = this._DOM.getLastDomUpdateTimeStamp();
            if (this.isRoot() && this.getType().getClass().getName().equals("com.jaxfront.swing.ui.editor.NavigationTree$RootType")) {
                this._name = name = "root";
                return name;
            }
            name = this.getType().getStyle().getTreeLabelText();
            if (name == null) {
                name = this.getType().getName();
            }
            if (this.getType().isList() && !this.getType().getStyle().hasTreeLabelFormulaExpression() && name.equals(this.getType().getName()) && this.getType().getDOM() != null && this.getType().getDOM().getGlobalDefinition().getGlobalTreeListEnding() != null) {
                String ending = this.getType().getDOM().getGlobalDefinition().getGlobalTreeListEnding();
                name = name + ending;
            }
            this._name = name;
        }
        return this._name;
    }

    public String getToolTip() {
        if (this._toolTip == null && this.lastUpdateTTTS < this._DOM.getLastDomUpdateTimeStamp()) {
            this.lastUpdateTTTS = this._DOM.getLastDomUpdateTimeStamp();
            if (!this.getType().getClass().getName().equals("com.jaxfront.swing.ui.editor.NavigationTree$RootType")) {
                this._toolTip = this.getType().getStyle().getTreeEntryToolTip();
            }
        }
        return this._toolTip;
    }

    public String getHelpText() {
        return this.getHelpText(this.getType());
    }

    private String getHelpText(Type type) {
        if (type != null) {
            String helpText = type.getStyle().getHelpText();
            if (helpText == null && type.getParent() != null) {
                Type nextTreeNodeType = type.getParent().getRepresentedTreeNodeParent();
                return this.getHelpText(nextTreeNodeType);
            }
            return helpText;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String iconName = this.getType().getStyle().getTreeIcon();
        if (!this.getType().isReleased()) {
            ImageIcon icon = JAXFrontProperties.getImageIcon(this.getType().getDOM().getFingerPrint().getXUIURL(), iconName);
            this.setIcon(icon);
        }
    }

    public void setIcon(ImageIcon icon) {
        this._icon = icon;
    }

    public void setModel(TreeModel model) {
        this._model = model;
    }

    private XMLSchemaPositionSorter getSorter() {
        return this._model.getSorter();
    }

    public void releaseNode() {
        if (this.getType() != null) {
            this.getType().getStyle().getPropertyChangeSupport().removePropertyChangeListener(this);
            if (this.getType().getStyle().hasTreeLabelFormulaExpression()) {
                this.getType().getDOM().getController().removePropertyChangeListener(this);
            }
        }
        this._model = null;
        this._toolTip = null;
        this._DOM = null;
        this._smartType = null;
        this._icon = null;
        this.userObject = null;
    }

    public void release() {
        this.releaseNode();
        if (this.getChildCount() > 0) {
            Enumeration<javax.swing.tree.TreeNode> childs = this.children();
            while (childs.hasMoreElements()) {
                ((TreeNode)childs.nextElement()).release();
            }
        }
    }

    public void setIsCheckBoxSelected(boolean isSelected) {
        this._isCheckBoxSelected = new Boolean(isSelected);
        if (this.getType() != null) {
            this.getType().setVisible(isSelected);
            TypeVisualizerFactory.getInstance().getVisualizer(this.getType()).setVisible(isSelected);
            this.getType().setSerializable(isSelected);
            this.getType().getStyle().setIsVisibleInOptionalTreeMode(isSelected);
        }
    }

    public boolean isCheckBoxSelected() {
        if (this._isCheckBoxSelected != null) {
            return this._isCheckBoxSelected;
        }
        return this.getType().getStyle().isVisibleInOptionalTreeMode();
    }

    public boolean showCheckBox() {
        boolean showCheckBox = false;
        if (this.getType() != null) {
            showCheckBox = this.getType().getStyle().isTreeEntryShowAsOptional();
        }
        return showCheckBox;
    }

    public List getChildren() {
        return this.children;
    }
}

