/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

public class DoubleKeyHashtable
implements Cloneable,
Serializable {
    protected transient Entry[] table;
    protected transient int count;
    protected int threshold;
    protected float loadFactor;
    protected transient int modCount = 0;
    private static final long serialVersionUID = 1421746759512286392L;
    protected volatile transient Set keySet = null;
    protected volatile transient Set entrySet = null;
    protected volatile transient Collection values = null;
    protected static final int KEYS = 0;
    protected static final int VALUES = 1;
    protected static final int ENTRIES = 2;
    protected static EmptyEnumerator emptyEnumerator = new EmptyEnumerator();
    protected static EmptyIterator emptyIterator = new EmptyIterator();

    public DoubleKeyHashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public DoubleKeyHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public DoubleKeyHashtable() {
        this(11, 0.75f);
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return this.getEnumeration(0);
    }

    public synchronized Enumeration elements() {
        return this.getEnumeration(1);
    }

    public synchronized boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public synchronized boolean containsKey(Object key1, Object key2) {
        Entry[] tab = this.table;
        int hash1 = key1.hashCode();
        int hash2 = key2.hashCode();
        int compHash = hash1 ^ hash2;
        int index = (compHash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash1 && e.hash2 == hash2 && e.key.equals(key1) && e.key2.equals(key2)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized Object get(Object key, Object key2) {
        Entry[] tab = this.table;
        int hash1 = key.hashCode();
        int hash2 = key2.hashCode();
        int compHash = hash1 ^ hash2;
        int index = (compHash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if ((e.hash ^ e.hash2) == compHash && e.key.equals(key) && e.key2.equals(key2)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public synchronized List getPrimary(Object key) {
        Vector<Object> entriesToRemove = new Vector<Object>();
        Enumeration compK = this.keys();
        while (compK.hasMoreElements()) {
            Entry element = (Entry)compK.nextElement();
            if (element.key != key && !element.key.equals(key)) continue;
            entriesToRemove.add(element.value);
        }
        return entriesToRemove;
    }

    public synchronized List getSecondary(Object key) {
        Vector<Object> entriesToRemove = new Vector<Object>();
        Enumeration compK = this.keys();
        while (compK.hasMoreElements()) {
            Entry element = (Entry)compK.nextElement();
            if (element.key2 != key && !element.key2.equals(key)) continue;
            entriesToRemove.add(element.value);
        }
        return entriesToRemove;
    }

    public synchronized Object get(Entry keyEntry) {
        Entry[] tab = this.table;
        int hash1 = keyEntry.hash;
        int hash2 = keyEntry.hash2;
        int compHash = hash1 ^ hash2;
        int index = (compHash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if ((e.hash ^ e.hash2) == compHash && e.key.equals(keyEntry.key) && e.key2.equals(keyEntry.key2)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = ((e.hash ^ e.hash2) & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized Object put(Object key1, Object key2, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int hash1 = key1.hashCode();
        int hash2 = key2.hashCode();
        int compHash = hash1 ^ hash2;
        int index = (compHash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if ((e.hash ^ e.hash2) == compHash && e.key.equals(key1) && e.key2.equals(key2)) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (compHash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry(hash1, key1, hash2, key2, value, tab[index]);
        ++this.count;
        return null;
    }

    public synchronized Object removeValue(Object value) {
        Iterator entries = this.entrySet().iterator();
        Entry aEntryToRemove = null;
        while (entries.hasNext()) {
            Entry aEntry = (Entry)entries.next();
            if (aEntry.getValue() != value) continue;
            aEntryToRemove = aEntry;
            break;
        }
        if (aEntryToRemove != null) {
            return this.remove(aEntryToRemove);
        }
        return null;
    }

    public synchronized Object remove(Object key1, Object key2) {
        Entry[] tab = this.table;
        int hash1 = key1.hashCode();
        int hash2 = key2.hashCode();
        int compHash = hash1 ^ hash2;
        int index = (compHash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash1 && e.hash2 == hash2 && e.key.equals(key1) && e.key2.equals(key2)) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized Object remove(Entry aEntry) {
        Entry[] tab = this.table;
        int hash1 = aEntry.hash;
        int hash2 = aEntry.hash2;
        int compHash = hash1 ^ hash2;
        int index = (compHash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash1 && e.hash2 == hash2 && e.key.equals(aEntry.getKey()) && e.key2.equals(aEntry.getKey2())) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized int removePrimary(Object key) {
        Vector<Entry> entriesToRemove = new Vector<Entry>();
        Enumeration compK = this.keys();
        while (compK.hasMoreElements()) {
            Entry element = (Entry)compK.nextElement();
            if (!element.key.equals(key)) continue;
            entriesToRemove.add(element);
        }
        for (int e = 0; e < entriesToRemove.size(); ++e) {
            this.remove((Entry)entriesToRemove.get(e));
        }
        return entriesToRemove.size();
    }

    public synchronized int removeSecondary(Object key) {
        Vector<Entry> entriesToRemove = new Vector<Entry>();
        Enumeration compK = this.keys();
        while (compK.hasMoreElements()) {
            Entry element = (Entry)compK.nextElement();
            if (!element.key2.equals(key)) continue;
            entriesToRemove.add(element);
        }
        for (int e = 0; e < entriesToRemove.size(); ++e) {
            this.remove((Entry)entriesToRemove.get(e));
        }
        return entriesToRemove.size();
    }

    public synchronized void clear() {
        Entry[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            DoubleKeyHashtable t = (DoubleKeyHashtable)super.clone();
            t.table = new Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                t.table[i] = this.table[i] != null ? (Entry)this.table[i].clone() : null;
            }
            t.keySet = null;
            t.entrySet = null;
            t.values = null;
            t.modCount = 0;
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Iterator it = this.entrySet().iterator();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            Entry e = (Entry)it.next();
            Object key = e.getKey();
            Object key2 = e.getKey2();
            Object value = e.getValue();
            buf.append((key == this ? "(this Map)" : key) + ";" + (key2 == this ? "(this Map)" : key2) + "=" + (value == this ? "(this Map)" : value));
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    protected Enumeration getEnumeration(int type) {
        if (this.count == 0) {
            return emptyEnumerator;
        }
        return new Enumerator(type, false);
    }

    protected Iterator getIterator(int type) {
        if (this.count == 0) {
            return emptyIterator;
        }
        return new Enumerator(type, true);
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = Collections.synchronizedSet(new KeySet());
        }
        return this.keySet;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = Collections.synchronizedSet(new EntrySet());
        }
        return this.entrySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = Collections.synchronizedCollection(new ValueCollection());
        }
        return this.values;
    }

    public synchronized boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map t = (Map)o;
        if (t.size() != this.size()) {
            return false;
        }
        try {
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = (Map.Entry)i.next();
                Object key = e.getKey();
                Object value = e.getValue();
                if (!(value == null ? t.get(key) != null || !t.containsKey(key) : !value.equals(t.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    public synchronized int hashCode() {
        int h = 0;
        if (this.count == 0 || this.loadFactor < 0.0f) {
            return h;
        }
        this.loadFactor = -this.loadFactor;
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                h += e.key.hashCode() ^ e.key2.hashCode() ^ e.value.hashCode();
                e = e.next;
            }
        }
        this.loadFactor = -this.loadFactor;
        return h;
    }

    protected synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.count);
        for (int index = this.table.length - 1; index >= 0; --index) {
            Entry entry = this.table[index];
            while (entry != null) {
                s.writeObject(entry.key);
                s.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    public synchronized void test() {
        DoubleKeyHashtable dh = new DoubleKeyHashtable();
        int length = 4000;
        String[] k1 = new String[length];
        for (int i = 0; i < k1.length; ++i) {
            k1[i] = new String("k1-" + i);
        }
        String[] k2 = new String[length];
        for (int i = 0; i < k2.length; ++i) {
            k2[i] = new String("k2-" + i);
        }
        String[] v = new String[length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = new String("v-" + i);
        }
        dh.clear();
        System.gc();
        try {
            this.wait(3000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        Hashtable<String, String> ah = new Hashtable<String, String>();
        long start = System.currentTimeMillis();
        for (int i = 0; i < v.length; ++i) {
            ah.put(this.createTestStringKey(k1[i], k2[i]), v[i]);
        }
        for (int j = 0; j < v.length; ++j) {
            for (int i = 0; i < v.length; ++i) {
                ah.get(this.createTestStringKey(k1[i], k2[i]));
            }
        }
        long start2 = System.currentTimeMillis();
        System.out.println("ht:" + (start2 - start));
        ah = null;
        System.gc();
        try {
            this.wait(3000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        start2 = System.currentTimeMillis();
        for (int i = 0; i < v.length; ++i) {
            dh.put(k1[i], k2[i], v[i]);
        }
        for (int j = 0; j < v.length; ++j) {
            for (int i = 0; i < v.length; ++i) {
                dh.get(k1[i], k2[i]);
            }
        }
        long end = System.currentTimeMillis();
        System.gc();
        try {
            this.wait(3000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("dt:" + (end - start2));
    }

    public String createTestStringKey(String a, String b) {
        return a + b;
    }

    public static void main(String[] args) {
        new DoubleKeyHashtable().test();
    }

    protected static class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("DoubleKeyHashtable Iterator");
        }

        public void remove() {
            throw new IllegalStateException("DoubleKeyHashtable Iterator");
        }
    }

    protected static class EmptyEnumerator
    implements Enumeration {
        EmptyEnumerator() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("DoubleKeyHashtable Enumerator");
        }
    }

    protected class Enumerator
    implements Enumeration,
    Iterator {
        Entry[] table;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        boolean iterator;
        protected int expectedModCount;

        Enumerator(int type, boolean iterator) {
            this.table = DoubleKeyHashtable.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = DoubleKeyHashtable.this.modCount;
            this.type = type;
            this.iterator = iterator;
        }

        public boolean hasMoreElements() {
            Entry e = this.entry;
            int i = this.index;
            Entry[] t = this.table;
            while (e == null && i > 0) {
                e = t[--i];
            }
            this.entry = e;
            this.index = i;
            return e != null;
        }

        public Object nextElement() {
            Entry et = this.entry;
            int i = this.index;
            Entry[] t = this.table;
            while (et == null && i > 0) {
                et = t[--i];
            }
            this.entry = et;
            this.index = i;
            if (et != null) {
                Entry e = this.lastReturned = this.entry;
                this.entry = e.next;
                return this.type == 0 ? e : (this.type == 1 ? e.value : e);
            }
            throw new NoSuchElementException("DoubleKeyHashtable Enumerator");
        }

        public boolean hasNext() {
            return this.hasMoreElements();
        }

        public Object next() {
            if (DoubleKeyHashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextElement();
        }

        public void remove() {
            if (!this.iterator) {
                throw new UnsupportedOperationException();
            }
            if (this.lastReturned == null) {
                throw new IllegalStateException("DoubleKeyHashtable Enumerator");
            }
            if (DoubleKeyHashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            DoubleKeyHashtable doubleKeyHashtable = DoubleKeyHashtable.this;
            synchronized (doubleKeyHashtable) {
                Entry[] tab = DoubleKeyHashtable.this.table;
                int index = (this.lastReturned.hash & Integer.MAX_VALUE) % tab.length;
                Entry e = tab[index];
                Entry prev = null;
                while (e != null) {
                    if (e == this.lastReturned) {
                        ++DoubleKeyHashtable.this.modCount;
                        ++this.expectedModCount;
                        if (prev == null) {
                            tab[index] = e.next;
                        } else {
                            prev.next = e.next;
                        }
                        --DoubleKeyHashtable.this.count;
                        this.lastReturned = null;
                        return;
                    }
                    prev = e;
                    e = e.next;
                }
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        int hash2;
        Object key2;
        Object value;
        Entry next;

        protected Entry(int hash, Object key, int hash2, Object key2, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.hash2 = hash2;
            this.key2 = key2;
            this.value = value;
            this.next = next;
        }

        protected Object clone() throws CloneNotSupportedException {
            return new Entry(this.hash, this.key, this.hash2, this.key2, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getKey2() {
            return this.key2;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return (this.key == null && this.key2 == null ? e.getKey() == null && e.getKey2() == null : this.key.equals(e.getKey()) && this.key2.equals(e.getKey2())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.key2.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return "(" + this.key.toString() + " ; " + this.key2.toString() + ") =" + this.value.toString();
        }
    }

    protected class ValueCollection
    extends AbstractCollection {
        protected ValueCollection() {
        }

        public Iterator iterator() {
            return DoubleKeyHashtable.this.getIterator(1);
        }

        public int size() {
            return DoubleKeyHashtable.this.count;
        }

        public boolean contains(Object o) {
            return DoubleKeyHashtable.this.containsValue(o);
        }

        public void clear() {
            DoubleKeyHashtable.this.clear();
        }
    }

    protected class EntrySet
    extends AbstractSet {
        protected EntrySet() {
        }

        public Iterator iterator() {
            return DoubleKeyHashtable.this.getIterator(2);
        }

        public boolean contains(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)o;
            Object key = entry.getKey();
            Object key2 = entry.getKey2();
            Entry[] tab = DoubleKeyHashtable.this.table;
            int hash1 = key.hashCode();
            int hash2 = key2.hashCode();
            int compHash = hash1 ^ hash2;
            int index = (compHash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                if (e.hash == hash1 && e.hash2 == hash2 && e.equals(entry)) {
                    return true;
                }
                e = e.next;
            }
            return false;
        }

        public boolean remove(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)o;
            Object key = entry.getKey();
            Object key2 = entry.getKey2();
            Entry[] tab = DoubleKeyHashtable.this.table;
            int hash1 = key.hashCode();
            int hash2 = key2.hashCode();
            int compHash = hash1 ^ hash2;
            int index = (compHash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e.hash == hash1 && e.hash2 == hash2 && e.equals(entry)) {
                    ++DoubleKeyHashtable.this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    --DoubleKeyHashtable.this.count;
                    e.value = null;
                    return true;
                }
                prev = e;
                e = e.next;
            }
            return false;
        }

        public int size() {
            return DoubleKeyHashtable.this.count;
        }

        public void clear() {
            DoubleKeyHashtable.this.clear();
        }
    }

    protected class KeySet
    extends AbstractSet {
        protected KeySet() {
        }

        public Iterator iterator() {
            return DoubleKeyHashtable.this.getIterator(0);
        }

        public int size() {
            return DoubleKeyHashtable.this.count;
        }

        public boolean contains(Object o1, Object o2) {
            return DoubleKeyHashtable.this.containsKey(o1, o2);
        }

        public boolean remove(Object o, Object o2) {
            return DoubleKeyHashtable.this.remove(o, o2) != null;
        }

        public void clear() {
            DoubleKeyHashtable.this.clear();
        }
    }
}

