/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.util.ArrayUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

public class FilterableArray {
    private Comparator defaultComp = new DefaultComparator();
    public static final String DEFAULT_FILTER = "*";
    private int[] _filterMapping;
    private int _filterMatchCount;
    private int rowCount = -1;
    private TableFilter _tableFilter;
    private Vector _dataColNames = null;
    private Vector _data = null;
    private int[] _rowsToFilterOut;

    public void addRow(Object[] rowColumns) {
        this.getData().add(rowColumns);
    }

    public int getRowCount() {
        if (this.getCachedRowCount() == -1) {
            if (this.isFilterEnabled()) {
                if (this._rowsToFilterOut != null) {
                    this.doFilter(this._rowsToFilterOut);
                } else {
                    this.doFilter();
                }
            }
            this.setCachedRowCount(this._filterMapping != null ? this._filterMapping.length : this.getData().size());
            return this.getCachedRowCount();
        }
        return this.getCachedRowCount();
    }

    public int getColumnCount() {
        if (this._dataColNames == null && this.getData().size() > 0) {
            return ((Object[])this.getData().get(0)).length;
        }
        return this.getColNames().size();
    }

    public String getColumnName(int column) {
        return (String)this.getColNames().get(column);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        int actualRowIndex = rowIndex;
        if (this.isFilterEnabled()) {
            actualRowIndex = this._filterMapping[rowIndex];
        }
        return ((Object[])this.getData().get(actualRowIndex))[columnIndex];
    }

    private Object getValueFromMode(int rowIndex, int columnIndex) {
        return ((Object[])this.getData().get(rowIndex))[columnIndex];
    }

    public int getViewToModel(int rowIndex) {
        int actualRowIndex = rowIndex;
        if (rowIndex >= 0 && this.isFilterEnabled()) {
            actualRowIndex = this._filterMapping[rowIndex];
        }
        return actualRowIndex;
    }

    public int[] getFilterMapping() {
        return this._filterMapping;
    }

    private void setFilterMapping(int[] filterMapping) {
        this._filterMapping = filterMapping;
    }

    public void deleteRow(int selectedRow) {
        this.getData().remove(selectedRow);
    }

    private void doFilter() {
        this._filterMatchCount = 0;
        int rowCount = this.getData().size();
        int[] tmpMapping = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            boolean found = true;
            int fCols = this._tableFilter.getCols();
            for (int j = 0; found && j < fCols; ++j) {
                ColumnFilter colFilter = this._tableFilter.getColumnFilter(j);
                if (colFilter != null) {
                    int filterIdx = this._tableFilter.getFilterColIndexFor(j);
                    if (filterIdx == -1) {
                        found = true;
                        continue;
                    }
                    found = this._tableFilter.getColumnFilter(j).match((String)this.getValueFromMode(i, filterIdx));
                    continue;
                }
                found = true;
            }
            if (!found) continue;
            tmpMapping[this._filterMatchCount++] = i;
            found = false;
        }
        int[] currentFilterMapping = new int[this._filterMatchCount];
        System.arraycopy(tmpMapping, 0, currentFilterMapping, 0, this._filterMatchCount);
        this.setFilterMapping(currentFilterMapping);
    }

    private void doFilter(int[] rowsToFilter) {
        this._filterMatchCount = 0;
        int rowCount = this.getData().size();
        int[] tmpMapping = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            boolean found = false;
            for (int j = 0; j < rowsToFilter.length; ++j) {
                if (rowsToFilter[j] != i) continue;
                found = true;
                break;
            }
            if (found) continue;
            tmpMapping[this._filterMatchCount++] = i;
            found = false;
        }
        int[] currentFilterMapping = new int[this._filterMatchCount];
        System.arraycopy(tmpMapping, 0, currentFilterMapping, 0, this._filterMatchCount);
        this.setFilterMapping(currentFilterMapping);
    }

    public int getFilterMatchCount() {
        return this._filterMatchCount;
    }

    public void setFilterMatchCount(int filterMatches) {
        this.setCachedRowCount(-1);
        this._filterMatchCount = filterMatches;
    }

    public TableFilter getFilter() {
        return this._tableFilter;
    }

    public void setFilter(String[][] filters) {
        this._tableFilter = new TableFilter(filters);
        this._rowsToFilterOut = null;
        this.setCachedRowCount(-1);
    }

    public void setFilter(String[] filters) {
        this._tableFilter = new TableFilter(filters);
        this._rowsToFilterOut = null;
        this.setCachedRowCount(-1);
    }

    public void setFilteredRows(int[] rows) {
        this._rowsToFilterOut = rows;
        this.setCachedRowCount(-1);
    }

    public void resetFilters() {
        if (this._tableFilter != null) {
            this._tableFilter.reset();
        }
        this.setCachedRowCount(-1);
    }

    public int[] getFilteredRows() {
        return this._rowsToFilterOut;
    }

    public void setFilter(String[][] filters, int[] filterCols) {
        this._tableFilter = new TableFilter(filterCols, filters);
        this.setFilterColumns(filterCols);
        this._rowsToFilterOut = null;
        this.setCachedRowCount(-1);
    }

    boolean isFilterEnabled() {
        return this.getFilteredRows() != null || this.getFilter() != null && !"".equals(this.getFilter());
    }

    public int[] getFilterColumns() {
        return this._tableFilter.getColMapping();
    }

    public void setFilterColumns(int[] filterColumns) {
        this._rowsToFilterOut = null;
        if (this._tableFilter != null) {
            this._tableFilter.setColMapping(filterColumns);
        } else {
            this._tableFilter = new TableFilter(filterColumns);
        }
    }

    private void setCachedRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    private int getCachedRowCount() {
        return this.rowCount;
    }

    public Vector getColNames() {
        if (this._dataColNames == null) {
            this._dataColNames = new Vector();
        }
        return this._dataColNames;
    }

    public void addColName(String name) {
        this.getColNames().add(name);
    }

    public synchronized String[][] toArrayArray() {
        return this.toArrayArray(0, this.getRowCount());
    }

    public synchronized String[][] toArrayArray(int startRow, int rowCount) {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        int itCount = 0;
        if (rowCount == -1) {
            rowCount = rows;
        }
        if (startRow == -1) {
            startRow = 0;
        }
        String[][] result = new String[rowCount - startRow][cols];
        for (int i = startRow; i < rows && itCount < rowCount; ++i, ++itCount) {
            for (int j = 0; j < cols; ++j) {
                Object value = this.getValueAt(i, j);
                if (value == null) continue;
                result[itCount][j] = value.toString();
            }
        }
        return result;
    }

    public synchronized List toList() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        Vector<Object[]> result = new Vector<Object[]>(rows);
        for (int i = 0; i < rows; ++i) {
            Object[] aRow = new Object[cols];
            for (int j = 0; j < cols; ++j) {
                aRow[j] = this.getValueAt(i, j);
            }
            result.add(aRow);
        }
        return result;
    }

    public static void main(String[] args) {
        FilterableArray fa = new FilterableArray();
        fa.addRow(new String[]{"test", "test2", "test3"});
        fa.addRow(new String[]{"test", "test2", "test3"});
        fa.addRow(new String[]{"test", "test2", "test3"});
        fa.addRow(new String[]{"test", "test2", "test3"});
        fa.addRow(new String[]{"test", "test2", "test3"});
        fa.addRow(new String[]{"test", "test2", "test3"});
        fa.addRow(new String[]{"test", "test2", "test3"});
        fa.addRow(new String[]{"test", "test2", "test3"});
        fa.addRow(new String[]{"test", "test2", "test3"});
        fa.addRow(new String[]{"test1", "test21", "test3"});
        fa.addRow(new String[]{"test", "test2", "test3"});
        fa.setFilter(new String[][]{{"test", "test1"}, {"test*"}});
        System.out.println(ArrayUtil.toString(fa.toArrayArray(), ","));
    }

    public Vector getData() {
        if (this._data == null) {
            this._data = new Vector();
        }
        return this._data;
    }

    public class ColumnFilter {
        private String[] _filterValues;
        String colName;
        int logic;
        int colIndex;
        Comparator compImpl = null;

        public ColumnFilter(String[] filters) {
            this.setFilters(filters);
        }

        public void setFilters(String[] filters) {
            this._filterValues = filters;
        }

        public String[] getFilterValues() {
            return this._filterValues;
        }

        public Comparator getComparable() {
            if (this.compImpl == null) {
                return FilterableArray.this.defaultComp;
            }
            return this.compImpl;
        }

        public void setSortable(Comparator compImpl) {
            this.compImpl = compImpl;
        }

        public int getLogic() {
            return this.logic;
        }

        public boolean match(String value) {
            if (this._filterValues == null) {
                return true;
            }
            for (int i = 0; i < this._filterValues.length; ++i) {
                if (this.getComparable().compare(value, this._filterValues[i]) != 1) continue;
                return true;
            }
            return false;
        }
    }

    public class TableFilter {
        private ColumnFilter[] _colFilters;
        private int[] _cols = new int[0];

        public TableFilter(String[][] filters) {
            this._colFilters = new ColumnFilter[filters.length];
            this._cols = new int[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                ColumnFilter colF;
                this._colFilters[i] = colF = new ColumnFilter(filters[i]);
                this._cols[i] = i;
            }
        }

        public TableFilter(String[] filters) {
            this._colFilters = new ColumnFilter[filters.length];
            this._cols = new int[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                ColumnFilter colF;
                this._colFilters[i] = colF = new ColumnFilter(new String[]{filters[i]});
                this._cols[i] = i;
            }
        }

        public TableFilter(int[] cols, String[][] filters) {
            this._colFilters = new ColumnFilter[filters.length];
            this._cols = cols;
            for (int i = 0; i < filters.length; ++i) {
                ColumnFilter colF;
                this._colFilters[i] = colF = new ColumnFilter(filters[i]);
            }
        }

        public TableFilter(int[] cols) {
            this._cols = cols;
        }

        public TableFilter(int cols) {
            this._colFilters = new ColumnFilter[cols];
            this._cols = new int[cols];
            for (int i = 0; i < cols; ++i) {
                ColumnFilter colF;
                this._colFilters[i] = colF = new ColumnFilter(new String[]{FilterableArray.DEFAULT_FILTER});
                this._cols[i] = i;
            }
        }

        public ColumnFilter getColumnFilter(int index) {
            if (this._colFilters == null) {
                return null;
            }
            return this._colFilters[index];
        }

        public ColumnFilter getColumnFilter(String colName) {
            for (int i = 0; i < this._colFilters.length; ++i) {
                if (this._colFilters[i].colName != colName) continue;
                return this._colFilters[i];
            }
            return null;
        }

        public int getCols() {
            return this._cols.length;
        }

        public int[] getColMapping() {
            return this._cols;
        }

        public void setColMapping(int[] cols) {
            this._cols = cols;
        }

        public int getFilterColIndexFor(int col) {
            return this._cols[col];
        }

        public void reset() {
            this._colFilters = null;
        }

        public void setFilters(String[] filters) {
            for (int i = 0; i < filters.length; ++i) {
                ColumnFilter colF = this._colFilters[i];
                colF.setFilters(new String[]{filters[i]});
            }
        }
    }

    public class DefaultComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            if (arg0 == null) {
                arg0 = "";
            }
            if (arg1 == null) {
                arg1 = "";
            }
            if (arg1.equals(FilterableArray.DEFAULT_FILTER)) {
                return 1;
            }
            String aVal = arg0.toString().toLowerCase();
            String filter = arg1.toString().toLowerCase();
            boolean leftJ = filter.startsWith(FilterableArray.DEFAULT_FILTER);
            boolean rightJ = filter.endsWith(FilterableArray.DEFAULT_FILTER);
            boolean matches = false;
            if (rightJ && leftJ) {
                matches = aVal.indexOf(filter = filter.substring(1, filter.length() - 1)) >= 0;
            } else if (rightJ) {
                filter = filter.substring(0, filter.length() - 1);
                matches = aVal.startsWith(filter);
            } else if (leftJ) {
                filter = filter.substring(1);
                matches = aVal.endsWith(filter);
            } else {
                matches = aVal.equals(filter);
            }
            return matches ? 1 : 0;
        }
    }
}

