/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.ResourceWrapper;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.util.io.FileHelper;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.awt.image.ReplicateScaleFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageHelper {
    private static Hashtable _images;
    public static final byte[] NULL_IMAGE_DEF;
    public static final byte[] IMAGE_NOT_FOUND_DEF;
    public static final byte[] IMAGE_EMPTY;
    public static ImageIcon imageNotFound;
    public static ImageIcon imageEmpty;
    private static ImageHelper _instance;

    public static Image getScaledImage(Component imageHolder, Image image, int newWidth, int newHeight) {
        Image scaledImage = image;
        if (imageHolder != null && image != null && newWidth > 0 && newHeight > 0) {
            MediaTracker media = new MediaTracker(imageHolder);
            media.addImage(image, 0);
            try {
                media.waitForID(0);
                ReplicateScaleFilter replicate = new ReplicateScaleFilter(newWidth, newHeight);
                FilteredImageSource prod = new FilteredImageSource(image.getSource(), replicate);
                scaledImage = imageHolder.createImage(prod);
                media.addImage(scaledImage, 1);
                media.waitForID(1);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return scaledImage;
    }

    public static byte[] getImageNotFound() {
        byte[] imgNF = NULL_IMAGE_DEF;
        try {
            imgNF = FileHelper.readFile(URLHelper.getUserURL(null, "com/jaxfront/core/images/files/image_not_found.gif"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return imgNF;
    }

    public static byte[] getImageEmpty() {
        byte[] imgNF = NULL_IMAGE_DEF;
        try {
            imgNF = FileHelper.readFile(URLHelper.getUserURL(null, "com/jaxfront/core/images/files/transp.gif"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return imgNF;
    }

    public static ImageHelper getInstance() {
        if (_instance == null) {
            _instance = new ImageHelper();
        }
        return _instance;
    }

    public Hashtable getImages() {
        if (_images == null) {
            _images = new Hashtable();
        }
        return _images;
    }

    public int getLoadedImages() {
        return this.getImages().size();
    }

    public int getLoadedImagesSize() {
        Enumeration wrappers = this.getImageWrappers();
        int size = 0;
        while (wrappers.hasMoreElements()) {
            ResourceWrapper element = (ResourceWrapper)wrappers.nextElement();
            size += element.getContentSize();
        }
        return size;
    }

    public void removeImage(String key) {
        if (key != null) {
            this.getImages().remove(key);
        }
    }

    public static String getHTMLSpacerImageTag(Document dom) {
        return "<img class=\"spacerImage\" width=\"4px\" alt=\"\" src =\"_images/transp.gif\"</img>";
    }

    public Enumeration getImageWrappers() {
        return this.getImages().elements();
    }

    public void releaseImageCache() {
        this.getImages().clear();
    }

    public void releaseImageCache(String startsWith) {
        Iterator entries = this.getImages().keySet().iterator();
        while (entries.hasNext()) {
            Object aKey = entries.next();
            if (!aKey.toString().startsWith("resources/" + startsWith + "/")) continue;
            this.getImages().remove(aKey);
        }
    }

    public void releaseInternalizedImages() {
        Vector result = new Vector();
        Iterator entries = this.getImages().entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry element = entries.next();
            Object key = element.getKey();
            ResourceWrapper value = (ResourceWrapper)element.getValue();
            if (!value.isInternalized()) continue;
            result.add(key);
        }
        for (int r = 0; r < result.size(); ++r) {
            this.getImages().remove(result.get(r));
        }
    }

    public ResourceWrapper getImageIconWrapper(URL baseURL, String imageName, boolean createNullImage) {
        ResourceWrapper wrapper;
        block11: {
            wrapper = null;
            if (imageName != null) {
                String imageKey = imageName;
                if (this.getImages().get(imageKey) != null) {
                    wrapper = (ResourceWrapper)this.getImages().get(imageKey);
                } else {
                    Image img = null;
                    try {
                        byte[] imageAsByte = null;
                        int imageSize = 0;
                        URL imageUrl = URLHelper.getUserURL(imageName);
                        URL uRL = imageUrl = imageUrl != null ? imageUrl : URLHelper.getUserURL(baseURL, imageName);
                        if (imageUrl != null && (imageAsByte = FileHelper.readFile(imageUrl)) != null) {
                            img = Toolkit.getDefaultToolkit().createImage(imageAsByte);
                            imageSize = imageAsByte.length;
                        }
                        ImageIcon imageIcon = null;
                        if (img != null) {
                            imageIcon = new ImageIcon(img);
                        } else if (createNullImage) {
                            if (JAXFrontProperties.LOG_ENABLED) {
                                LogRegistry.getInstance().error(JAXFrontProperties.class, "Can't find imagefile:" + imageName);
                            }
                            imageIcon = new ImageIcon(NULL_IMAGE_DEF);
                            imageSize = NULL_IMAGE_DEF.length;
                        }
                        if (imageIcon != null) {
                            wrapper = new ResourceWrapper(imageKey, imageIcon, false);
                            wrapper.setContentSize(imageSize);
                            this.getImages().put(imageKey, wrapper);
                        }
                    }
                    catch (Throwable t) {
                        ImageIcon imageIcon = imageNotFound;
                        int imageSize = 0;
                        wrapper = new ResourceWrapper(imageKey, imageIcon, false);
                        wrapper.setContentSize(imageSize);
                        this.getImages().put(imageKey, wrapper);
                        if (!JAXFrontProperties.LOG_ENABLED) break block11;
                        LogRegistry.getInstance().error(JAXFrontProperties.class, "Can't find imagefile: " + t.getMessage());
                    }
                }
            }
        }
        return wrapper;
    }

    public void putImage(String key, byte[] value, boolean internalized) {
        ImageIcon newIcon = new ImageIcon(value);
        ResourceWrapper rw = new ResourceWrapper(key, newIcon, internalized);
        rw.setContentSize(value.length);
        this.getImages().put(key, rw);
    }

    public static URL getImageUrl(String imageName) {
        ClassLoader cl = JAXFrontProperties.class.getClassLoader();
        URL resourceURL = cl.getResource(imageName);
        return resourceURL;
    }

    public Image getImage(String imageName) {
        Image image = null;
        ImageIcon imageIcon = this.getImageIcon(imageName);
        if (imageIcon != null) {
            image = imageIcon.getImage();
        }
        return image;
    }

    public ImageIcon getImageIcon(String imageName) {
        return this.getImageIcon(null, imageName);
    }

    public ImageIcon getImageIcon(URL baseURL, String imageName) {
        ResourceWrapper wrapper = this.getImageIconWrapper(baseURL, imageName, true);
        if (wrapper != null) {
            return (ImageIcon)wrapper.getContent();
        }
        return null;
    }

    public static byte[] createByteArray(Image image, String type) {
        return ImageHelper.createByteArray(new ImageIcon(image), type);
    }

    public static byte[] createByteArray(ImageIcon i, String type) {
        BufferedImage bi = new BufferedImage(i.getIconWidth(), i.getIconHeight(), 2);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(i.getImage(), 0, 0, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bi, type, baos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    static {
        NULL_IMAGE_DEF = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        IMAGE_NOT_FOUND_DEF = ImageHelper.getImageNotFound();
        IMAGE_EMPTY = ImageHelper.getImageEmpty();
        imageNotFound = new ImageIcon(Toolkit.getDefaultToolkit().createImage(URLHelper.getUserURL(null, "com/jaxfront/core/images/files/image_not_found.gif")));
        imageEmpty = new ImageIcon(Toolkit.getDefaultToolkit().createImage(URLHelper.getUserURL(null, "com/jaxfront/core/images/files/transp.gif")));
    }
}

