/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import [Lcom.jaxfront.core.type.Type;;
import [Ljava.lang.Integer;;
import [Ljava.lang.String;;
import com.jaxfront.core.jep.ArrayResult;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.MethodParameter;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.IntrospectionMethodParameter;
import com.jaxfront.core.util.ListEntry;
import com.jaxfront.core.util.MapHelper;
import com.jaxfront.core.util.MethodUtils;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.URLHelper;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.nfunk.jep.type.NULL;

public class IntroSpectionHelper {
    public static final String TYPE_BOOLEAN = "Boolean";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_STRING_ARRAY = "String[]";
    public static final String TYPE_STRING_ARRAY_2 = "StringArray";
    public static final String TYPE_INTEGER = "Integer";
    public static final String TYPE_BOOLEAN_PRIMITIVE = "boolean";
    public static final String TYPE_INTEGER_PRIMITIVE = "int";
    public static final String TYPE_COLOR = "Color";
    public static final String TYPE_VISUALIZER = "Visualizer";
    public static final String TYPE_TYPE = "Type";
    public static final String TYPE_TYPE_ARRAY = "Type[]";
    public static final String TYPE_URL = "URL";
    public static final String TYPE_INT_ARRAY = "int[]";
    public static final String TYPE_INT_ARRAY_2 = "intArray";
    public static final String TYPE_INTEGER_ARRAY = "Integer[]";
    public static final String TYPE_BYTE_ARRAY_NATIVE = "[B";
    public static final String TYPE_SHORT_ARRAY_NATIVE = "[S";
    public static final String TYPE_INT_ARRAY_NATIVE = "[I";
    public static final String TYPE_LONG_ARRAY_NATIVE = "[J";
    public static final String TYPE_FLOAT_ARRAY_NATIVE = "[F";
    public static final String TYPE_DOUBLE_ARRAY_NATIVE = "[D";
    public static final String TYPE_CHAR_ARRAY_NATIVE = "[C";
    public static final String TYPE_BOOLEAN_ARRAY_NATIVE = "[Z";
    public static final String TYPE_STRING_ARRAY_NATIVE = "[Ljava.lang.String;";
    public static IntroSpectionHelper _instance = null;
    static /* synthetic */ Class class$java$lang$Object;

    public static Object callFunktion(String className, String functionName) {
        return IntroSpectionHelper.callFunktion(className, null, null, functionName, null, null);
    }

    public static Object callFunktion(Object object, String functionName) {
        return IntroSpectionHelper.callFunktion(object, functionName, null, null);
    }

    public static Object getFieldValue(String fieldName, Object fieldHolder) throws Exception {
        Object o = null;
        try {
            Field field = IntroSpectionHelper.getField(fieldHolder.getClass(), fieldName);
            field.setAccessible(true);
            o = field.get(fieldHolder);
        }
        catch (SecurityException e) {
            LogRegistry.getInstance().error(fieldHolder.getClass(), "Can't access field!" + fieldName + " " + e.getMessage());
        }
        return o;
    }

    private static Field getField(Class class1, String fieldName) {
        Field field;
        block3: {
            field = null;
            try {
                field = class1.getDeclaredField(fieldName);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                if (class1.getSuperclass() == null) break block3;
                field = IntroSpectionHelper.getField(class1.getSuperclass(), fieldName);
            }
        }
        return field;
    }

    public static Object getPrivateFieldValue(String fieldName, Object fieldHolder) throws Exception {
        Object o = null;
        try {
            Field field = fieldHolder.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            o = field.get(fieldHolder);
        }
        catch (SecurityException e) {
            LogRegistry.getInstance().error(fieldHolder.getClass(), "Can't access field!" + fieldName + " " + e.getMessage());
        }
        return o;
    }

    public static void setPrivateFieldValue(String fieldName, Object fieldHolder, Object value) throws Exception {
        try {
            Field field = fieldHolder.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(fieldHolder, value);
        }
        catch (SecurityException e) {
            LogRegistry.getInstance().error(fieldHolder.getClass(), "Can't access field!" + fieldName + " " + e.getMessage());
        }
    }

    public static Object callFunktion(String className, Class[] constructorParamClasses, Object[] classParams, String functionName, Class[] functionParamsClasses, Object[] functionParams) {
        Object callInstance = IntroSpectionHelper.createObject(className, constructorParamClasses, classParams, null);
        return IntroSpectionHelper.callFunktion(callInstance, functionName, functionParamsClasses, functionParams);
    }

    public static Object callFunktion(Object callInstance, String functionName, Class[] functionParamsClasses, Object[] functionParams) {
        Object result = null;
        try {
            result = IntroSpectionHelper.callFunktion(callInstance, functionName, functionParamsClasses, functionParams, true);
        }
        catch (Throwable e) {
            // empty catch block
        }
        return result;
    }

    public static Object callFunktion(Object callInstance, String functionName, Class[] functionParamsClasses, Object[] functionParams, boolean catchExceptions) throws Throwable {
        Object result;
        block3: {
            result = null;
            if (callInstance != null) {
                try {
                    result = IntroSpectionHelper.doCallFunktion(callInstance, functionName, functionParamsClasses, functionParams);
                }
                catch (Throwable e) {
                    if (catchExceptions) break block3;
                    throw e;
                }
            }
        }
        return result;
    }

    private static Object doCallFunktion(Object callInstance, String functionName, Class[] functionParamsClasses, Object[] functionParams) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object result = null;
        if (callInstance != null) {
            if (functionParamsClasses == null) {
                functionParamsClasses = new Class[]{};
            }
            if (functionParams == null) {
                functionParams = new Object[]{};
            }
            if (functionName != null) {
                result = MethodUtils.invokeMethod(callInstance, functionName, functionParams, functionParamsClasses);
            }
        }
        return result;
    }

    public static Object callStaticFunktion(String className, String functionName, Object[] params) {
        Class[] functionParamsClasses = new Class[params.length];
        Object[] functionParams = new Object[params.length];
        for (int p = 0; p < params.length; ++p) {
            Object aParam;
            functionParams[p] = aParam = params[p];
            functionParamsClasses[p] = aParam == null ? (class$java$lang$Object == null ? IntroSpectionHelper.class$("java.lang.Object") : class$java$lang$Object) : aParam.getClass();
        }
        return IntroSpectionHelper.callStaticFunktion(className, functionName, functionParamsClasses, functionParams);
    }

    public static Object callStaticFunktion(String className, String functionName, Class[] functionParamsClasses, Object[] functionParams, ClassLoader classLoader) {
        try {
            Class<?> callerClass = null;
            callerClass = classLoader != null ? classLoader.loadClass(className) : Class.forName(className);
            return IntroSpectionHelper.callStaticFunktion(callerClass, functionName, functionParamsClasses, functionParams);
        }
        catch (Throwable t) {
            LogRegistry.getInstance().error(IntroSpectionHelper.class, "can't call class:" + className + " function:" + functionName + " " + t.getMessage());
            return null;
        }
    }

    public static Object callStaticFunktion(String className, String functionName, Class[] functionParamsClasses, Object[] functionParams) {
        return IntroSpectionHelper.callStaticFunktion(className, functionName, functionParamsClasses, functionParams, null);
    }

    public static Object callStaticFunktion(Class callInstanceClass, String functionName, Class[] functionParamsClasses, Object[] functionParams) {
        Object result = null;
        if (callInstanceClass != null) {
            try {
                if (functionParamsClasses == null) {
                    functionParamsClasses = new Class[]{};
                }
                if (functionParams == null) {
                    functionParams = new Object[]{};
                }
                if (functionName != null) {
                    Method callMethod = callInstanceClass.getMethod(functionName, functionParamsClasses);
                    result = callMethod.invoke((Object)callInstanceClass, functionParams);
                }
            }
            catch (Exception e) {
                LogRegistry.getInstance().error(IntroSpectionHelper.class, "can't call class:" + callInstanceClass.getClass().toString() + " function:" + functionName + " " + e.getMessage());
            }
        }
        return result;
    }

    public static Object createObject(String className, Type paramType) {
        return IntroSpectionHelper.createObjectByClassloader(className, IntroSpectionHelper.getMethodParameters(paramType), null);
    }

    public static Object createObject(String className, Type paramType, ClassLoader cl) {
        return IntroSpectionHelper.createObjectByClassloader(className, IntroSpectionHelper.getMethodParameters(paramType), cl);
    }

    public static Object createObject(String className, List constructorParams) {
        return IntroSpectionHelper.createObjectByClassloader(className, constructorParams, null);
    }

    public static Object createObjectByClassloader(String className, List constructorParams, ClassLoader classLoader) {
        Object instance = null;
        if (className != null) {
            ObjectConstructorSet constructorSet = IntroSpectionHelper.createObjectConstructorSet(constructorParams);
            try {
                Class<?> callClass = null;
                callClass = classLoader != null ? classLoader.loadClass(className) : Class.forName(className);
                if (callClass == null) {
                    LogRegistry.getInstance().error(IntroSpectionHelper.class, "can't create object from class:" + className + " ");
                    return null;
                }
                Constructor<?> callClassConstructor = callClass.getConstructor(constructorSet.getClasses());
                instance = callClassConstructor.newInstance(constructorSet.getObjects());
            }
            catch (Exception e) {
                LogRegistry.getInstance().error(IntroSpectionHelper.class, "can't create object from class:" + className + " " + e.getMessage());
            }
        }
        return instance;
    }

    public static Object createObject(String className, Class[] constructorParamClasses, Object[] classParams) {
        return IntroSpectionHelper.createObject(className, constructorParamClasses, classParams, null);
    }

    public static Object createObject(String className, Class[] constructorParamClasses, Object[] classParams, ClassLoader customCl) {
        Object instance;
        block11: {
            instance = null;
            if (className != null) {
                try {
                    Class<?> callClass = null;
                    callClass = customCl != null ? customCl.loadClass(className) : Class.forName(className);
                    if (constructorParamClasses == null) {
                        constructorParamClasses = new Class[]{};
                    }
                    if (classParams == null) {
                        classParams = new Object[]{};
                    }
                    try {
                        if (callClass != null) {
                            Constructor<?> callClassConstructor = callClass.getConstructor(constructorParamClasses);
                            instance = callClassConstructor.newInstance(classParams);
                        }
                    }
                    catch (Exception e) {
                        Constructor callClassConstructor = MethodUtils.getMatchingAccessibleConstructor(callClass, constructorParamClasses);
                        if (callClassConstructor != null) {
                            instance = callClassConstructor.newInstance(classParams);
                        } else if (LogRegistry.getInstance().logWarnings()) {
                            LogRegistry.getInstance().warn(IntroSpectionHelper.class, "can't create object from class:" + className + " " + e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    if (!LogRegistry.getInstance().logWarnings()) break block11;
                    LogRegistry.getInstance().warn(IntroSpectionHelper.class, "can't create object from class:" + className + " " + e.getMessage());
                }
            }
        }
        return instance;
    }

    public static Object createObject(String functionDefinition) {
        return IntroSpectionHelper.createObject(functionDefinition, (ClassLoader)null);
    }

    public static Object createObject(String functionDefinition, ClassLoader cl) {
        int indexOfOB = functionDefinition.indexOf("(");
        String paramDef = null;
        List params = null;
        String className = "";
        if (indexOfOB >= 0) {
            className = functionDefinition.substring(0, indexOfOB);
            int indexOfCB = functionDefinition.indexOf(")");
            paramDef = functionDefinition.substring(indexOfOB + 1, indexOfCB);
            params = IntroSpectionHelper.parseParameters(paramDef);
            Class[] classes = IntrospectionMethodParameter.getParameterClasses(params);
            Object[] values = IntrospectionMethodParameter.getParameters(params);
            return IntroSpectionHelper.createObject(className, classes, values, cl);
        }
        className = functionDefinition;
        return IntroSpectionHelper.createObject(className, null, null, null);
    }

    public static Object createObjectWithAdditionalParams(String functionDefinition, Class[] addClasses, Object[] addValues) {
        try {
            int indexOfOB = functionDefinition.indexOf("(");
            String paramDef = null;
            List params = null;
            String className = "";
            if (indexOfOB >= 0) {
                className = functionDefinition.substring(0, indexOfOB);
                int indexOfCB = functionDefinition.indexOf(")");
                paramDef = functionDefinition.substring(indexOfOB + 1, indexOfCB);
                params = IntroSpectionHelper.parseParameters(paramDef);
                Class[] classes = ArrayUtil.addToClassArray(addClasses, IntrospectionMethodParameter.getParameterClasses(params));
                Object[] values = ArrayUtil.addToArray(addValues, IntrospectionMethodParameter.getParameters(params));
                return IntroSpectionHelper.createObject(className, classes, values, null);
            }
            className = functionDefinition;
            return IntroSpectionHelper.createObject(className, addClasses, addValues, null);
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(IntroSpectionHelper.class, e);
            return null;
        }
    }

    public static void main(String[] args) {
        Object o = IntroSpectionHelper.createObject("java.lang.String");
        Object b = IntroSpectionHelper.createObject("java.lang.String(java.lang.String=aa)");
        Object c = IntroSpectionHelper.createObject("java.lang.String(java.lang.String=aa;java.lang.String=aa)");
    }

    public static List parseParameters(String parameterBlock) {
        StringTokenizer paramTok = new StringTokenizer(parameterBlock, ";");
        Vector<IntrospectionMethodParameter> resultParams = new Vector<IntrospectionMethodParameter>();
        while (paramTok.hasMoreTokens()) {
            String aParam = paramTok.nextToken().trim();
            resultParams.add(IntroSpectionHelper.parseParam(aParam));
        }
        return resultParams;
    }

    public static IntrospectionMethodParameter parseParam(String paramDef) {
        int equalPos = paramDef.indexOf("=");
        if (equalPos == -1) {
            equalPos = paramDef.indexOf(" ");
        }
        String paramClassName = null;
        String paramClassValue = null;
        if (equalPos >= 0) {
            paramClassName = paramDef.substring(0, equalPos);
            paramClassValue = paramDef.substring(equalPos + 1);
        } else {
            paramClassName = paramDef;
        }
        return new IntrospectionMethodParameter(paramClassName, paramClassValue);
    }

    public static String getClassName(Class forClass) {
        String packagename = forClass.getPackage().getName();
        String fullQ = forClass.getName();
        return fullQ.substring(packagename.length());
    }

    public static ObjectConstructorSet createObjectConstructorSet(List paramDefs) {
        Class[] objectClasses = null;
        Object[] objects = null;
        if (paramDefs != null) {
            objectClasses = new Class[paramDefs.size()];
            objects = new Object[paramDefs.size()];
            for (int i = 0; i < paramDefs.size(); ++i) {
                Object paramDef = paramDefs.get(i);
                String className = null;
                Object classValue = null;
                if (paramDef instanceof ListEntry) {
                    className = ((ListEntry)paramDef).getKey();
                    classValue = ((ListEntry)paramDef).getValueObject();
                } else {
                    className = ((String[])paramDef)[0];
                    classValue = ((String[])paramDef)[0];
                }
                objectClasses[i] = IntroSpectionHelper.getParameterClass(className);
                objects[i] = IntroSpectionHelper.getParameterObject(className, classValue);
            }
        }
        IntroSpectionHelper introSpectionHelper = IntroSpectionHelper.getInstance();
        introSpectionHelper.getClass();
        return introSpectionHelper.new ObjectConstructorSet(objectClasses, objects);
    }

    public static IntroSpectionHelper getInstance() {
        if (_instance == null) {
            _instance = new IntroSpectionHelper();
        }
        return _instance;
    }

    public static Class getParameterClass(String className) {
        if (className != null) {
            if (className.equals(TYPE_BOOLEAN_ARRAY_NATIVE)) {
                return [Z.class;
            }
            if (className.equals(TYPE_CHAR_ARRAY_NATIVE)) {
                return [C.class;
            }
            if (className.equals(TYPE_DOUBLE_ARRAY_NATIVE)) {
                return [D.class;
            }
            if (className.equals(TYPE_FLOAT_ARRAY_NATIVE)) {
                return [D.class;
            }
            if (className.equals(TYPE_LONG_ARRAY_NATIVE)) {
                return [J.class;
            }
            if (className.equals(TYPE_SHORT_ARRAY_NATIVE)) {
                return [S.class;
            }
            if (className.equals(TYPE_BYTE_ARRAY_NATIVE)) {
                return [B.class;
            }
            if (className.equals(TYPE_BOOLEAN_PRIMITIVE)) {
                return Boolean.TYPE;
            }
            if (className.equals(TYPE_BOOLEAN)) {
                return Boolean.class;
            }
            if (className.equals(TYPE_STRING)) {
                return String.class;
            }
            if (className.equals(TYPE_STRING_ARRAY) || className.equals(TYPE_STRING_ARRAY_2) || className.equals(TYPE_STRING_ARRAY_NATIVE)) {
                return String;.class;
            }
            if (className.equals(TYPE_INTEGER)) {
                return Integer.class;
            }
            if (className.equals(TYPE_INTEGER_PRIMITIVE)) {
                return Integer.TYPE;
            }
            if (className.equals(TYPE_INT_ARRAY) || className.equals(TYPE_INT_ARRAY_2) || className.equals(TYPE_INT_ARRAY_NATIVE)) {
                return [I.class;
            }
            if (className.equals(TYPE_INTEGER_ARRAY)) {
                return Integer;.class;
            }
            if (className.equals(TYPE_COLOR)) {
                return Color.class;
            }
            if (className.equals(TYPE_VISUALIZER)) {
                return Visualizer.class;
            }
            if (className.equals(TYPE_TYPE)) {
                return Type.class;
            }
            if (className.equals(TYPE_URL)) {
                return URL.class;
            }
            if (className.equals(TYPE_TYPE_ARRAY)) {
                return Type;.class;
            }
            try {
                return Class.forName(className);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object getParameterObject(String className, Object value) {
        Object returnValue = null;
        if (className != null) {
            if (value != null) {
                if (className.equals(TYPE_BOOLEAN_ARRAY_NATIVE)) {
                    return value;
                }
                if (className.equals(TYPE_CHAR_ARRAY_NATIVE)) {
                    return value;
                }
                if (className.equals(TYPE_DOUBLE_ARRAY_NATIVE)) {
                    return value;
                }
                if (className.equals(TYPE_FLOAT_ARRAY_NATIVE)) {
                    return value;
                }
                if (className.equals(TYPE_LONG_ARRAY_NATIVE)) {
                    return value;
                }
                if (className.equals(TYPE_SHORT_ARRAY_NATIVE)) {
                    return value;
                }
                if (className.equals(TYPE_BYTE_ARRAY_NATIVE)) {
                    return value;
                }
                returnValue = className.equals(TYPE_BOOLEAN) ? (Object)new Boolean((String)value) : (className.equals(TYPE_BOOLEAN_PRIMITIVE) ? (Object)new Boolean((String)value) : (className.equals(TYPE_STRING_ARRAY) || className.equals(TYPE_STRING_ARRAY_2) || className.equals(TYPE_STRING_ARRAY_NATIVE) ? (Object)IntroSpectionHelper.createStringArray((String)value) : (className.equals(TYPE_STRING) ? (value.equals("NULL") ? null : (Object)new String((String)value)) : (className.equals(TYPE_INTEGER) ? (Object)new Integer((String)value) : (className.equals(TYPE_INTEGER_PRIMITIVE) ? (Object)new Integer((String)value) : (className.equals(TYPE_INT_ARRAY) || className.equals(TYPE_INT_ARRAY_2) || className.equals(TYPE_INT_ARRAY_NATIVE) ? (Object)IntroSpectionHelper.createIntArray((String)value) : (className.equals(TYPE_URL) ? (Object)URLHelper.getUserURL((String)value) : (className.equals("com.jaxfront.core.jep.ArrayResult") ? (Object)ArrayResult.createFromString((String)value) : (className.equals("java.util.Hashtable") ? (Object)MapHelper.createFromString((String)value) : (className.equals("org.nfunk.jep.type.NULL") ? (Object)NULL._null : (className.equals("java.util.Date") ? (Object)new Date(StringUtil.getLong("" + value, System.currentTimeMillis())) : (Object)value)))))))))));
            } else {
                returnValue = className.equals(TYPE_BOOLEAN_ARRAY_NATIVE) ? new boolean[]{} : (className.equals(TYPE_CHAR_ARRAY_NATIVE) ? (Object)new char[0] : (className.equals(TYPE_DOUBLE_ARRAY_NATIVE) ? (Object)new double[0] : (className.equals(TYPE_FLOAT_ARRAY_NATIVE) ? (Object)new float[0] : (className.equals(TYPE_LONG_ARRAY_NATIVE) ? (Object)new long[0] : (className.equals(TYPE_SHORT_ARRAY_NATIVE) ? (Object)new short[0] : (className.equals(TYPE_BYTE_ARRAY_NATIVE) ? (Object)new byte[0] : (className.equals(TYPE_BOOLEAN) ? (Object)Boolean.FALSE : (className.equals(TYPE_BOOLEAN_PRIMITIVE) ? (Object)Boolean.FALSE : (className.equals(TYPE_STRING_ARRAY) || className.equals(TYPE_STRING_ARRAY_2) || className.equals(TYPE_STRING_ARRAY_NATIVE) ? (Object)new String[0] : (className.equals(TYPE_STRING) ? (Object)new String() : (className.equals(TYPE_INTEGER) ? (Object)new Integer(0) : (className.equals(TYPE_INTEGER_PRIMITIVE) ? (Object)new Integer(0) : (className.equals(TYPE_INT_ARRAY) || className.equals(TYPE_INT_ARRAY_2) || className.equals(TYPE_INT_ARRAY_NATIVE) ? (Object)new int[0] : (className.equals(TYPE_URL) ? null : (className.equals("com.jaxfront.core.jep.ArrayResult") ? (Object)new ArrayResult() : (className.equals("java.util.Hashtable") ? (Object)new Hashtable() : (className.equals("org.nfunk.jep.type.NULL") ? (Object)NULL._null : (className.equals("java.util.Date") ? (Object)new Date(System.currentTimeMillis()) : (className.equals(TYPE_COLOR) ? (Object)Color.black : (className.equals(TYPE_TYPE) ? (Object)value : (Object)value))))))))))))))))))));
            }
        }
        return returnValue;
    }

    private static Object createIntArray(String intArrayString) {
        StringTokenizer st = new StringTokenizer(intArrayString, ",");
        int[] intArray = new int[st.countTokens()];
        int counter = 0;
        while (st.hasMoreElements()) {
            String intString = st.nextToken();
            intArray[counter] = new Integer(intString);
            ++counter;
        }
        return intArray;
    }

    private static Object createStringArray(String stringArrayString) {
        stringArrayString = StringUtil.removeIfFirstLast(stringArrayString, "[", "]");
        String[] stringArray = MethodParameter.createStringArray(stringArrayString);
        return stringArray;
    }

    public static boolean callFunktion(Object callInstance, String functionName, Object param) {
        Class[] functionParamsClasses = null;
        Object[] functionParams = null;
        if (param != null) {
            functionParamsClasses = new Class[]{param.getClass()};
            functionParams = new Object[]{param};
        }
        try {
            IntroSpectionHelper.doCallFunktion(callInstance, functionName, functionParamsClasses, functionParams);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean callFunktion(Object callInstance, FunctionWrapper function) {
        Class[] functionParamsClasses = function.getClasses();
        Object[] functionParams = function.getObjects();
        try {
            IntroSpectionHelper.doCallFunktion(callInstance, function.getName(), functionParamsClasses, functionParams);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object callFunktion(Object callInstance, String functionName, List params) {
        Class[] functionParamsClasses = new Class[params.size()];
        Object[] functionParams = new Object[params.size()];
        for (int p = 0; p < params.size(); ++p) {
            Object aParam = params.get(p);
            functionParams[p] = aParam;
            functionParamsClasses[p] = aParam == null ? (class$java$lang$Object == null ? IntroSpectionHelper.class$("java.lang.Object") : class$java$lang$Object) : aParam.getClass();
        }
        try {
            return IntroSpectionHelper.doCallFunktion(callInstance, functionName, functionParamsClasses, functionParams);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object callFunktion(Object callInstance, String functionName, Object[] params) {
        Class[] functionParamsClasses = new Class[params.length];
        Object[] functionParams = new Object[params.length];
        for (int p = 0; p < params.length; ++p) {
            Object aParam;
            functionParams[p] = aParam = params[p];
            functionParamsClasses[p] = aParam == null ? (class$java$lang$Object == null ? IntroSpectionHelper.class$("java.lang.Object") : class$java$lang$Object) : aParam.getClass();
        }
        try {
            return IntroSpectionHelper.doCallFunktion(callInstance, functionName, functionParamsClasses, functionParams);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] read(ObjectInput in) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IntroSpectionHelper.write(in, bos);
        bos.close();
        in.close();
        return bos.toByteArray();
    }

    public static OutputStream write(ObjectInput in, OutputStream outstream) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(outstream);
        byte[] rgb = new byte[10000];
        int readCounter = 0;
        while ((readCounter = in.read(rgb)) > -1) {
            bos.write(rgb, 0, readCounter);
        }
        bos.flush();
        return bos;
    }

    public static List getMethodParameters(Type action) {
        ListType paramList;
        Vector<ListEntry> result = new Vector<ListEntry>();
        if (action != null && (paramList = (ListType)action.getDirectChild("param")) != null) {
            for (int i = 0; i < paramList.size(); ++i) {
                Type aParam = (Type)paramList.get(i);
                String className = aParam.getDirectChildValue("type");
                String classValue = aParam.getDirectChildValue("value");
                ListEntry entry = new ListEntry((Object)className, classValue);
                result.add(entry);
            }
        }
        return result;
    }

    public static Object callPrivateMethod(Object o, String methodName, Object[] params) {
        Method[] methods = o.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            try {
                methods[i].setAccessible(true);
                return methods[i].invoke(o, params);
            }
            catch (IllegalAccessException ex) {
                continue;
            }
            catch (InvocationTargetException ite) {
                // empty catch block
            }
        }
        return null;
    }

    public class FunctionWrapper {
        private String _name;
        private Class[] _classes;
        private Object[] _objects;

        public FunctionWrapper(String name, Class[] classes, Object[] paramObjects) {
            this._name = name;
            this._classes = classes;
            this._objects = paramObjects;
        }

        public FunctionWrapper(String name, Object[] params) {
            this._name = name;
            this._objects = params;
        }

        public FunctionWrapper(String name, List params) {
            this._name = name;
            if (params != null) {
                this._objects = params.toArray();
            }
        }

        public Object[] getObjects() {
            if (this._objects == null || this._objects.length == 0) {
                this._objects = new Class[0];
            }
            return this._objects;
        }

        public Class[] getClasses() {
            if (this._classes == null || this._classes.length == 0) {
                if (this.getObjects().length > 0) {
                    this._classes = new Class[this.getObjects().length];
                    for (int p = 0; p < this._classes.length; ++p) {
                        Object aParam = this.getObjects()[p];
                        this._classes[p] = aParam == null ? (class$java$lang$Object == null ? IntroSpectionHelper.class$("java.lang.Object") : class$java$lang$Object) : aParam.getClass();
                    }
                } else {
                    this._classes = new Class[0];
                }
            }
            return this._classes;
        }

        public String getName() {
            return this._name;
        }
    }

    public class ObjectConstructorSet {
        private Class[] _classes;
        private Object[] _objects;

        ObjectConstructorSet(Class[] classes, Object[] objects) {
            this._classes = classes;
            this._objects = objects;
        }

        public Object[] getObjects() {
            if (this._objects == null || this._objects.length == 0) {
                this._objects = new Class[0];
            }
            return this._objects;
        }

        public Class[] getClasses() {
            if (this._classes == null || this._classes.length == 0) {
                this._classes = new Class[0];
            }
            return this._classes;
        }
    }
}

