/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.util.JAXFrontDateTools;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import java.util.List;
import java.util.Vector;

public class JAXFrontDateConverter {
    public static final char era = 'G';
    public static final char year = 'y';
    public static final char month = 'M';
    public static final char dayInMonth = 'd';
    public static final char hour = 'h';
    public static final char hourInDay0_24 = 'H';
    public static final char minuteInHour = 'm';
    public static final char second = 's';
    public static final char millisecond = 'S';
    public static final char dayInWeek = 'E';
    public static final char dayInYear = 'D';
    public static final char dayOfWeekInMonth = 'F';
    public static final char weekInYear = 'w';
    public static final char weekInMonth = 'W';
    public static final char ampmMarker = 'a';
    public static final char hourInDay = 'k';
    public static final char hourInAmPm0_11 = 'K';
    public static final char timeZone = 'z';
    private static JAXFrontDateConverter _instance = null;

    public Section getSection(String fromPattern, int start) {
        char c;
        int n = -1;
        block3: for (int fp = start; fp < fromPattern.length(); ++fp) {
            char aType = fromPattern.charAt(fp);
            switch (aType) {
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'K': 
                case 'M': 
                case 'S': 
                case 'W': 
                case 'a': 
                case 'd': 
                case 'h': 
                case 'k': 
                case 'm': 
                case 's': 
                case 'w': 
                case 'y': 
                case 'z': {
                    if (c == '\uffffffff') {
                        c = aType;
                        continue block3;
                    }
                    if (c == aType) continue block3;
                    return new Section(aType, start, fp, JAXFrontDateConverter.readAheadTillDelim(fromPattern, fp));
                }
                default: {
                    return new Section(c, start, fp, JAXFrontDateConverter.readAheadTillDelim(fromPattern, fp));
                }
            }
        }
        if (start < fromPattern.length()) {
            return new Section(c, start, fromPattern.length(), JAXFrontDateConverter.readAheadTillDelim(fromPattern, fromPattern.length()));
        }
        return null;
    }

    public static void main(String[] args) {
        JAXFrontDateConverter jf = new JAXFrontDateConverter();
        String sourcePattern1 = "dd.MM.yyyy HH:mm:ss";
        String destPattern1 = "yyyy-MM-dd HH:mm:ss.SSSSSSSSS";
        System.out.println(jf.create(sourcePattern1, destPattern1, "10.02.%", false));
        String sourcePattern = "yyyy.MM.dd hh:mm:ss a 'z'";
        String destPattern = "yyyy/MM/dd'T'HH.mm.ss z";
        List sections = jf.getSections(sourcePattern);
        JAXFrontDateConverter jAXFrontDateConverter = jf;
        jAXFrontDateConverter.getClass();
        DateDefinition df = jAXFrontDateConverter.new DateDefinition(sections);
        df.setValue("1234.12.21 0");
        System.out.println(sourcePattern + "->" + df.toString());
        List sections2 = jf.getSections(destPattern);
        JAXFrontDateConverter jAXFrontDateConverter2 = jf;
        jAXFrontDateConverter2.getClass();
        DateDefinition df2 = jAXFrontDateConverter2.new DateDefinition(sections2);
        df2.merge(df, false, null);
        System.out.println(destPattern + "->" + df2.toString());
        System.out.println(JAXFrontDateTools.parseISODate("1979-12-21"));
        System.out.println(JAXFrontDateTools.parseISODate("1979-2-21"));
        System.out.println(JAXFrontDateTools.parseISODate("1979-12-1"));
        System.out.println(JAXFrontDateTools.parseISODate("1979-2-1"));
    }

    public String create(String fromPattern, String toPattern, String value) {
        return this.create(fromPattern, toPattern, value, true);
    }

    public String create(String fromPattern, String toPattern, String value, boolean translNull) {
        JAXFrontDateConverter jf = new JAXFrontDateConverter();
        List sections = jf.getSections(fromPattern);
        JAXFrontDateConverter jAXFrontDateConverter = jf;
        jAXFrontDateConverter.getClass();
        DateDefinition df = jAXFrontDateConverter.new DateDefinition(sections);
        df.setValue(value);
        List sections2 = jf.getSections(toPattern);
        JAXFrontDateConverter jAXFrontDateConverter2 = jf;
        jAXFrontDateConverter2.getClass();
        DateDefinition df2 = jAXFrontDateConverter2.new DateDefinition(sections2);
        df2.merge(df, false, null);
        return df2.toString(translNull);
    }

    public String expandYear(String fromPattern, String value, String yearBase) {
        JAXFrontDateConverter jf = new JAXFrontDateConverter();
        List sections = jf.getSections(fromPattern);
        JAXFrontDateConverter jAXFrontDateConverter = jf;
        jAXFrontDateConverter.getClass();
        DateDefinition df = jAXFrontDateConverter.new DateDefinition(sections);
        df.setValue(value);
        df.merge(df, true, yearBase);
        return df.toString();
    }

    public List getSections(String pattern) {
        Vector<Section> sections = new Vector<Section>();
        Section aSection = null;
        int start = 0;
        while ((aSection = this.getSection(pattern, start)) != null) {
            sections.add(aSection);
            start = aSection._end + aSection.getDelimiter().length();
        }
        return sections;
    }

    public static String readAheadTillDelim(String pattern, int from) {
        StringBuffer delim = new StringBuffer();
        for (int p = from; p < pattern.length() && !JAXFrontDateConverter.isDelimChar(pattern.charAt(p)); ++p) {
            delim.append(pattern.charAt(p));
        }
        return delim.toString();
    }

    public static boolean isDelimChar(int aChar) {
        switch (aChar) {
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 77: 
            case 83: 
            case 87: 
            case 97: 
            case 100: 
            case 104: 
            case 107: 
            case 109: 
            case 115: 
            case 119: 
            case 121: 
            case 122: {
                return true;
            }
        }
        return false;
    }

    public static JAXFrontDateConverter getInstance() {
        if (_instance == null) {
            _instance = new JAXFrontDateConverter();
        }
        return _instance;
    }

    public class Section {
        int _start;
        int _end;
        int _type;
        private String _delimiter;
        private String _value;
        boolean _complete;

        public Section(int type, int start, int end, String delim) {
            this._type = type;
            this._start = start;
            this._end = end;
            this.setDelimiter(delim);
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean translateNull) {
            String delimiter = this._delimiter;
            if (delimiter != null && delimiter.length() > 0) {
                delimiter = TextTools.removeSingleOccureChar(delimiter, '\'');
            }
            if (this.getValue() != null && this.getValue().length() > 0) {
                if ("*".equals(this.getValue()) || "%".equals(this.getValue())) {
                    return this.getValue();
                }
                return this.getValue() + delimiter;
            }
            if (translateNull) {
                switch (this._type) {
                    case 72: 
                    case 75: 
                    case 104: 
                    case 107: 
                    case 109: 
                    case 115: {
                        return "00" + delimiter;
                    }
                    case 83: {
                        return "000" + delimiter;
                    }
                }
                return "";
            }
            return "";
        }

        void setValue(String value) {
            if (value != null) {
                value = value.trim();
            }
            this._value = value;
            this._complete = this._value != null && this._value.length() == this._end - this._start;
        }

        String getValue() {
            return this._value;
        }

        void setDelimiter(String delimiter) {
            this._delimiter = delimiter;
        }

        String getDelimiter() {
            return this._delimiter;
        }

        Section getSection(Section[] sections, char type) {
            for (int i = 0; i < sections.length; ++i) {
                if (sections[i]._type != type) continue;
                return sections[i];
            }
            return null;
        }

        Section getSection(List sections, char type) {
            for (int i = 0; i < sections.size(); ++i) {
                if (((Section)sections.get((int)i))._type != type) continue;
                return (Section)sections.get(i);
            }
            return null;
        }
    }

    public class DateDefinition {
        List _sections;

        public DateDefinition(List sections) {
            this._sections = sections;
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean translateNull) {
            StringBuffer result = new StringBuffer();
            for (int s = 0; s < this._sections.size(); ++s) {
                Section aSection = (Section)this._sections.get(s);
                if ("*".equals(aSection.getValue())) {
                    result.append(aSection.toString(translateNull));
                    break;
                }
                result.append(aSection.toString(translateNull));
            }
            return result.toString();
        }

        public void setValue(String value) {
            int offset = 0;
            for (int s = 0; s < this._sections.size(); ++s) {
                Section aSection = (Section)this._sections.get(s);
                int sStart = aSection._start;
                int sEnd = aSection._end;
                int vLength = value.length();
                sEnd -= offset;
                if (vLength < (sStart -= offset)) continue;
                if (vLength >= sEnd) {
                    String secVal;
                    String valuePart = value.substring(sStart, sEnd);
                    if (aSection.getDelimiter() != null && aSection.getDelimiter().length() > 0 && valuePart.indexOf(aSection.getDelimiter()) >= 0) {
                        int dif = valuePart.length() - valuePart.indexOf(aSection.getDelimiter());
                        offset += dif;
                        sEnd = value.indexOf(aSection.getDelimiter(), sStart);
                    }
                    if (!StringUtil.isInteger(secVal = value.substring(sStart, sEnd)) && !StringUtil.isAlpha(secVal)) continue;
                    aSection.setValue(secVal);
                    continue;
                }
                String secVal = value.substring(sStart, vLength);
                if (!"%".equals(secVal) && !"*".equals(secVal) && !StringUtil.isInteger(secVal) && !StringUtil.isAlpha(secVal)) continue;
                aSection.setValue(secVal);
            }
        }

        public Section getSection(int type) {
            for (int s = 0; s < this._sections.size(); ++s) {
                Section sec = (Section)this._sections.get(s);
                if (sec._type != type) continue;
                return sec;
            }
            return null;
        }

        public void merge(DateDefinition df, boolean expand, String yearBase) {
            for (int s = 0; s < this._sections.size(); ++s) {
                Section sec = (Section)this._sections.get(s);
                Section sourceSection = df.getSection(sec._type);
                String sVal = null;
                if (sourceSection == null) {
                    if (sec._type == 72) {
                        sourceSection = df.getSection(104);
                        if (sourceSection != null) {
                            int intVal;
                            sVal = sourceSection.getValue();
                            Section amPMSection = sourceSection.getSection(df._sections, 'a');
                            if (amPMSection != null && sVal != null && (intVal = StringUtil.getInt(sVal)) != 0) {
                                sVal = intVal == 12 ? "00" : String.valueOf(intVal + 12);
                            }
                        }
                    } else if (sec._type == 104 && (sVal = (sourceSection = df.getSection(72)).getValue()) != null) {
                        sVal = String.valueOf(StringUtil.getInt(sVal) - 12);
                    }
                }
                if (sourceSection == null) continue;
                if (sVal == null) {
                    sVal = sourceSection.getValue();
                }
                if (yearBase != null && sec._type == 121 && expand && !"*".equals(sVal) && !"%".equals(sVal)) {
                    if (sVal == null || sVal.length() == 0) {
                        sVal = yearBase + "000";
                    } else if (sVal.length() == 1) {
                        sVal = yearBase + "00" + sVal;
                    } else if (sVal.length() == 2) {
                        sVal = yearBase + "0" + sVal;
                    } else if (sVal.length() == 3) {
                        sVal = yearBase + sVal;
                    }
                }
                sec.setValue(sVal);
            }
        }
    }
}

