/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.util.TextTools;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class KeyCoder {
    public static void main(String[] args) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        byte[] key = KeyCoder.createKey("AES", 128);
        byte[] verschluesselt = KeyCoder.encode(key, "Das ist ein Test");
        System.out.println(new String(verschluesselt));
        System.out.println(KeyCoder.decode(key, verschluesselt));
    }

    public static String decode(byte[] key, byte[] encryptedBytes) {
        byte[] plainTextBytes = null;
        try {
            SecretKeySpec specKey = new SecretKeySpec(key, "AES");
            Cipher encryptCipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            encryptCipher.init(2, specKey);
            plainTextBytes = encryptCipher.doFinal(encryptedBytes);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            return new String(plainTextBytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return new String(plainTextBytes);
        }
    }

    public static String decode(String key, String encryptedBytes) {
        return KeyCoder.decode(key.getBytes(), encryptedBytes.getBytes());
    }

    public static byte[] encode(byte[] key, String text) {
        byte[] encryptedBytes = null;
        try {
            byte[] plainTextBytes = text.getBytes("ISO-8859-1");
            SecretKeySpec specKey = new SecretKeySpec(key, "AES");
            Cipher encryptCipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            encryptCipher.init(1, specKey);
            encryptedBytes = encryptCipher.doFinal(plainTextBytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return encryptedBytes;
    }

    public static byte[] encode(String key, String text) {
        return KeyCoder.encode(key.getBytes(), text);
    }

    public static String createHEXKey() {
        try {
            byte[] key = KeyCoder.createKey();
            return TextTools.toHexString(key);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static byte[] createKey() throws NoSuchAlgorithmException {
        return KeyCoder.createKey("AES", 128);
    }

    public static byte[] createKey(String method, int keySize) throws NoSuchAlgorithmException {
        byte[] keyVal = null;
        KeyGenerator generator = KeyGenerator.getInstance(method);
        generator.init(keySize);
        SecretKey key = generator.generateKey();
        keyVal = key.getEncoded();
        return keyVal;
    }
}

