/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.alphase.lic.License;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.io.FileFinder;
import java.io.File;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class LicenseChecker {
    private static LicenseChecker _singleton;
    private static License _currentLicense;
    private static boolean _hasCommunityLicense;
    private static boolean _isStandardEditionLicense;
    private static boolean _isProfessionalEdition;
    private static boolean _isEnterpriseEdition;
    private static boolean _isEnterpriseStudioEdition;
    public static final String COMMUNITY_EDITION = "COMMUNITY";
    public static final String STANDARD_EDITION = "STANDARD";
    public static final String PROFESSIONAL_EDITION = "PROFESSIONAL";
    public static final String ENTERPRISE_EDITION = "ENTERPRISE";
    public static final String ENTERPRISE_STUDIO_EDITION = "JAXFORMS";

    private LicenseChecker() {
        LicenseChecker.initializeLicenseInfo();
    }

    public static LicenseChecker getInstance() {
        if (_singleton == null) {
            _singleton = new LicenseChecker();
        }
        return _singleton;
    }

    public static License getLicense() {
        return _currentLicense;
    }

    public static String getVersion() {
        String version = null;
        if (_currentLicense != null) {
            version = new Integer(LicenseChecker._currentLicense.Version).toString() + "." + new Integer(LicenseChecker._currentLicense.SubVersion).toString();
        }
        return version;
    }

    public static int getEvaluationDaysLeft() {
        String expirationDate;
        if (_currentLicense != null && (expirationDate = LicenseChecker._currentLicense.ExDate) != null) {
            if (expirationDate.equals("none")) {
                return -1;
            }
            try {
                SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                Date expiration = df.parse(expirationDate);
                long time = expiration.getTime() - new Date().getTime();
                long days = Math.round((double)time / 8.64E7);
                return Integer.valueOf(String.valueOf(days));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean hasValidLicense() {
        return this.hasValidLicenseContext(null);
    }

    public boolean hasValidLicenseContext(String context) {
        boolean valid;
        boolean bl = valid = _currentLicense != null && LicenseChecker._currentLicense.LicenseVal >= 0;
        if (context != null && valid) {
            String customer = LicenseChecker._currentLicense.Product;
            if (customer != null) {
                if (customer.indexOf(context) == -1) {
                    valid = false;
                }
            } else {
                valid = false;
            }
        }
        return valid;
    }

    public boolean hasValidLicense(String directoryName, String context) {
        Vector files = new Vector();
        if (directoryName != null && directoryName.length() > 0) {
            FileFinder ff = new FileFinder(directoryName, new String[]{".lic"});
            files = ff.getFiles();
        }
        if (files.size() > 0) {
            LicenseChecker.verifyLicense(((File)files.get(0)).getPath());
        } else {
            _currentLicense = null;
        }
        return this.hasValidLicenseContext(context);
    }

    public static License verifyLicense(String fileLocation) {
        _currentLicense = new License(0);
        _currentLicense.verifyLicenseFile(fileLocation);
        LicenseChecker.initializeLicenseInfo();
        return _currentLicense;
    }

    public static void initializeLicenseInfo() {
        if (_currentLicense == null) {
            LicenseChecker.class.getClassLoader();
            URL foundLicURL = ClassLoader.getSystemResource("jaxfront.lic");
            if (foundLicURL == null) {
                LogRegistry.getInstance().warn(LicenseChecker.class, "can't load jaxfront.lic via: getClass().getClassLoader().getSystemResource(\"jaxfront.lic\") ");
                foundLicURL = LicenseChecker.class.getClassLoader().getResource("jaxfront.lic");
            }
            if (foundLicURL != null) {
                if (LogRegistry.getInstance().logWarnings()) {
                    LogRegistry.getInstance().warn(LicenseChecker.class, "Resolve lic from; " + foundLicURL.toExternalForm());
                }
                LicenseChecker.verifyLicense(foundLicURL.toExternalForm());
            } else {
                if (LogRegistry.getInstance().logWarnings()) {
                    LogRegistry.getInstance().warn(LicenseChecker.class, "can't load jaxfront.lic via:  this.getClass().getClassLoader().getResource(\"jaxfront.lic\") ");
                }
                String userDir = System.getProperty("user.dir") + File.separator + "lic";
                String errorMessage = "Unable to locate lic-directory (" + userDir + ") or no file with file suffix '.lic' found";
                FileFinder ff = new FileFinder(userDir, new String[]{".lic"});
                Vector files = ff.getFiles();
                if (files != null && files.size() > 0) {
                    LicenseChecker.verifyLicense(((File)files.get(0)).getPath());
                } else {
                    String licLocation;
                    if (LogRegistry.getInstance().logWarnings()) {
                        LogRegistry.getInstance().warn(LicenseChecker.class, errorMessage);
                    }
                    if ((licLocation = JAXFrontProperties.getInstance().getLicenseLocation()) != null) {
                        LicenseChecker.verifyLicense(licLocation);
                    } else {
                        LicenseChecker.class.getClassLoader();
                        foundLicURL = ClassLoader.getSystemResource("jaxfront-community.lic");
                        if (foundLicURL != null) {
                            if (LogRegistry.getInstance().logWarnings()) {
                                LogRegistry.getInstance().warn(LicenseChecker.class, "Resolve lic from; " + foundLicURL.toExternalForm());
                            }
                            LicenseChecker.verifyLicense(foundLicURL.toExternalForm());
                        }
                    }
                }
            }
        }
        if (_currentLicense != null) {
            String licenseText = LicenseChecker._currentLicense.Product;
            _hasCommunityLicense = licenseText == null || licenseText.indexOf("Community Edition") != -1;
            if (!_hasCommunityLicense) {
                LicenseChecker.initializeLicenseEdition(licenseText, LicenseChecker.getVersion());
            }
        } else {
            _hasCommunityLicense = true;
        }
    }

    private static void initializeLicenseEdition(String licenseText, String version) {
        boolean isSwingLic;
        int licAreaStart = licenseText.lastIndexOf("(");
        if (licAreaStart == -1) {
            _hasCommunityLicense = true;
            return;
        }
        String licArea = licenseText.substring(licenseText.lastIndexOf("("));
        int htmlIdx = StringUtil.indexOfIgnoreCase(licArea, "HTML", 0);
        int swingIdx = StringUtil.indexOfIgnoreCase(licArea, "SWING", 0);
        int standardIdx = StringUtil.indexOfIgnoreCase(licArea, STANDARD_EDITION, 0);
        int profIdx = StringUtil.indexOfIgnoreCase(licArea, PROFESSIONAL_EDITION, 0);
        int entIdx = StringUtil.indexOfIgnoreCase(licArea, ENTERPRISE_EDITION, 0);
        int studioIdx = StringUtil.indexOfIgnoreCase(licArea, ENTERPRISE_STUDIO_EDITION, 0);
        boolean isRunningAsHTML = TypeVisualizerFactory.getInstance().isHTMLFactory();
        boolean isRunningAsSwing = TypeVisualizerFactory.getInstance().isSwingFactory();
        boolean isHTMLLic = htmlIdx != -1;
        boolean bl = isSwingLic = swingIdx != -1;
        if (!isHTMLLic && !isSwingLic) {
            _hasCommunityLicense = true;
        } else if (isRunningAsHTML && !isHTMLLic || isRunningAsSwing && !isSwingLic) {
            _hasCommunityLicense = true;
        } else {
            _isStandardEditionLicense = standardIdx != -1;
            _isProfessionalEdition = profIdx != -1;
            _isEnterpriseEdition = entIdx != -1;
            _isEnterpriseStudioEdition = studioIdx != -1;
        }
        String runningVersion = "2.77";
        int runningMajorVersion = TextTools.parseInt(runningVersion.substring(0, runningVersion.indexOf(".")), -1);
        if (version == null || version.indexOf(".") == -1) {
            _hasCommunityLicense = true;
        } else {
            String majorVersion = version.substring(0, version.indexOf("."));
            String minorVersion = version.substring(version.indexOf(".") + 1);
            if (TextTools.parseInt(majorVersion, -1) < runningMajorVersion) {
                _hasCommunityLicense = true;
            }
        }
    }

    public boolean hasCommunityLicense() {
        return _hasCommunityLicense;
    }

    public String getLicenseText() {
        if (!_hasCommunityLicense && _currentLicense != null) {
            return LicenseChecker._currentLicense.Product;
        }
        return " Community Edition (None Commercial)";
    }

    public boolean isStandardEdition() {
        return _isStandardEditionLicense;
    }

    public boolean isProfessionalEdition() {
        return _isProfessionalEdition;
    }

    public boolean isEnterpriseEdition() {
        return _isEnterpriseEdition;
    }

    public boolean isEnterpriseStudioEdition() {
        return _isEnterpriseStudioEdition;
    }

    static {
        _hasCommunityLicense = true;
        _isStandardEditionLicense = false;
        _isProfessionalEdition = false;
        _isEnterpriseEdition = false;
        _isEnterpriseStudioEdition = false;
    }
}

