/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.util.JAXFrontProperties;
import java.lang.reflect.Constructor;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class LicenseErrorException
extends RuntimeException {
    public static final String MESSAGE = "No valid JAXFront license installed.";
    private JDialog _dialog;

    public LicenseErrorException() {
        this("No valid JAXFront license installed. (looking for jaxfront-properties.xml in " + System.getProperty("user.home") + ", lic-location: )" + JAXFrontProperties.getInstance().getLicenseLocation());
    }

    public LicenseErrorException(String message) {
        super(message);
        System.out.println(MESSAGE);
        System.out.println(" --> ====================================================================");
        System.out.println(" --> please install a jaxfront license (.lic)");
        System.out.println(" --> license may be ordererd at info@jaxfront.com");
        System.out.println(" --> ====================================================================");
        System.out.println(" --> (c) xcentric technology & consulting GmbH, Zurich - www.xcentric.ch");
    }

    public void showLicenseDialog(JFrame parentFrame) {
        if (this._dialog == null) {
            try {
                Constructor<?> constructor;
                Class<?> dialogClass = Class.forName("com.jaxfront.swing.ui.tools.LicenseCheckerDialog");
                if (dialogClass != null && (constructor = dialogClass.getConstructors()[0]) != null) {
                    Object[] parameters = new Object[]{parentFrame, "JAXFront License Manager (www.demo.jaxfront.com)", Boolean.TRUE, new Integer(-1)};
                    this._dialog = (JDialog)constructor.newInstance(parameters);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._dialog != null) {
            this._dialog.show();
        }
    }
}

