/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.ResourceWrapper;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ResourceHandler {
    private static Hashtable _resources;
    private static ResourceHandler _instance;

    public static synchronized ResourceHandler getInstance() {
        if (_instance == null) {
            _instance = new ResourceHandler();
        }
        return _instance;
    }

    private Hashtable getResources() {
        if (_resources == null) {
            _resources = new Hashtable();
        }
        return _resources;
    }

    public void removeResource(String key) {
        if (key != null) {
            this.getResources().remove(key);
        }
    }

    public Enumeration getResourceWrappers() {
        return this.getResources().elements();
    }

    public Enumeration getResourceWrappers(String type) {
        Enumeration wraps = this.getResources().elements();
        Vector<ResourceWrapper> found = new Vector<ResourceWrapper>();
        while (wraps.hasMoreElements()) {
            ResourceWrapper element = (ResourceWrapper)wraps.nextElement();
            if (!element.getType().equals(type)) continue;
            found.add(element);
        }
        return found.elements();
    }

    public void releaseResources() {
        this.getResources().clear();
    }

    public void releaseResources(String type) {
        Vector<String> result = new Vector<String>();
        Enumeration entries = this.getResources().elements();
        while (entries.hasMoreElements()) {
            ResourceWrapper element = (ResourceWrapper)entries.nextElement();
            if (!element.getType().equals(type)) continue;
            result.add(element.getId());
        }
        for (int r = 0; r < result.size(); ++r) {
            this.getResources().remove(result.get(r));
        }
    }

    public void releaseInternalizedResources() {
        Vector result = new Vector();
        Iterator entries = this.getResources().entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry element = entries.next();
            Object key = element.getKey();
            ResourceWrapper value = (ResourceWrapper)element.getValue();
            if (!value.isInternalized()) continue;
            result.add(key);
        }
        for (int r = 0; r < result.size(); ++r) {
            this.getResources().remove(result.get(r));
        }
    }

    public void releaseInternalizedResources(String type) {
        Vector result = new Vector();
        Iterator entries = this.getResources().entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry element = entries.next();
            Object key = element.getKey();
            ResourceWrapper value = (ResourceWrapper)element.getValue();
            if (!value.isInternalized() || !value.getType().equals(type)) continue;
            result.add(key);
        }
        for (int r = 0; r < result.size(); ++r) {
            this.getResources().remove(result.get(r));
        }
    }

    public void putResource(String key, String type, byte[] value, boolean internalized) {
        ImageIcon newIcon = new ImageIcon(value);
        this.getResources().put(key, new ResourceWrapper(key, newIcon, type, internalized));
    }

    public static byte[] createByteArray(ImageIcon i, String type) {
        BufferedImage bi = new BufferedImage(i.getIconWidth(), i.getIconHeight(), 2);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(i.getImage(), 0, 0, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bi, type, baos);
        }
        catch (IOException e) {
            LogRegistry.getInstance().error(ResourceHandler.class, e);
        }
        return baos.toByteArray();
    }
}

