/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.formatter.ColumnFormatter;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.TextTools;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    public static final char NOT_AN_CHAR = '\uffff';
    public static final String[] javaLiterals = new String[]{"\\\"", "\\'", "\\n", "\\r", "\\t", "\\\\"};
    public static final String[] sqlLiterals = new String[]{"\\'"};
    public static final char[] javaCharLiterals = new char[]{'\"', '\'', '\n', '\r', '\t', '\\'};
    public static final char[] sqlCharLiterals = new char[]{'\''};
    public static final String[] empty = new String[]{""};
    public static final char newLineChar = '\n';
    public static final char carriageReturnChar = '\r';
    public static final char[] charCarriageReturnArr = new char[]{'\r'};
    public static final char[] charNewLineArr = new char[]{'\n'};
    public static final char[] URL_SPECIAL_ENC = new char[]{'%', '&', '=', '<', '>', '#', '{', '}', '|', '\\', '^', '~', '[', ']', '\'', ';', '/', '?', ':', '@', '$'};
    public static final String[] URL_SPECIAL_ENC_DEST = new String[]{"%25", "%26", "%3D", "%3C", "%3E", "%23", "%7B", "%7D", "%7C", "%5C", "%5E", "%7E", "%5B", "%5D", "%60", "%3B", "%2F", "%3F", "%3A", "%40", "%24"};
    public static final String[] freeMarker_Escape = new String[]{"_P_", "_M_", "_LB_", "_RB_", "_EQ_"};
    public static final char[] freeMarker_Unescape = new char[]{'/', '-', '[', ']', '='};
    public static final String newLine = System.getProperty("line.separator");
    public static final String newTab = String.valueOf('\t');
    public static final String doubleQuote = "\"";
    public static final String space = " ";
    public static final String AMP = "&";
    public static final String XML_AMP = "&amp;";
    public static final String LESS = "<";
    public static final String XML_LESS = "&lt;";
    public static final String GREATER = ">";
    public static final String XML_GREATER = "&gt;";
    public static final String QUOT = "\"";
    public static final String XML_QUOT = "&quot;";
    public static final Comparator NATURAL_COMPARATOR_ASCII = new Comparator(){

        public int compare(Object o1, Object o2) {
            return StringUtil.compareNaturalAscii((String)o1, (String)o2);
        }
    };
    public static final Comparator IGNORE_CASE_NATURAL_COMPARATOR_ASCII = new Comparator(){

        public int compare(Object o1, Object o2) {
            return StringUtil.compareNaturalIgnoreCaseAscii((String)o1, (String)o2);
        }
    };
    public static final Comparator TO_STRING_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return StringUtil.compareNatural(o1 == null ? null : o1.toString(), o2 == null ? null : o2.toString());
        }
    };
    private static HashMap htmlEntities = new HashMap();
    public static final char[] jax_protokol_escape;
    public static final String[] jax_protokol_unescape;
    static /* synthetic */ Class class$java$lang$String;

    public static String substring(String value, String startId, String endId) {
        String result = null;
        int idStart = value.indexOf(startId);
        if (idStart >= 0) {
            if (endId != null) {
                int idEnd = value.indexOf(endId, idStart + startId.length());
                if (idEnd != -1) {
                    result = value.substring(idStart + startId.length(), idEnd);
                }
            } else {
                result = value.substring(idStart + startId.length());
            }
        }
        return result;
    }

    public static String prepad(String s, int length) {
        return StringUtil.prepad(s, length, ' ');
    }

    public static String prepad(String s, int length, char c) {
        int needed = length - s.length();
        if (needed <= 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(length);
        for (int i = 0; i < needed; ++i) {
            sb.append(c);
        }
        sb.append(s);
        return sb.toString();
    }

    public static String postpad(String s, int length) {
        return StringUtil.postpad(s, length, ' ');
    }

    public static String postpad(String s, int length, char c) {
        int needed = length - s.length();
        if (needed <= 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(length);
        sb.append(s);
        for (int i = 0; i < needed; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String midpad(String s, int length) {
        return StringUtil.midpad(s, length, ' ');
    }

    public static String midpad(String s, int length, char c) {
        int i;
        int needed = length - s.length();
        if (needed <= 0) {
            return s;
        }
        int beginning = needed / 2;
        int end = beginning + needed % 2;
        StringBuffer sb = new StringBuffer(length);
        for (i = 0; i < beginning; ++i) {
            sb.append(c);
        }
        sb.append(s);
        for (i = 0; i < end; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String[] split(String s, String delimiter) {
        int end;
        int delimiterLength;
        int stringLength = s.length();
        if (delimiter == null || (delimiterLength = delimiter.length()) == 0) {
            return new String[]{s};
        }
        int count = 0;
        int start = 0;
        while ((end = s.indexOf(delimiter, start)) != -1) {
            ++count;
            start = end + delimiterLength;
        }
        String[] result = new String[++count];
        count = 0;
        start = 0;
        while ((end = s.indexOf(delimiter, start)) != -1) {
            result[count] = s.substring(start, end);
            ++count;
            start = end + delimiterLength;
        }
        end = stringLength;
        result[count] = s.substring(start, end);
        return result;
    }

    public static String escapeHTML(String s) {
        int length;
        if (s == null) {
            return s;
        }
        int newLength = length = s.length();
        boolean someCharacterEscaped = false;
        block18: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            int cint = 0xFFFF & c;
            if (cint < 32) {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': {
                        break;
                    }
                    default: {
                        --newLength;
                        someCharacterEscaped = true;
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\"': {
                    newLength += 5;
                    someCharacterEscaped = true;
                    continue block18;
                }
                case '&': 
                case '\'': {
                    newLength += 4;
                    someCharacterEscaped = true;
                    continue block18;
                }
                case '<': 
                case '>': {
                    newLength += 3;
                    someCharacterEscaped = true;
                }
            }
        }
        if (!someCharacterEscaped) {
            return s;
        }
        StringBuffer sb = new StringBuffer(newLength);
        block19: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            int cint = 0xFFFF & c;
            if (cint < 32) {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': {
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\"': {
                    sb.append(XML_QUOT);
                    continue block19;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block19;
                }
                case '&': {
                    sb.append(XML_AMP);
                    continue block19;
                }
                case '<': {
                    sb.append(XML_LESS);
                    continue block19;
                }
                case '>': {
                    sb.append(XML_GREATER);
                    continue block19;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String unEscapeXML(String str) {
        return StringEscapeUtils.unescapeXml((String)str);
    }

    public static String escapeXML(String s) {
        int length;
        if (s == null) {
            return s;
        }
        int newLength = length = s.length();
        boolean someCharacterEscaped = false;
        block12: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            int cint = 0xFFFF & c;
            switch (c) {
                case '\"': 
                case '\'': {
                    newLength += 5;
                    someCharacterEscaped = true;
                    continue block12;
                }
                case '&': {
                    newLength += 4;
                    someCharacterEscaped = true;
                    continue block12;
                }
                case '<': 
                case '>': {
                    newLength += 3;
                    someCharacterEscaped = true;
                }
            }
        }
        if (!someCharacterEscaped) {
            return s;
        }
        StringBuffer sb = new StringBuffer(newLength);
        block13: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            int cint = 0xFFFF & c;
            switch (c) {
                case '\"': {
                    sb.append(XML_QUOT);
                    continue block13;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block13;
                }
                case '&': {
                    sb.append(XML_AMP);
                    continue block13;
                }
                case '<': {
                    sb.append(XML_LESS);
                    continue block13;
                }
                case '>': {
                    sb.append(XML_GREATER);
                    continue block13;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeSQL(String s) {
        int length;
        if (s == null) {
            return null;
        }
        int newLength = length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0000': 
                case '\"': 
                case '\'': 
                case '\\': {
                    ++newLength;
                }
            }
        }
        if (length == newLength) {
            return s;
        }
        StringBuffer sb = new StringBuffer(newLength);
        block10: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block10;
                }
                case '\u0000': {
                    sb.append("\\0");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeJavaLiteral(String s) {
        int length;
        int newLength = length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '\'': 
                case '\\': {
                    ++newLength;
                }
            }
        }
        if (length == newLength) {
            return s;
        }
        StringBuffer sb = new StringBuffer(newLength);
        block12: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block12;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block12;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block12;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block12;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block12;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block12;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeSQLLiteral(String s) {
        int length;
        int newLength = length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    ++newLength;
                }
            }
        }
        if (length == newLength) {
            return s;
        }
        StringBuffer sb = new StringBuffer(newLength);
        block7: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    sb.append("''");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static boolean parseBoolean(String s, boolean defaultVal) {
        if (s == null || s.length() == 0) {
            return defaultVal;
        }
        if ("true".equalsIgnoreCase(s)) {
            return true;
        }
        return "1".equalsIgnoreCase(s);
    }

    public static String escapeLiteral(String s, char what, String with) {
        int length;
        int newLength = length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c != what) continue;
            ++newLength;
        }
        if (length == newLength) {
            return s;
        }
        StringBuffer sb = new StringBuffer(newLength);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == what) {
                sb.append(with);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unEscapeLiteral(String s, String lit, String with) {
        return StringUtil.replace(s, lit, with);
    }

    public static String unEscapeJavaLiteral(String s) {
        StringBuffer result = new StringBuffer(s);
        for (int l = 0; l < javaLiterals.length; ++l) {
            String aLit = javaLiterals[l];
            char aCharLit = javaCharLiterals[l];
            int litPos = 0;
            while ((litPos = result.indexOf(aLit)) >= 0) {
                if (litPos < 0) continue;
                result.replace(litPos, litPos + aLit.length(), "");
                result.insert(litPos, aCharLit);
            }
        }
        return result.toString();
    }

    public static String unEscapeSQLLiteral(String s) {
        StringBuffer result = new StringBuffer(s);
        for (int l = 0; l < sqlLiterals.length; ++l) {
            String aLit = sqlLiterals[l];
            char aCharLit = sqlCharLiterals[l];
            int litPos = 0;
            while ((litPos = result.indexOf(aLit)) >= 0) {
                if (litPos < 0) continue;
                result.replace(litPos, litPos + aLit.length(), "");
                result.insert(litPos, aCharLit);
            }
        }
        return result.toString();
    }

    public static String removeAllBetween(String text, String startQuali, String endQuali) {
        return StringUtil.removeAllBetween(text, startQuali, endQuali, false);
    }

    public static String removeAllBetween(String text, String startQuali, String endQuali, boolean onlyNumeric) {
        int sqLen = startQuali.length();
        int eqLen = endQuali.length();
        int comStart = text.indexOf(startQuali);
        if (comStart == -1) {
            return text;
        }
        StringBuffer cleared = new StringBuffer(text.length());
        int start = 0;
        while (comStart != -1) {
            String qualiContent;
            cleared.append(text.substring(start, comStart));
            int comEnd = text.indexOf(endQuali, comStart);
            if (comEnd == -1) break;
            if (onlyNumeric && !StringUtil.isNumeric(qualiContent = text.substring(comStart + sqLen, comEnd))) {
                cleared.append(text.substring(comStart, comEnd + eqLen));
            }
            comStart = text.indexOf(startQuali, comEnd + eqLen);
            start = comEnd + eqLen;
            if (comStart != -1) continue;
            cleared.append(text.substring(comEnd + eqLen));
        }
        return cleared.toString();
    }

    public static String replace(String source, String[] from, char[] to) {
        if (source == null) {
            return source;
        }
        StringBuffer result = new StringBuffer(source);
        int froms = from.length;
        for (int l = 0; l < froms; ++l) {
            String aLit = from[l];
            char aCharLit = to[l];
            int litPos = 0;
            while ((litPos = result.indexOf(aLit)) >= 0) {
                if (litPos < 0) continue;
                result.replace(litPos, litPos + aLit.length(), "");
                result.insert(litPos, aCharLit);
            }
        }
        return result.toString();
    }

    public static String escapeJavaScript(String value) {
        if (value != null) {
            StringBuffer result = new StringBuffer(value.length());
            block5: for (int l = 0; l < value.length(); ++l) {
                char aChar = value.charAt(l);
                switch (aChar) {
                    case '\'': {
                        result.append("\\'");
                        continue block5;
                    }
                    case '\"': {
                        result.append("&#34;");
                        continue block5;
                    }
                    case '\\': {
                        result.append("\\\\");
                        continue block5;
                    }
                    default: {
                        result.append(aChar);
                    }
                }
            }
            return result.toString();
        }
        return null;
    }

    public static String escapeToURLEncoding(String value) {
        if (value != null) {
            value = StringUtil.replace(value, URL_SPECIAL_ENC, URL_SPECIAL_ENC_DEST);
        }
        return value;
    }

    public static String unEscapeToURLEncoding(String value) {
        String encoded = StringUtil.replace(value, URL_SPECIAL_ENC_DEST, URL_SPECIAL_ENC);
        return encoded;
    }

    public static String[] unEscapeToURLEncoding(String[] values) {
        for (int l = 0; l < values.length; ++l) {
            values[l] = StringUtil.replace(values[l], URL_SPECIAL_ENC_DEST, URL_SPECIAL_ENC);
        }
        return values;
    }

    public static String[] unescapeHTML(String[] values) {
        for (int l = 0; l < values.length; ++l) {
            values[l] = StringUtil.unescapeHTML(values[l]);
        }
        return values;
    }

    public static String replace(String source, char[] from, String[] to) {
        if (source == null) {
            return source;
        }
        StringBuffer result = new StringBuffer(source);
        int froms = from.length;
        for (int l = 0; l < froms; ++l) {
            char fromChar = from[l];
            String toString = to != null ? to[l] : "";
            for (int i = result.length() - 1; i >= 0; --i) {
                if (result.charAt(i) != fromChar) continue;
                result.replace(i, i + 1, "");
                result.insert(i, toString);
            }
        }
        return result.toString();
    }

    public static StringBuffer replace(StringBuffer source, char[] from, String[] to) {
        StringBuffer result = source;
        int froms = from.length;
        for (int l = 0; l < froms; ++l) {
            char fromChar = from[l];
            String toString = to[l];
            for (int i = result.length() - 1; i >= 0; --i) {
                if (result.charAt(i) != fromChar) continue;
                result.replace(i, i + 1, "");
                result.insert(i, toString);
            }
        }
        return result;
    }

    public static String trim(String s, String c) {
        int j;
        char ch;
        int i;
        int length = s.length();
        if (c == null) {
            return s;
        }
        int cLength = c.length();
        if (c.length() == 0) {
            return s;
        }
        int start = 0;
        int end = length;
        boolean found = false;
        for (i = 0; !found && i < length; ++i) {
            ch = s.charAt(i);
            found = true;
            for (j = 0; found && j < cLength; ++j) {
                if (c.charAt(j) != ch) continue;
                found = false;
            }
        }
        if (!found) {
            return "";
        }
        start = i - 1;
        found = false;
        for (i = length - 1; !found && i >= 0; --i) {
            ch = s.charAt(i);
            found = true;
            for (j = 0; found && j < cLength; ++j) {
                if (c.charAt(j) != ch) continue;
                found = false;
            }
        }
        end = i + 2;
        return s.substring(start, end);
    }

    public static String trimRight(String content) {
        int len;
        int st = 0;
        int off = 0;
        char[] val = content.toCharArray();
        for (len = content.length(); st < len && val[off + len - 1] <= ' '; --len) {
        }
        return st > 0 || len < content.length() ? content.substring(st, len) : content;
    }

    public static String trimLeft(String content) {
        int st;
        int len = content.length();
        int off = 0;
        char[] val = content.toCharArray();
        for (st = 0; st < len && val[off + st] <= ' '; ++st) {
        }
        return st > 0 || len < content.length() ? content.substring(st, len) : content;
    }

    public static String unescapeHTML(String s) {
        StringBuffer result = new StringBuffer(s.length());
        int ampInd = s.indexOf(AMP);
        int lastEnd = 0;
        while (ampInd >= 0) {
            int nextAmp = s.indexOf(AMP, ampInd + 1);
            int nextSemi = s.indexOf(";", ampInd + 1);
            if (nextSemi != -1 && (nextAmp == -1 || nextSemi < nextAmp)) {
                int value = -1;
                String escape = s.substring(ampInd + 1, nextSemi);
                try {
                    if (escape.startsWith("#")) {
                        value = Integer.parseInt(escape.substring(1), 10);
                    } else if (htmlEntities.containsKey(escape)) {
                        value = (Integer)htmlEntities.get(escape);
                    }
                }
                catch (NumberFormatException x) {
                    // empty catch block
                }
                result.append(s.substring(lastEnd, ampInd));
                lastEnd = nextSemi + 1;
                if (value >= 0 && value <= 65535) {
                    result.append((char)value);
                } else {
                    result.append(AMP).append(escape).append(";");
                }
            }
            ampInd = nextAmp;
        }
        result.append(s.substring(lastEnd));
        return result.toString();
    }

    public static String escapeRegularExpressionLiteral(String s) {
        int length;
        int newLength = length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
            ++newLength;
        }
        if (length == newLength) {
            return s;
        }
        StringBuffer sb = new StringBuffer(newLength);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void buildFindAnyPattern(String[] terms, StringBuffer sb) {
        if (terms.length == 0) {
            throw new IllegalArgumentException("There must be at least one term to find.");
        }
        sb.append("(?:");
        for (int i = 0; i < terms.length; ++i) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append("(?:");
            sb.append(StringUtil.escapeRegularExpressionLiteral(terms[i]));
            sb.append(")");
        }
        sb.append(")");
    }

    public static Pattern getContainsAnyPattern(String[] terms) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?s).*");
        StringUtil.buildFindAnyPattern(terms, sb);
        sb.append(".*");
        return Pattern.compile(sb.toString());
    }

    public static Pattern getEqualsAnyPattern(String[] terms) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?s)\\A");
        StringUtil.buildFindAnyPattern(terms, sb);
        sb.append("\\z");
        return Pattern.compile(sb.toString());
    }

    public static Pattern getStartsWithAnyPattern(String[] terms) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?s)\\A");
        StringUtil.buildFindAnyPattern(terms, sb);
        sb.append(".*");
        return Pattern.compile(sb.toString());
    }

    public static Pattern getEndsWithAnyPattern(String[] terms) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?s).*");
        StringUtil.buildFindAnyPattern(terms, sb);
        sb.append("\\z");
        return Pattern.compile(sb.toString());
    }

    public static Pattern getContainsAnyIgnoreCasePattern(String[] terms) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?i)(?u)(?s).*");
        StringUtil.buildFindAnyPattern(terms, sb);
        sb.append(".*");
        return Pattern.compile(sb.toString());
    }

    public static Pattern getEqualsAnyIgnoreCasePattern(String[] terms) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?i)(?u)(?s)\\A");
        StringUtil.buildFindAnyPattern(terms, sb);
        sb.append("\\z");
        return Pattern.compile(sb.toString());
    }

    public static Pattern getStartsWithAnyIgnoreCasePattern(String[] terms) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?i)(?u)(?s)\\A");
        StringUtil.buildFindAnyPattern(terms, sb);
        sb.append(".*");
        return Pattern.compile(sb.toString());
    }

    public static Pattern getEndsWithAnyIgnoreCasePattern(String[] terms) {
        StringBuffer sb = new StringBuffer();
        sb.append("(?i)(?u)(?s).*");
        StringUtil.buildFindAnyPattern(terms, sb);
        sb.append("\\z");
        return Pattern.compile(sb.toString());
    }

    public static boolean containsAny(String s, String[] terms) {
        return StringUtil.getContainsAnyPattern(terms).matcher(s).matches();
    }

    public static boolean equalsAny(String s, String[] terms) {
        return StringUtil.getEqualsAnyPattern(terms).matcher(s).matches();
    }

    public static boolean startsWithAny(String s, String[] terms) {
        return StringUtil.getStartsWithAnyPattern(terms).matcher(s).matches();
    }

    public static boolean endsWithAny(String s, String[] terms) {
        return StringUtil.getEndsWithAnyPattern(terms).matcher(s).matches();
    }

    public static boolean containsAnyIgnoreCase(String s, String[] terms) {
        return StringUtil.getContainsAnyIgnoreCasePattern(terms).matcher(s).matches();
    }

    public static boolean equalsAnyIgnoreCase(String s, String[] terms) {
        return StringUtil.getEqualsAnyIgnoreCasePattern(terms).matcher(s).matches();
    }

    public static boolean startsWithAnyIgnoreCase(String s, String[] terms) {
        return StringUtil.getStartsWithAnyIgnoreCasePattern(terms).matcher(s).matches();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static void main(String[] args) {
        System.out.println(StringUtil.escapeXML("Ja (en')"));
        int[] cData = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5};
        int change2 = -1;
        while ((change2 = StringUtil.getSequenceChangePosLast(cData, change2 + 1)) != -1) {
            System.out.println(change2);
        }
        cData = new int[]{1, 1, 1, 1, 1};
        change2 = -1;
        while ((change2 = StringUtil.getSequenceChangePosLast(cData, change2 + 1)) != -1) {
            System.out.println(change2);
        }
        cData = new int[]{1, 2, 3, 4, 5};
        change2 = -1;
        while ((change2 = StringUtil.getSequenceChangePosLast(cData, change2 + 1)) != -1) {
            System.out.println(change2);
        }
        cData = new int[]{};
        change2 = 0;
        while ((change2 = StringUtil.getSequenceChangePos(cData, change2)) != -1) {
            System.out.println(change2);
        }
        Vector<Object[]> Data = new Vector<Object[]>();
        Data.add(new String[]{"1", "1", "1", "1"});
        Data.add(new String[]{"1", "1", "1", "1"});
        Data.add(new String[]{"1", "1", "1", "1"});
        Data.add(new String[]{"1", "2", "1", "1"});
        Data.add(new String[]{"1", "2", "1", "1"});
        Data.add(new String[]{"1", "2", "1", "1"});
        Data.add(new String[]{"1", "3", "1", "1"});
        Data.add(new String[]{"1", "3", "1", "1"});
        Data.add(new String[]{"1", "3", "1", "1"});
        Data.add(new String[]{"1", "4", "1", "1"});
        Data.add(new String[]{"1", "4", "1", "1"});
        Data.add(new String[]{"1", "4", "1", "1"});
        Data.add(new String[]{"1", "5", "1", "1"});
        change2 = -1;
        while ((change2 = StringUtil.getSequenceChangePosLast(Data, change2 + 1, 1)) != -1) {
            System.out.println(change2);
        }
        System.out.println(StringUtil.equals(null, null));
        System.out.println(StringUtil.equals(null, "1"));
        System.out.println(StringUtil.equals("1", null));
        System.out.println(StringUtil.equals("1", "1"));
        System.out.println(StringUtil.equals("1", "2"));
        System.out.print(StringUtil.getFirstLine("das ist ein test\ntest\narsch"));
        System.out.print(StringUtil.getFirstLine("das ist ein testtestarsch"));
        System.out.print(StringUtil.getFirstLine("\ndas ist ein test\ntest\narsch"));
        System.out.println(StringUtil.getFirstLine(""));
        System.out.println(new StringBuffer().append("evaluated:").append(ArrayUtil.toString(StringUtil.getAllBetween("a${das${ist${ein}test}}${test2}", "${", "}", null, '\uffff', '\uffff', false, false))).toString());
        System.out.println("expected :das${ist${ein}test},test2");
        System.out.println(new StringBuffer().append("evaluated:").append(ArrayUtil.toString(StringUtil.getAllBetween("a${$das${ist${ein}test}}${test2}$", "${", "}", null, '\uffff', '\uffff', false, false))).toString());
        System.out.println("expected :$das${ist${ein}test},test2");
        System.out.println(new StringBuffer().append("evaluated:").append(ArrayUtil.toString(StringUtil.getAllBetween("a${-$das${-ist${-ein-}test-}-}${-test2-}$", "${-", "-}", null, '\uffff', '\uffff', false, false))).toString());
        System.out.println("expected :$das${-ist${-ein-}test-},test2");
        System.out.println(new StringBuffer().append("evaluated:").append(ArrayUtil.toString(StringUtil.getAllBetween("$das${-ist${-ein-}test-}", "${-", "-}", null, '\uffff', '\uffff', false, false))).toString());
        System.out.println("expected :ist${-ein-}test");
        System.out.println(new StringBuffer().append("evaluated:").append(ArrayUtil.toString(StringUtil.getAllBetween("test <ref>aRef</ref> testr <ref>aRef2</ref> ende", "<ref>", "</ref>", null, '\uffff', '\uffff', false, false))).toString());
        System.out.println("expected :aRef,aRef2");
        System.out.println(new StringBuffer().append("evaluated:").append(ArrayUtil.toString(StringUtil.getAllBetween("<REF>Test1</REF><REF>Test2</REF>", "<REF>", "</REF>"))).toString());
        System.out.println("expected :Test1,Test2");
        System.out.println(new StringBuffer().append("evaluated:").append(ArrayUtil.toString(StringUtil.getAllBetween("", "<REF>", "</REF>"))).toString());
        System.out.println("expected : ");
        System.out.println(new StringBuffer().append("evaluated:").append(ArrayUtil.toString(StringUtil.getAllBetween(null, "<REF>", "</REF>"))).toString());
        System.out.println("expected :null");
        System.out.println(new StringBuffer().append("evaluated:").append(ArrayUtil.toString(StringUtil.getAllBetween("arsch", "<REF>", "</REF>"))).toString());
        System.out.println("expected :");
        System.out.println("das_ist_ein_TestF\ufffdrMich Oder nicht?");
        System.out.println(StringUtil.convertToCamelCase("das_ist_ein_TestF\ufffdrMich Oder nicht?", null));
        System.out.println(StringUtil.split("ID22232149_2_;_incomplete_;_Das Feld \"Antragsteller > Name\" ist zwingend einzugeben._;_ID22232149_3_;_incomplete_;_Das Feld \"Antragsteller > Adresse\" ist zwingend einzugeben._;_ID22232149_7_;_incomplete_;_Das Feld \"Antragsteller > Land\" ist zwingend einzugeben._;_ID22232149_8_;_incomplete_;_Das Feld \"Antragsteller > PLZ\" ist zwingend einzugeben._;_ID22232149_9_;_incomplete_;_Das Feld \"Antragsteller > Ort\" ist zwingend einzugeben._;_ID22232149_4_;_incomplete_;_Das Feld \"Antragsteller > Telefon\" ist zwingend einzugeben._;_ID22232149_6_;_incomplete_;_Das Feld \"Antragsteller > E-Mail\" ist zwingend einzugeben.", "_;_", "").size());
        System.out.println(StringUtil.split("das, ist, ein,, test, fall", ",", ",,").size());
        System.out.println(new StringBuffer().append(StringUtil.replace("-1--2-", "-", "|")).append("->|1||2|").toString());
        System.out.println(new StringBuffer().append(StringUtil.replace("123", "", "|")).append("->123").toString());
        System.out.println(new StringBuffer().append(StringUtil.replace("1-2---3----4", "--", "|")).append("->1-2|-3||4").toString());
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            System.out.println(new StringBuffer().append(StringUtil.replace("1-2---3----4", "--", "---")).append("->1-2----3------4").toString());
            System.out.println(new StringBuffer().append(StringUtil.replace("-1--2-", "-", "|")).append("->|1||2|").toString());
            System.out.println(new StringBuffer().append(StringUtil.replace("123", "", "|")).append("->123").toString());
            System.out.println(new StringBuffer().append(StringUtil.replace("1-2---3----4", "--", "|")).append("->1-2|-3||4").toString());
            System.out.println(new StringBuffer().append(StringUtil.replace("1-2---3----4", "-", "")).append("->1234").toString());
            System.out.println(new StringBuffer().append(StringUtil.replace("1-2---3----4", "4", "5")).append("->1-2---3----5").toString());
            System.out.println(new StringBuffer().append(StringUtil.replace("1-2---3----4", "1", "5")).append("->5-2---3----4").toString());
            System.out.println(new StringBuffer().append(StringUtil.replace("", "--", "---")).append("->").toString());
            System.out.println(new StringBuffer().append(StringUtil.replace(null, "--", "---")).append("->null").toString());
        }
        long stop = System.currentTimeMillis();
        long stop2 = System.currentTimeMillis();
        System.out.println(stop - start);
    }

    public static int getSequenceChangePos(int[] cData, int offset) {
        if (cData.length <= 0) {
            return -1;
        }
        if (offset < 0) {
            return 0;
        }
        int old = cData[offset];
        for (int i = offset; i < cData.length; ++i) {
            if (old == cData[i]) continue;
            return i;
        }
        return -1;
    }

    public static int getSequenceChangePosLast(int[] cData, int offset) {
        if (cData == null || cData.length <= 0) {
            return -1;
        }
        if (offset >= cData.length) {
            return -1;
        }
        int old = cData[offset];
        for (int i = offset; i < cData.length; ++i) {
            if (old != cData[i]) {
                return i - 1;
            }
            if (i + 1 != cData.length) continue;
            return i;
        }
        return -1;
    }

    public static int getSequenceChangePos(List data, int offset) {
        int size = data.size();
        if (size <= 0) {
            return -1;
        }
        if (offset < 0) {
            return 0;
        }
        Object old = data.get(offset);
        for (int i = offset; i < size; ++i) {
            if (StringUtil.equals(old, data.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static int getSequenceChangePosLast(List data, int offset) {
        int size = data.size();
        if (size == 0) {
            return -1;
        }
        if (offset >= size) {
            return -1;
        }
        Object old = data.get(offset);
        for (int i = offset; i < size; ++i) {
            if (!StringUtil.equals(old, data.get(i))) {
                return i - 1;
            }
            if (i + 1 != size) continue;
            return i;
        }
        return -1;
    }

    public static int getSequenceChangePos(List<Object[]> data, int offset, int arrPos) {
        int size = data.size();
        if (size <= 0) {
            return -1;
        }
        if (offset < 0) {
            return 0;
        }
        Object[] arrData = data.get(offset);
        Object old = arrData[arrPos];
        for (int i = offset; i < size; ++i) {
            arrData = data.get(i);
            Object cur = arrData[arrPos];
            if (StringUtil.equals(old, cur)) continue;
            return i;
        }
        return -1;
    }

    public static int getSequenceChangePosLast(List<Object[]> data, int offset, int arrPos) {
        int size = data.size();
        if (size == 0) {
            return -1;
        }
        if (offset >= size) {
            return -1;
        }
        Object[] arrData = data.get(offset);
        Object old = arrData[arrPos];
        for (int i = offset; i < size; ++i) {
            arrData = data.get(i);
            Object cur = arrData[arrPos];
            if (!StringUtil.equals(old, cur)) {
                return i - 1;
            }
            if (i + 1 != size) continue;
            return i;
        }
        return -1;
    }

    public static boolean endsWithAnyIgnoreCase(String s, String[] terms) {
        return StringUtil.getEndsWithAnyIgnoreCasePattern(terms).matcher(s).matches();
    }

    public static String format(boolean left, char fill, int size, String text) {
        int l;
        if (text == null) {
            text = "";
        }
        if ((l = text.length()) >= size) {
            return left ? text.substring(0, size) : text.substring(l - size);
        }
        StringBuffer buffer = new StringBuffer(size);
        StringUtil.format(left, fill, size, text, buffer);
        return buffer.toString();
    }

    public static String shredder(String text, int length, int startAt) {
        String base = text.substring(startAt);
        String trail = text.substring(0, startAt);
        if ((length -= startAt) <= 0) {
            return trail;
        }
        if (base.length() > length) {
            int difFactor = (int)Math.ceil((double)base.length() / (double)length);
            StringBuffer newSeqName = new StringBuffer(length);
            for (int s = 0; s < base.length(); s += difFactor) {
                newSeqName.append(base.charAt(s));
            }
            if (newSeqName.length() < length) {
                int addChars = length - newSeqName.length();
                newSeqName.append(base.substring(base.length() - addChars, base.length()));
            }
            base = newSeqName.toString();
        }
        return new StringBuffer().append(trail).append(base).toString();
    }

    public static void format(boolean left, char fill, int size, String text, StringBuffer buffer) {
        int l;
        if (text == null) {
            text = "";
        }
        if ((l = text.length()) >= size) {
            buffer.append(left ? text.substring(0, size) : text.substring(l - size));
        } else {
            if (left) {
                buffer.append(text);
            }
            size -= l;
            if (fill == ' ') {
                while (size > 31) {
                    buffer.append("                                ");
                    size -= 32;
                }
                if (size > 15) {
                    buffer.append("                ");
                    size -= 16;
                }
                if (size > 7) {
                    buffer.append("        ");
                    size -= 8;
                }
                switch (size) {
                    case 7: {
                        buffer.append("       ");
                        break;
                    }
                    case 6: {
                        buffer.append("      ");
                        break;
                    }
                    case 5: {
                        buffer.append("     ");
                        break;
                    }
                    case 4: {
                        buffer.append("    ");
                        break;
                    }
                    case 3: {
                        buffer.append("   ");
                        break;
                    }
                    case 2: {
                        buffer.append("  ");
                        break;
                    }
                    case 1: {
                        buffer.append(' ');
                    }
                }
            } else if (fill == '0') {
                while (size > 31) {
                    buffer.append("00000000000000000000000000000000");
                    size -= 32;
                }
                if (size > 15) {
                    buffer.append("0000000000000000");
                    size -= 16;
                }
                if (size > 7) {
                    buffer.append("00000000");
                    size -= 8;
                }
                switch (size) {
                    case 7: {
                        buffer.append("0000000");
                        break;
                    }
                    case 6: {
                        buffer.append("000000");
                        break;
                    }
                    case 5: {
                        buffer.append("00000");
                        break;
                    }
                    case 4: {
                        buffer.append("0000");
                        break;
                    }
                    case 3: {
                        buffer.append("000");
                        break;
                    }
                    case 2: {
                        buffer.append("00");
                        break;
                    }
                    case 1: {
                        buffer.append('0');
                    }
                }
            } else {
                while (size > 0) {
                    buffer.append(fill);
                    --size;
                }
            }
            if (!left) {
                buffer.append(text);
            }
        }
    }

    public static String replace(String text, String oldCharacters, String newCharacters) {
        if (text == null) {
            return null;
        }
        int l = oldCharacters.length();
        if (l > 0) {
            int i = text.indexOf(oldCharacters);
            if (i < 0) {
                return text;
            }
            int ncL = newCharacters.length() - 1;
            if (ncL < 0) {
                ncL = 0;
            }
            StringBuffer buffer = new StringBuffer(text.length() + 2 * ncL);
            buffer.append(text.substring(0, i));
            int j = 0;
            while ((j = text.indexOf(oldCharacters, i)) != -1) {
                buffer.append(text.substring(i, j));
                buffer.append(newCharacters);
                i = j + l;
            }
            buffer.append(text.substring(i));
            text = buffer.toString();
        }
        return text;
    }

    public static int getIdxOfNextNonDigit(String text, int from) {
        for (int ii = from; ii < text.length(); ++ii) {
            if (StringUtil.isDigit(text.charAt(ii))) continue;
            return ii;
        }
        return -1;
    }

    public static String replace(String source, char[] from, char to) {
        StringBuffer result = new StringBuffer(source.length());
        int froms = from.length;
        int sLength = source.length();
        for (int i = 0; i < sLength; ++i) {
            char aChar = source.charAt(i);
            if (!ArrayUtil.contains(from, aChar)) {
                result.append(aChar);
                continue;
            }
            result.append(to);
        }
        return result.toString();
    }

    public static String replace(String text, char varIdentifier, String[] values) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == varIdentifier) {
                int vIdxEnd = 0;
                int idx = -1;
                int newI = i;
                int ii = i + 1;
                while (ii < text.length() && StringUtil.isDigit(text.charAt(ii))) {
                    vIdxEnd = ii;
                    newI = ii++;
                }
                if (vIdxEnd > 0) {
                    idx = Integer.parseInt(text.substring(i + 1, vIdxEnd + 1));
                    if (values != null && values.length > 0 && idx > 0 && idx - 1 < values.length) {
                        result.append(values[idx - 1]);
                    }
                } else {
                    result.append(c);
                }
                i = newI;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String replaceIgnoreCase(String text, String oldCharacters, String newCharacters) {
        int l = oldCharacters.length();
        if (l > 0) {
            int ncL = newCharacters.length() - 1;
            if (ncL < 0) {
                ncL = 0;
            }
            StringBuffer buffer = new StringBuffer(text.length() + 2 * ncL);
            int i = 0;
            int j = 0;
            while ((j = StringUtil.indexOfIgnoreCase(text, oldCharacters, i)) != -1) {
                buffer.append(text.substring(i, j));
                buffer.append(newCharacters);
                i = j + l;
            }
            buffer.append(text.substring(i));
            text = buffer.toString();
        }
        return text;
    }

    public static int numberOfDigits(String text) {
        int l = text.length();
        int count = 0;
        for (int i = 0; i < l; ++i) {
            if (!Character.isDigit(text.charAt(i))) continue;
            ++count;
        }
        return count;
    }

    private static int getNestedEndPos(String text, int start, char openBracket, char closeBracket) {
        int endPos = -1;
        int oBCount = 0;
        int cBCount = 0;
        for (int i = start; i < text.length(); ++i) {
            char posChar = text.charAt(i);
            if (posChar == openBracket) {
                ++oBCount;
                endPos = i + 1;
                continue;
            }
            if (posChar == closeBracket) {
                endPos = i + 1;
                if (oBCount != ++cBCount) continue;
                return endPos;
            }
            endPos = i + 1;
        }
        return endPos;
    }

    private static boolean equalsAll(String text, String open, int pos) {
        return text.length() - pos - open.length() >= 0 && text.indexOf(open, pos) == pos;
    }

    private static int getNestedEndPos(String text, int start, String open, String close) {
        char openBracket = open.charAt(0);
        char closeBracket = close.charAt(0);
        int endPos = -1;
        int oBCount = 0;
        int cBCount = 0;
        int openLen = open.length() - 1;
        int closeLen = close.length() - 1;
        for (int i = start; i < text.length(); ++i) {
            char posChar = text.charAt(i);
            if (posChar == openBracket && StringUtil.equalsAll(text, open, i)) {
                ++oBCount;
                endPos = i + 1;
                i += openLen;
                continue;
            }
            if (posChar == closeBracket && StringUtil.equalsAll(text, close, i)) {
                endPos = i + 1;
                if (oBCount != ++cBCount) continue;
                return endPos;
            }
            endPos = i + 1;
        }
        return endPos;
    }

    public static List getAllBetween(String text, String from, String to) {
        return StringUtil.getAllBetween(text, from, to, null, '\uffff', '\uffff');
    }

    public static List getAllBetween(String text, String from, String to, String breakChars) {
        return StringUtil.getAllBetween(text, from, to, breakChars, '\uffff', '\uffff', false, false);
    }

    public static List getAllBetween(String text, String from, String to, String breakChars, char openBracket, char closeBracket) {
        return StringUtil.getAllBetween(text, from, to, breakChars, openBracket, closeBracket, false, false);
    }

    public static List getAllBetween(String text, String from, String to, String breakChars, char openBracket, char closeBracket, boolean returnIDXs, boolean recursive) {
        boolean useIndexOf;
        if (text == null) {
            return null;
        }
        int pos = 0;
        ArrayList<Object> result = new ArrayList<Object>();
        String bween = null;
        int[] fromTo = null;
        boolean bl = useIndexOf = openBracket == '\uffff' && closeBracket == '\uffff';
        while ((pos = text.indexOf(from, pos)) >= 0) {
            int endPos = 0;
            endPos = useIndexOf ? StringUtil.getNestedEndPos(text, pos, from, to) - 1 : StringUtil.getNestedEndPos(text, pos, openBracket, closeBracket) - 1;
            if (endPos <= pos) break;
            bween = text.substring(pos + from.length(), endPos);
            fromTo = new int[]{pos + from.length(), endPos};
            if (breakChars != null && breakChars.length() > 0) {
                boolean breaked = false;
                for (int i = 0; i < bween.length(); ++i) {
                    int bIdx = breakChars.indexOf(bween.charAt(i));
                    if (bIdx < 0) continue;
                    if (returnIDXs) {
                        fromTo = new int[]{fromTo[0], fromTo[1] + i};
                        result.add(fromTo);
                    } else {
                        result.add(bween.substring(0, i));
                    }
                    breaked = true;
                    break;
                }
                if (!breaked) {
                    if (returnIDXs) {
                        result.add(fromTo);
                    } else {
                        result.add(bween);
                    }
                }
            } else if (returnIDXs) {
                result.add(fromTo);
            } else {
                result.add(bween);
            }
            if (useIndexOf) {
                pos = endPos;
                continue;
            }
            if (recursive) {
                int nestedPos = text.indexOf(from, pos + 1);
                if (nestedPos >= 0) {
                    pos = nestedPos;
                    continue;
                }
                pos = endPos;
                continue;
            }
            pos = endPos;
        }
        return result;
    }

    public static int indexOfIgnoreCase(String string, String substring, int fromIndex) {
        String ls = string.toLowerCase();
        String ss = substring.toLowerCase();
        return ls.indexOf(ss, fromIndex);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix, int offset) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.regionMatches(true, offset, prefix, 0, prefix.length());
    }

    public static String insert(String into, int pos, String what) {
        if (pos >= 0 && pos <= into.length() && into != null && what != null) {
            return new StringBuffer(into).insert(pos, what).toString();
        }
        return into;
    }

    public static String insert(String into, int pos, char what) {
        if (pos >= 0 && pos <= into.length() && into != null) {
            return new StringBuffer(into).insert(pos, what).toString();
        }
        return into;
    }

    public static String removeSpecialChars(String result, boolean spaceIncluded) {
        String theResult = "";
        theResult = StringUtil.removeSpecialChars(result);
        if (spaceIncluded) {
            theResult = StringUtil.removeSpaceChars(result);
        }
        return theResult;
    }

    public static String removeSpecialChars(String result) {
        StringBuffer resBuf = new StringBuffer(result.length());
        block3: for (int c = 0; c < result.length(); ++c) {
            char cur = result.charAt(c);
            switch (cur) {
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\u000b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    resBuf.append(' ');
                    continue block3;
                }
                default: {
                    resBuf.append(cur);
                }
            }
        }
        return resBuf.toString();
    }

    public static String removeSpaceChars(String result) {
        result = result.replace(' ', '\u0000');
        return result;
    }

    public static boolean isNumeric(String text) {
        if (text == null) {
            return false;
        }
        int length = text.length();
        if (length == 0) {
            return false;
        }
        int start = 0;
        if (text.charAt(0) == '-') {
            start = 1;
        }
        boolean dotEncountered = false;
        for (int i = start; i < length; ++i) {
            char c = text.charAt(i);
            if (Character.isDigit(c)) continue;
            if (!dotEncountered && c == '.') {
                dotEncountered = true;
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean equals(String val1, String val2) {
        if (val1 == val2) {
            return true;
        }
        return val1 != null && val1.equals(val2);
    }

    public static boolean equals(Object val1, Object val2) {
        if (val1 == val2) {
            return true;
        }
        return val1 != null && val1.equals(val2);
    }

    public static boolean isTrue(String val) {
        if (val == null || val.equalsIgnoreCase("false")) {
            return false;
        }
        return val.equalsIgnoreCase("true") || val.equalsIgnoreCase("y") || val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("1") || val.equalsIgnoreCase("1.0");
    }

    public static boolean isInteger(String myInput) {
        if (myInput == null || myInput.length() < 1) {
            return false;
        }
        int start = 0;
        if (myInput.charAt(0) == '-') {
            start = 1;
        }
        int length = myInput.length();
        for (int i = start; i < length; ++i) {
            if (Character.isDigit(myInput.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isDigit(char v) {
        return Character.isDigit(v);
    }

    public static boolean isAlpha(char v) {
        return Character.isLetter(v);
    }

    public static boolean isAlphaNumeric(char v) {
        return Character.isLetterOrDigit(v);
    }

    public static boolean isFloatString(String str) {
        int decimalPointCount = 0;
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            boolean flag;
            if (str.charAt(i) == '.') {
                ++decimalPointCount;
            }
            boolean bl = flag = StringUtil.isDigit(str.charAt(i)) && decimalPointCount <= 1;
            if (flag) continue;
            return false;
        }
        return true;
    }

    public static boolean isIntegerString(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            boolean flag = StringUtil.isDigit(str.charAt(i));
            if (flag) continue;
            return false;
        }
        return true;
    }

    public static int getInt(String integer) {
        if (integer == null || integer.length() == 0) {
            return 0;
        }
        if (StringUtil.isInteger(integer)) {
            return Integer.parseInt(integer);
        }
        return 0;
    }

    public static long getLong(String value, long defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static short getShort(String value, short defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        try {
            return Short.parseShort(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static double getDouble(String value, double defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getInt(String integer, int defaultValue) {
        if (integer == null || integer.length() == 0) {
            return defaultValue;
        }
        if (StringUtil.isInteger(integer)) {
            return Integer.parseInt(integer);
        }
        return defaultValue;
    }

    public static int extractInt(String mixedString) {
        if (mixedString == null || mixedString.length() == 0) {
            return 0;
        }
        int start = -1;
        int end = -1;
        for (int c = 0; c < mixedString.length(); ++c) {
            if (StringUtil.isDigit(mixedString.charAt(c))) {
                if (start == -1) {
                    start = c;
                    end = c + 1;
                    continue;
                }
                end = c + 1;
                continue;
            }
            if (start == -1) continue;
            end = c;
            break;
        }
        if (start != -1 && end != -1) {
            return Integer.valueOf(mixedString.substring(start, end));
        }
        return -1;
    }

    public static String extractIntAsString(String mixedString) {
        if (mixedString == null || mixedString.length() == 0) {
            return "0";
        }
        int start = -1;
        int end = -1;
        for (int c = 0; c < mixedString.length(); ++c) {
            if (StringUtil.isDigit(mixedString.charAt(c))) {
                if (start == -1) {
                    start = c;
                    end = c + 1;
                    continue;
                }
                end = c + 1;
                continue;
            }
            if (start == -1) continue;
            end = c;
            break;
        }
        if (start != -1 && end != -1) {
            return mixedString.substring(start, end);
        }
        return "-1";
    }

    public static boolean isAlpha(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            boolean flag = StringUtil.isAlpha(str.charAt(i));
            if (flag) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            boolean flag = StringUtil.isAlphaNumeric(str.charAt(i));
            if (flag) continue;
            return false;
        }
        return false;
    }

    public static boolean checkDistance(String source, char aChar, int distance) {
        int distStart = -1;
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) != aChar) continue;
            if (distStart != -1 && i - distStart != distance) {
                return false;
            }
            distStart = i;
        }
        return true;
    }

    public static boolean checkDistance(String source, char[] aChar, int distance) {
        int distStart = -1;
        for (int i = 0; i < source.length(); ++i) {
            for (int j = 0; j < aChar.length; ++j) {
                if (source.charAt(i) != aChar[j]) continue;
                if (distStart != -1 && i - distStart != distance) {
                    return false;
                }
                distStart = i;
            }
        }
        return true;
    }

    public static List removeDuplicates(String[] data) {
        if (data == null) {
            return null;
        }
        Vector<String> result = null;
        Hashtable<String, String> found = new Hashtable<String, String>();
        for (int i = 0; i < data.length; ++i) {
            String item = data[i];
            if (found.containsKey(item)) continue;
            if (result == null) {
                result = new Vector<String>();
            }
            if (item == null) continue;
            result.add(item);
            found.put(item, item);
        }
        return result;
    }

    public static String[][] removeDuplicates(int startCol, String[][] data) {
        int rLength = data.length;
        if (rLength <= 0) {
            return new String[0][0];
        }
        Vector<Object[]> content = new Vector<Object[]>(rLength);
        Hashtable<String, String> dupHash = new Hashtable<String, String>(rLength);
        for (int i = 0; i < rLength; ++i) {
            Object[] row = data[i];
            String key = Arrays.toString(row);
            if (dupHash.containsKey(key)) continue;
            content.add(row);
            dupHash.put(key, "");
        }
        String[][] result = new String[content.size()][];
        for (int c = 0; c < content.size(); ++c) {
            result[c] = (String[])content.get(c);
        }
        return result;
    }

    public static List removeDuplicates(List strArrData) {
        int rLength = strArrData.size();
        if (rLength <= 0) {
            return new Vector();
        }
        Vector<Object[]> content = new Vector<Object[]>(rLength);
        Hashtable<String, String> dupHash = new Hashtable<String, String>(rLength);
        for (int i = 0; i < rLength; ++i) {
            Object[] row = (Object[])strArrData.get(i);
            String key = Arrays.toString(row);
            if (dupHash.containsKey(key)) continue;
            content.add(row);
            dupHash.put(key, "");
        }
        return content;
    }

    public static int countTokens(String value, char token, boolean retDelims) {
        int count = 0;
        int currpos = 0;
        int maxPosition = value.length();
        while (currpos < maxPosition) {
            char c;
            while (currpos < value.length()) {
                char c2 = value.charAt(currpos);
                if (!retDelims && token != c2) break;
                ++currpos;
            }
            if (currpos >= maxPosition) break;
            int startPos = currpos;
            while (currpos < value.length() && token != (c = value.charAt(currpos))) {
                ++currpos;
            }
            if (retDelims && startPos == currpos && token != (c = value.charAt(currpos))) {
                ++currpos;
            }
            ++count;
        }
        return count;
    }

    public static Comparator getNaturalComparator() {
        Collator collator = Collator.getInstance();
        return StringUtil.getNaturalComparator(collator);
    }

    public static Comparator getNaturalComparator(final Collator collator) {
        if (collator == null) {
            throw new NullPointerException("collator must not be null");
        }
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return StringUtil.compareNatural(collator, (String)o1, (String)o2);
            }
        };
    }

    public static Comparator getNaturalTypeTreeLabelComparator() {
        Collator collator = Collator.getInstance();
        return StringUtil.getNaturalTypeTreeLabelComparator(collator);
    }

    public static Comparator getNaturalTypeTreeLabelComparator(final Collator collator) {
        if (collator == null) {
            throw new NullPointerException("collator must not be null");
        }
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return StringUtil.compareNatural(collator, ((Type)o1).getStyle().getTreeLabelText(), ((Type)o2).getStyle().getTreeLabelText());
            }
        };
    }

    public static Comparator getNaturalTypeXPathComparator() {
        Collator collator = Collator.getInstance();
        return StringUtil.getNaturalTypeXPathComparator(collator);
    }

    public static Comparator getNaturalTypeXPathComparator(final Collator collator) {
        if (collator == null) {
            throw new NullPointerException("collator must not be null");
        }
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return StringUtil.compareNatural(collator, ((Type)o1).getXPathLocation(), ((Type)o2).getXPathLocation());
            }
        };
    }

    public static Comparator getNaturalComparatorAscii() {
        return NATURAL_COMPARATOR_ASCII;
    }

    public static Comparator getNaturalComparatorIgnoreCaseAscii() {
        return IGNORE_CASE_NATURAL_COMPARATOR_ASCII;
    }

    public static int compareNatural(String s, String t) {
        return StringUtil.compareNatural(s, t, false, Collator.getInstance());
    }

    public static int compareNatural(Collator collator, String s, String t) {
        return StringUtil.compareNatural(s, t, true, collator);
    }

    public static int compareNaturalAscii(String s, String t) {
        return StringUtil.compareNatural(s, t, true, null);
    }

    public static int compareNaturalIgnoreCaseAscii(String s, String t) {
        return StringUtil.compareNatural(s, t, false, null);
    }

    private static int compareNatural(String s, String t, boolean caseSensitive, Collator collator) {
        int sIndex = 0;
        int tIndex = 0;
        int sLength = s.length();
        int tLength = t.length();
        block0: while (sIndex != sLength || tIndex != tLength) {
            if (sIndex == sLength) {
                return -1;
            }
            if (tIndex == tLength) {
                return 1;
            }
            char sChar = s.charAt(sIndex);
            char tChar = t.charAt(tIndex);
            boolean sCharIsDigit = Character.isDigit(sChar);
            boolean tCharIsDigit = Character.isDigit(tChar);
            if (sCharIsDigit && tCharIsDigit) {
                boolean tAllZero;
                int sLeadingZeroCount = 0;
                while (sChar == '0') {
                    ++sLeadingZeroCount;
                    if (++sIndex == sLength) break;
                    sChar = s.charAt(sIndex);
                }
                int tLeadingZeroCount = 0;
                while (tChar == '0') {
                    ++tLeadingZeroCount;
                    if (++tIndex == tLength) break;
                    tChar = t.charAt(tIndex);
                }
                boolean sAllZero = sIndex == sLength || !Character.isDigit(sChar);
                boolean bl = tAllZero = tIndex == tLength || !Character.isDigit(tChar);
                if (sAllZero && tAllZero) continue;
                if (sAllZero && !tAllZero) {
                    return -1;
                }
                if (tAllZero) {
                    return 1;
                }
                int diff = 0;
                do {
                    if (diff == 0) {
                        diff = sChar - tChar;
                    }
                    if (++sIndex == sLength && ++tIndex == tLength) {
                        return diff != 0 ? diff : sLeadingZeroCount - tLeadingZeroCount;
                    }
                    if (sIndex == sLength) {
                        if (diff == 0) {
                            return -1;
                        }
                        return Character.isDigit(t.charAt(tIndex)) ? -1 : diff;
                    }
                    if (tIndex == tLength) {
                        if (diff == 0) {
                            return 1;
                        }
                        return Character.isDigit(s.charAt(sIndex)) ? 1 : diff;
                    }
                    sChar = s.charAt(sIndex);
                    tChar = t.charAt(tIndex);
                    sCharIsDigit = Character.isDigit(sChar);
                    tCharIsDigit = Character.isDigit(tChar);
                    if (!sCharIsDigit && !tCharIsDigit) {
                        if (diff == 0) continue block0;
                        return diff;
                    }
                    if (sCharIsDigit) continue;
                    return -1;
                } while (tCharIsDigit);
                return 1;
            }
            if (collator != null) {
                String bs;
                int aw = sIndex;
                int bw = tIndex;
                while (++sIndex < sLength && !Character.isDigit(s.charAt(sIndex))) {
                }
                while (++tIndex < tLength && !Character.isDigit(t.charAt(tIndex))) {
                }
                String as = s.substring(aw, sIndex);
                int subwordResult = collator.compare(as, bs = t.substring(bw, tIndex));
                if (subwordResult == 0) continue;
                return subwordResult;
            }
            do {
                if (sChar != tChar) {
                    if (caseSensitive) {
                        return sChar - tChar;
                    }
                    if ((sChar = Character.toUpperCase(sChar)) != (tChar = Character.toUpperCase(tChar)) && (sChar = Character.toLowerCase(sChar)) != (tChar = Character.toLowerCase(tChar))) {
                        return sChar - tChar;
                    }
                }
                if (++sIndex == sLength && ++tIndex == tLength) {
                    return 0;
                }
                if (sIndex == sLength) {
                    return -1;
                }
                if (tIndex == tLength) {
                    return 1;
                }
                sChar = s.charAt(sIndex);
                tChar = t.charAt(tIndex);
                sCharIsDigit = Character.isDigit(sChar);
                tCharIsDigit = Character.isDigit(tChar);
            } while (!sCharIsDigit && !tCharIsDigit);
        }
        return 0;
    }

    public static String appendCount(String source) {
        int count = 1;
        for (int s = source.length() - 1; s >= 0; --s) {
            if (Character.isDigit(source.charAt(s))) continue;
            String posNumStr = source.substring(s + 1);
            if (!StringUtil.isInteger(posNumStr)) break;
            count = Integer.parseInt(posNumStr) + 1;
            source = source.substring(0, s + 1);
            break;
        }
        return new StringBuffer().append(source).append(count).toString();
    }

    public static String addIfNotEndWith(String value, String add) {
        if (value != null && !value.endsWith(add)) {
            value = new StringBuffer().append(value).append(add).toString();
        }
        return value;
    }

    public static String replaceNumberTail(String source, long replacement) {
        if (source.lastIndexOf(".") != -1) {
            String extension = source.substring(source.lastIndexOf(".") + 1, source.length());
            return new StringBuffer().append(source.substring(0, source.lastIndexOf("."))).append(replacement).append(".").append(extension).toString();
        }
        source = new StringBuffer().append(source).append(replacement).toString();
        return source;
    }

    public static int getFirstStartsWith(String[] data, String value) {
        int pos = -1;
        for (int si = 0; si < data.length; ++si) {
            if (!data[si].startsWith(value)) continue;
            pos = si;
            break;
        }
        return pos;
    }

    public static int getLastStartsWith(String[] data, String value) {
        int pos = -1;
        for (int si = data.length - 1; si >= 0; --si) {
            if (!data[si].startsWith(value)) continue;
            pos = si;
            break;
        }
        return pos;
    }

    public void recursionMemTestRec(int value) {
        if (value > 0) {
            this.recursionMemTestRec(value - 1);
        }
    }

    public void recursionMemTestfor(int value) {
        int aValue = value;
        for (int i = 0; i < value; ++i) {
            --aValue;
        }
    }

    public static String removeIfLast(String value, String last) {
        return StringUtil.removeIfLast(value, last, false);
    }

    public static String removeIfLast(String value, String last, boolean trimRight) {
        if (trimRight) {
            value = StringUtil.trimRight(value);
        }
        if (value.endsWith(last)) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public static String removeIfFirst(String value, String first) {
        if (value.startsWith(first)) {
            value = value.substring(first.length(), value.length());
        }
        return value;
    }

    public static String cut(String string, int length) {
        if (string == null || string.length() < length) {
            return string;
        }
        return string.substring(0, length);
    }

    public static String cut(String string, int length, String cutTail) {
        if (string == null || string.length() < length) {
            return string;
        }
        return new StringBuffer().append(string.substring(0, length)).append(cutTail).toString();
    }

    public static String replaceLetters(String result, String replacement) {
        if (result == null) {
            return result;
        }
        StringBuffer resBuf = new StringBuffer(result.length());
        block3: for (int c = 0; c < result.length(); ++c) {
            char cur = result.charAt(c);
            switch (cur) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    resBuf.append(' ');
                    continue block3;
                }
                default: {
                    resBuf.append(cur);
                }
            }
        }
        return resBuf.toString();
    }

    public static int[] getOptimalColWidth(HashMap colFormatters, int readAhead, int[] minVals, int maxVal, int filerColumn, String[] visColNames, String[][] values) {
        int i;
        Font font = new Font("Verdana", 0, 11);
        int cols = visColNames.length;
        if (filerColumn >= 0) {
            --cols;
        }
        int[] colWidths = new int[cols];
        if (readAhead == -1) {
            readAhead = Integer.MAX_VALUE;
        }
        for (int i2 = 0; i2 < colWidths.length; ++i2) {
            String aColName = visColNames[i2];
            if (aColName == null) continue;
            colWidths[i2] = TextTools.calculateTextLength(font, aColName);
        }
        int rLength = values.length;
        for (i = 0; i < rLength && i < readAhead; ++i) {
            String[] aRow = values[i];
            int offset = 0;
            for (int j = 0; j < aRow.length; ++j) {
                if (filerColumn != j) {
                    String aVal = aRow[j];
                    int vLength = 0;
                    if (aVal != null) {
                        ColumnFormatter aFormatter;
                        if (colFormatters != null && (aFormatter = (ColumnFormatter)colFormatters.get(visColNames[j])) != null) {
                            aVal = aFormatter.format(null, i, j, j, aVal);
                        }
                        vLength = TextTools.calculateTextLength(font, aVal.trim());
                    }
                    colWidths[j + offset] = Math.max(colWidths[j + offset], vLength);
                    continue;
                }
                offset = -1;
            }
        }
        for (i = 0; i < colWidths.length; ++i) {
            colWidths[i] = ArrayUtil.getMaxSegment(minVals, colWidths[i]);
            if (maxVal == -1) continue;
            colWidths[i] = Math.min(colWidths[i], maxVal);
        }
        return colWidths;
    }

    public static String verticalize(String text) {
        StringBuffer result = new StringBuffer(text.length() * 2);
        for (int t = 0; t < text.length(); ++t) {
            result.append(text.charAt(t));
            result.append("\n");
        }
        return result.toString();
    }

    public static String[] toLines(String logoText) {
        return StringUtil.split(logoText, "\n");
    }

    public static List getAllVarsFrom(String template) {
        return StringUtil.getAllBetween(template, "${", "}", "!", '\uffff', '\uffff');
    }

    public static String fillWith(int length, String fillWith, String source) {
        int dif = length - source.length();
        if (dif <= 0) {
            return source;
        }
        StringBuffer res = new StringBuffer(length);
        for (int i = 0; i < dif; ++i) {
            res.append(fillWith);
        }
        res.append(source);
        return res.toString();
    }

    public static String repeat(int times, String what) {
        StringBuffer buff = new StringBuffer(times * what.length());
        for (int i = 0; i < times; ++i) {
            buff.append(what);
        }
        return buff.toString();
    }

    public static String replaceAllBetween(String text, String startQuali, String endQuali, String replace) {
        int sqLen = startQuali.length();
        int eqLen = endQuali.length();
        int comStart = text.indexOf(startQuali);
        if (comStart == -1) {
            return text;
        }
        int comStartOld = comStart;
        StringBuffer cleared = new StringBuffer(text.length());
        int start = 0;
        while (comStart != -1) {
            cleared.append(text.substring(start, comStart));
            int comEnd = text.indexOf(endQuali, comStart);
            if (comEnd == -1) break;
            comStartOld = comStart;
            comStart = text.indexOf(startQuali, comEnd + eqLen);
            start = comEnd + eqLen;
            if (comStart == -1) {
                cleared.append(replace);
                cleared.append(text.substring(comEnd + eqLen));
                continue;
            }
            cleared.append(replace);
        }
        return cleared.toString();
    }

    public static String substringBefore(String value, String what) {
        if (value == null) {
            return null;
        }
        int s = value.indexOf(what);
        if (s >= 0) {
            return value.substring(0, s);
        }
        return null;
    }

    public static String substringAfter(String value, String what) {
        if (value == null) {
            return null;
        }
        int s = value.indexOf(what);
        if (s >= 0 && s + 1 < value.length()) {
            return value.substring(s + 1);
        }
        return null;
    }

    public static String escape(String s, String what, String with) {
        if (s == null) {
            return s;
        }
        int whatIdx = s.indexOf(what);
        if (whatIdx < 0) {
            return s;
        }
        return StringUtil.replace(s, what, with);
    }

    public static List split(String s, String token, String reserved) {
        ArrayList<String> resultArray = new ArrayList<String>();
        StringBuffer result = new StringBuffer(s.length());
        char startTokChar = token.charAt(0);
        int sLen = s.length();
        int tLen = token.length();
        int escLen = reserved != null ? reserved.length() : 0;
        for (int c = 0; c < sLen; ++c) {
            char aChar = s.charAt(c);
            if (aChar == startTokChar && s.startsWith(token, c)) {
                int readAhead = c - escLen + 1;
                if (escLen > 0 && s.startsWith(reserved, c)) {
                    result.append(aChar);
                    continue;
                }
                if (escLen > 0 && readAhead >= 0) {
                    if (s.startsWith(reserved, readAhead)) {
                        result.append(aChar);
                        continue;
                    }
                    resultArray.add(result.toString());
                    result = new StringBuffer();
                    if (tLen <= 1) continue;
                    c += tLen - 1;
                    continue;
                }
                resultArray.add(result.toString());
                result = new StringBuffer();
                if (tLen <= 1) continue;
                c += tLen - 1;
                continue;
            }
            result.append(aChar);
        }
        if (result.length() > 0) {
            resultArray.add(result.toString());
        }
        return resultArray;
    }

    public static String[] splitString(String s, String token, String reserved) {
        Object[] resultArray = null;
        StringBuffer result = new StringBuffer(s.length());
        char startTokChar = token.charAt(0);
        int sLen = s.length();
        int tLen = token.length();
        int escLen = reserved != null ? reserved.length() : 0;
        for (int c = 0; c < sLen; ++c) {
            char aChar = s.charAt(c);
            if (aChar == startTokChar && s.startsWith(token, c)) {
                int readAhead = c - escLen + 1;
                if (escLen > 0 && s.startsWith(reserved, c)) {
                    result.append(aChar);
                    continue;
                }
                if (escLen > 0 && readAhead >= 0) {
                    if (s.startsWith(reserved, readAhead)) {
                        result.append(aChar);
                        continue;
                    }
                    resultArray = ArrayUtil.addToGrowArray(resultArray, result.toString(), 10);
                    result = new StringBuffer();
                    if (tLen <= 1) continue;
                    c += tLen - 1;
                    continue;
                }
                resultArray = ArrayUtil.addToGrowArray(resultArray, result.toString(), 10);
                result = new StringBuffer();
                if (tLen <= 1) continue;
                c += tLen - 1;
                continue;
            }
            result.append(aChar);
        }
        if (result.length() > 0) {
            resultArray = ArrayUtil.addToGrowArray(resultArray, result.toString(), 10);
        }
        return (String[])ArrayUtil.finalizeGrowArray(class$java$lang$String == null ? (class$java$lang$String = StringUtil.class$("java.lang.String")) : class$java$lang$String, resultArray);
    }

    public static String convertToCamelCase(String cn, String regex) {
        StringBuffer sb = new StringBuffer();
        if (regex == null) {
            regex = "[_ ]";
        }
        String[] str = cn.split(regex);
        boolean firstTime = true;
        for (String temp : str) {
            if (firstTime) {
                sb.append(temp.toLowerCase());
                firstTime = false;
                continue;
            }
            sb.append(Character.toUpperCase(temp.charAt(0)));
            sb.append(temp.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public static String appendNotNull(String stra, String strb, String delim) {
        boolean hasA;
        StringBuilder res = new StringBuilder();
        boolean bl = hasA = stra != null && stra.length() > 0;
        if (hasA) {
            res.append(stra);
        }
        if (strb != null && strb.length() > 0) {
            if (delim != null && hasA) {
                res.append(delim);
            }
            res.append(strb);
        }
        return res.toString();
    }

    public static String getFirstLine(String messageText) {
        if (messageText == null || messageText.length() == 0) {
            return null;
        }
        int nlIdx = messageText.indexOf(10);
        if (nlIdx >= 0) {
            return messageText.substring(0, nlIdx + 1);
        }
        return null;
    }

    public static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    public static String removeIfFirstLast(String string, String first, String last) {
        if (string != null && string.startsWith(first) && string.endsWith(last)) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String[] escapeSQL(String[] lookupValues) {
        for (int l = 0; l < lookupValues.length; ++l) {
            lookupValues[l] = StringUtil.escapeSQL(lookupValues[l]);
        }
        return lookupValues;
    }

    public static String encodeJaxProtokolToURL(String data) {
        return StringUtil.replace(data, jax_protokol_escape, jax_protokol_unescape);
    }

    public static String decodeJaxProtokolFromURL(String data) {
        return StringUtil.replace(data, jax_protokol_unescape, jax_protokol_escape);
    }

    public static String[] trim(String[] columnNames) {
        if (columnNames != null && columnNames.length > 0) {
            for (int c = 0; c < columnNames.length; ++c) {
                columnNames[c] = columnNames[c] != null ? columnNames[c].trim() : null;
            }
        }
        return columnNames;
    }

    public static List readLines(InputStream inStream, boolean skipEmpty) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        char[] convtBuf = new char[1024];
        BufferedReader lr = new BufferedReader(new InputStreamReader(inStream));
        String line = null;
        while ((line = lr.readLine()) != null) {
            if (skipEmpty && line.length() == 0) continue;
            result.add(line);
        }
        return result;
    }

    public static String unEscapeFreemarker(String value) {
        if (value == null) {
            return value;
        }
        int uscIdx = value.indexOf("_");
        if (uscIdx == -1) {
            return value;
        }
        StringBuffer result = new StringBuffer(value.length());
        result.append(value.substring(0, uscIdx));
        block3: for (int l = uscIdx; l < value.length(); ++l) {
            char aChar = value.charAt(l);
            switch (aChar) {
                case '_': {
                    if (value.startsWith("P_", l + 1)) {
                        result.append('/');
                        l += 2;
                        continue block3;
                    }
                    if (value.startsWith("M_", l + 1)) {
                        result.append('-');
                        l += 2;
                        continue block3;
                    }
                    if (value.startsWith("LB_", l + 1)) {
                        result.append('[');
                        l += 3;
                        continue block3;
                    }
                    if (value.startsWith("RB_", l + 1)) {
                        result.append(']');
                        l += 3;
                        continue block3;
                    }
                    if (value.startsWith("EQ_", l + 1)) {
                        result.append('=');
                        l += 3;
                        continue block3;
                    }
                    result.append(aChar);
                    continue block3;
                }
                default: {
                    result.append(aChar);
                }
            }
        }
        return result.toString();
    }

    public static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String getQuoted(String str) {
        StringBuilder res = new StringBuilder("\"");
        res.append(str);
        res.append("\"");
        return res.toString();
    }

    public static String getSQuoted(String str) {
        StringBuilder res = new StringBuilder("'");
        res.append(str);
        res.append("'");
        return res.toString();
    }

    public static StringBuilder printQuoted(StringBuilder str) {
        str.append("\"");
        str.append((CharSequence)str);
        str.append("\"");
        return str;
    }

    public static String nullToEmpty(String text) {
        return text == null ? "" : text;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        htmlEntities.put("nbsp", new Integer(160));
        htmlEntities.put("iexcl", new Integer(161));
        htmlEntities.put("cent", new Integer(162));
        htmlEntities.put("pound", new Integer(163));
        htmlEntities.put("curren", new Integer(164));
        htmlEntities.put("yen", new Integer(165));
        htmlEntities.put("brvbar", new Integer(166));
        htmlEntities.put("sect", new Integer(167));
        htmlEntities.put("uml", new Integer(168));
        htmlEntities.put("copy", new Integer(169));
        htmlEntities.put("ordf", new Integer(170));
        htmlEntities.put("laquo", new Integer(171));
        htmlEntities.put("not", new Integer(172));
        htmlEntities.put("shy", new Integer(173));
        htmlEntities.put("reg", new Integer(174));
        htmlEntities.put("macr", new Integer(175));
        htmlEntities.put("deg", new Integer(176));
        htmlEntities.put("plusmn", new Integer(177));
        htmlEntities.put("sup2", new Integer(178));
        htmlEntities.put("sup3", new Integer(179));
        htmlEntities.put("acute", new Integer(180));
        htmlEntities.put("micro", new Integer(181));
        htmlEntities.put("para", new Integer(182));
        htmlEntities.put("middot", new Integer(183));
        htmlEntities.put("cedil", new Integer(184));
        htmlEntities.put("sup1", new Integer(185));
        htmlEntities.put("ordm", new Integer(186));
        htmlEntities.put("raquo", new Integer(187));
        htmlEntities.put("frac14", new Integer(188));
        htmlEntities.put("frac12", new Integer(189));
        htmlEntities.put("frac34", new Integer(190));
        htmlEntities.put("iquest", new Integer(191));
        htmlEntities.put("Agrave", new Integer(192));
        htmlEntities.put("Aacute", new Integer(193));
        htmlEntities.put("Acirc", new Integer(194));
        htmlEntities.put("Atilde", new Integer(195));
        htmlEntities.put("Auml", new Integer(196));
        htmlEntities.put("Aring", new Integer(197));
        htmlEntities.put("AElig", new Integer(198));
        htmlEntities.put("Ccedil", new Integer(199));
        htmlEntities.put("Egrave", new Integer(200));
        htmlEntities.put("Eacute", new Integer(201));
        htmlEntities.put("Ecirc", new Integer(202));
        htmlEntities.put("Euml", new Integer(203));
        htmlEntities.put("Igrave", new Integer(204));
        htmlEntities.put("Iacute", new Integer(205));
        htmlEntities.put("Icirc", new Integer(206));
        htmlEntities.put("Iuml", new Integer(207));
        htmlEntities.put("ETH", new Integer(208));
        htmlEntities.put("Ntilde", new Integer(209));
        htmlEntities.put("Ograve", new Integer(210));
        htmlEntities.put("Oacute", new Integer(211));
        htmlEntities.put("Ocirc", new Integer(212));
        htmlEntities.put("Otilde", new Integer(213));
        htmlEntities.put("Ouml", new Integer(214));
        htmlEntities.put("times", new Integer(215));
        htmlEntities.put("Oslash", new Integer(216));
        htmlEntities.put("Ugrave", new Integer(217));
        htmlEntities.put("Uacute", new Integer(218));
        htmlEntities.put("Ucirc", new Integer(219));
        htmlEntities.put("Uuml", new Integer(220));
        htmlEntities.put("Yacute", new Integer(221));
        htmlEntities.put("THORN", new Integer(222));
        htmlEntities.put("szlig", new Integer(223));
        htmlEntities.put("agrave", new Integer(224));
        htmlEntities.put("aacute", new Integer(225));
        htmlEntities.put("acirc", new Integer(226));
        htmlEntities.put("atilde", new Integer(227));
        htmlEntities.put("auml", new Integer(228));
        htmlEntities.put("aring", new Integer(229));
        htmlEntities.put("aelig", new Integer(230));
        htmlEntities.put("ccedil", new Integer(231));
        htmlEntities.put("egrave", new Integer(232));
        htmlEntities.put("eacute", new Integer(233));
        htmlEntities.put("ecirc", new Integer(234));
        htmlEntities.put("euml", new Integer(235));
        htmlEntities.put("igrave", new Integer(236));
        htmlEntities.put("iacute", new Integer(237));
        htmlEntities.put("icirc", new Integer(238));
        htmlEntities.put("iuml", new Integer(239));
        htmlEntities.put("eth", new Integer(240));
        htmlEntities.put("ntilde", new Integer(241));
        htmlEntities.put("ograve", new Integer(242));
        htmlEntities.put("oacute", new Integer(243));
        htmlEntities.put("ocirc", new Integer(244));
        htmlEntities.put("otilde", new Integer(245));
        htmlEntities.put("ouml", new Integer(246));
        htmlEntities.put("divide", new Integer(247));
        htmlEntities.put("oslash", new Integer(248));
        htmlEntities.put("ugrave", new Integer(249));
        htmlEntities.put("uacute", new Integer(250));
        htmlEntities.put("ucirc", new Integer(251));
        htmlEntities.put("uuml", new Integer(252));
        htmlEntities.put("yacute", new Integer(253));
        htmlEntities.put("thorn", new Integer(254));
        htmlEntities.put("yuml", new Integer(255));
        htmlEntities.put("fnof", new Integer(402));
        htmlEntities.put("Alpha", new Integer(913));
        htmlEntities.put("Beta", new Integer(914));
        htmlEntities.put("Gamma", new Integer(915));
        htmlEntities.put("Delta", new Integer(916));
        htmlEntities.put("Epsilon", new Integer(917));
        htmlEntities.put("Zeta", new Integer(918));
        htmlEntities.put("Eta", new Integer(919));
        htmlEntities.put("Theta", new Integer(920));
        htmlEntities.put("Iota", new Integer(921));
        htmlEntities.put("Kappa", new Integer(922));
        htmlEntities.put("Lambda", new Integer(923));
        htmlEntities.put("Mu", new Integer(924));
        htmlEntities.put("Nu", new Integer(925));
        htmlEntities.put("Xi", new Integer(926));
        htmlEntities.put("Omicron", new Integer(927));
        htmlEntities.put("Pi", new Integer(928));
        htmlEntities.put("Rho", new Integer(929));
        htmlEntities.put("Sigma", new Integer(931));
        htmlEntities.put("Tau", new Integer(932));
        htmlEntities.put("Upsilon", new Integer(933));
        htmlEntities.put("Phi", new Integer(934));
        htmlEntities.put("Chi", new Integer(935));
        htmlEntities.put("Psi", new Integer(936));
        htmlEntities.put("Omega", new Integer(937));
        htmlEntities.put("alpha", new Integer(945));
        htmlEntities.put("beta", new Integer(946));
        htmlEntities.put("gamma", new Integer(947));
        htmlEntities.put("delta", new Integer(948));
        htmlEntities.put("epsilon", new Integer(949));
        htmlEntities.put("zeta", new Integer(950));
        htmlEntities.put("eta", new Integer(951));
        htmlEntities.put("theta", new Integer(952));
        htmlEntities.put("iota", new Integer(953));
        htmlEntities.put("kappa", new Integer(954));
        htmlEntities.put("lambda", new Integer(955));
        htmlEntities.put("mu", new Integer(956));
        htmlEntities.put("nu", new Integer(957));
        htmlEntities.put("xi", new Integer(958));
        htmlEntities.put("omicron", new Integer(959));
        htmlEntities.put("pi", new Integer(960));
        htmlEntities.put("rho", new Integer(961));
        htmlEntities.put("sigmaf", new Integer(962));
        htmlEntities.put("sigma", new Integer(963));
        htmlEntities.put("tau", new Integer(964));
        htmlEntities.put("upsilon", new Integer(965));
        htmlEntities.put("phi", new Integer(966));
        htmlEntities.put("chi", new Integer(967));
        htmlEntities.put("psi", new Integer(968));
        htmlEntities.put("omega", new Integer(969));
        htmlEntities.put("thetasym", new Integer(977));
        htmlEntities.put("upsih", new Integer(978));
        htmlEntities.put("piv", new Integer(982));
        htmlEntities.put("bull", new Integer(8226));
        htmlEntities.put("hellip", new Integer(8230));
        htmlEntities.put("prime", new Integer(8242));
        htmlEntities.put("Prime", new Integer(8243));
        htmlEntities.put("oline", new Integer(8254));
        htmlEntities.put("frasl", new Integer(8260));
        htmlEntities.put("weierp", new Integer(8472));
        htmlEntities.put("image", new Integer(8465));
        htmlEntities.put("real", new Integer(8476));
        htmlEntities.put("trade", new Integer(8482));
        htmlEntities.put("alefsym", new Integer(8501));
        htmlEntities.put("larr", new Integer(8592));
        htmlEntities.put("uarr", new Integer(8593));
        htmlEntities.put("rarr", new Integer(8594));
        htmlEntities.put("darr", new Integer(8595));
        htmlEntities.put("harr", new Integer(8596));
        htmlEntities.put("crarr", new Integer(8629));
        htmlEntities.put("lArr", new Integer(8656));
        htmlEntities.put("uArr", new Integer(8657));
        htmlEntities.put("rArr", new Integer(8658));
        htmlEntities.put("dArr", new Integer(8659));
        htmlEntities.put("hArr", new Integer(8660));
        htmlEntities.put("forall", new Integer(8704));
        htmlEntities.put("part", new Integer(8706));
        htmlEntities.put("exist", new Integer(8707));
        htmlEntities.put("empty", new Integer(8709));
        htmlEntities.put("nabla", new Integer(8711));
        htmlEntities.put("isin", new Integer(8712));
        htmlEntities.put("notin", new Integer(8713));
        htmlEntities.put("ni", new Integer(8715));
        htmlEntities.put("prod", new Integer(8719));
        htmlEntities.put("sum", new Integer(8721));
        htmlEntities.put("minus", new Integer(8722));
        htmlEntities.put("lowast", new Integer(8727));
        htmlEntities.put("radic", new Integer(8730));
        htmlEntities.put("prop", new Integer(8733));
        htmlEntities.put("infin", new Integer(8734));
        htmlEntities.put("ang", new Integer(8736));
        htmlEntities.put("and", new Integer(8743));
        htmlEntities.put("or", new Integer(8744));
        htmlEntities.put("cap", new Integer(8745));
        htmlEntities.put("cup", new Integer(8746));
        htmlEntities.put("int", new Integer(8747));
        htmlEntities.put("there4", new Integer(8756));
        htmlEntities.put("sim", new Integer(8764));
        htmlEntities.put("cong", new Integer(8773));
        htmlEntities.put("asymp", new Integer(8776));
        htmlEntities.put("ne", new Integer(8800));
        htmlEntities.put("equiv", new Integer(8801));
        htmlEntities.put("le", new Integer(8804));
        htmlEntities.put("ge", new Integer(8805));
        htmlEntities.put("sub", new Integer(8834));
        htmlEntities.put("sup", new Integer(8835));
        htmlEntities.put("nsub", new Integer(8836));
        htmlEntities.put("sube", new Integer(8838));
        htmlEntities.put("supe", new Integer(8839));
        htmlEntities.put("oplus", new Integer(8853));
        htmlEntities.put("otimes", new Integer(8855));
        htmlEntities.put("perp", new Integer(8869));
        htmlEntities.put("sdot", new Integer(8901));
        htmlEntities.put("lceil", new Integer(8968));
        htmlEntities.put("rceil", new Integer(8969));
        htmlEntities.put("lfloor", new Integer(8970));
        htmlEntities.put("rfloor", new Integer(8971));
        htmlEntities.put("lang", new Integer(9001));
        htmlEntities.put("rang", new Integer(9002));
        htmlEntities.put("loz", new Integer(9674));
        htmlEntities.put("spades", new Integer(9824));
        htmlEntities.put("clubs", new Integer(9827));
        htmlEntities.put("hearts", new Integer(9829));
        htmlEntities.put("diams", new Integer(9830));
        htmlEntities.put("quot", new Integer(34));
        htmlEntities.put("amp", new Integer(38));
        htmlEntities.put("lt", new Integer(60));
        htmlEntities.put("gt", new Integer(62));
        htmlEntities.put("OElig", new Integer(338));
        htmlEntities.put("oelig", new Integer(339));
        htmlEntities.put("Scaron", new Integer(352));
        htmlEntities.put("scaron", new Integer(353));
        htmlEntities.put("Yuml", new Integer(376));
        htmlEntities.put("circ", new Integer(710));
        htmlEntities.put("tilde", new Integer(732));
        htmlEntities.put("ensp", new Integer(8194));
        htmlEntities.put("emsp", new Integer(8195));
        htmlEntities.put("thinsp", new Integer(8201));
        htmlEntities.put("zwnj", new Integer(8204));
        htmlEntities.put("zwj", new Integer(8205));
        htmlEntities.put("lrm", new Integer(8206));
        htmlEntities.put("rlm", new Integer(8207));
        htmlEntities.put("ndash", new Integer(8211));
        htmlEntities.put("mdash", new Integer(8212));
        htmlEntities.put("lsquo", new Integer(8216));
        htmlEntities.put("rsquo", new Integer(8217));
        htmlEntities.put("sbquo", new Integer(8218));
        htmlEntities.put("ldquo", new Integer(8220));
        htmlEntities.put("rdquo", new Integer(8221));
        htmlEntities.put("bdquo", new Integer(8222));
        htmlEntities.put("dagger", new Integer(8224));
        htmlEntities.put("Dagger", new Integer(8225));
        htmlEntities.put("permil", new Integer(8240));
        htmlEntities.put("lsaquo", new Integer(8249));
        htmlEntities.put("rsaquo", new Integer(8250));
        htmlEntities.put("euro", new Integer(8364));
        jax_protokol_escape = new char[]{'&', '='};
        jax_protokol_unescape = new String[]{"_amp;", "_equal;"};
    }
}

