/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.log.LogRegistry;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPool {
    int corePoolSize = 2;
    int maxPoolSize = 10;
    long keepAliveTime = 600L;
    ThreadPoolExecutor threadPool = null;
    final ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue(100);
    private static ThreadPool _instance = null;

    public ThreadPool() {
        this.threadPool = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.SECONDS, this.workQueue);
    }

    public ThreadPool(int corePoolSize, int maxPoolSize, long keepAliveTime) {
        this.threadPool = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, TimeUnit.SECONDS, this.workQueue);
    }

    public void runTask(Runnable task) {
        this.threadPool.execute(task);
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(this.getClass(), "Tasks in workQueue.." + this.workQueue.size());
        }
    }

    public void shutDown() {
        this.threadPool.shutdown();
    }

    public void release() {
        this.shutDown();
        this.threadPool = null;
        _instance = null;
    }

    public static void init(int corePoolSize, int maxPoolSize, long keepAliveTime) {
        _instance = new ThreadPool(corePoolSize, maxPoolSize, keepAliveTime);
    }

    public static ThreadPool getInstance() {
        if (_instance == null) {
            _instance = new ThreadPool();
        }
        return _instance;
    }

    public static void main(String[] args) {
        ThreadPool.init(2, 10, 10L);
        for (int i = 0; i < 100; ++i) {
            ThreadPool.getInstance().runTask(new Runnable(){

                public synchronized void run() {
                    System.out.println("test1");
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.threadPool.setKeepAliveTime(keepAliveTime, TimeUnit.SECONDS);
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.threadPool.setMaximumPoolSize(maxPoolSize);
    }

    public void setCorePoolSize(int corePoolSize) {
        this.threadPool.setCorePoolSize(corePoolSize);
    }
}

