/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.StringUtil;
import java.util.Comparator;

public class XPathComparator
implements Comparator {
    private String _rootName;
    private boolean _ascending = true;

    public XPathComparator(String rootName, boolean ascending) {
        this._rootName = rootName;
        this._ascending = ascending;
    }

    public XPathComparator(String rootName) {
        this(rootName, true);
    }

    public int setOrder(int value) {
        if (this._ascending) {
            switch (value) {
                case -1: {
                    return 1;
                }
                case 1: {
                    return -1;
                }
            }
        }
        return value;
    }

    public int compare(Object a, Object b) {
        String xpathA = null;
        String xpathB = null;
        boolean aIncluded = false;
        boolean bIncluded = false;
        if (a instanceof String && b instanceof String) {
            String aString = (String)a;
            String bString = (String)b;
            xpathA = aString.substring(0, aString.indexOf("="));
            xpathB = bString.substring(0, bString.indexOf("="));
        } else if (a instanceof Type && b instanceof Type) {
            Type A = (Type)a;
            Type B = (Type)b;
            aIncluded = A.isIncluded();
            bIncluded = B.isIncluded();
            xpathA = A.getDirectChildValue("xpath");
            xpathB = B.getDirectChildValue("xpath");
        }
        if (xpathA != null && xpathB != null) {
            int tokensB;
            if (!xpathA.startsWith(this._rootName) && xpathB.startsWith(this._rootName)) {
                return this.setOrder(1);
            }
            if (!xpathB.startsWith(this._rootName) && xpathA.startsWith(this._rootName)) {
                return this.setOrder(0);
            }
            int tokensA = StringUtil.countTokens(xpathA, '/', false);
            if (tokensA == (tokensB = StringUtil.countTokens(xpathB, '/', false))) {
                int cp = xpathA.compareTo(xpathB);
                if (cp == 0) {
                    if (aIncluded && !bIncluded) {
                        return this.setOrder(1);
                    }
                    if (!aIncluded && bIncluded) {
                        return this.setOrder(0);
                    }
                    return this.setOrder(1);
                }
                return cp < 0 ? this.setOrder(1) : this.setOrder(0);
            }
            return tokensA < tokensB ? this.setOrder(1) : this.setOrder(0);
        }
        return this.setOrder(0);
    }
}

