/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.Md5;
import com.jaxfront.core.util.JAXFrontProperties;
import java.util.ArrayList;
import java.util.Hashtable;

public class XPathEncoder {
    private Hashtable xpathID = new Hashtable();
    private Hashtable _iDXToXPath = null;
    private ArrayList iDXPath = new ArrayList();
    private String _prefix = null;
    private boolean _staticMode = false;

    public XPathEncoder(String prefix, boolean staticMode) {
        this._prefix = prefix;
        this._staticMode = staticMode;
    }

    public void release() {
        if (this.xpathID != null) {
            this.xpathID.clear();
            this.xpathID = null;
        }
        if (this.iDXPath != null) {
            this.iDXPath.clear();
            this.iDXPath = null;
        }
    }

    public String encode(String xpath) {
        Object idObject = this.xpathID.get(xpath);
        if (idObject == null) {
            if (this._staticMode) {
                idObject = Md5.createHash(xpath);
                this.getMD5IDXToXPath().put(idObject, xpath);
            } else {
                idObject = new Integer(this.iDXPath.size());
                this.iDXPath.add(xpath);
            }
            this.xpathID.put(xpath, idObject);
        }
        return this._prefix + idObject.toString();
    }

    public String decode(Type model) {
        return this.decode(model.getPrefixedXPathLocation());
    }

    public void remove(String xpath) {
        Object idObject = this.xpathID.get(xpath);
        if (idObject != null) {
            if (this._staticMode) {
                idObject = Md5.createHash(xpath);
                this.getMD5IDXToXPath().remove(idObject);
            } else {
                int pos = (Integer)idObject;
                Object rem = this.iDXPath.get(pos);
                if (pos >= 0) {
                    this.iDXPath.set(pos, null);
                }
            }
            Object v = this.xpathID.remove(xpath);
        }
    }

    public String decode(String xpath) {
        if (xpath == null) {
            return null;
        }
        String xPathPrefix = null;
        try {
            int prefIdx = xpath.indexOf("_");
            if (prefIdx != -1 && (xPathPrefix = xpath.substring(0, prefIdx + 1)).equals(this._prefix)) {
                String intString = xpath.substring(this._prefix.length());
                if (this._staticMode) {
                    String xP = (String)this.getMD5IDXToXPath().get(intString);
                    if (xP != null && xP.length() > 0) {
                        return xP;
                    }
                    if (JAXFrontProperties.LOG_ENABLED) {
                        LogRegistry.getInstance().error(this.getClass(), "can't find xpath for:" + xpath);
                    }
                    return null;
                }
                int val = Integer.valueOf(intString);
                if (val >= 0 && val < this.iDXPath.size()) {
                    return (String)this.iDXPath.get(val);
                }
                if (JAXFrontProperties.LOG_ENABLED) {
                    LogRegistry.getInstance().error(this.getClass(), "can't find xpath for:" + xpath);
                }
                return null;
            }
            LogRegistry.getInstance().warn(this.getClass(), "wrong document for xpath to decode requested dom:" + xPathPrefix + " target dom:" + this._prefix);
            return null;
        }
        catch (Exception e) {
            LogRegistry.getInstance().warn(this.getClass(), "not a xpath to decode:" + xpath);
            return null;
        }
    }

    public static String encode(Type model) {
        return model.getDOM().getXPathEncoder().encode(model.getPrefixedXPathLocation());
    }

    public static String encode(Document dom, String xpath) {
        return dom.getXPathEncoder().encode(xpath);
    }

    public static String decode(Document dom, String xpath) {
        return dom.getXPathEncoder().decode(xpath);
    }

    public Hashtable getMD5IDXToXPath() {
        if (this._iDXToXPath == null) {
            this._iDXToXPath = new Hashtable();
        }
        return this._iDXToXPath;
    }
}

