/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.Sortable;
import com.jaxfront.core.util.StringUtil;

public class XPathSorter
implements Sortable {
    private String _rootName;

    public XPathSorter(String rootName) {
        this._rootName = rootName;
    }

    public boolean compare(Object a, Object b) {
        String xpathA = null;
        String xpathB = null;
        boolean aIncluded = false;
        boolean bIncluded = false;
        if (a instanceof String && b instanceof String) {
            String aString = (String)a;
            String bString = (String)b;
            xpathA = aString.substring(0, aString.indexOf("="));
            xpathB = bString.substring(0, bString.indexOf("="));
        } else if (a instanceof Type && b instanceof Type) {
            Type A = (Type)a;
            Type B = (Type)b;
            aIncluded = A.isIncluded();
            bIncluded = B.isIncluded();
            xpathA = A.getDirectChildValue("xpath");
            xpathB = B.getDirectChildValue("xpath");
        }
        if (xpathA != null && xpathB != null) {
            int tokensB;
            if (!xpathA.startsWith(this._rootName) && xpathB.startsWith(this._rootName)) {
                return true;
            }
            if (!xpathB.startsWith(this._rootName) && xpathA.startsWith(this._rootName)) {
                return false;
            }
            int tokensA = StringUtil.countTokens(xpathA, '/', false);
            if (tokensA == (tokensB = StringUtil.countTokens(xpathB, '/', false))) {
                int cp = xpathA.compareTo(xpathB);
                if (cp == 0) {
                    if (aIncluded && !bIncluded) {
                        return true;
                    }
                    return aIncluded || !bIncluded;
                }
                return cp < 0;
            }
            return tokensA < tokensB;
        }
        return false;
    }
}

